/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.binding;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.LibVlcOutOfDateException;
import uk.co.caprica.vlcj.binding.LoggingProxy;
import uk.co.caprica.vlcj.discovery.NativeDiscovery;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.version.Version;

public class LibVlcFactory {
    private final Logger logger = LoggerFactory.getLogger(LibVlcFactory.class);
    private static final String NATIVE_LIBRARY_HELP = "Failed to load the native library.\n\nThe error was \"{0}\".\n\nThe required native libraries are named \"{1}\" and \"{2}\".\n\nIn the text below <libvlc-path> represents the name of the directory containing \"{1}\" and \"{2}\"...\n\nThere are a number of different ways to specify where to find the native libraries:\n 1. Include NativeLibrary.addSearchPath(\"{3}\", \"<libvlc-path>\"); at the start of your application code.\n 2. Include System.setProperty(\"jna.library.path\", \"<libvlc-path>\"); at the start of your application code.\n 3. Specify -Djna.library.path=<libvlc-path> on the command-line when starting your application.\n 4. Add <libvlc-path> to the system search path (and reboot).\n\nIf this still does not work, then it may be necessary to explicitly add the native library directory to the operating\nsystem configuration - e.g. on Linux this might mean setting the LD_LIBRARY_PATH environment variable, or adding\nconfiguration to the \"/etc/ld.so.conf\" file or the \"/etc/ld.so.conf.d\" directory. Of these options, setting\nLD_LIBRARY_PATH is the only one that would not require root privileges.\n\nFinally, it is not possible to mix CPU architectures - it is not possible for a 64-bit Java Virtual Machine to load\n32-bit native libraries.\n\nMore information may be available in the log.\n";
    private boolean synchronise;
    private boolean log;
    private Version requiredVersion;
    private NativeDiscovery discovery;

    private LibVlcFactory() {
    }

    public static LibVlcFactory factory() {
        return new LibVlcFactory();
    }

    public LibVlcFactory synchronise() {
        this.synchronise = true;
        return this;
    }

    public LibVlcFactory log() {
        this.log = true;
        return this;
    }

    public LibVlcFactory atLeast(String string) {
        this.requiredVersion = new Version(string);
        return this;
    }

    public LibVlcFactory discovery(NativeDiscovery nativeDiscovery) {
        this.discovery = nativeDiscovery;
        return this;
    }

    public LibVlc create() {
        if (this.discovery != null) {
            this.discovery.discover();
        }
        try {
            LibVlc libVlc;
            LibVlc libVlc2 = libVlc = this.synchronise ? LibVlc.SYNC_INSTANCE : LibVlc.INSTANCE;
            if (this.log) {
                libVlc = (LibVlc)Proxy.newProxyInstance(LibVlc.class.getClassLoader(), new Class[]{LibVlc.class}, (InvocationHandler)new LoggingProxy(libVlc));
            }
            String string = libVlc.libvlc_get_version();
            this.logger.info("vlc: {}, changeset {}", (Object)string, (Object)LibVlc.INSTANCE.libvlc_get_changeset());
            this.logger.info("libvlc: {}", (Object)LibVlcFactory.getNativeLibraryPath(libVlc));
            if (this.requiredVersion != null) {
                Version version;
                try {
                    version = new Version(string);
                }
                catch (Exception exception) {
                    this.logger.error("Unable to parse native library version {} because of {}", (Object)string, (Object)exception);
                    version = null;
                }
                if (version != null) {
                    if (!version.atLeast(this.requiredVersion)) {
                        this.logger.error("This version of vlcj requires version {} or later of libvlc, found too old version {}", (Object)this.requiredVersion, (Object)version);
                        throw new LibVlcOutOfDateException(this.requiredVersion, version);
                    }
                } else {
                    this.logger.error("Unable to check the native library version '{}'", (Object)string);
                    throw new RuntimeException("Unable to check the native library version " + string);
                }
            }
            return libVlc;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.logger.error("Failed to load native library");
            String string = MessageFormat.format(NATIVE_LIBRARY_HELP, unsatisfiedLinkError.getMessage(), RuntimeUtil.getLibVlcName(), RuntimeUtil.getLibVlcCoreName(), RuntimeUtil.getLibVlcLibraryName());
            throw new RuntimeException(string);
        }
    }

    private static String getNativeLibraryPath(Object object) {
        int n;
        String string = object.toString();
        int n2 = string.indexOf(60);
        if (n2 != -1 && (n = string.indexOf(64, ++n2)) != -1) {
            string = string.substring(n2, n);
            return string;
        }
        return string;
    }
}

