/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.binding;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;

class LoggingProxy
implements InvocationHandler {
    private final Logger logger = LoggerFactory.getLogger(LoggingProxy.class);
    private final LibVlc target;

    LoggingProxy(LibVlc libVlc) {
        this.target = libVlc;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        try {
            this.before(method, objectArray);
            object2 = method.invoke((Object)this.target, objectArray);
            this.after(method, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.exception(method, invocationTargetException.getCause());
            throw invocationTargetException;
        }
        return object2;
    }

    private void before(Method method, Object[] objectArray) {
        this.logger.trace("call {}: {}", (Object)method.getName(), (Object)Arrays.toString(objectArray));
    }

    private void after(Method method, Object object) {
        if (!method.getReturnType().equals(Void.TYPE)) {
            this.logger.trace("return {}: {}", (Object)method.getName(), object);
        } else {
            this.logger.trace("return {}: void", (Object)method.getName());
        }
    }

    private void exception(Method method, Throwable throwable) {
        this.logger.trace("exception {}: {}", (Object)method.getName(), (Object)throwable);
    }
}

