/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.component;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.component.Arguments;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.MediaPlayerFactory;

public class AudioMediaPlayerComponent
extends MediaPlayerEventAdapter {
    private final Logger logger = LoggerFactory.getLogger(AudioMediaPlayerComponent.class);
    protected static final String[] DEFAULT_FACTORY_ARGUMENTS = new String[]{"--quiet-synchro", "--intf=dummy"};
    private final MediaPlayerFactory mediaPlayerFactory = this.onGetMediaPlayerFactory();
    private final MediaPlayer mediaPlayer = this.mediaPlayerFactory.newHeadlessMediaPlayer();

    public AudioMediaPlayerComponent() {
        this.onAfterConstruct();
        this.mediaPlayer.addMediaPlayerEventListener(this);
    }

    public final MediaPlayerFactory getMediaPlayerFactory() {
        return this.mediaPlayerFactory;
    }

    public final MediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public final void release() {
        this.onBeforeRelease();
        this.mediaPlayer.release();
        this.onAfterRelease();
    }

    public final void release(boolean bl) {
        this.release();
        if (bl) {
            this.mediaPlayerFactory.release();
        }
    }

    protected MediaPlayerFactory onGetMediaPlayerFactory() {
        Object[] objectArray = Arguments.mergeArguments(this.onGetMediaPlayerFactoryArgs(), this.onGetMediaPlayerFactoryExtraArgs());
        this.logger.debug("args={}", (Object)Arrays.toString(objectArray));
        return new MediaPlayerFactory((String[])objectArray);
    }

    protected String[] onGetMediaPlayerFactoryArgs() {
        return DEFAULT_FACTORY_ARGUMENTS;
    }

    protected String[] onGetMediaPlayerFactoryExtraArgs() {
        return null;
    }

    protected void onAfterConstruct() {
    }

    protected void onBeforeRelease() {
    }

    protected void onAfterRelease() {
    }
}

