/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.component;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.component.Arguments;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.videosurface.CanvasVideoSurface;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;

public class EmbeddedMediaPlayerComponent
extends Panel
implements MediaPlayerEventListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private final Logger logger = LoggerFactory.getLogger(EmbeddedMediaPlayerComponent.class);
    protected static final String[] DEFAULT_FACTORY_ARGUMENTS = new String[]{"--video-title=vlcj video output", "--no-snapshot-preview", "--quiet-synchro", "--sub-filter=logo:marq", "--intf=dummy"};
    private final MediaPlayerFactory mediaPlayerFactory = this.onGetMediaPlayerFactory();
    private final EmbeddedMediaPlayer mediaPlayer = this.mediaPlayerFactory.newEmbeddedMediaPlayer(this.onGetFullScreenStrategy());
    private final Canvas canvas = this.onGetCanvas();
    private final CanvasVideoSurface videoSurface = this.mediaPlayerFactory.newVideoSurface(this.canvas);
    private Cursor blankCursor;

    public EmbeddedMediaPlayerComponent() {
        this.mediaPlayer.setVideoSurface(this.videoSurface);
        this.setBackground(Color.black);
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas, "Center");
        this.mediaPlayer.addMediaPlayerEventListener(this);
        switch (this.onGetInputEvents()) {
            case NONE: {
                break;
            }
            case DISABLE_NATIVE: {
                this.mediaPlayer.setEnableKeyInputHandling(false);
                this.mediaPlayer.setEnableMouseInputHandling(false);
            }
            case DEFAULT: {
                this.canvas.addMouseListener(this);
                this.canvas.addMouseMotionListener(this);
                this.canvas.addMouseWheelListener(this);
                this.canvas.addKeyListener(this);
            }
        }
        this.mediaPlayer.setOverlay(this.onGetOverlay());
        this.onAfterConstruct();
    }

    public final MediaPlayerFactory getMediaPlayerFactory() {
        return this.mediaPlayerFactory;
    }

    public final EmbeddedMediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public final Canvas getVideoSurface() {
        return this.canvas;
    }

    public final void setCursorEnabled(boolean bl) {
        this.setCursor(bl ? null : this.getBlankCursor());
    }

    public final void release() {
        this.onBeforeRelease();
        this.mediaPlayer.release();
        this.onAfterRelease();
    }

    public final void release(boolean bl) {
        this.logger.debug("release(releaseFactory={})", (Object)bl);
        this.release();
        if (bl) {
            this.logger.debug("Releasing media player factory");
            this.mediaPlayerFactory.release();
        }
    }

    private Cursor getBlankCursor() {
        if (this.blankCursor == null) {
            BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
            this.blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(0, 0), "");
        }
        return this.blankCursor;
    }

    protected MediaPlayerFactory onGetMediaPlayerFactory() {
        Object[] objectArray = Arguments.mergeArguments(this.onGetMediaPlayerFactoryArgs(), this.onGetMediaPlayerFactoryExtraArgs());
        this.logger.debug("args={}", (Object)Arrays.toString(objectArray));
        return new MediaPlayerFactory((String[])objectArray);
    }

    protected String[] onGetMediaPlayerFactoryArgs() {
        return DEFAULT_FACTORY_ARGUMENTS;
    }

    protected String[] onGetMediaPlayerFactoryExtraArgs() {
        return null;
    }

    protected FullScreenStrategy onGetFullScreenStrategy() {
        return null;
    }

    protected Canvas onGetCanvas() {
        Canvas canvas = new Canvas();
        canvas.setBackground(Color.black);
        return canvas;
    }

    protected InputEvents onGetInputEvents() {
        if (RuntimeUtil.isNix() || RuntimeUtil.isMac()) {
            return InputEvents.DEFAULT;
        }
        return InputEvents.DISABLE_NATIVE;
    }

    protected Window onGetOverlay() {
        return null;
    }

    protected void onAfterConstruct() {
    }

    protected void onBeforeRelease() {
    }

    protected void onAfterRelease() {
    }

    @Override
    public void mediaChanged(MediaPlayer mediaPlayer, libvlc_media_t libvlc_media_t2, String string) {
    }

    @Override
    public void opening(MediaPlayer mediaPlayer) {
    }

    @Override
    public void buffering(MediaPlayer mediaPlayer, float f) {
    }

    @Override
    public void playing(MediaPlayer mediaPlayer) {
    }

    @Override
    public void paused(MediaPlayer mediaPlayer) {
    }

    @Override
    public void stopped(MediaPlayer mediaPlayer) {
    }

    @Override
    public void forward(MediaPlayer mediaPlayer) {
    }

    @Override
    public void backward(MediaPlayer mediaPlayer) {
    }

    @Override
    public void finished(MediaPlayer mediaPlayer) {
    }

    @Override
    public void timeChanged(MediaPlayer mediaPlayer, long l) {
    }

    @Override
    public void positionChanged(MediaPlayer mediaPlayer, float f) {
    }

    @Override
    public void seekableChanged(MediaPlayer mediaPlayer, int n) {
    }

    @Override
    public void pausableChanged(MediaPlayer mediaPlayer, int n) {
    }

    @Override
    public void titleChanged(MediaPlayer mediaPlayer, int n) {
    }

    @Override
    public void snapshotTaken(MediaPlayer mediaPlayer, String string) {
    }

    @Override
    public void lengthChanged(MediaPlayer mediaPlayer, long l) {
    }

    @Override
    public void videoOutput(MediaPlayer mediaPlayer, int n) {
    }

    @Override
    public void scrambledChanged(MediaPlayer mediaPlayer, int n) {
    }

    @Override
    public void elementaryStreamAdded(MediaPlayer mediaPlayer, int n, int n2) {
    }

    @Override
    public void elementaryStreamDeleted(MediaPlayer mediaPlayer, int n, int n2) {
    }

    @Override
    public void elementaryStreamSelected(MediaPlayer mediaPlayer, int n, int n2) {
    }

    @Override
    public void corked(MediaPlayer mediaPlayer, boolean bl) {
    }

    @Override
    public void muted(MediaPlayer mediaPlayer, boolean bl) {
    }

    @Override
    public void volumeChanged(MediaPlayer mediaPlayer, float f) {
    }

    @Override
    public void audioDeviceChanged(MediaPlayer mediaPlayer, String string) {
    }

    @Override
    public void chapterChanged(MediaPlayer mediaPlayer, int n) {
    }

    @Override
    public void error(MediaPlayer mediaPlayer) {
    }

    @Override
    public void mediaMetaChanged(MediaPlayer mediaPlayer, int n) {
    }

    @Override
    public void mediaSubItemAdded(MediaPlayer mediaPlayer, libvlc_media_t libvlc_media_t2) {
    }

    @Override
    public void mediaDurationChanged(MediaPlayer mediaPlayer, long l) {
    }

    @Override
    public void mediaParsedChanged(MediaPlayer mediaPlayer, int n) {
    }

    @Override
    public void mediaFreed(MediaPlayer mediaPlayer) {
    }

    @Override
    public void mediaStateChanged(MediaPlayer mediaPlayer, int n) {
    }

    @Override
    public void mediaSubItemTreeAdded(MediaPlayer mediaPlayer, libvlc_media_t libvlc_media_t2) {
    }

    @Override
    public void newMedia(MediaPlayer mediaPlayer) {
    }

    @Override
    public void subItemPlayed(MediaPlayer mediaPlayer, int n) {
    }

    @Override
    public void subItemFinished(MediaPlayer mediaPlayer, int n) {
    }

    @Override
    public void endOfSubItems(MediaPlayer mediaPlayer) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public static enum InputEvents {
        NONE,
        DEFAULT,
        DISABLE_NATIVE;

    }
}

