/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.component.overlay;

import com.sun.jna.platform.WindowUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import javax.swing.JWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJWindowOverlayComponent
extends JWindow {
    private final Logger logger = LoggerFactory.getLogger(AbstractJWindowOverlayComponent.class);
    private static final long serialVersionUID = 1L;
    private int layoutWidth = -1;
    private int layoutHeight = -1;

    public AbstractJWindowOverlayComponent(Window window) {
        this(window, WindowUtils.getAlphaCompatibleGraphicsConfiguration());
    }

    public AbstractJWindowOverlayComponent(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        if (window == null) {
            throw new IllegalArgumentException("The overlay window owner must not be null");
        }
        this.onSetWindowTransparency();
        this.onCreateOverlay();
        if (this.onHideCursor()) {
            this.setCursor(this.getBlankCursor());
        }
    }

    protected void onSetWindowTransparency() {
        String string = System.getProperty("java.specification.version");
        if ("1.7".compareTo(string) <= 0) {
            this.setBackground(new Color(0, 0, 0, 0));
        } else {
            try {
                Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
                Method method = clazz.getMethod("setWindowOpaque", Window.class, Boolean.class);
                method.invoke(null, this, false);
            }
            catch (Exception exception) {
                this.logger.debug("No apparent support for transparent windows", (Object)exception.getMessage());
                this.setBackground(new Color(0, 0, 0, 0));
            }
        }
    }

    protected void onCreateOverlay() {
    }

    protected boolean onHideCursor() {
        return true;
    }

    @Override
    public final void paint(Graphics graphics) {
        this.layoutHeight = this.getHeight();
        this.layoutWidth = this.getWidth();
        if (this.layoutWidth != this.layoutWidth | this.layoutHeight != this.layoutHeight) {
            this.onNewSize(this.layoutWidth, this.layoutHeight);
        }
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.onPrepareGraphicsContext(graphics2D);
        this.onPaintOverlay(graphics2D);
    }

    protected void onNewSize(int n, int n2) {
    }

    protected void onPrepareGraphicsContext(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    protected void onPaintOverlay(Graphics2D graphics2D) {
    }

    private Cursor getBlankCursor() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        return Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(0, 0), "");
    }
}

