/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.discovery;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.discovery.NativeDiscoveryStrategy;

public abstract class AbstractNativeDiscoveryStrategy
implements NativeDiscoveryStrategy {
    private final Logger logger = LoggerFactory.getLogger(AbstractNativeDiscoveryStrategy.class);
    protected static final String PLUGIN_ENV_NAME = "VLC_PLUGIN_PATH";

    @Override
    public final String discover() {
        this.logger.debug("discover()");
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        this.getDirectoryNames(arrayList);
        this.logger.debug("directoryNames={}", (Object)arrayList);
        for (String string2 : arrayList) {
            this.logger.debug("directoryName={}", (Object)string2);
            if (!this.find(string2)) continue;
            string = string2;
            break;
        }
        this.logger.debug("result={}", (Object)string);
        return string;
    }

    private boolean find(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            Pattern[] patternArray = this.getFilenamePatterns();
            int n = 0;
            for (File file2 : fileArray) {
                for (Pattern pattern : patternArray) {
                    Matcher matcher = pattern.matcher(file2.getName());
                    if (!matcher.matches()) continue;
                    this.logger.debug("Matched '{}' in '{}'", (Object)file2.getName(), (Object)string);
                    if (++n != patternArray.length) continue;
                    this.logger.debug("Matched all required files");
                    return true;
                }
            }
        }
        this.logger.debug("Failed to matched all required files");
        return false;
    }

    protected final List<String> getSystemPath() {
        String string = System.getenv("PATH");
        if (string != null) {
            String[] stringArray = string.split(File.pathSeparator);
            return Arrays.asList(stringArray);
        }
        return Collections.emptyList();
    }

    protected abstract Pattern[] getFilenamePatterns();

    protected abstract void getDirectoryNames(List<String> var1);

    @Override
    public void onFound(String string) {
    }
}

