/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.discovery;

import com.sun.jna.NativeLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.Info;
import uk.co.caprica.vlcj.discovery.NativeDiscoveryStrategy;
import uk.co.caprica.vlcj.discovery.linux.DefaultLinuxNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.discovery.mac.DefaultMacNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.discovery.windows.DefaultWindowsNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;

public class NativeDiscovery {
    private static final String JNA_SYSTEM_PROPERTY_NAME = "jna.library.path";
    private final Logger logger = LoggerFactory.getLogger(NativeDiscovery.class);
    private final NativeDiscoveryStrategy[] discoveryStrategies;

    public NativeDiscovery(NativeDiscoveryStrategy ... nativeDiscoveryStrategyArray) {
        this.discoveryStrategies = nativeDiscoveryStrategyArray;
    }

    public NativeDiscovery() {
        this(new DefaultLinuxNativeDiscoveryStrategy(), new DefaultWindowsNativeDiscoveryStrategy(), new DefaultMacNativeDiscoveryStrategy());
    }

    public final boolean discover() {
        this.logger.debug("discover()");
        String string = System.getProperty(JNA_SYSTEM_PROPERTY_NAME);
        this.logger.debug("jnaLibraryPath={}", (Object)string);
        if (string == null) {
            for (NativeDiscoveryStrategy nativeDiscoveryStrategy : this.discoveryStrategies) {
                this.logger.debug("discoveryStrategy={}", (Object)nativeDiscoveryStrategy);
                boolean bl = nativeDiscoveryStrategy.supported();
                this.logger.debug("supported={}", (Object)bl);
                if (!bl) continue;
                String string2 = nativeDiscoveryStrategy.discover();
                this.logger.debug("path={}", (Object)string2);
                if (string2 == null) continue;
                this.logger.info("Discovery found libvlc at '{}'", (Object)string2);
                NativeLibrary.addSearchPath(RuntimeUtil.getLibVlcLibraryName(), string2);
                nativeDiscoveryStrategy.onFound(string2);
                return true;
            }
            this.logger.warn("Discovery did not find libvlc");
        } else {
            this.logger.info("Skipped discovery as system property '{}' already set to '{}'", (Object)JNA_SYSTEM_PROPERTY_NAME, (Object)string);
        }
        return false;
    }

    static {
        Info.getInstance();
    }
}

