/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public abstract class ExtensionFileFilter
implements FileFilter {
    private final String[] extensions;
    private final Set<String> extensionsSet = new HashSet<String>();

    protected ExtensionFileFilter(String[] stringArray) {
        this.extensions = Arrays.copyOf(stringArray, stringArray.length);
        Arrays.sort(this.extensions);
        for (String string : stringArray) {
            this.extensionsSet.add(string);
        }
    }

    public String[] getExtensions() {
        return Arrays.copyOf(this.extensions, this.extensions.length);
    }

    public Set<String> getExtensionSet() {
        return new TreeSet<String>(this.extensionsSet);
    }

    @Override
    public boolean accept(File file) {
        String string;
        int n;
        if (file.isFile() && (n = (string = file.getName()).lastIndexOf(46)) != -1 && n + 1 < string.length()) {
            String string2 = string.substring(n + 1).toLowerCase();
            return this.extensionsSet.contains(string2);
        }
        return false;
    }
}

