/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.log;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibC;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_log_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_log_level_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_log_t;
import uk.co.caprica.vlcj.log.LogEventListener;
import uk.co.caprica.vlcj.version.LibVlcVersion;

public class NativeLog {
    private static final int BUFFER_SIZE = 201;
    private final Logger logger = LoggerFactory.getLogger(NativeLog.class);
    private final List<LogEventListener> eventListenerList = new ArrayList<LogEventListener>();
    private final ExecutorService listenersService = Executors.newSingleThreadExecutor();
    private final LibVlc libvlc;
    private final libvlc_instance_t instance;
    private libvlc_log_cb callback;
    private final AtomicBoolean released = new AtomicBoolean();
    private libvlc_log_level_e logLevel = libvlc_log_level_e.NOTICE;

    public NativeLog(LibVlc libVlc, libvlc_instance_t libvlc_instance_t2) {
        if (!LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_210)) {
            throw new RuntimeException("Native log requires libvlc 2.1.0 or later");
        }
        this.libvlc = libVlc;
        this.instance = libvlc_instance_t2;
        this.createInstance();
    }

    public final void addLogListener(LogEventListener logEventListener) {
        this.logger.debug("addLogListener(listener={})", (Object)logEventListener);
        this.eventListenerList.add(logEventListener);
    }

    public final void removeLogListener(LogEventListener logEventListener) {
        this.logger.debug("removeLogListener(listener={})", (Object)logEventListener);
        this.eventListenerList.remove(logEventListener);
    }

    public final void setLevel(libvlc_log_level_e libvlc_log_level_e2) {
        this.logLevel = libvlc_log_level_e2;
    }

    public final libvlc_log_level_e getLevel() {
        return this.logLevel;
    }

    public final void release() {
        this.logger.debug("release()");
        if (this.released.compareAndSet(false, true)) {
            this.destroyInstance();
        }
    }

    private void createInstance() {
        this.logger.debug("createInstance()");
        this.callback = new NativeLogCallback();
        this.libvlc.libvlc_log_set(this.instance, this.callback, null);
    }

    private void destroyInstance() {
        this.logger.debug("destroyInstance()");
        this.libvlc.libvlc_log_unset(this.instance);
        this.eventListenerList.clear();
        this.logger.debug("Shut down listeners...");
        this.listenersService.shutdown();
        this.logger.debug("Listeners shut down.");
    }

    protected void finalize() throws Throwable {
        this.logger.debug("finalize()");
        this.logger.debug("Native log has been garbage collected");
        super.finalize();
    }

    private String getString(PointerByReference pointerByReference) {
        Pointer pointer = pointerByReference.getValue();
        return pointer != null ? pointer.getString(0L) : null;
    }

    private void raiseLogEvent(libvlc_log_level_e libvlc_log_level_e2, String string, String string2, Integer n, String string3, String string4, Integer n2, String string5) {
        this.logger.trace("raiseLogEvent(level={},module={},line={},name={},header={},id={},message={}", new Object[]{libvlc_log_level_e2, string, string2, n, string3, string4, n2, string5});
        this.listenersService.submit(new NotifyEventListenersRunnable(libvlc_log_level_e2, string, string2, n, string3, string4, n2, string5));
    }

    private final class NotifyEventListenersRunnable
    implements Runnable {
        private final libvlc_log_level_e level;
        private final String module;
        private final String file;
        private final Integer line;
        private final String name;
        private final String header;
        private final Integer id;
        private final String message;

        private NotifyEventListenersRunnable(libvlc_log_level_e libvlc_log_level_e2, String string, String string2, Integer n, String string3, String string4, Integer n2, String string5) {
            this.level = libvlc_log_level_e2;
            this.module = string;
            this.file = string2;
            this.line = n;
            this.name = string3;
            this.header = string4;
            this.id = n2;
            this.message = string5;
        }

        @Override
        public void run() {
            NativeLog.this.logger.trace("run()");
            for (int i = NativeLog.this.eventListenerList.size() - 1; i >= 0; --i) {
                LogEventListener logEventListener = (LogEventListener)NativeLog.this.eventListenerList.get(i);
                try {
                    logEventListener.log(this.level, this.module, this.file, this.line, this.name, this.header, this.id, this.message);
                    continue;
                }
                catch (Exception exception) {
                    NativeLog.this.logger.warn("Event listener {} threw an exception", (Object)exception, (Object)logEventListener);
                }
            }
            NativeLog.this.logger.trace("runnable exits");
        }
    }

    private final class NativeLogCallback
    implements libvlc_log_cb {
        private NativeLogCallback() {
        }

        @Override
        public void log(Pointer pointer, int n, libvlc_log_t libvlc_log_t2, String string, Pointer pointer2) {
            if (NativeLog.this.logLevel != null && n >= NativeLog.this.logLevel.intValue()) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(201);
                int n2 = LibC.INSTANCE.vsnprintf(byteBuffer, byteBuffer.capacity(), string, pointer2);
                if (n2 >= 0) {
                    n2 = Math.min(n2, 201);
                    byte[] byArray = new byte[n2];
                    byteBuffer.get(byArray);
                    String string2 = new String(byArray);
                    if (string2.length() > 0) {
                        PointerByReference pointerByReference = new PointerByReference();
                        PointerByReference pointerByReference2 = new PointerByReference();
                        IntByReference intByReference = new IntByReference();
                        NativeLog.this.libvlc.libvlc_log_get_context(libvlc_log_t2, pointerByReference, pointerByReference2, intByReference);
                        PointerByReference pointerByReference3 = new PointerByReference();
                        PointerByReference pointerByReference4 = new PointerByReference();
                        IntByReference intByReference2 = new IntByReference();
                        NativeLog.this.libvlc.libvlc_log_get_object(libvlc_log_t2, pointerByReference3, pointerByReference4, intByReference2);
                        String string3 = NativeLog.this.getString(pointerByReference);
                        String string4 = NativeLog.this.getString(pointerByReference2);
                        Integer n3 = intByReference.getValue();
                        String string5 = NativeLog.this.getString(pointerByReference3);
                        String string6 = NativeLog.this.getString(pointerByReference4);
                        Integer n4 = intByReference2.getValue();
                        NativeLog.this.raiseLogEvent(libvlc_log_level_e.level(n), string3, string4, n3, string5, string6, n4, string2);
                    }
                } else {
                    NativeLog.this.logger.error("Failed to format log message");
                }
            }
        }
    }
}

