/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.medialist;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_manager_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_meta_t;
import uk.co.caprica.vlcj.medialist.MediaListEventListener;
import uk.co.caprica.vlcj.medialist.MediaListItem;
import uk.co.caprica.vlcj.medialist.events.MediaListEvent;
import uk.co.caprica.vlcj.medialist.events.MediaListEventFactory;
import uk.co.caprica.vlcj.player.MediaResourceLocator;
import uk.co.caprica.vlcj.player.NativeString;

public class MediaList {
    private final Logger logger = LoggerFactory.getLogger(MediaList.class);
    private final List<MediaListEventListener> eventListenerList = new ArrayList<MediaListEventListener>();
    private final MediaListEventFactory eventFactory = new MediaListEventFactory(this);
    private final ExecutorService listenersService = Executors.newSingleThreadExecutor();
    private final LibVlc libvlc;
    private final libvlc_instance_t instance;
    private libvlc_media_list_t mediaListInstance;
    private libvlc_event_manager_t mediaListEventManager;
    private libvlc_callback_t callback;
    private final AtomicBoolean released = new AtomicBoolean();
    private String[] standardMediaOptions;

    public MediaList(LibVlc libVlc, libvlc_instance_t libvlc_instance_t2) {
        this(libVlc, libvlc_instance_t2, null);
    }

    public MediaList(LibVlc libVlc, libvlc_instance_t libvlc_instance_t2, libvlc_media_list_t libvlc_media_list_t2) {
        this.libvlc = libVlc;
        this.instance = libvlc_instance_t2;
        this.createInstance(libvlc_media_list_t2);
    }

    public final void addMediaListEventListener(MediaListEventListener mediaListEventListener) {
        this.logger.debug("addMediaListEventListener(listener={})", (Object)mediaListEventListener);
        this.eventListenerList.add(mediaListEventListener);
    }

    public final void removeListEventListener(MediaListEventListener mediaListEventListener) {
        this.logger.debug("removeMediaListEventListener(listener={})", (Object)mediaListEventListener);
        this.eventListenerList.remove(mediaListEventListener);
    }

    public final void setStandardMediaOptions(String ... stringArray) {
        this.logger.debug("setStandardMediaOptions(standardMediaOptions={})", (Object)Arrays.toString(stringArray));
        this.standardMediaOptions = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMedia(String string, String ... stringArray) {
        this.logger.debug("addMedia(mrl={},mediaOptions={})", (Object)string, (Object)Arrays.toString(stringArray));
        try {
            this.lock();
            libvlc_media_t libvlc_media_t2 = this.newMediaDescriptor(string, stringArray);
            this.libvlc.libvlc_media_list_add_media(this.mediaListInstance, libvlc_media_t2);
            this.releaseMediaDescriptor(libvlc_media_t2);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insertMedia(int n, String string, String ... stringArray) {
        this.logger.debug("insertMedia(index={},mrl={},mediaOptions={})", n, string, Arrays.toString(stringArray));
        try {
            this.lock();
            libvlc_media_t libvlc_media_t2 = this.newMediaDescriptor(string, stringArray);
            this.libvlc.libvlc_media_list_insert_media(this.mediaListInstance, libvlc_media_t2, n);
            this.releaseMediaDescriptor(libvlc_media_t2);
        }
        finally {
            this.unlock();
        }
    }

    public final void removeMedia(int n) {
        this.logger.debug("removeMedia(index={})", (Object)n);
        try {
            this.lock();
            libvlc_media_t libvlc_media_t2 = this.libvlc.libvlc_media_list_item_at_index(this.mediaListInstance, n);
            if (libvlc_media_t2 != null) {
                this.libvlc.libvlc_media_list_remove_index(this.mediaListInstance, n);
                this.libvlc.libvlc_media_release(libvlc_media_t2);
            }
        }
        finally {
            this.unlock();
        }
    }

    public final void clear() {
        this.logger.debug("clear()");
        try {
            this.lock();
            for (int i = this.libvlc.libvlc_media_list_count(this.mediaListInstance) - 1; i >= 0; --i) {
                this.libvlc.libvlc_media_list_remove_index(this.mediaListInstance, i);
            }
        }
        finally {
            this.unlock();
        }
    }

    public final int size() {
        this.logger.debug("size()");
        try {
            this.lock();
            int n = this.libvlc.libvlc_media_list_count(this.mediaListInstance);
            this.logger.debug("size={}", (Object)n);
            int n2 = n;
            return n2;
        }
        finally {
            this.unlock();
        }
    }

    public final boolean isReadOnly() {
        this.logger.debug("isReadOnly()");
        return this.libvlc.libvlc_media_list_is_readonly(this.mediaListInstance) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<MediaListItem> items() {
        this.logger.debug("items()");
        ArrayList<MediaListItem> arrayList = new ArrayList<MediaListItem>();
        try {
            this.lock();
            for (int i = 0; i < this.libvlc.libvlc_media_list_count(this.mediaListInstance); ++i) {
                libvlc_media_t libvlc_media_t2 = this.libvlc.libvlc_media_list_item_at_index(this.mediaListInstance, i);
                arrayList.add(this.newMediaListItem(libvlc_media_t2));
                this.libvlc.libvlc_media_release(libvlc_media_t2);
            }
        }
        finally {
            this.unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaListItem newMediaListItem(libvlc_media_t libvlc_media_t2) {
        List<MediaListItem> list;
        String string = NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_get_meta(libvlc_media_t2, libvlc_meta_t.libvlc_meta_Title.intValue()));
        String string2 = NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_get_mrl(libvlc_media_t2));
        libvlc_media_list_t libvlc_media_list_t2 = this.libvlc.libvlc_media_subitems(libvlc_media_t2);
        if (libvlc_media_list_t2 != null) {
            try {
                this.libvlc.libvlc_media_list_lock(libvlc_media_list_t2);
                list = new ArrayList<MediaListItem>();
                for (int i = 0; i < this.libvlc.libvlc_media_list_count(libvlc_media_list_t2); ++i) {
                    libvlc_media_t libvlc_media_t3 = this.libvlc.libvlc_media_list_item_at_index(libvlc_media_list_t2, i);
                    list.add(this.newMediaListItem(libvlc_media_t3));
                    this.libvlc.libvlc_media_release(libvlc_media_t3);
                }
            }
            finally {
                this.libvlc.libvlc_media_list_unlock(libvlc_media_list_t2);
            }
            this.libvlc.libvlc_media_list_release(libvlc_media_list_t2);
        } else {
            list = Collections.emptyList();
        }
        return new MediaListItem(string, string2, list);
    }

    public final void release() {
        this.logger.debug("release()");
        if (this.released.compareAndSet(false, true)) {
            this.destroyInstance();
        }
    }

    private void createInstance(libvlc_media_list_t libvlc_media_list_t2) {
        this.logger.debug("createInstance()");
        if (libvlc_media_list_t2 == null) {
            libvlc_media_list_t2 = this.libvlc.libvlc_media_list_new(this.instance);
        } else {
            this.libvlc.libvlc_media_list_retain(libvlc_media_list_t2);
        }
        this.mediaListInstance = libvlc_media_list_t2;
        this.logger.debug("mediaListInstance={}", (Object)libvlc_media_list_t2);
        this.mediaListEventManager = this.libvlc.libvlc_media_list_event_manager(libvlc_media_list_t2);
        this.logger.debug("mediaListEventManager={}", (Object)this.mediaListEventManager);
        this.registerEventListener();
    }

    private void destroyInstance() {
        this.logger.debug("destroyInstance()");
        this.deregisterEventListener();
        if (this.mediaListInstance != null) {
            this.libvlc.libvlc_media_list_release(this.mediaListInstance);
        }
        this.logger.debug("Shut down listeners...");
        this.listenersService.shutdown();
        this.logger.debug("Listeners shut down.");
    }

    private void registerEventListener() {
        this.logger.debug("registerEventListener()");
        this.callback = new MediaListCallback();
        for (libvlc_event_e libvlc_event_e2 : libvlc_event_e.values()) {
            if (libvlc_event_e2.intValue() < libvlc_event_e.libvlc_MediaListItemAdded.intValue() || libvlc_event_e2.intValue() > libvlc_event_e.libvlc_MediaListEndReached.intValue()) continue;
            this.logger.debug("event={}", (Object)libvlc_event_e2);
            int n = this.libvlc.libvlc_event_attach(this.mediaListEventManager, libvlc_event_e2.intValue(), this.callback, null);
            this.logger.debug("result={}", (Object)n);
        }
    }

    private void deregisterEventListener() {
        this.logger.debug("deregisterEventListener()");
        if (this.callback != null) {
            for (libvlc_event_e libvlc_event_e2 : libvlc_event_e.values()) {
                if (libvlc_event_e2.intValue() < libvlc_event_e.libvlc_MediaListItemAdded.intValue() || libvlc_event_e2.intValue() > libvlc_event_e.libvlc_MediaListEndReached.intValue()) continue;
                this.logger.debug("event={}", (Object)libvlc_event_e2);
                this.libvlc.libvlc_event_detach(this.mediaListEventManager, libvlc_event_e2.intValue(), this.callback, null);
            }
            this.callback = null;
        }
    }

    private void raiseEvent(MediaListEvent mediaListEvent) {
        this.logger.trace("raiseEvent(mediaListEvent={}", (Object)mediaListEvent);
        if (mediaListEvent != null) {
            this.listenersService.submit(new NotifyEventListenersRunnable(mediaListEvent));
        }
    }

    private void lock() {
        this.logger.debug("lock()");
        this.libvlc.libvlc_media_list_lock(this.mediaListInstance);
    }

    private void unlock() {
        this.logger.debug("unlock()");
        this.libvlc.libvlc_media_list_unlock(this.mediaListInstance);
    }

    private libvlc_media_t newMediaDescriptor(String string, String ... stringArray) {
        libvlc_media_t libvlc_media_t2;
        this.logger.debug("newMediaDescriptor(media={},mediaOptions={})", (Object)string, (Object)Arrays.toString(stringArray));
        string = MediaResourceLocator.encodeMrl(string);
        if (MediaResourceLocator.isLocation(string)) {
            this.logger.debug("Treating mrl as a location");
            libvlc_media_t2 = this.libvlc.libvlc_media_new_location(this.instance, string);
        } else {
            this.logger.debug("Treating mrl as a path");
            libvlc_media_t2 = this.libvlc.libvlc_media_new_path(this.instance, string);
        }
        this.logger.debug("mediaDescriptor={}", (Object)libvlc_media_t2);
        if (this.standardMediaOptions != null) {
            for (String string2 : this.standardMediaOptions) {
                this.logger.debug("standardMediaOption={}", (Object)string2);
                this.libvlc.libvlc_media_add_option(libvlc_media_t2, string2);
            }
        }
        if (stringArray != null) {
            for (String string2 : stringArray) {
                this.logger.debug("mediaOption={}", (Object)string2);
                this.libvlc.libvlc_media_add_option(libvlc_media_t2, string2);
            }
        }
        return libvlc_media_t2;
    }

    private void releaseMediaDescriptor(libvlc_media_t libvlc_media_t2) {
        this.logger.debug("releaseMediaDescriptor(mediaDescriptor={})", (Object)libvlc_media_t2);
        this.libvlc.libvlc_media_release(libvlc_media_t2);
    }

    public final libvlc_media_list_t mediaListInstance() {
        return this.mediaListInstance;
    }

    private final class NotifyEventListenersRunnable
    implements Runnable {
        private final MediaListEvent mediaListEvent;

        private NotifyEventListenersRunnable(MediaListEvent mediaListEvent) {
            this.mediaListEvent = mediaListEvent;
        }

        @Override
        public void run() {
            MediaList.this.logger.trace("run()");
            for (int i = MediaList.this.eventListenerList.size() - 1; i >= 0; --i) {
                MediaListEventListener mediaListEventListener = (MediaListEventListener)MediaList.this.eventListenerList.get(i);
                try {
                    this.mediaListEvent.notify(mediaListEventListener);
                    continue;
                }
                catch (Exception exception) {
                    MediaList.this.logger.warn("Event listener {} threw an exception", (Object)exception, (Object)mediaListEventListener);
                }
            }
            MediaList.this.logger.trace("runnable exits");
        }
    }

    private final class MediaListCallback
    implements libvlc_callback_t {
        private MediaListCallback() {
        }

        @Override
        public void callback(libvlc_event_t libvlc_event_t2, Pointer pointer) {
            MediaList.this.logger.trace("callback(event={},userData={})", (Object)libvlc_event_t2, (Object)pointer);
            if (!MediaList.this.eventListenerList.isEmpty()) {
                MediaList.this.raiseEvent(MediaList.this.eventFactory.createEvent(libvlc_event_t2));
            }
        }
    }
}

