/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_meta_t;
import uk.co.caprica.vlcj.player.MediaMeta;
import uk.co.caprica.vlcj.player.MediaMetaData;
import uk.co.caprica.vlcj.player.NativeString;
import uk.co.caprica.vlcj.version.Version;

class DefaultMediaMeta
implements MediaMeta {
    private final Logger logger = LoggerFactory.getLogger(DefaultMediaMeta.class);
    private static final Version VERSION_220 = new Version("2.2.0");
    private static final Version VERSION_300 = new Version("3.0.0");
    private final AtomicBoolean released = new AtomicBoolean();
    private final LibVlc libvlc;
    private final libvlc_media_t media;
    private final Version actualVersion;
    private BufferedImage artwork;

    DefaultMediaMeta(LibVlc libVlc, libvlc_media_t libvlc_media_t2) {
        this.libvlc = libVlc;
        this.media = libvlc_media_t2;
        this.actualVersion = new Version(libVlc.libvlc_get_version());
        libVlc.libvlc_media_retain(libvlc_media_t2);
    }

    @Override
    public final void parse() {
        this.logger.debug("parse()");
        this.libvlc.libvlc_media_parse(this.media);
    }

    @Override
    public final String getTitle() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Title);
    }

    @Override
    public final void setTitle(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Title, string);
    }

    @Override
    public final String getArtist() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Artist);
    }

    @Override
    public final void setArtist(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Artist, string);
    }

    @Override
    public final String getGenre() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Genre);
    }

    @Override
    public final void setGenre(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Genre, string);
    }

    @Override
    public final String getCopyright() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Copyright);
    }

    @Override
    public final void setCopyright(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Copyright, string);
    }

    @Override
    public final String getAlbum() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Album);
    }

    @Override
    public final void setAlbum(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Album, string);
    }

    @Override
    public final String getTrackNumber() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_TrackNumber);
    }

    @Override
    public final void setTrackNumber(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_TrackNumber, string);
    }

    @Override
    public final String getDescription() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Description);
    }

    @Override
    public final void setDescription(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Description, string);
    }

    @Override
    public final String getRating() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Rating);
    }

    @Override
    public final void setRating(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Rating, string);
    }

    @Override
    public final String getDate() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Date);
    }

    @Override
    public final void setDate(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Date, string);
    }

    @Override
    public final String getSetting() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Setting);
    }

    @Override
    public final void setSetting(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Setting, string);
    }

    @Override
    public final String getUrl() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_URL);
    }

    @Override
    public final void setUrl(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_URL, string);
    }

    @Override
    public final String getLanguage() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Language);
    }

    @Override
    public final void setLanguage(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Language, string);
    }

    @Override
    public final String getNowPlaying() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_NowPlaying);
    }

    @Override
    public final void setNowPlaying(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_NowPlaying, string);
    }

    @Override
    public final String getPublisher() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Publisher);
    }

    @Override
    public final void setPublisher(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Publisher, string);
    }

    @Override
    public final String getEncodedBy() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_EncodedBy);
    }

    @Override
    public final void setEncodedBy(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_EncodedBy, string);
    }

    @Override
    public final String getArtworkUrl() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_ArtworkURL);
    }

    @Override
    public final void setArtworkUrl(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_ArtworkURL, string);
    }

    @Override
    public final String getTrackId() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_TrackID);
    }

    @Override
    public final void setTrackId(String string) {
        this.setMeta(libvlc_meta_t.libvlc_meta_TrackID, string);
    }

    @Override
    public final String getTrackTotal() {
        this.checkVersion(VERSION_220);
        return this.getMeta(libvlc_meta_t.libvlc_meta_TrackTotal);
    }

    @Override
    public final void setTrackTotal(String string) {
        this.checkVersion(VERSION_220);
        this.setMeta(libvlc_meta_t.libvlc_meta_TrackTotal, string);
    }

    @Override
    public final String getDirector() {
        this.checkVersion(VERSION_220);
        return this.getMeta(libvlc_meta_t.libvlc_meta_Director);
    }

    @Override
    public final void setDirector(String string) {
        this.checkVersion(VERSION_220);
        this.setMeta(libvlc_meta_t.libvlc_meta_Director, string);
    }

    @Override
    public final String getSeason() {
        this.checkVersion(VERSION_220);
        return this.getMeta(libvlc_meta_t.libvlc_meta_Season);
    }

    @Override
    public final void setSeason(String string) {
        this.checkVersion(VERSION_220);
        this.setMeta(libvlc_meta_t.libvlc_meta_Season, string);
    }

    @Override
    public final String getEpisode() {
        this.checkVersion(VERSION_220);
        return this.getMeta(libvlc_meta_t.libvlc_meta_Episode);
    }

    @Override
    public final void setEpisode(String string) {
        this.checkVersion(VERSION_220);
        this.setMeta(libvlc_meta_t.libvlc_meta_Episode, string);
    }

    @Override
    public final String getShowName() {
        this.checkVersion(VERSION_220);
        return this.getMeta(libvlc_meta_t.libvlc_meta_ShowName);
    }

    @Override
    public final void setShowName(String string) {
        this.checkVersion(VERSION_220);
        this.setMeta(libvlc_meta_t.libvlc_meta_ShowName, string);
    }

    @Override
    public final String getActors() {
        this.checkVersion(VERSION_220);
        return this.getMeta(libvlc_meta_t.libvlc_meta_Actors);
    }

    @Override
    public final void setActors(String string) {
        this.checkVersion(VERSION_220);
        this.setMeta(libvlc_meta_t.libvlc_meta_Actors, string);
    }

    @Override
    public String getAlbumArtist() {
        this.checkVersion(VERSION_300);
        return this.getMeta(libvlc_meta_t.libvlc_meta_AlbumArtist);
    }

    @Override
    public void setAlbumArtist(String string) {
        this.checkVersion(VERSION_300);
        this.setMeta(libvlc_meta_t.libvlc_meta_AlbumArtist, string);
    }

    @Override
    public String getDiscNumber() {
        this.checkVersion(VERSION_300);
        return this.getMeta(libvlc_meta_t.libvlc_meta_DiscNumber);
    }

    @Override
    public void setDiscNumber(String string) {
        this.checkVersion(VERSION_300);
        this.setMeta(libvlc_meta_t.libvlc_meta_DiscNumber, string);
    }

    @Override
    public String getDiscTotal() {
        this.checkVersion(VERSION_300);
        return this.getMeta(libvlc_meta_t.libvlc_meta_DiscTotal);
    }

    @Override
    public void setDiscTotal(String string) {
        this.checkVersion(VERSION_300);
        this.setMeta(libvlc_meta_t.libvlc_meta_DiscTotal, string);
    }

    @Override
    public final BufferedImage getArtwork() {
        String string;
        this.logger.debug("getArtwork()");
        if (this.artwork == null && (string = this.getArtworkUrl()) != null && string.length() > 0) {
            try {
                URL uRL = new URL(string);
                this.logger.debug("url={}", (Object)uRL);
                this.artwork = ImageIO.read(uRL);
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to load artwork", exception);
            }
        }
        return this.artwork;
    }

    @Override
    public final long getLength() {
        return this.libvlc.libvlc_media_get_duration(this.media);
    }

    @Override
    public final void save() {
        this.logger.debug("save()");
        this.libvlc.libvlc_media_save_meta(this.media);
    }

    @Override
    public final void release() {
        this.logger.debug("release()");
        if (this.released.compareAndSet(false, true)) {
            this.libvlc.libvlc_media_release(this.media);
        }
    }

    @Override
    public MediaMetaData asMediaMetaData() {
        MediaMetaData mediaMetaData = new MediaMetaData();
        mediaMetaData.setTitle(this.getTitle());
        mediaMetaData.setArtist(this.getArtist());
        mediaMetaData.setGenre(this.getGenre());
        mediaMetaData.setCopyright(this.getCopyright());
        mediaMetaData.setAlbum(this.getAlbum());
        mediaMetaData.setTrackNumber(this.getTrackNumber());
        mediaMetaData.setDescription(this.getDescription());
        mediaMetaData.setRating(this.getRating());
        mediaMetaData.setDate(this.getDate());
        mediaMetaData.setSetting(this.getSetting());
        mediaMetaData.setUrl(this.getUrl());
        mediaMetaData.setLanguage(this.getLanguage());
        mediaMetaData.setNowPlaying(this.getNowPlaying());
        mediaMetaData.setPublisher(this.getPublisher());
        mediaMetaData.setEncodedBy(this.getEncodedBy());
        mediaMetaData.setArtworkUrl(this.getArtworkUrl());
        mediaMetaData.setTrackId(this.getTrackId());
        if (this.actualVersion.atLeast(VERSION_220)) {
            mediaMetaData.setTrackTotal(this.getTrackTotal());
            mediaMetaData.setDirector(this.getDirector());
            mediaMetaData.setSeason(this.getSeason());
            mediaMetaData.setEpisode(this.getEpisode());
            mediaMetaData.setShowName(this.getShowName());
            mediaMetaData.setActors(this.getActors());
        }
        if (this.actualVersion.atLeast(VERSION_300)) {
            mediaMetaData.setAlbumArtist(this.getAlbumArtist());
            mediaMetaData.setDiscNumber(this.getDiscNumber());
            mediaMetaData.setDiscTotal(this.getDiscTotal());
        }
        return mediaMetaData;
    }

    protected void finalize() throws Throwable {
        this.logger.debug("finalize()");
        this.logger.debug("Meta data has been garbage collected");
        super.finalize();
    }

    private String getMeta(libvlc_meta_t libvlc_meta_t2) {
        this.logger.trace("getMeta(metaType={},media={})", (Object)libvlc_meta_t2, (Object)this.media);
        return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_get_meta(this.media, libvlc_meta_t2.intValue()));
    }

    private void setMeta(libvlc_meta_t libvlc_meta_t2, String string) {
        this.logger.trace("setMeta(metaType={},media={},value={})", new Object[]{libvlc_meta_t2, this.media, string});
        this.libvlc.libvlc_media_set_meta(this.media, libvlc_meta_t2.intValue(), string);
    }

    private void checkVersion(Version version) {
        if (!this.actualVersion.atLeast(version)) {
            throw new RuntimeException("Requires at least VLC version " + version);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getClass().getSimpleName()).append('[');
        stringBuilder.append("title=").append(this.getTitle()).append(',');
        stringBuilder.append("artist=").append(this.getArtist()).append(',');
        stringBuilder.append("genre=").append(this.getGenre()).append(',');
        stringBuilder.append("copyright=").append(this.getCopyright()).append(',');
        stringBuilder.append("album=").append(this.getAlbum()).append(',');
        stringBuilder.append("trackNumber=").append(this.getTrackNumber()).append(',');
        stringBuilder.append("description=").append(this.getDescription()).append(',');
        stringBuilder.append("rating=").append(this.getRating()).append(',');
        stringBuilder.append("date=").append(this.getDate()).append(',');
        stringBuilder.append("setting=").append(this.getSetting()).append(',');
        stringBuilder.append("url=").append(this.getUrl()).append(',');
        stringBuilder.append("language=").append(this.getLanguage()).append(',');
        stringBuilder.append("nowPlaying=").append(this.getNowPlaying()).append(',');
        stringBuilder.append("publisher=").append(this.getPublisher()).append(',');
        stringBuilder.append("encodedBy=").append(this.getEncodedBy()).append(',');
        stringBuilder.append("artworkUrl=").append(this.getArtworkUrl()).append(',');
        stringBuilder.append("trackId=").append(this.getTrackId()).append(',');
        if (this.actualVersion.atLeast(VERSION_220)) {
            stringBuilder.append("trackTotal=").append(this.getTrackTotal()).append(',');
            stringBuilder.append("director=").append(this.getDirector()).append(',');
            stringBuilder.append("season=").append(this.getSeason()).append(',');
            stringBuilder.append("episode=").append(this.getEpisode()).append(',');
            stringBuilder.append("showName=").append(this.getShowName()).append(',');
            stringBuilder.append("actors=").append(this.getActors()).append(',');
        }
        if (this.actualVersion.atLeast(VERSION_300)) {
            stringBuilder.append("albumArtist=").append(this.getAlbumArtist()).append(',');
            stringBuilder.append("discNumber=").append(this.getDiscNumber()).append(',');
        }
        stringBuilder.append("length=").append(this.getLength()).append(']');
        return stringBuilder.toString();
    }
}

