/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_device_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_track_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_chapter_description_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_equalizer_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_manager_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_logo_position_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_marquee_position_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_parse_flag_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_stats_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_track_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_type_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_navigate_mode_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_position_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_state_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_subtitle_track_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_title_description_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_track_description_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_track_type_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_adjust_option_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_logo_option_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_marquee_option_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_track_t;
import uk.co.caprica.vlcj.medialist.MediaList;
import uk.co.caprica.vlcj.player.AbstractMediaPlayer;
import uk.co.caprica.vlcj.player.AudioDevice;
import uk.co.caprica.vlcj.player.AudioTrackInfo;
import uk.co.caprica.vlcj.player.ChapterDescription;
import uk.co.caprica.vlcj.player.DefaultMediaMeta;
import uk.co.caprica.vlcj.player.DeinterlaceMode;
import uk.co.caprica.vlcj.player.Equalizer;
import uk.co.caprica.vlcj.player.EqualizerListener;
import uk.co.caprica.vlcj.player.LibVlcMediaListIterator;
import uk.co.caprica.vlcj.player.Logo;
import uk.co.caprica.vlcj.player.Marquee;
import uk.co.caprica.vlcj.player.MediaDetails;
import uk.co.caprica.vlcj.player.MediaMeta;
import uk.co.caprica.vlcj.player.MediaMetaData;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.MediaPlayerLatch;
import uk.co.caprica.vlcj.player.MediaResourceLocator;
import uk.co.caprica.vlcj.player.NativeString;
import uk.co.caprica.vlcj.player.TextTrackInfo;
import uk.co.caprica.vlcj.player.TitleDescription;
import uk.co.caprica.vlcj.player.TrackDescription;
import uk.co.caprica.vlcj.player.TrackInfo;
import uk.co.caprica.vlcj.player.TrackType;
import uk.co.caprica.vlcj.player.UnknownTrackInfo;
import uk.co.caprica.vlcj.player.VideoTrackInfo;
import uk.co.caprica.vlcj.player.WaitForSnapshot;
import uk.co.caprica.vlcj.player.condition.BeforeConditionAbortedException;
import uk.co.caprica.vlcj.player.events.MediaPlayerEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerEventFactory;
import uk.co.caprica.vlcj.player.events.MediaPlayerEventType;
import uk.co.caprica.vlcj.player.media.Media;
import uk.co.caprica.vlcj.player.media.callback.CallbackMedia;
import uk.co.caprica.vlcj.player.media.simple.SimpleMedia;
import uk.co.caprica.vlcj.version.LibVlcVersion;
import uk.co.caprica.vlcj.version.Version;

public abstract class DefaultMediaPlayer
extends AbstractMediaPlayer
implements MediaPlayer,
EqualizerListener {
    private final Logger logger = LoggerFactory.getLogger(DefaultMediaPlayer.class);
    private final CopyOnWriteArrayList<MediaPlayerEventListener> eventListenerList = new CopyOnWriteArrayList();
    private final MediaPlayerEventFactory eventFactory = new MediaPlayerEventFactory(this);
    private final ExecutorService listenersService = Executors.newSingleThreadExecutor();
    private libvlc_media_player_t mediaPlayerInstance;
    private libvlc_event_manager_t mediaPlayerEventManager;
    private libvlc_callback_t callback;
    private libvlc_media_t mediaInstance;
    private long eventMask = MediaPlayerEventType.ALL.value();
    private String[] standardMediaOptions;
    private libvlc_media_stats_t libvlcMediaStats;
    private boolean repeat;
    private boolean playSubItems;
    private int subItemIndex;
    private String snapshotDirectoryName;
    private Equalizer equalizer;
    private libvlc_equalizer_t equalizerInstance;
    private Object userData;
    private final AtomicBoolean released = new AtomicBoolean();
    private Media lastPlayedMedia;

    public DefaultMediaPlayer(LibVlc libVlc, libvlc_instance_t libvlc_instance_t2) {
        super(libVlc, libvlc_instance_t2);
        this.logger.debug("DefaultMediaPlayer(libvlc={}, instance={})", (Object)libVlc, (Object)libvlc_instance_t2);
        this.createInstance();
    }

    @Override
    public void addMediaPlayerEventListener(MediaPlayerEventListener mediaPlayerEventListener) {
        this.logger.debug("addMediaPlayerEventListener(listener={})", (Object)mediaPlayerEventListener);
        if (mediaPlayerEventListener == null) {
            throw new IllegalArgumentException("listener can not be null");
        }
        this.eventListenerList.add(mediaPlayerEventListener);
    }

    @Override
    public void removeMediaPlayerEventListener(MediaPlayerEventListener mediaPlayerEventListener) {
        this.logger.debug("removeMediaPlayerEventListener(listener={})", (Object)mediaPlayerEventListener);
        if (mediaPlayerEventListener == null) {
            throw new IllegalArgumentException("listener can not be null");
        }
        this.eventListenerList.remove(mediaPlayerEventListener);
    }

    @Override
    public void enableEvents(long l) {
        this.logger.debug("enableEvents(eventMask={})", (Object)l);
        this.eventMask = l;
    }

    @Override
    public void setStandardMediaOptions(String ... stringArray) {
        this.logger.debug("setStandardMediaOptions(options={})", (Object)Arrays.toString(stringArray));
        this.standardMediaOptions = stringArray;
    }

    @Override
    public boolean playMedia(String string, String ... stringArray) {
        this.logger.debug("playMedia(mrl={},mediaOptions={})", (Object)string, (Object)Arrays.toString(stringArray));
        return this.playMedia(new SimpleMedia(string, stringArray));
    }

    @Override
    public boolean playMedia(Media media) {
        this.logger.debug("playMedia(media={})", (Object)media);
        if (this.prepareMedia(media)) {
            this.play();
            return true;
        }
        return false;
    }

    @Override
    public boolean prepareMedia(String string, String ... stringArray) {
        this.logger.debug("prepareMedia(mrl={},mediaOptions={})", (Object)string, (Object)Arrays.toString(stringArray));
        return this.prepareMedia(new SimpleMedia(string, stringArray));
    }

    @Override
    public boolean prepareMedia(Media media) {
        this.logger.debug("prepareMedia(media={})", (Object)media);
        return this.setMedia(media);
    }

    @Override
    public boolean startMedia(String string, String ... stringArray) {
        this.logger.debug("startMedia(mrl={}, mediaOptions={})", (Object)string, (Object)Arrays.toString(stringArray));
        return this.startMedia(new SimpleMedia(string, stringArray));
    }

    @Override
    public boolean startMedia(Media media) {
        this.logger.debug("startMedia(media={})", (Object)media);
        if (this.prepareMedia(media)) {
            return new MediaPlayerLatch(this).play();
        }
        return false;
    }

    @Override
    public void parseMedia() {
        this.logger.debug("parseMedia()");
        if (this.mediaInstance == null) {
            throw new IllegalStateException("No media");
        }
        this.libvlc.libvlc_media_parse(this.mediaInstance);
    }

    @Override
    public void requestParseMedia() {
        this.logger.debug("requestParseMedia()");
        if (this.mediaInstance == null) {
            throw new IllegalStateException("No media");
        }
        this.libvlc.libvlc_media_parse_async(this.mediaInstance);
    }

    @Override
    public boolean requestParseMediaWithOptions(libvlc_media_parse_flag_t ... libvlc_media_parse_flag_tArray) {
        this.logger.debug("requestParseMediaWithOptions(options={})", (Object)(libvlc_media_parse_flag_tArray != null ? Arrays.toString((Object[])libvlc_media_parse_flag_tArray) : ""));
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_300)) {
            int n = 0;
            for (libvlc_media_parse_flag_t libvlc_media_parse_flag_t2 : libvlc_media_parse_flag_tArray) {
                n |= libvlc_media_parse_flag_t2.intValue();
            }
            return this.libvlc.libvlc_media_parse_with_options(this.mediaInstance, n) == 0;
        }
        return false;
    }

    @Override
    public boolean isMediaParsed() {
        this.logger.debug("isMediaParsed()");
        if (this.mediaInstance != null) {
            return 0 != this.libvlc.libvlc_media_is_parsed(this.mediaInstance);
        }
        throw new IllegalStateException("No media");
    }

    @Override
    public MediaMeta getMediaMeta() {
        this.logger.debug("getMediaMeta()");
        return this.getMediaMeta(this.mediaInstance);
    }

    @Override
    public MediaMeta getMediaMeta(libvlc_media_t libvlc_media_t2) {
        this.logger.debug("getMediaMeta(media={})", (Object)libvlc_media_t2);
        if (libvlc_media_t2 != null) {
            return new DefaultMediaMeta(this.libvlc, libvlc_media_t2);
        }
        throw new IllegalStateException("No media");
    }

    @Override
    public List<MediaMeta> getSubItemMediaMeta() {
        this.logger.debug("getSubItemMediaMeta()");
        return this.handleSubItems(new SubItemsHandler<List<MediaMeta>>(){

            @Override
            public List<MediaMeta> subItems(int n, libvlc_media_list_t libvlc_media_list_t2) {
                ArrayList<MediaMeta> arrayList = new ArrayList<MediaMeta>(n);
                for (libvlc_media_t libvlc_media_t2 : new LibVlcMediaListIterator(DefaultMediaPlayer.this.libvlc, libvlc_media_list_t2)) {
                    arrayList.add(DefaultMediaPlayer.this.getMediaMeta(libvlc_media_t2));
                }
                return arrayList;
            }
        });
    }

    @Override
    public MediaMetaData getMediaMetaData() {
        this.logger.debug("getMediaMetaData()");
        return this.getMediaMeta().asMediaMetaData();
    }

    @Override
    public List<MediaMetaData> getSubItemMediaMetaData() {
        ArrayList<MediaMetaData> arrayList;
        this.logger.debug("getSubItemMediaMetaData()");
        List<MediaMeta> list = this.getSubItemMediaMeta();
        if (list != null) {
            arrayList = new ArrayList<MediaMetaData>(list.size());
            for (MediaMeta mediaMeta : this.getSubItemMediaMeta()) {
                arrayList.add(mediaMeta.asMediaMetaData());
            }
        } else {
            arrayList = null;
        }
        return arrayList;
    }

    @Override
    public void addMediaOptions(String ... stringArray) {
        this.logger.debug("addMediaOptions(mediaOptions={})", (Object)Arrays.toString(stringArray));
        if (this.mediaInstance != null) {
            for (String string : stringArray) {
                this.logger.debug("mediaOption={}", (Object)string);
                this.libvlc.libvlc_media_add_option(this.mediaInstance, string);
            }
        } else {
            throw new IllegalStateException("No media");
        }
    }

    @Override
    public void setRepeat(boolean bl) {
        this.logger.debug("setRepeat(repeat={})", (Object)bl);
        this.repeat = bl;
    }

    @Override
    public boolean getRepeat() {
        this.logger.debug("getRepeat()");
        return this.repeat;
    }

    @Override
    public void setPlaySubItems(boolean bl) {
        this.logger.debug("setPlaySubItems(playSubItems={})", (Object)bl);
        this.playSubItems = bl;
    }

    @Override
    public int subItemCount() {
        this.logger.debug("subItemCount()");
        return this.handleSubItems(new SubItemsHandler<Integer>(){

            @Override
            public Integer subItems(int n, libvlc_media_list_t libvlc_media_list_t2) {
                return n;
            }
        });
    }

    @Override
    public int subItemIndex() {
        return this.subItemIndex;
    }

    @Override
    public List<String> subItems() {
        this.logger.debug("subItems()");
        return this.handleSubItems(new SubItemsHandler<List<String>>(){

            @Override
            public List<String> subItems(int n, libvlc_media_list_t libvlc_media_list_t2) {
                ArrayList<String> arrayList = new ArrayList<String>(n);
                for (libvlc_media_t libvlc_media_t2 : new LibVlcMediaListIterator(DefaultMediaPlayer.this.libvlc, libvlc_media_list_t2)) {
                    arrayList.add(NativeString.getNativeString(DefaultMediaPlayer.this.libvlc, DefaultMediaPlayer.this.libvlc.libvlc_media_get_mrl(libvlc_media_t2)));
                }
                return arrayList;
            }
        });
    }

    @Override
    public List<libvlc_media_t> subItemsMedia() {
        this.logger.debug("subItemsMedia()");
        return this.handleSubItems(new SubItemsHandler<List<libvlc_media_t>>(){

            @Override
            public List<libvlc_media_t> subItems(int n, libvlc_media_list_t libvlc_media_list_t2) {
                ArrayList<libvlc_media_t> arrayList = new ArrayList<libvlc_media_t>(n);
                for (libvlc_media_t libvlc_media_t2 : new LibVlcMediaListIterator(DefaultMediaPlayer.this.libvlc, libvlc_media_list_t2)) {
                    arrayList.add(libvlc_media_t2);
                }
                return arrayList;
            }
        });
    }

    @Override
    public MediaList subItemsMediaList() {
        MediaList mediaList;
        this.logger.debug("subItemsMediaList()");
        if (this.mediaInstance != null) {
            libvlc_media_list_t libvlc_media_list_t2 = this.libvlc.libvlc_media_subitems(this.mediaInstance);
            mediaList = new MediaList(this.libvlc, this.instance, libvlc_media_list_t2);
            this.libvlc.libvlc_media_list_release(libvlc_media_list_t2);
        } else {
            mediaList = null;
        }
        return mediaList;
    }

    @Override
    public boolean playNextSubItem(String ... stringArray) {
        this.logger.debug("playNextSubItem(mediaOptions={})", (Object)Arrays.toString(stringArray));
        return this.playSubItem(this.subItemIndex + 1, stringArray);
    }

    @Override
    public boolean playSubItem(final int n, final String ... stringArray) {
        this.logger.debug("playSubItem(index={},mediaOptions={})", (Object)n, (Object)Arrays.toString(stringArray));
        return this.handleSubItems(new SubItemsHandler<Boolean>(){

            @Override
            public Boolean subItems(int n2, libvlc_media_list_t libvlc_media_list_t2) {
                if (libvlc_media_list_t2 != null) {
                    DefaultMediaPlayer.this.logger.debug("Handling media sub-item...");
                    DefaultMediaPlayer.this.logger.debug("count={}", (Object)n2);
                    DefaultMediaPlayer.this.subItemIndex = n;
                    DefaultMediaPlayer.this.logger.debug("subItemIndex={}", (Object)DefaultMediaPlayer.this.subItemIndex);
                    if (DefaultMediaPlayer.this.subItemIndex >= n2) {
                        DefaultMediaPlayer.this.logger.debug("End of sub-items reached");
                        if (!DefaultMediaPlayer.this.repeat) {
                            DefaultMediaPlayer.this.logger.debug("Do not repeat sub-items");
                            DefaultMediaPlayer.this.subItemIndex = -1;
                            DefaultMediaPlayer.this.logger.debug("Raising events for end of sub-items");
                            DefaultMediaPlayer.this.raiseEvent(DefaultMediaPlayer.this.eventFactory.createMediaEndOfSubItemsEvent(DefaultMediaPlayer.this.eventMask));
                        } else {
                            DefaultMediaPlayer.this.logger.debug("Repeating sub-items");
                            DefaultMediaPlayer.this.subItemIndex = 0;
                        }
                    }
                    if (DefaultMediaPlayer.this.subItemIndex != -1) {
                        libvlc_media_t libvlc_media_t2 = DefaultMediaPlayer.this.libvlc.libvlc_media_list_item_at_index(libvlc_media_list_t2, DefaultMediaPlayer.this.subItemIndex);
                        DefaultMediaPlayer.this.logger.debug("subItem={}", (Object)libvlc_media_t2);
                        if (libvlc_media_t2 != null) {
                            DefaultMediaPlayer.this.logger.debug("subItemMrl={}", (Object)DefaultMediaPlayer.this.mrl(libvlc_media_t2));
                            DefaultMediaPlayer.this.libvlc.libvlc_media_player_set_media(DefaultMediaPlayer.this.mediaPlayerInstance, libvlc_media_t2);
                            if (DefaultMediaPlayer.this.standardMediaOptions != null) {
                                for (String string : DefaultMediaPlayer.this.standardMediaOptions) {
                                    DefaultMediaPlayer.this.logger.debug("standardMediaOption={}", (Object)string);
                                    DefaultMediaPlayer.this.libvlc.libvlc_media_add_option(libvlc_media_t2, string);
                                }
                            }
                            if (stringArray != null) {
                                for (String string : stringArray) {
                                    DefaultMediaPlayer.this.logger.debug("mediaOption={}", (Object)string);
                                    DefaultMediaPlayer.this.libvlc.libvlc_media_add_option(libvlc_media_t2, string);
                                }
                            }
                            DefaultMediaPlayer.this.libvlc.libvlc_media_player_play(DefaultMediaPlayer.this.mediaPlayerInstance);
                            DefaultMediaPlayer.this.libvlc.libvlc_media_release(libvlc_media_t2);
                            DefaultMediaPlayer.this.logger.debug("Raising played event for sub-item {}", (Object)DefaultMediaPlayer.this.subItemIndex);
                            DefaultMediaPlayer.this.raiseEvent(DefaultMediaPlayer.this.eventFactory.createMediaSubItemPlayedEvent(DefaultMediaPlayer.this.subItemIndex, DefaultMediaPlayer.this.eventMask));
                            return true;
                        }
                    }
                }
                return false;
            }
        });
    }

    @Override
    public boolean isPlayable() {
        this.logger.trace("isPlayable()");
        return this.libvlc.libvlc_media_player_will_play(this.mediaPlayerInstance) == 1;
    }

    @Override
    public boolean isPlaying() {
        this.logger.trace("isPlaying()");
        return this.libvlc.libvlc_media_player_is_playing(this.mediaPlayerInstance) == 1;
    }

    @Override
    public boolean isSeekable() {
        this.logger.trace("isSeekable()");
        return this.libvlc.libvlc_media_player_is_seekable(this.mediaPlayerInstance) == 1;
    }

    @Override
    public boolean canPause() {
        this.logger.trace("canPause()");
        return this.libvlc.libvlc_media_player_can_pause(this.mediaPlayerInstance) == 1;
    }

    @Override
    public boolean programScrambled() {
        this.logger.trace("programScrambled()");
        return this.libvlc.libvlc_media_player_program_scrambled(this.mediaPlayerInstance) == 1;
    }

    @Override
    public long getLength() {
        this.logger.trace("getLength()");
        return this.libvlc.libvlc_media_player_get_length(this.mediaPlayerInstance);
    }

    @Override
    public long getTime() {
        this.logger.trace("getTime()");
        return this.libvlc.libvlc_media_player_get_time(this.mediaPlayerInstance);
    }

    @Override
    public float getPosition() {
        this.logger.trace("getPosition()");
        return this.libvlc.libvlc_media_player_get_position(this.mediaPlayerInstance);
    }

    @Override
    public float getFps() {
        this.logger.trace("getFps()");
        return this.libvlc.libvlc_media_player_get_fps(this.mediaPlayerInstance);
    }

    @Override
    public float getRate() {
        this.logger.trace("getRate()");
        return this.libvlc.libvlc_media_player_get_rate(this.mediaPlayerInstance);
    }

    @Override
    public int getVideoOutputs() {
        this.logger.trace("getVideoOutputs()");
        return this.libvlc.libvlc_media_player_has_vout(this.mediaPlayerInstance);
    }

    @Override
    public Dimension getVideoDimension() {
        this.logger.debug("getVideoDimension()");
        if (this.getVideoOutputs() > 0) {
            IntByReference intByReference = new IntByReference();
            IntByReference intByReference2 = new IntByReference();
            int n = this.libvlc.libvlc_video_get_size(this.mediaPlayerInstance, 0, intByReference, intByReference2);
            if (n == 0) {
                return new Dimension(intByReference.getValue(), intByReference2.getValue());
            }
            this.logger.warn("Video size is not available");
            return null;
        }
        this.logger.warn("Can't get video dimension if no video output has been started");
        return null;
    }

    @Override
    public MediaDetails getMediaDetails() {
        this.logger.debug("getMediaDetails()");
        if (this.isPlaying()) {
            MediaDetails mediaDetails = new MediaDetails();
            mediaDetails.setTitleCount(this.getTitleCount());
            mediaDetails.setVideoTrackCount(this.getVideoTrackCount());
            mediaDetails.setAudioTrackCount(this.getAudioTrackCount());
            mediaDetails.setSpuCount(this.getSpuCount());
            mediaDetails.setTitleDescriptions(this.getTitleDescriptions());
            mediaDetails.setVideoDescriptions(this.getVideoDescriptions());
            mediaDetails.setAudioDescriptions(this.getAudioDescriptions());
            mediaDetails.setSpuDescriptions(this.getSpuDescriptions());
            mediaDetails.setChapterDescriptions(this.getAllChapterDescriptions());
            return mediaDetails;
        }
        this.logger.warn("Can't get media meta data if media is not playing");
        return null;
    }

    @Override
    public String getAspectRatio() {
        this.logger.debug("getAspectRatio()");
        return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_video_get_aspect_ratio(this.mediaPlayerInstance));
    }

    @Override
    public float getScale() {
        this.logger.debug("getScale()");
        return this.libvlc.libvlc_video_get_scale(this.mediaPlayerInstance);
    }

    @Override
    public String getCropGeometry() {
        this.logger.debug("getCropGeometry()");
        return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_video_get_crop_geometry(this.mediaPlayerInstance));
    }

    @Override
    public libvlc_media_stats_t getMediaStatistics() {
        this.logger.trace("getMediaStatistics()");
        return this.getMediaStatistics(this.mediaInstance);
    }

    @Override
    public libvlc_media_stats_t getMediaStatistics(libvlc_media_t libvlc_media_t2) {
        this.logger.trace("getMediaStatistics(media={})", (Object)libvlc_media_t2);
        if (this.isPlaying() && libvlc_media_t2 != null) {
            this.libvlc.libvlc_media_get_stats(libvlc_media_t2, this.libvlcMediaStats);
        }
        return this.libvlcMediaStats;
    }

    @Override
    public libvlc_state_t getMediaState() {
        this.logger.debug("getMediaState()");
        libvlc_state_t libvlc_state_t2 = null;
        if (this.mediaInstance != null) {
            libvlc_state_t2 = libvlc_state_t.state(this.libvlc.libvlc_media_get_state(this.mediaInstance));
        }
        return libvlc_state_t2;
    }

    @Override
    public libvlc_state_t getMediaPlayerState() {
        this.logger.debug("getMediaPlayerState()");
        return libvlc_state_t.state(this.libvlc.libvlc_media_player_get_state(this.mediaPlayerInstance));
    }

    @Override
    public int getTitleCount() {
        this.logger.debug("getTitleCount()");
        return this.libvlc.libvlc_media_player_get_title_count(this.mediaPlayerInstance);
    }

    @Override
    public int getTitle() {
        this.logger.debug("getTitle()");
        return this.libvlc.libvlc_media_player_get_title(this.mediaPlayerInstance);
    }

    @Override
    public void setTitle(int n) {
        this.logger.debug("setTitle(title={})", (Object)n);
        this.libvlc.libvlc_media_player_set_title(this.mediaPlayerInstance, n);
    }

    @Override
    public int getVideoTrackCount() {
        this.logger.debug("getVideoTrackCount()");
        return this.libvlc.libvlc_video_get_track_count(this.mediaPlayerInstance);
    }

    @Override
    public int getVideoTrack() {
        this.logger.debug("getVideoTrack()");
        return this.libvlc.libvlc_video_get_track(this.mediaPlayerInstance);
    }

    @Override
    public int setVideoTrack(int n) {
        this.logger.debug("setVideoTrack(track={})", (Object)n);
        this.libvlc.libvlc_video_set_track(this.mediaPlayerInstance, n);
        return this.getVideoTrack();
    }

    @Override
    public int getAudioTrackCount() {
        this.logger.debug("getVideoTrackCount()");
        return this.libvlc.libvlc_audio_get_track_count(this.mediaPlayerInstance);
    }

    @Override
    public int getAudioTrack() {
        this.logger.debug("getAudioTrack()");
        return this.libvlc.libvlc_audio_get_track(this.mediaPlayerInstance);
    }

    @Override
    public int setAudioTrack(int n) {
        this.logger.debug("setAudioTrack(track={})", (Object)n);
        this.libvlc.libvlc_audio_set_track(this.mediaPlayerInstance, n);
        return this.getAudioTrack();
    }

    @Override
    public void play() {
        this.logger.debug("play()");
        this.onBeforePlay();
        this.libvlc.libvlc_media_player_play(this.mediaPlayerInstance);
        this.logger.debug("after play");
    }

    @Override
    public boolean start() {
        return new MediaPlayerLatch(this).play();
    }

    @Override
    public void stop() {
        this.logger.debug("stop()");
        this.libvlc.libvlc_media_player_stop(this.mediaPlayerInstance);
    }

    @Override
    public void setPause(boolean bl) {
        this.logger.debug("setPause(pause={})", (Object)bl);
        this.libvlc.libvlc_media_player_set_pause(this.mediaPlayerInstance, bl ? 1 : 0);
    }

    @Override
    public void pause() {
        this.logger.debug("pause()");
        this.libvlc.libvlc_media_player_pause(this.mediaPlayerInstance);
    }

    @Override
    public void nextFrame() {
        this.logger.debug("nextFrame()");
        this.libvlc.libvlc_media_player_next_frame(this.mediaPlayerInstance);
    }

    @Override
    public void skip(long l) {
        this.logger.debug("skip(delta={})", (Object)l);
        long l2 = this.getTime();
        this.logger.debug("current={}", (Object)l2);
        if (l2 != -1L) {
            this.setTime(l2 + l);
        }
    }

    @Override
    public void skipPosition(float f) {
        this.logger.debug("skipPosition(delta={})", (Object)Float.valueOf(f));
        float f2 = this.getPosition();
        this.logger.debug("current={}", (Object)Float.valueOf(f2));
        if (f2 != -1.0f) {
            this.setPosition(f2 + f);
        }
    }

    @Override
    public void setTime(long l) {
        this.logger.debug("setTime(time={})", (Object)l);
        this.libvlc.libvlc_media_player_set_time(this.mediaPlayerInstance, Math.max(l, 0L));
    }

    @Override
    public void setPosition(float f) {
        this.logger.debug("setPosition(position={})", (Object)Float.valueOf(f));
        this.libvlc.libvlc_media_player_set_position(this.mediaPlayerInstance, Math.max(f, 0.0f));
    }

    @Override
    public int setRate(float f) {
        this.logger.debug("setRate(rate={})", (Object)Float.valueOf(f));
        return this.libvlc.libvlc_media_player_set_rate(this.mediaPlayerInstance, f);
    }

    @Override
    public void setAspectRatio(String string) {
        this.logger.debug("setAspectRatio(aspectRatio={})", (Object)string);
        this.libvlc.libvlc_video_set_aspect_ratio(this.mediaPlayerInstance, string);
    }

    @Override
    public void setScale(float f) {
        this.logger.debug("setScale(factor={})", (Object)Float.valueOf(f));
        this.libvlc.libvlc_video_set_scale(this.mediaPlayerInstance, f);
    }

    @Override
    public void setCropGeometry(String string) {
        this.logger.debug("setCropGeometry(cropGeometry={})", (Object)string);
        this.libvlc.libvlc_video_set_crop_geometry(this.mediaPlayerInstance, string);
    }

    @Override
    public boolean setAudioOutput(String string) {
        this.logger.debug("setAudioOutput(output={})", (Object)string);
        return 0 == this.libvlc.libvlc_audio_output_set(this.mediaPlayerInstance, string);
    }

    @Override
    public void setAudioOutputDevice(String string, String string2) {
        this.logger.debug("setAudioOutputDevice(output={},outputDeviceId={})", (Object)string, (Object)string2);
        this.libvlc.libvlc_audio_output_device_set(this.mediaPlayerInstance, string, string2);
    }

    @Override
    public String getAudioOutputDevice() {
        this.logger.debug("getAudioOutputDevice()");
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_300)) {
            return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_audio_output_device_get(this.mediaPlayerInstance));
        }
        return null;
    }

    @Override
    public List<AudioDevice> getAudioOutputDevices() {
        this.logger.debug("getAudioOutputDevices()");
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_220)) {
            ArrayList<AudioDevice> arrayList = new ArrayList<AudioDevice>();
            libvlc_audio_output_device_t libvlc_audio_output_device_t2 = this.libvlc.libvlc_audio_output_device_enum(this.mediaPlayerInstance);
            if (libvlc_audio_output_device_t2 != null) {
                libvlc_audio_output_device_t2.setAutoSynch(false);
                libvlc_audio_output_device_t libvlc_audio_output_device_t3 = libvlc_audio_output_device_t2;
                while (libvlc_audio_output_device_t3 != null) {
                    String string = NativeString.copyNativeString(this.libvlc, libvlc_audio_output_device_t3.psz_device);
                    String string2 = NativeString.copyNativeString(this.libvlc, libvlc_audio_output_device_t3.psz_description);
                    arrayList.add(new AudioDevice(string, string2));
                    libvlc_audio_output_device_t3 = libvlc_audio_output_device_t3.p_next;
                }
                this.libvlc.libvlc_audio_output_device_list_release(libvlc_audio_output_device_t2);
            }
            return arrayList;
        }
        this.logger.warn("Audio output device enumeration requires libvlc 2.2.0 or later");
        return null;
    }

    @Override
    public boolean mute() {
        this.logger.debug("mute()");
        this.libvlc.libvlc_audio_toggle_mute(this.mediaPlayerInstance);
        return this.isMute();
    }

    @Override
    public void mute(boolean bl) {
        this.logger.debug("mute(mute={})", (Object)bl);
        this.libvlc.libvlc_audio_set_mute(this.mediaPlayerInstance, bl ? 1 : 0);
    }

    @Override
    public boolean isMute() {
        this.logger.debug("isMute()");
        return this.libvlc.libvlc_audio_get_mute(this.mediaPlayerInstance) != 0;
    }

    @Override
    public int getVolume() {
        this.logger.debug("getVolume()");
        return this.libvlc.libvlc_audio_get_volume(this.mediaPlayerInstance);
    }

    @Override
    public void setVolume(int n) {
        this.logger.debug("setVolume(volume={})", (Object)n);
        this.libvlc.libvlc_audio_set_volume(this.mediaPlayerInstance, n);
    }

    @Override
    public int getAudioChannel() {
        this.logger.debug("getAudioChannel()");
        return this.libvlc.libvlc_audio_get_channel(this.mediaPlayerInstance);
    }

    @Override
    public void setAudioChannel(int n) {
        this.logger.debug("setAudioChannel(channel={})", (Object)n);
        this.libvlc.libvlc_audio_set_channel(this.mediaPlayerInstance, n);
    }

    @Override
    public long getAudioDelay() {
        this.logger.debug("getAudioDelay()");
        return this.libvlc.libvlc_audio_get_delay(this.mediaPlayerInstance);
    }

    @Override
    public void setAudioDelay(long l) {
        this.logger.debug("setAudioDelay(delay={})", (Object)l);
        this.libvlc.libvlc_audio_set_delay(this.mediaPlayerInstance, l);
    }

    @Override
    public int getChapterCount() {
        this.logger.trace("getChapterCount()");
        return this.libvlc.libvlc_media_player_get_chapter_count(this.mediaPlayerInstance);
    }

    @Override
    public int getChapter() {
        this.logger.trace("getChapter()");
        return this.libvlc.libvlc_media_player_get_chapter(this.mediaPlayerInstance);
    }

    @Override
    public void setChapter(int n) {
        this.logger.debug("setChapter(chapterNumber={})", (Object)n);
        this.libvlc.libvlc_media_player_set_chapter(this.mediaPlayerInstance, n);
    }

    @Override
    public void nextChapter() {
        this.logger.debug("nextChapter()");
        this.libvlc.libvlc_media_player_next_chapter(this.mediaPlayerInstance);
    }

    @Override
    public void previousChapter() {
        this.logger.debug("previousChapter()");
        this.libvlc.libvlc_media_player_previous_chapter(this.mediaPlayerInstance);
    }

    @Override
    public void menuActivate() {
        this.logger.debug("menuActivate()");
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_activate.intValue());
    }

    @Override
    public void menuUp() {
        this.logger.debug("menuUp()");
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_up.intValue());
    }

    @Override
    public void menuDown() {
        this.logger.debug("menuDown()");
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_down.intValue());
    }

    @Override
    public void menuLeft() {
        this.logger.debug("menuLeft()");
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_left.intValue());
    }

    @Override
    public void menuRight() {
        this.logger.debug("menuRight()");
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_right.intValue());
    }

    @Override
    public int getSpuCount() {
        this.logger.debug("getSpuCount()");
        return this.libvlc.libvlc_video_get_spu_count(this.mediaPlayerInstance);
    }

    @Override
    public int getSpu() {
        this.logger.debug("getSpu()");
        return this.libvlc.libvlc_video_get_spu(this.mediaPlayerInstance);
    }

    @Override
    public int setSpu(int n) {
        this.logger.debug("setSpu(spu={})", (Object)n);
        this.libvlc.libvlc_video_set_spu(this.mediaPlayerInstance, n);
        return this.getSpu();
    }

    @Override
    public long getSpuDelay() {
        this.logger.debug("getSpuDelay()");
        return this.libvlc.libvlc_video_get_spu_delay(this.mediaPlayerInstance);
    }

    @Override
    public void setSpuDelay(long l) {
        this.logger.debug("setSpuDelay(delay={})", (Object)l);
        this.libvlc.libvlc_video_set_spu_delay(this.mediaPlayerInstance, l);
    }

    @Override
    public void setSubTitleFile(String string) {
        this.logger.debug("setSubTitleFile(subTitleFileName={})", (Object)string);
        this.libvlc.libvlc_video_set_subtitle_file(this.mediaPlayerInstance, string);
    }

    @Override
    public void setSubTitleFile(File file) {
        this.logger.debug("setSubTitleFile(subTitleFile={})", (Object)file);
        this.setSubTitleFile(file.getAbsolutePath());
    }

    @Override
    public int getTeletextPage() {
        this.logger.debug("getTeletextPage()");
        return this.libvlc.libvlc_video_get_teletext(this.mediaPlayerInstance);
    }

    @Override
    public void setTeletextPage(int n) {
        this.logger.debug("setTeletextPage(pageNumber={})", (Object)n);
        this.libvlc.libvlc_video_set_teletext(this.mediaPlayerInstance, n);
    }

    @Override
    public void toggleTeletext() {
        this.logger.debug("toggleTeletext()");
        this.libvlc.libvlc_toggle_teletext(this.mediaPlayerInstance);
    }

    @Override
    public List<TrackDescription> getTitleDescriptions() {
        this.logger.debug("getTitleDescriptions()");
        libvlc_track_description_t libvlc_track_description_t2 = this.libvlc.libvlc_video_get_title_description(this.mediaPlayerInstance);
        return this.getTrackDescriptions(libvlc_track_description_t2);
    }

    @Override
    public List<TrackDescription> getVideoDescriptions() {
        this.logger.debug("getVideoDescriptions()");
        libvlc_track_description_t libvlc_track_description_t2 = this.libvlc.libvlc_video_get_track_description(this.mediaPlayerInstance);
        return this.getTrackDescriptions(libvlc_track_description_t2);
    }

    @Override
    public List<TrackDescription> getAudioDescriptions() {
        this.logger.debug("getAudioDescriptions()");
        libvlc_track_description_t libvlc_track_description_t2 = this.libvlc.libvlc_audio_get_track_description(this.mediaPlayerInstance);
        return this.getTrackDescriptions(libvlc_track_description_t2);
    }

    @Override
    public List<TrackDescription> getSpuDescriptions() {
        this.logger.debug("getSpuDescriptions()");
        libvlc_track_description_t libvlc_track_description_t2 = this.libvlc.libvlc_video_get_spu_description(this.mediaPlayerInstance);
        return this.getTrackDescriptions(libvlc_track_description_t2);
    }

    @Override
    public List<String> getChapterDescriptions(int n) {
        ArrayList<String> arrayList;
        this.logger.debug("getChapterDescriptions(title={})", (Object)n);
        if (n >= 0 && n < this.getTitleCount()) {
            libvlc_track_description_t libvlc_track_description_t2;
            arrayList = new ArrayList<String>();
            libvlc_track_description_t libvlc_track_description_t3 = libvlc_track_description_t2 = this.libvlc.libvlc_video_get_chapter_description(this.mediaPlayerInstance, n);
            while (libvlc_track_description_t3 != null) {
                arrayList.add(libvlc_track_description_t3.psz_name);
                libvlc_track_description_t3 = libvlc_track_description_t3.p_next;
            }
            if (libvlc_track_description_t2 != null) {
                this.libvlc.libvlc_track_description_list_release(libvlc_track_description_t2.getPointer());
            }
        } else {
            arrayList = null;
        }
        return arrayList;
    }

    @Override
    public List<String> getChapterDescriptions() {
        this.logger.debug("getChapterDescriptions()");
        return this.getChapterDescriptions(this.getTitle());
    }

    @Override
    public List<List<String>> getAllChapterDescriptions() {
        this.logger.debug("getAllChapterDescriptions()");
        int n = this.getTitleCount();
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>(Math.max(n, 0));
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getChapterDescriptions(i));
        }
        return arrayList;
    }

    @Override
    public List<TitleDescription> getExtendedTitleDescriptions() {
        ArrayList<TitleDescription> arrayList;
        this.logger.debug("getExtendedTitleDescriptions()");
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_300)) {
            PointerByReference pointerByReference = new PointerByReference();
            int n = this.libvlc.libvlc_media_player_get_full_title_descriptions(this.mediaPlayerInstance, pointerByReference);
            if (n != -1) {
                Pointer[] pointerArray;
                arrayList = new ArrayList(n);
                for (Pointer pointer : pointerArray = pointerByReference.getValue().getPointerArray(0L, n)) {
                    libvlc_title_description_t libvlc_title_description_t2 = (libvlc_title_description_t)Structure.newInstance(libvlc_title_description_t.class, pointer);
                    libvlc_title_description_t2.read();
                    arrayList.add(new TitleDescription(libvlc_title_description_t2.i_duration, NativeString.copyNativeString(this.libvlc, libvlc_title_description_t2.psz_name), libvlc_title_description_t2.b_menu != 0));
                }
                this.libvlc.libvlc_title_descriptions_release(pointerByReference.getValue(), n);
            } else {
                arrayList = new ArrayList(0);
            }
        } else {
            arrayList = new ArrayList<TitleDescription>(0);
        }
        return arrayList;
    }

    @Override
    public List<ChapterDescription> getExtendedChapterDescriptions() {
        this.logger.debug("getExtendedChapterDescriptions()");
        return this.getExtendedChapterDescriptions(this.getTitle());
    }

    @Override
    public List<ChapterDescription> getExtendedChapterDescriptions(int n) {
        ArrayList<ChapterDescription> arrayList;
        this.logger.debug("getExtendedChapterDescriptions(title={})", (Object)n);
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_300)) {
            PointerByReference pointerByReference = new PointerByReference();
            int n2 = this.libvlc.libvlc_media_player_get_full_chapter_descriptions(this.mediaPlayerInstance, n, pointerByReference);
            if (n2 != -1) {
                Pointer[] pointerArray;
                arrayList = new ArrayList(n2);
                for (Pointer pointer : pointerArray = pointerByReference.getValue().getPointerArray(0L, n2)) {
                    libvlc_chapter_description_t libvlc_chapter_description_t2 = (libvlc_chapter_description_t)Structure.newInstance(libvlc_chapter_description_t.class, pointer);
                    libvlc_chapter_description_t2.read();
                    arrayList.add(new ChapterDescription(libvlc_chapter_description_t2.i_time_offset, libvlc_chapter_description_t2.i_duration, NativeString.getNativeString(this.libvlc, libvlc_chapter_description_t2.psz_name)));
                }
                this.libvlc.libvlc_chapter_descriptions_release(pointerByReference.getValue(), n2);
            } else {
                arrayList = new ArrayList(0);
            }
        } else {
            arrayList = new ArrayList<ChapterDescription>(0);
        }
        return arrayList;
    }

    @Override
    public List<TrackInfo> getTrackInfo(TrackType ... trackTypeArray) {
        this.logger.debug("getTrackInfo(types={})", (Object)Arrays.toString((Object[])trackTypeArray));
        return this.getTrackInfo(this.mediaInstance, trackTypeArray);
    }

    @Override
    public List<TrackInfo> getTrackInfo(libvlc_media_t libvlc_media_t2, TrackType ... trackTypeArray) {
        this.logger.debug("getTrackInfo(media={},types={})", (Object)libvlc_media_t2, (Object)Arrays.toString((Object[])trackTypeArray));
        List<TrackInfo> list = null;
        if (libvlc_media_t2 != null) {
            HashSet<TrackType> hashSet;
            if (trackTypeArray == null || trackTypeArray.length == 0) {
                hashSet = null;
            } else {
                hashSet = new HashSet<TrackType>(trackTypeArray.length);
                for (TrackType trackType : trackTypeArray) {
                    hashSet.add(trackType);
                }
            }
            list = this.getTrackInfo(libvlc_media_t2, hashSet);
        }
        return list;
    }

    private List<TrackInfo> getTrackInfo(libvlc_media_t libvlc_media_t2, Set<TrackType> set) {
        this.logger.debug("newGetTrackInfo(media={},types={})", (Object)libvlc_media_t2, (Object)set);
        PointerByReference pointerByReference = new PointerByReference();
        int n = this.libvlc.libvlc_media_tracks_get(libvlc_media_t2, pointerByReference);
        this.logger.debug("numberOfTracks={}", (Object)n);
        ArrayList<TrackInfo> arrayList = new ArrayList<TrackInfo>(n);
        if (n > 0) {
            Pointer[] pointerArray;
            block6: for (Pointer pointer : pointerArray = pointerByReference.getValue().getPointerArray(0L, n)) {
                libvlc_media_track_t libvlc_media_track_t2 = new libvlc_media_track_t(pointer);
                switch (libvlc_track_type_t.valueOf(libvlc_media_track_t2.i_type)) {
                    case libvlc_track_unknown: {
                        if (set != null && !set.contains((Object)TrackType.UNKNOWN)) continue block6;
                        arrayList.add(new UnknownTrackInfo(libvlc_media_track_t2.i_codec, libvlc_media_track_t2.i_original_fourcc, libvlc_media_track_t2.i_id, libvlc_media_track_t2.i_profile, libvlc_media_track_t2.i_level, libvlc_media_track_t2.i_bitrate, NativeString.copyNativeString(this.libvlc, libvlc_media_track_t2.psz_language), NativeString.copyNativeString(this.libvlc, libvlc_media_track_t2.psz_description), this.getCodecDescription(libvlc_track_type_t.libvlc_track_unknown, libvlc_media_track_t2.i_codec)));
                        continue block6;
                    }
                    case libvlc_track_video: {
                        if (set != null && !set.contains((Object)TrackType.VIDEO)) continue block6;
                        libvlc_media_track_t2.u.setType(libvlc_video_track_t.class);
                        libvlc_media_track_t2.u.read();
                        arrayList.add(new VideoTrackInfo(libvlc_media_track_t2.i_codec, libvlc_media_track_t2.i_original_fourcc, libvlc_media_track_t2.i_id, libvlc_media_track_t2.i_profile, libvlc_media_track_t2.i_level, libvlc_media_track_t2.i_bitrate, NativeString.copyNativeString(this.libvlc, libvlc_media_track_t2.psz_language), NativeString.copyNativeString(this.libvlc, libvlc_media_track_t2.psz_description), libvlc_media_track_t2.u.video.i_width, libvlc_media_track_t2.u.video.i_height, libvlc_media_track_t2.u.video.i_sar_num, libvlc_media_track_t2.u.video.i_sar_den, libvlc_media_track_t2.u.video.i_frame_rate_num, libvlc_media_track_t2.u.video.i_frame_rate_den, this.getCodecDescription(libvlc_track_type_t.libvlc_track_video, libvlc_media_track_t2.i_codec)));
                        continue block6;
                    }
                    case libvlc_track_audio: {
                        if (set != null && !set.contains((Object)TrackType.AUDIO)) continue block6;
                        libvlc_media_track_t2.u.setType(libvlc_audio_track_t.class);
                        libvlc_media_track_t2.u.read();
                        arrayList.add(new AudioTrackInfo(libvlc_media_track_t2.i_codec, libvlc_media_track_t2.i_original_fourcc, libvlc_media_track_t2.i_id, libvlc_media_track_t2.i_profile, libvlc_media_track_t2.i_level, libvlc_media_track_t2.i_bitrate, NativeString.copyNativeString(this.libvlc, libvlc_media_track_t2.psz_language), NativeString.copyNativeString(this.libvlc, libvlc_media_track_t2.psz_description), libvlc_media_track_t2.u.audio.i_channels, libvlc_media_track_t2.u.audio.i_rate, this.getCodecDescription(libvlc_track_type_t.libvlc_track_audio, libvlc_media_track_t2.i_codec)));
                        continue block6;
                    }
                    case libvlc_track_text: {
                        if (set != null && !set.contains((Object)TrackType.TEXT)) continue block6;
                        libvlc_media_track_t2.u.setType(libvlc_subtitle_track_t.class);
                        libvlc_media_track_t2.u.read();
                        arrayList.add(new TextTrackInfo(libvlc_media_track_t2.i_codec, libvlc_media_track_t2.i_original_fourcc, libvlc_media_track_t2.i_id, libvlc_media_track_t2.i_profile, libvlc_media_track_t2.i_level, libvlc_media_track_t2.i_bitrate, NativeString.copyNativeString(this.libvlc, libvlc_media_track_t2.psz_language), NativeString.copyNativeString(this.libvlc, libvlc_media_track_t2.psz_description), NativeString.copyNativeString(this.libvlc, libvlc_media_track_t2.u.subtitle.psz_encoding), this.getCodecDescription(libvlc_track_type_t.libvlc_track_text, libvlc_media_track_t2.i_codec)));
                    }
                }
            }
            this.libvlc.libvlc_media_tracks_release(pointerByReference.getValue(), n);
        }
        return arrayList;
    }

    @Override
    public libvlc_media_type_e getMediaType() {
        this.logger.debug("getMediaType()");
        return this.getMediaType(this.mediaInstance);
    }

    @Override
    public libvlc_media_type_e getMediaType(libvlc_media_t libvlc_media_t2) {
        this.logger.debug("getMediaType(media={})", (Object)libvlc_media_t2);
        if (libvlc_media_t2 != null) {
            return libvlc_media_type_e.mediaType(this.libvlc.libvlc_media_get_type(libvlc_media_t2));
        }
        return null;
    }

    @Override
    public String getCodecDescription(libvlc_track_type_t libvlc_track_type_t2, int n) {
        this.logger.debug("getCodecDescription(type={},codec={})", (Object)libvlc_track_type_t2, (Object)n);
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_300)) {
            return this.libvlc.libvlc_media_get_codec_description(libvlc_track_type_t2.intValue(), n);
        }
        return "";
    }

    @Override
    public List<List<TrackInfo>> getSubItemTrackInfo(TrackType ... trackTypeArray) {
        this.logger.debug("getSubItemTrackInfo(types={})", (Object)Arrays.toString((Object[])trackTypeArray));
        return this.handleSubItems(new SubItemsHandler<List<List<TrackInfo>>>(){

            @Override
            public List<List<TrackInfo>> subItems(int n, libvlc_media_list_t libvlc_media_list_t2) {
                ArrayList<List<TrackInfo>> arrayList = new ArrayList<List<TrackInfo>>(n);
                for (libvlc_media_t libvlc_media_t2 : new LibVlcMediaListIterator(DefaultMediaPlayer.this.libvlc, libvlc_media_list_t2)) {
                    arrayList.add(DefaultMediaPlayer.this.getTrackInfo(libvlc_media_t2, new TrackType[0]));
                }
                return arrayList;
            }
        });
    }

    private List<TrackDescription> getTrackDescriptions(libvlc_track_description_t libvlc_track_description_t2) {
        this.logger.debug("getTrackDescriptions()");
        ArrayList<TrackDescription> arrayList = new ArrayList<TrackDescription>();
        libvlc_track_description_t libvlc_track_description_t3 = libvlc_track_description_t2;
        while (libvlc_track_description_t3 != null) {
            arrayList.add(new TrackDescription(libvlc_track_description_t3.i_id, libvlc_track_description_t3.psz_name));
            libvlc_track_description_t3 = libvlc_track_description_t3.p_next;
        }
        if (libvlc_track_description_t2 != null) {
            this.libvlc.libvlc_track_description_list_release(libvlc_track_description_t2.getPointer());
        }
        return arrayList;
    }

    @Override
    public void setSnapshotDirectory(String string) {
        this.logger.debug("setSnapshotDirectory(snapshotDirectoryName={})", (Object)string);
        this.snapshotDirectoryName = string;
    }

    @Override
    public boolean saveSnapshot() {
        this.logger.debug("saveSnapshot()");
        return this.saveSnapshot(0, 0);
    }

    @Override
    public boolean saveSnapshot(int n, int n2) {
        this.logger.debug("saveSnapshot(width={},height={})", (Object)n, (Object)n2);
        File file = new File(this.snapshotDirectoryName == null ? System.getProperty("user.home") : this.snapshotDirectoryName);
        File file2 = new File(file, "vlcj-snapshot-" + System.currentTimeMillis() + ".png");
        return this.saveSnapshot(file2, n, n2);
    }

    @Override
    public boolean saveSnapshot(File file) {
        this.logger.debug("saveSnapshot(file={})", (Object)file);
        return this.saveSnapshot(file, 0, 0);
    }

    @Override
    public boolean saveSnapshot(File file, int n, int n2) {
        this.logger.debug("saveSnapshot(file={},width={},height={})", file, n, n2);
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = new File(".");
            this.logger.debug("No directory specified for snapshot, snapshot will be saved to {}", (Object)file2.getAbsolutePath());
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (file2.exists()) {
            boolean bl = this.libvlc.libvlc_video_take_snapshot(this.mediaPlayerInstance, 0, file.getAbsolutePath(), n, n2) == 0;
            this.logger.debug("snapshotTaken={}", (Object)bl);
            return bl;
        }
        throw new RuntimeException("Directory does not exist and could not be created for '" + file.getAbsolutePath() + "'");
    }

    @Override
    public BufferedImage getSnapshot() {
        this.logger.debug("getSnapshot()");
        return this.getSnapshot(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getSnapshot(int n, int n2) {
        this.logger.debug("getSnapshot(width={},height={})", (Object)n, (Object)n2);
        File file = null;
        try {
            file = File.createTempFile("vlcj-snapshot-", ".png");
            this.logger.debug("file={}", (Object)file.getAbsolutePath());
            BufferedImage bufferedImage = ImageIO.read(new File((String)new WaitForSnapshot(this, file, n, n2).await()));
            return bufferedImage;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to get snapshot image", iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Failed to get snapshot image", interruptedException);
        }
        catch (BeforeConditionAbortedException beforeConditionAbortedException) {
            this.logger.debug("Failed to take snapshot");
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            if (file != null) {
                boolean bl = file.delete();
                this.logger.debug("deleted={}", (Object)bl);
            }
        }
    }

    @Override
    public void enableLogo(boolean bl) {
        this.logger.debug("enableLogo(enable={})", (Object)bl);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_enable.intValue(), bl ? 1 : 0);
    }

    @Override
    public void setLogoOpacity(int n) {
        this.logger.debug("setLogoOpacity(opacity={})", (Object)n);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_opacity.intValue(), n);
    }

    @Override
    public void setLogoOpacity(float f) {
        this.logger.debug("setLogoOpacity(opacity={})", (Object)Float.valueOf(f));
        int n = Math.round(f * 255.0f);
        this.logger.debug("opacityValue={}", (Object)n);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_opacity.intValue(), n);
    }

    @Override
    public void setLogoLocation(int n, int n2) {
        this.logger.debug("setLogoLocation(x={},y={})", (Object)n, (Object)n2);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_x.intValue(), n);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_y.intValue(), n2);
    }

    @Override
    public void setLogoPosition(libvlc_logo_position_e libvlc_logo_position_e2) {
        this.logger.debug("setLogoPosition(position={})", (Object)libvlc_logo_position_e2);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_position.intValue(), libvlc_logo_position_e2.intValue());
    }

    @Override
    public void setLogoFile(String string) {
        this.logger.debug("setLogoFile(logoFile={})", (Object)string);
        this.libvlc.libvlc_video_set_logo_string(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_file.intValue(), string);
    }

    @Override
    public void setLogoImage(RenderedImage renderedImage) {
        this.logger.debug("setLogoImage(logoImage={})", (Object)renderedImage);
        File file = null;
        try {
            file = File.createTempFile("vlcj-logo-", ".png");
            ImageIO.write(renderedImage, "png", file);
            if (file.exists()) {
                this.setLogoFile(file.getAbsolutePath());
                file.deleteOnExit();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to set logo image", iOException);
        }
    }

    @Override
    public void setLogo(Logo logo) {
        this.logger.debug("setLogo(logo={})", (Object)logo);
        logo.apply(this);
    }

    @Override
    public void enableMarquee(boolean bl) {
        this.logger.debug("enableMarquee(enable={})", (Object)bl);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Enable.intValue(), bl ? 1 : 0);
    }

    @Override
    public void setMarqueeText(String string) {
        this.logger.debug("setMarqueeText(text={})", (Object)string);
        this.libvlc.libvlc_video_set_marquee_string(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Text.intValue(), string);
    }

    @Override
    public void setMarqueeColour(Color color) {
        this.logger.debug("setMarqueeColour(colour={})", (Object)color);
        this.setMarqueeColour(color.getRGB() & 0xFFFFFF);
    }

    @Override
    public void setMarqueeColour(int n) {
        this.logger.debug("setMarqueeColour(colour={})", (Object)n);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Color.intValue(), n);
    }

    @Override
    public void setMarqueeOpacity(int n) {
        this.logger.debug("setMarqueeOpacity(opacity={})", (Object)n);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Opacity.intValue(), n);
    }

    @Override
    public void setMarqueeOpacity(float f) {
        this.logger.debug("setMarqueeOpacity(opacity={})", (Object)Float.valueOf(f));
        int n = Math.round(f * 255.0f);
        this.logger.debug("opacityValue={}", (Object)n);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Opacity.intValue(), n);
    }

    @Override
    public void setMarqueeSize(int n) {
        this.logger.debug("setMarqueeSize(size={})", (Object)n);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Size.intValue(), n);
    }

    @Override
    public void setMarqueeTimeout(int n) {
        this.logger.debug("setMarqueeTimeout(timeout={})", (Object)n);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Timeout.intValue(), n);
    }

    @Override
    public void setMarqueeLocation(int n, int n2) {
        this.logger.debug("setMarqueeLocation(x={},y={})", (Object)n, (Object)n2);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_X.intValue(), n);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Y.intValue(), n2);
    }

    @Override
    public void setMarqueePosition(libvlc_marquee_position_e libvlc_marquee_position_e2) {
        this.logger.debug("setMarqueePosition(position={})", (Object)libvlc_marquee_position_e2);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Position.intValue(), libvlc_marquee_position_e2.intValue());
    }

    @Override
    public void setMarquee(Marquee marquee) {
        this.logger.debug("setMarquee(marquee={})", (Object)marquee);
        marquee.apply(this);
    }

    @Override
    public void setDeinterlace(DeinterlaceMode deinterlaceMode) {
        this.logger.debug("setDeinterlace(deinterlaceMode={})", (Object)deinterlaceMode);
        this.libvlc.libvlc_video_set_deinterlace(this.mediaPlayerInstance, deinterlaceMode != null ? deinterlaceMode.mode() : null);
    }

    @Override
    public void setAdjustVideo(boolean bl) {
        this.logger.debug("setAdjustVideo(adjustVideo={})", (Object)bl);
        this.libvlc.libvlc_video_set_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Enable.intValue(), bl ? 1 : 0);
    }

    @Override
    public boolean isAdjustVideo() {
        this.logger.debug("isAdjustVideo()");
        return this.libvlc.libvlc_video_get_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Enable.intValue()) == 1;
    }

    @Override
    public float getContrast() {
        this.logger.debug("getContrast()");
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Contrast.intValue());
    }

    @Override
    public void setContrast(float f) {
        this.logger.debug("setContrast(contrast={})", (Object)Float.valueOf(f));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Contrast.intValue(), f);
    }

    @Override
    public float getBrightness() {
        this.logger.debug("getBrightness()");
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Brightness.intValue());
    }

    @Override
    public void setBrightness(float f) {
        this.logger.debug("setBrightness(brightness={})", (Object)Float.valueOf(f));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Brightness.intValue(), f);
    }

    @Override
    public int getHue() {
        this.logger.debug("getHue()");
        return this.libvlc.libvlc_video_get_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Hue.intValue());
    }

    @Override
    public void setHue(int n) {
        this.logger.debug("setHue(hue={})", (Object)n);
        this.libvlc.libvlc_video_set_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Hue.intValue(), n);
    }

    @Override
    public float getSaturation() {
        this.logger.debug("getSaturation()");
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Saturation.intValue());
    }

    @Override
    public void setSaturation(float f) {
        this.logger.debug("setSaturation(saturation={})", (Object)Float.valueOf(f));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Saturation.intValue(), f);
    }

    @Override
    public float getGamma() {
        this.logger.debug("getGamma()");
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Gamma.intValue());
    }

    @Override
    public void setGamma(float f) {
        this.logger.debug("setGamma(gamma={})", (Object)Float.valueOf(f));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Gamma.intValue(), f);
    }

    @Override
    public void setVideoTitleDisplay(libvlc_position_e libvlc_position_e2, int n) {
        this.logger.debug("setVideoTitleDisplay(position={},timeout={})", (Object)libvlc_position_e2, (Object)n);
        this.libvlc.libvlc_media_player_set_video_title_display(this.mediaPlayerInstance, libvlc_position_e2.intValue(), n);
    }

    @Override
    public Equalizer getEqualizer() {
        this.logger.debug("getEqualizer()");
        return this.equalizer;
    }

    @Override
    public void setEqualizer(Equalizer equalizer) {
        this.logger.debug("setEqualizer(equalizer={})", (Object)equalizer);
        if (this.equalizer != null) {
            this.equalizer.removeEqualizerListener(this);
            this.libvlc.libvlc_audio_equalizer_release(this.equalizerInstance);
            this.equalizerInstance = null;
        }
        this.equalizer = equalizer;
        if (this.equalizer != null) {
            this.equalizerInstance = this.libvlc.libvlc_audio_equalizer_new();
            this.equalizer.addEqualizerListener(this);
        }
        this.applyEqualizer();
    }

    private void applyEqualizer() {
        this.logger.trace("applyEqualizer()");
        this.logger.trace("equalizerInstance={}", (Object)this.equalizerInstance);
        if (this.equalizerInstance != null) {
            this.logger.trace("Set equalizer");
            this.libvlc.libvlc_audio_equalizer_set_preamp(this.equalizerInstance, this.equalizer.getPreamp());
            for (int i = 0; i < this.libvlc.libvlc_audio_equalizer_get_band_count(); ++i) {
                this.libvlc.libvlc_audio_equalizer_set_amp_at_index(this.equalizerInstance, this.equalizer.getAmp(i), i);
            }
            this.libvlc.libvlc_media_player_set_equalizer(this.mediaPlayerInstance, this.equalizerInstance);
        } else {
            this.logger.trace("Disable equalizer");
            this.libvlc.libvlc_media_player_set_equalizer(this.mediaPlayerInstance, null);
        }
    }

    @Override
    public String mrl() {
        this.logger.debug("mrl()");
        if (this.mediaInstance != null) {
            return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_get_mrl(this.mediaInstance));
        }
        return null;
    }

    @Override
    public String mrl(libvlc_media_t libvlc_media_t2) {
        this.logger.debug("mrl(mediaInstance={})", (Object)libvlc_media_t2);
        return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_get_mrl(libvlc_media_t2));
    }

    @Override
    public Object userData() {
        this.logger.debug("userData()");
        return this.userData;
    }

    @Override
    public void userData(Object object) {
        this.logger.debug("userData(userData={})", object);
        this.userData = object;
    }

    @Override
    public final void release() {
        this.logger.debug("release()");
        if (this.released.compareAndSet(false, true)) {
            this.destroyInstance();
            this.onAfterRelease();
        }
    }

    @Override
    public final libvlc_media_player_t mediaPlayerInstance() {
        return this.mediaPlayerInstance;
    }

    protected void onBeforePlay() {
    }

    protected void onAfterRelease() {
    }

    private void createInstance() {
        this.logger.debug("createInstance()");
        this.mediaPlayerInstance = this.libvlc.libvlc_media_player_new(this.instance);
        this.logger.debug("mediaPlayerInstance={}", (Object)this.mediaPlayerInstance);
        this.mediaPlayerEventManager = this.libvlc.libvlc_media_player_event_manager(this.mediaPlayerInstance);
        this.logger.debug("mediaPlayerEventManager={}", (Object)this.mediaPlayerEventManager);
        this.registerEventListener();
        this.eventListenerList.add(new NewMediaEventHandler());
        this.eventListenerList.add(new RepeatPlayEventHandler());
        this.eventListenerList.add(new SubItemEventHandler());
        this.eventListenerList.add(new ResetMediaHandler());
    }

    private void destroyInstance() {
        this.logger.debug("destroyInstance()");
        this.logger.debug("Detach media events...");
        this.deregisterMediaEventListener();
        this.logger.debug("Media events detached.");
        if (this.mediaInstance != null) {
            this.logger.debug("Release media...");
            this.libvlc.libvlc_media_release(this.mediaInstance);
            this.logger.debug("Media released.");
        }
        this.logger.debug("Detach media player events...");
        this.deregisterEventListener();
        this.logger.debug("Media player events detached.");
        this.eventListenerList.clear();
        if (this.mediaPlayerInstance != null) {
            this.logger.debug("Release media player...");
            this.libvlc.libvlc_media_player_release(this.mediaPlayerInstance);
            this.logger.debug("Media player released.");
        }
        if (this.equalizer != null) {
            this.equalizer.removeEqualizerListener(this);
            this.equalizer = null;
        }
        if (this.equalizerInstance != null) {
            this.libvlc.libvlc_audio_equalizer_release(this.equalizerInstance);
            this.equalizerInstance = null;
        }
        this.logger.debug("Shut down listeners...");
        this.listenersService.shutdown();
        this.logger.debug("Listeners shut down.");
    }

    private void registerEventListener() {
        this.logger.debug("registerEventListener()");
        this.callback = new EventCallback();
        libvlc_event_e libvlc_event_e2 = this.lastKnownEvent();
        for (libvlc_event_e libvlc_event_e3 : libvlc_event_e.values()) {
            if (libvlc_event_e3.intValue() < libvlc_event_e.libvlc_MediaPlayerMediaChanged.intValue() || libvlc_event_e3.intValue() > libvlc_event_e2.intValue()) continue;
            this.logger.debug("event={}", (Object)libvlc_event_e3);
            int n = this.libvlc.libvlc_event_attach(this.mediaPlayerEventManager, libvlc_event_e3.intValue(), this.callback, null);
            this.logger.debug("result={}", (Object)n);
        }
    }

    private void deregisterEventListener() {
        this.logger.debug("deregisterEventListener()");
        if (this.callback != null) {
            libvlc_event_e libvlc_event_e2 = this.lastKnownEvent();
            for (libvlc_event_e libvlc_event_e3 : libvlc_event_e.values()) {
                if (libvlc_event_e3.intValue() < libvlc_event_e.libvlc_MediaPlayerMediaChanged.intValue() || libvlc_event_e3.intValue() > libvlc_event_e2.intValue()) continue;
                this.logger.debug("event={}", (Object)libvlc_event_e3);
                this.libvlc.libvlc_event_detach(this.mediaPlayerEventManager, libvlc_event_e3.intValue(), this.callback, null);
            }
            this.callback = null;
        }
    }

    private libvlc_event_e lastKnownEvent() {
        Version version = new Version(this.libvlc.libvlc_get_version());
        libvlc_event_e libvlc_event_e2 = version.atLeast(new Version("3.0.0")) ? libvlc_event_e.libvlc_MediaPlayerChapterChanged : (version.atLeast(new Version("2.2.0")) ? libvlc_event_e.libvlc_MediaPlayerScrambledChanged : libvlc_event_e.libvlc_MediaPlayerVout);
        return libvlc_event_e2;
    }

    private void registerMediaEventListener() {
        this.logger.debug("registerMediaEventListener()");
        if (this.mediaInstance != null) {
            libvlc_event_manager_t libvlc_event_manager_t2 = this.libvlc.libvlc_media_event_manager(this.mediaInstance);
            libvlc_event_e libvlc_event_e2 = this.lastKnownMediaEvent();
            for (libvlc_event_e libvlc_event_e3 : libvlc_event_e.values()) {
                if (libvlc_event_e3.intValue() < libvlc_event_e.libvlc_MediaMetaChanged.intValue() || libvlc_event_e3.intValue() > libvlc_event_e2.intValue()) continue;
                this.logger.debug("event={}", (Object)libvlc_event_e3);
                int n = this.libvlc.libvlc_event_attach(libvlc_event_manager_t2, libvlc_event_e3.intValue(), this.callback, null);
                this.logger.debug("result={}", (Object)n);
            }
        }
    }

    private void deregisterMediaEventListener() {
        this.logger.debug("deregisterMediaEventListener()");
        if (this.mediaInstance != null) {
            libvlc_event_manager_t libvlc_event_manager_t2 = this.libvlc.libvlc_media_event_manager(this.mediaInstance);
            libvlc_event_e libvlc_event_e2 = this.lastKnownMediaEvent();
            for (libvlc_event_e libvlc_event_e3 : libvlc_event_e.values()) {
                if (libvlc_event_e3.intValue() < libvlc_event_e.libvlc_MediaMetaChanged.intValue() || libvlc_event_e3.intValue() > libvlc_event_e2.intValue()) continue;
                this.logger.debug("event={}", (Object)libvlc_event_e3);
                this.libvlc.libvlc_event_detach(libvlc_event_manager_t2, libvlc_event_e3.intValue(), this.callback, null);
            }
        }
    }

    private libvlc_event_e lastKnownMediaEvent() {
        Version version = new Version(this.libvlc.libvlc_get_version());
        libvlc_event_e libvlc_event_e2 = version.atLeast(new Version("2.1.5")) ? libvlc_event_e.libvlc_MediaSubItemTreeAdded : libvlc_event_e.libvlc_MediaStateChanged;
        return libvlc_event_e2;
    }

    private void raiseEvent(MediaPlayerEvent mediaPlayerEvent) {
        this.logger.trace("raiseEvent(mediaPlayerEvent={}", (Object)mediaPlayerEvent);
        if (mediaPlayerEvent != null) {
            this.listenersService.submit(new NotifyEventListenersRunnable(mediaPlayerEvent));
        }
    }

    private boolean setMedia(Media media) {
        this.logger.debug("setMedia(media={})", (Object)media);
        this.lastPlayedMedia = media;
        if (this.mediaInstance != null) {
            this.deregisterMediaEventListener();
            this.libvlc.libvlc_media_release(this.mediaInstance);
            this.mediaInstance = null;
        }
        this.subItemIndex = -1;
        this.mediaInstance = this.createMediaInstance(media);
        this.logger.debug("mediaInstance={}", (Object)this.mediaInstance);
        if (this.mediaInstance != null) {
            if (this.standardMediaOptions != null) {
                for (String string : this.standardMediaOptions) {
                    this.logger.debug("standardMediaOption={}", (Object)string);
                    this.libvlc.libvlc_media_add_option(this.mediaInstance, string);
                }
            }
            if (media.mediaOptions() != null) {
                for (String string : media.mediaOptions()) {
                    this.logger.debug("mediaOption={}", (Object)string);
                    this.libvlc.libvlc_media_add_option(this.mediaInstance, string);
                }
            }
            this.registerMediaEventListener();
            this.libvlc.libvlc_media_player_set_media(this.mediaPlayerInstance, this.mediaInstance);
        } else {
            this.logger.error("Failed to create native media resource for '{}'", (Object)media);
        }
        this.libvlcMediaStats = new libvlc_media_stats_t();
        boolean bl = this.mediaInstance != null;
        this.logger.debug("result={}", (Object)bl);
        return bl;
    }

    private libvlc_media_t createMediaInstance(Media media) {
        libvlc_media_t libvlc_media_t2;
        this.logger.debug("createMediaInstance(media={})", (Object)media);
        if (media instanceof SimpleMedia) {
            String string = ((SimpleMedia)media).mrl();
            if (MediaResourceLocator.isLocation(string)) {
                this.logger.debug("Treating mrl as a location");
                libvlc_media_t2 = this.libvlc.libvlc_media_new_location(this.instance, string);
            } else {
                this.logger.debug("Treating mrl as a path");
                libvlc_media_t2 = this.libvlc.libvlc_media_new_path(this.instance, string);
            }
        } else if (media instanceof CallbackMedia) {
            CallbackMedia callbackMedia = (CallbackMedia)((Object)media);
            libvlc_media_t2 = this.libvlc.libvlc_media_new_callbacks(this.instance, callbackMedia.getOpen(), callbackMedia.getRead(), callbackMedia.getSeek(), callbackMedia.getClose(), callbackMedia.getOpaque());
        } else {
            throw new IllegalStateException("Don't know about media type " + media);
        }
        return libvlc_media_t2;
    }

    private <T> T handleSubItems(SubItemsHandler<T> subItemsHandler) {
        block5: {
            T t;
            block6: {
                this.logger.debug("handleSubItems()");
                libvlc_media_list_t libvlc_media_list_t2 = null;
                try {
                    if (this.mediaInstance == null) break block5;
                    libvlc_media_list_t2 = this.libvlc.libvlc_media_subitems(this.mediaInstance);
                    this.logger.debug("subItemList={}", (Object)libvlc_media_list_t2);
                    if (libvlc_media_list_t2 != null) {
                        this.libvlc.libvlc_media_list_lock(libvlc_media_list_t2);
                    }
                    t = subItemsHandler.subItems(libvlc_media_list_t2 != null ? this.libvlc.libvlc_media_list_count(libvlc_media_list_t2) : 0, libvlc_media_list_t2);
                    if (libvlc_media_list_t2 == null) break block6;
                    this.libvlc.libvlc_media_list_unlock(libvlc_media_list_t2);
                    this.libvlc.libvlc_media_list_release(libvlc_media_list_t2);
                }
                catch (Throwable throwable) {
                    if (libvlc_media_list_t2 != null) {
                        this.libvlc.libvlc_media_list_unlock(libvlc_media_list_t2);
                        this.libvlc.libvlc_media_list_release(libvlc_media_list_t2);
                    }
                    throw throwable;
                }
            }
            return t;
        }
        throw new IllegalStateException("No media");
    }

    private void resetMedia() {
        this.logger.debug("resetMedia()");
        this.setMedia(this.lastPlayedMedia);
    }

    @Override
    public final void equalizerChanged(Equalizer equalizer) {
        this.logger.trace("equalizerChanged(equalizer={})", (Object)equalizer);
        this.applyEqualizer();
    }

    private static interface SubItemsHandler<T> {
        public T subItems(int var1, libvlc_media_list_t var2);
    }

    private final class ResetMediaHandler
    extends MediaPlayerEventAdapter {
        private ResetMediaHandler() {
        }

        @Override
        public void finished(MediaPlayer mediaPlayer) {
            if (DefaultMediaPlayer.this.subItemCount() == 0) {
                DefaultMediaPlayer.this.resetMedia();
            }
        }
    }

    private final class SubItemEventHandler
    extends MediaPlayerEventAdapter {
        private SubItemEventHandler() {
        }

        @Override
        public void finished(MediaPlayer mediaPlayer) {
            DefaultMediaPlayer.this.logger.debug("finished(mediaPlayer={})", (Object)mediaPlayer);
            if (DefaultMediaPlayer.this.subItemIndex != -1) {
                DefaultMediaPlayer.this.logger.debug("Raising finished event for sub-item {}", (Object)DefaultMediaPlayer.this.subItemIndex);
                DefaultMediaPlayer.this.raiseEvent(DefaultMediaPlayer.this.eventFactory.createMediaSubItemFinishedEvent(DefaultMediaPlayer.this.subItemIndex, DefaultMediaPlayer.this.eventMask));
            }
            if (DefaultMediaPlayer.this.playSubItems) {
                DefaultMediaPlayer.this.playNextSubItem(new String[0]);
            }
        }
    }

    private final class RepeatPlayEventHandler
    extends MediaPlayerEventAdapter {
        private RepeatPlayEventHandler() {
        }

        @Override
        public void finished(MediaPlayer mediaPlayer) {
            DefaultMediaPlayer.this.logger.debug("finished(mediaPlayer={})", (Object)mediaPlayer);
            if (DefaultMediaPlayer.this.repeat && DefaultMediaPlayer.this.mediaInstance != null) {
                int n = DefaultMediaPlayer.this.subItemCount();
                DefaultMediaPlayer.this.logger.debug("subitemCount={}", (Object)n);
                if (n == 0) {
                    String string = NativeString.getNativeString(DefaultMediaPlayer.this.libvlc, DefaultMediaPlayer.this.libvlc.libvlc_media_get_mrl(DefaultMediaPlayer.this.mediaInstance));
                    DefaultMediaPlayer.this.logger.debug("auto repeat mrl={}", (Object)string);
                    mediaPlayer.playMedia(string, DefaultMediaPlayer.this.lastPlayedMedia.mediaOptions());
                } else {
                    DefaultMediaPlayer.this.logger.debug("Sub-items handling repeat");
                }
            } else {
                DefaultMediaPlayer.this.logger.debug("No repeat");
            }
        }
    }

    private final class NewMediaEventHandler
    extends MediaPlayerEventAdapter {
        private NewMediaEventHandler() {
        }

        @Override
        public void mediaChanged(MediaPlayer mediaPlayer, libvlc_media_t libvlc_media_t2, String string) {
            DefaultMediaPlayer.this.logger.debug("mediaChanged(mediaPlayer={},media={},mrl={})", mediaPlayer, libvlc_media_t2, string);
            if (DefaultMediaPlayer.this.subItemIndex() == -1) {
                DefaultMediaPlayer.this.logger.debug("Raising event for new media");
                DefaultMediaPlayer.this.raiseEvent(DefaultMediaPlayer.this.eventFactory.createMediaNewEvent(DefaultMediaPlayer.this.eventMask));
            }
        }
    }

    private final class NotifyEventListenersRunnable
    implements Runnable {
        private final MediaPlayerEvent mediaPlayerEvent;

        private NotifyEventListenersRunnable(MediaPlayerEvent mediaPlayerEvent) {
            this.mediaPlayerEvent = mediaPlayerEvent;
        }

        @Override
        public void run() {
            DefaultMediaPlayer.this.logger.trace("run()");
            for (int i = DefaultMediaPlayer.this.eventListenerList.size() - 1; i >= 0; --i) {
                MediaPlayerEventListener mediaPlayerEventListener = (MediaPlayerEventListener)DefaultMediaPlayer.this.eventListenerList.get(i);
                try {
                    this.mediaPlayerEvent.notify(mediaPlayerEventListener);
                    continue;
                }
                catch (Exception exception) {
                    DefaultMediaPlayer.this.logger.warn("Event listener {} threw an exception {}", (Object)mediaPlayerEventListener, (Object)exception.getMessage());
                }
            }
            DefaultMediaPlayer.this.logger.trace("runnable exits");
        }
    }

    private final class EventCallback
    implements libvlc_callback_t {
        private EventCallback() {
        }

        @Override
        public void callback(libvlc_event_t libvlc_event_t2, Pointer pointer) {
            DefaultMediaPlayer.this.logger.trace("callback(event={},userData={})", (Object)libvlc_event_t2, (Object)pointer);
            MediaPlayerEvent mediaPlayerEvent = DefaultMediaPlayer.this.eventFactory.createEvent(libvlc_event_t2, DefaultMediaPlayer.this.eventMask);
            if (libvlc_event_t2 != null) {
                DefaultMediaPlayer.this.raiseEvent(mediaPlayerEvent);
            }
        }
    }
}

