/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.co.caprica.vlcj.player.EqualizerListener;

public final class Equalizer {
    private final int bandCount;
    private final List<EqualizerListener> listeners = new ArrayList<EqualizerListener>();
    private float preamp;
    private final float[] bandAmps;

    public Equalizer(int n) {
        this.bandCount = n;
        this.bandAmps = new float[n];
    }

    public final void addEqualizerListener(EqualizerListener equalizerListener) {
        this.listeners.add(equalizerListener);
    }

    public final void removeEqualizerListener(EqualizerListener equalizerListener) {
        this.listeners.remove(equalizerListener);
    }

    public final int getBandCount() {
        return this.bandCount;
    }

    public final float getPreamp() {
        return this.preamp;
    }

    public final void setPreamp(float f) {
        this.checkAmp(f);
        this.preamp = f;
        this.fireEqualizerChanged();
    }

    public final float getAmp(int n) {
        if (n >= 0 && n < this.bandCount) {
            return this.bandAmps[n];
        }
        throw new IllegalArgumentException("Invalid band index");
    }

    public final void setAmp(int n, float f) {
        this.checkAmp(f);
        if (n < 0 || n >= this.bandCount) {
            throw new IllegalArgumentException("Invalid band index");
        }
        this.bandAmps[n] = f;
        this.fireEqualizerChanged();
    }

    public final float[] getAmps() {
        float[] fArray = new float[this.bandCount];
        this.copy(this.bandAmps, fArray);
        return fArray;
    }

    public final void setAmps(float[] fArray) {
        if (fArray != null && fArray.length == this.bandCount) {
            for (float f : fArray) {
                this.checkAmp(f);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.copy(fArray, this.bandAmps);
        this.fireEqualizerChanged();
    }

    public final void setEqualizer(Equalizer equalizer) {
        if (equalizer == null) {
            throw new IllegalArgumentException();
        }
        this.preamp = equalizer.preamp;
        this.copy(equalizer.bandAmps, this.bandAmps);
        this.fireEqualizerChanged();
    }

    public final void reset() {
        this.preamp = 0.0f;
        for (int i = 0; i < this.bandCount; ++i) {
            this.bandAmps[i] = 0.0f;
        }
        this.fireEqualizerChanged();
    }

    private void checkAmp(float f) {
        if (f < -20.0f || f > 20.0f) {
            throw new IllegalArgumentException("Invalid amplification value: " + f);
        }
    }

    private void copy(float[] fArray, float[] fArray2) {
        System.arraycopy(fArray, 0, fArray2, 0, this.bandCount);
    }

    private void fireEqualizerChanged() {
        for (EqualizerListener equalizerListener : this.listeners) {
            equalizerListener.equalizerChanged(this);
        }
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append(this.getClass().getSimpleName()).append('[');
        stringBuilder.append("preamp=").append(this.preamp).append(',');
        stringBuilder.append("bandAmps=").append(Arrays.toString(this.bandAmps)).append(']');
        return stringBuilder.toString();
    }
}

