/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.awt.Color;
import uk.co.caprica.vlcj.binding.internal.libvlc_marquee_position_e;
import uk.co.caprica.vlcj.player.MediaPlayer;

public final class Marquee {
    private String text;
    private Color colour;
    private Integer rgb;
    private Integer intOpacity;
    private Float floatOpacity;
    private Integer size;
    private Integer timeout;
    private Integer x;
    private Integer y;
    private libvlc_marquee_position_e position;
    private boolean enable;

    public static Marquee marquee() {
        return new Marquee();
    }

    private Marquee() {
    }

    public Marquee text(String string) {
        this.text = string;
        return this;
    }

    public Marquee colour(Color color) {
        this.colour = color;
        return this;
    }

    public Marquee colour(int n) {
        this.rgb = n;
        return this;
    }

    public Marquee opacity(int n) {
        this.intOpacity = n;
        return this;
    }

    public Marquee opacity(float f) {
        this.floatOpacity = Float.valueOf(f);
        return this;
    }

    public Marquee size(int n) {
        this.size = n;
        return this;
    }

    public Marquee timeout(int n) {
        this.timeout = n;
        return this;
    }

    public Marquee location(int n, int n2) {
        this.x = n;
        this.y = n2;
        return this;
    }

    public Marquee position(libvlc_marquee_position_e libvlc_marquee_position_e2) {
        this.position = libvlc_marquee_position_e2;
        return this;
    }

    public Marquee enable(boolean bl) {
        this.enable = bl;
        return this;
    }

    public Marquee enable() {
        this.enable = true;
        return this;
    }

    public Marquee disable() {
        this.enable = false;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public Color getColour() {
        return this.colour;
    }

    public Integer getRgb() {
        return this.rgb;
    }

    public Integer getIntegerOpacity() {
        return this.intOpacity;
    }

    public Float getFloatOpacity() {
        return this.floatOpacity;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getX() {
        return this.x;
    }

    public Integer getY() {
        return this.y;
    }

    public libvlc_marquee_position_e getPosition() {
        return this.position;
    }

    public boolean getEnable() {
        return this.enable;
    }

    public void apply(MediaPlayer mediaPlayer) {
        if (this.text != null) {
            mediaPlayer.setMarqueeText(this.text);
        }
        if (this.colour != null) {
            mediaPlayer.setMarqueeColour(this.colour);
        }
        if (this.rgb != null) {
            mediaPlayer.setMarqueeColour(this.rgb);
        }
        if (this.intOpacity != null) {
            mediaPlayer.setMarqueeOpacity(this.intOpacity);
        }
        if (this.floatOpacity != null) {
            mediaPlayer.setMarqueeOpacity(this.floatOpacity.floatValue());
        }
        if (this.size != null) {
            mediaPlayer.setMarqueeSize(this.size);
        }
        if (this.timeout != null) {
            mediaPlayer.setMarqueeTimeout(this.timeout);
        }
        if (this.x != null && this.y != null && this.x >= 0 && this.y >= 0) {
            mediaPlayer.setMarqueeLocation(this.x, this.y);
        }
        if (this.position != null) {
            mediaPlayer.setMarqueePosition(this.position);
        }
        if (this.enable) {
            mediaPlayer.enableMarquee(true);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + "text=" + this.text + ',' + "colour=" + this.colour + ',' + "rgb=" + this.rgb + ',' + "intOpacity=" + this.intOpacity + ',' + "floatOpacity=" + this.floatOpacity + ',' + "size=" + this.size + ',' + "timeout=" + this.timeout + ',' + "x=" + this.x + ',' + "y=" + this.y + ',' + "position=" + (Object)((Object)this.position) + ',' + "enable=" + this.enable + ']';
    }
}

