/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.awt.Canvas;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.LibVlcFactory;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_device_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_equalizer_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_type_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_module_description_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_track_type_t;
import uk.co.caprica.vlcj.log.NativeLog;
import uk.co.caprica.vlcj.medialist.MediaList;
import uk.co.caprica.vlcj.player.AudioDevice;
import uk.co.caprica.vlcj.player.AudioOutput;
import uk.co.caprica.vlcj.player.DefaultMediaMeta;
import uk.co.caprica.vlcj.player.Equalizer;
import uk.co.caprica.vlcj.player.MediaMeta;
import uk.co.caprica.vlcj.player.ModuleDescription;
import uk.co.caprica.vlcj.player.NativeString;
import uk.co.caprica.vlcj.player.direct.BufferFormatCallback;
import uk.co.caprica.vlcj.player.direct.DefaultDirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.DirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.RenderCallback;
import uk.co.caprica.vlcj.player.directaudio.AudioCallback;
import uk.co.caprica.vlcj.player.directaudio.DefaultDirectAudioPlayer;
import uk.co.caprica.vlcj.player.directaudio.DirectAudioPlayer;
import uk.co.caprica.vlcj.player.discoverer.MediaDiscoverer;
import uk.co.caprica.vlcj.player.embedded.DefaultEmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.videosurface.CanvasVideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.ComponentIdVideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.linux.LinuxVideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.mac.MacVideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.windows.WindowsVideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.headless.DefaultHeadlessMediaPlayer;
import uk.co.caprica.vlcj.player.headless.HeadlessMediaPlayer;
import uk.co.caprica.vlcj.player.list.DefaultMediaListPlayer;
import uk.co.caprica.vlcj.player.list.MediaListPlayer;
import uk.co.caprica.vlcj.player.manager.DefaultMediaManager;
import uk.co.caprica.vlcj.player.manager.MediaManager;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.runtime.x.LibXUtil;
import uk.co.caprica.vlcj.version.LibVlcVersion;
import uk.co.caprica.vlcj.version.Version;

public class MediaPlayerFactory {
    private static final Logger logger;
    private static final String PLUGIN_PATH_HELP = "Failed to initialise libvlc.\n\nThis is most often caused either by an invalid vlc option being passed when creating a MediaPlayerFactory or by libvlc being unable to locate the required plugins.\n\nIf libvlc is unable to locate the required plugins the instructions below may help:\n\nIn the text below <libvlc-path> represents the name of the directory containing \"{0}\" and \"{1}\" and <plugins-path> represents the name of the directory containing the vlc plugins...\n\nFor libvlc to function correctly the vlc plugins must be available, there are a number of different ways to achieve this:\n 1. Make sure the plugins are installed in the \"<libvlc-path>/{2}\" directory, this should be the case with a normal vlc installation.\n 2. Set the VLC_PLUGIN_PATH operating system environment variable to point to \"<plugins-path>\".\n\nMore information may be available in the log.\n\n";
    protected final LibVlc libvlc;
    protected final libvlc_instance_t instance;
    private final boolean equalizerAvailable;
    private final List<Float> equalizerBandFrequencies;
    private final List<String> equalizerPresetNames;
    private boolean released;

    public MediaPlayerFactory() {
        this(new String[0]);
    }

    public MediaPlayerFactory(String ... stringArray) {
        this(LibVlcFactory.factory().atLeast("2.1.0").create(), stringArray);
    }

    public MediaPlayerFactory(LibVlc libVlc) {
        this(libVlc, new String[0]);
    }

    public MediaPlayerFactory(LibVlc libVlc, String ... stringArray) {
        logger.debug("MediaPlayerFactory(libvlc={},libvlcArgs={})", (Object)libVlc, (Object)Arrays.toString(stringArray));
        logger.debug("jna.library.path={}", (Object)System.getProperty("jna.library.path"));
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String string = System.getProperty("VLC_PLUGIN_PATH");
        logger.debug("VLC_PLUGIN_PATH={}", (Object)string);
        this.libvlc = libVlc;
        this.instance = libVlc.libvlc_new(stringArray.length, stringArray);
        logger.debug("instance={}", (Object)this.instance);
        if (this.instance == null) {
            logger.error("Failed to initialise libvlc");
            String string2 = MessageFormat.format(PLUGIN_PATH_HELP, RuntimeUtil.getLibVlcName(), RuntimeUtil.getLibVlcCoreName(), RuntimeUtil.getPluginsDirectoryName());
            throw new RuntimeException(string2);
        }
        this.equalizerAvailable = LibVlcVersion.getVersion().atLeast(new Version("2.2.0"));
        logger.debug("equalizerAvailable={}", (Object)this.equalizerAvailable);
        if (this.equalizerAvailable) {
            this.equalizerBandFrequencies = this.createEqualizerBandFrequencies();
            this.equalizerPresetNames = this.createEqualizerPresetNames();
        } else {
            this.equalizerBandFrequencies = null;
            this.equalizerPresetNames = null;
        }
    }

    public MediaPlayerFactory(List<String> list) {
        this(list.toArray(new String[list.size()]));
    }

    public MediaPlayerFactory(LibVlc libVlc, List<String> list) {
        this(libVlc, list.toArray(new String[list.size()]));
    }

    public void release() {
        logger.debug("release()");
        if (!this.released) {
            if (this.instance != null) {
                this.libvlc.libvlc_release(this.instance);
            }
            this.released = true;
        }
    }

    public void setUserAgent(String string) {
        logger.debug("setUserAgent(userAgent={})", (Object)string);
        this.setUserAgent(string, null);
    }

    public void setUserAgent(String string, String string2) {
        logger.debug("setUserAgent(userAgent={},httpUserAgent={})", (Object)string, (Object)string2);
        this.libvlc.libvlc_set_user_agent(this.instance, string, string);
    }

    public void setApplicationId(String string, String string2, String string3) {
        logger.debug("setApplicationId(id=" + string + ",version=" + string2 + ",icon=" + string3 + ")");
        this.libvlc.libvlc_set_app_id(this.instance, string, string2, string3);
    }

    public List<AudioOutput> getAudioOutputs() {
        logger.debug("getAudioOutputs()");
        ArrayList<AudioOutput> arrayList = new ArrayList<AudioOutput>();
        libvlc_audio_output_t libvlc_audio_output_t2 = this.libvlc.libvlc_audio_output_list_get(this.instance);
        if (libvlc_audio_output_t2 != null) {
            libvlc_audio_output_t2.setAutoSynch(false);
            libvlc_audio_output_t libvlc_audio_output_t3 = libvlc_audio_output_t2;
            while (libvlc_audio_output_t3 != null) {
                String string = NativeString.copyNativeString(this.libvlc, libvlc_audio_output_t3.psz_name);
                String string2 = NativeString.copyNativeString(this.libvlc, libvlc_audio_output_t3.psz_description);
                arrayList.add(new AudioOutput(string, string2, this.getAudioOutputDevices(string)));
                libvlc_audio_output_t3 = libvlc_audio_output_t3.p_next;
            }
            this.libvlc.libvlc_audio_output_list_release(libvlc_audio_output_t2);
        }
        return arrayList;
    }

    private List<AudioDevice> getAudioOutputDevices(String string) {
        logger.debug("getAudioOutputDevices(outputName={})", (Object)string);
        ArrayList<AudioDevice> arrayList = new ArrayList<AudioDevice>();
        libvlc_audio_output_device_t libvlc_audio_output_device_t2 = this.libvlc.libvlc_audio_output_device_list_get(this.instance, string);
        if (libvlc_audio_output_device_t2 != null) {
            libvlc_audio_output_device_t2.setAutoSynch(false);
            libvlc_audio_output_device_t libvlc_audio_output_device_t3 = libvlc_audio_output_device_t2;
            while (libvlc_audio_output_device_t3 != null) {
                String string2 = NativeString.copyNativeString(this.libvlc, libvlc_audio_output_device_t3.psz_device);
                String string3 = NativeString.copyNativeString(this.libvlc, libvlc_audio_output_device_t3.psz_description);
                arrayList.add(new AudioDevice(string2, string3));
                libvlc_audio_output_device_t3 = libvlc_audio_output_device_t3.p_next;
            }
            this.libvlc.libvlc_audio_output_device_list_release(libvlc_audio_output_device_t2);
        }
        return arrayList;
    }

    public List<ModuleDescription> getAudioFilters() {
        logger.debug("getAudioFilters()");
        libvlc_module_description_t libvlc_module_description_t2 = this.libvlc.libvlc_audio_filter_list_get(this.instance);
        libvlc_module_description_t2.setAutoSynch(false);
        List<ModuleDescription> list = this.getModuleDescriptions(libvlc_module_description_t2);
        this.libvlc.libvlc_module_description_list_release(libvlc_module_description_t2);
        return list;
    }

    public List<ModuleDescription> getVideoFilters() {
        logger.debug("getVideoFilters()");
        libvlc_module_description_t libvlc_module_description_t2 = this.libvlc.libvlc_video_filter_list_get(this.instance);
        libvlc_module_description_t2.setAutoSynch(false);
        List<ModuleDescription> list = this.getModuleDescriptions(libvlc_module_description_t2);
        this.libvlc.libvlc_module_description_list_release(libvlc_module_description_t2);
        return list;
    }

    private List<ModuleDescription> getModuleDescriptions(libvlc_module_description_t libvlc_module_description_t2) {
        ArrayList<ModuleDescription> arrayList = new ArrayList<ModuleDescription>();
        libvlc_module_description_t libvlc_module_description_t3 = libvlc_module_description_t2;
        while (libvlc_module_description_t3 != null) {
            arrayList.add(new ModuleDescription(libvlc_module_description_t3.psz_name, libvlc_module_description_t3.psz_shortname, libvlc_module_description_t3.psz_longname, libvlc_module_description_t3.psz_help));
            libvlc_module_description_t3 = libvlc_module_description_t3.p_next;
        }
        return arrayList;
    }

    public final boolean isEqualizerAvailable() {
        return this.equalizerAvailable;
    }

    private List<Float> createEqualizerBandFrequencies() {
        logger.debug("createEqualizerBandFrequencies()");
        int n = this.libvlc.libvlc_audio_equalizer_get_band_count();
        logger.debug("numBands={}", (Object)n);
        ArrayList<Float> arrayList = new ArrayList<Float>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(Float.valueOf(this.libvlc.libvlc_audio_equalizer_get_band_frequency(i)));
        }
        logger.debug("result={}", (Object)arrayList);
        return Collections.unmodifiableList(arrayList);
    }

    private List<String> createEqualizerPresetNames() {
        logger.debug("createEqualizerPresetNames()");
        int n = this.libvlc.libvlc_audio_equalizer_get_preset_count();
        logger.debug("numPresets={}", (Object)n);
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.libvlc.libvlc_audio_equalizer_get_preset_name(i));
        }
        logger.debug("result={}", (Object)arrayList);
        return Collections.unmodifiableList(arrayList);
    }

    public final List<Float> getEqualizerBandFrequencies() {
        logger.debug("getEqualizerBandFrequencies()");
        this.checkEqualizer();
        return this.equalizerBandFrequencies;
    }

    public final List<String> getEqualizerPresetNames() {
        logger.debug("getEqualizerPresetNames()");
        this.checkEqualizer();
        return this.equalizerPresetNames;
    }

    public final Equalizer newEqualizer() {
        logger.debug("newEqualizer()");
        this.checkEqualizer();
        return new Equalizer(this.libvlc.libvlc_audio_equalizer_get_band_count());
    }

    public final Equalizer newEqualizer(String string) {
        logger.debug("newEqualizer(presetName={})", (Object)string);
        this.checkEqualizer();
        int n = this.equalizerPresetNames.indexOf(string);
        if (n != -1) {
            libvlc_equalizer_t libvlc_equalizer_t2 = this.libvlc.libvlc_audio_equalizer_new_from_preset(n);
            if (libvlc_equalizer_t2 != null) {
                Equalizer equalizer = new Equalizer(this.libvlc.libvlc_audio_equalizer_get_band_count());
                equalizer.setPreamp(this.libvlc.libvlc_audio_equalizer_get_preamp(libvlc_equalizer_t2));
                for (int i = 0; i < this.libvlc.libvlc_audio_equalizer_get_band_count(); ++i) {
                    equalizer.setAmp(i, this.libvlc.libvlc_audio_equalizer_get_amp_at_index(libvlc_equalizer_t2, i));
                }
                this.libvlc.libvlc_audio_equalizer_release(libvlc_equalizer_t2);
                return equalizer;
            }
            return null;
        }
        throw new IllegalArgumentException("No such preset named '" + string + "'");
    }

    public final Map<String, Equalizer> getAllPresetEqualizers() {
        logger.debug("getAllPresetEqualizers()");
        this.checkEqualizer();
        TreeMap<String, Equalizer> treeMap = new TreeMap<String, Equalizer>();
        for (String string : this.equalizerPresetNames) {
            treeMap.put(string, this.newEqualizer(string));
        }
        logger.trace("result={}", (Object)treeMap);
        return treeMap;
    }

    private void checkEqualizer() {
        if (!this.equalizerAvailable) {
            throw new UnsupportedOperationException("Equalizer is not available, you need libvlc 2.2.0 or later");
        }
    }

    public EmbeddedMediaPlayer newEmbeddedMediaPlayer() {
        logger.debug("newEmbeddedMediaPlayer()");
        return this.newEmbeddedMediaPlayer(null);
    }

    public EmbeddedMediaPlayer newEmbeddedMediaPlayer(FullScreenStrategy fullScreenStrategy) {
        logger.debug("newEmbeddedMediaPlayer(fullScreenStrategy={})", (Object)fullScreenStrategy);
        return new DefaultEmbeddedMediaPlayer(this.libvlc, this.instance, fullScreenStrategy);
    }

    public DirectMediaPlayer newDirectMediaPlayer(BufferFormatCallback bufferFormatCallback, RenderCallback renderCallback) {
        logger.debug("newDirectMediaPlayer(formatCallback={},renderCallback={})", (Object)bufferFormatCallback, (Object)renderCallback);
        return new DefaultDirectMediaPlayer(this.libvlc, this.instance, bufferFormatCallback, renderCallback);
    }

    public DirectAudioPlayer newDirectAudioPlayer(String string, int n, int n2, AudioCallback audioCallback) {
        logger.debug("newDirectAudioPlayer(format={},rate={},channels={},audioCallback={}", string, n, n2, audioCallback);
        return new DefaultDirectAudioPlayer(this.libvlc, this.instance, string, n, n2, audioCallback);
    }

    public HeadlessMediaPlayer newHeadlessMediaPlayer() {
        logger.debug("newHeadlessMediaPlayer()");
        return new DefaultHeadlessMediaPlayer(this.libvlc, this.instance);
    }

    public MediaListPlayer newMediaListPlayer() {
        logger.debug("newMediaListPlayer()");
        return new DefaultMediaListPlayer(this.libvlc, this.instance);
    }

    public CanvasVideoSurface newVideoSurface(Canvas canvas) {
        VideoSurfaceAdapter videoSurfaceAdapter;
        logger.debug("newVideoSurface(canvas={})", (Object)canvas);
        if (RuntimeUtil.isNix()) {
            videoSurfaceAdapter = new LinuxVideoSurfaceAdapter();
        } else if (RuntimeUtil.isWindows()) {
            videoSurfaceAdapter = new WindowsVideoSurfaceAdapter();
        } else if (RuntimeUtil.isMac()) {
            videoSurfaceAdapter = new MacVideoSurfaceAdapter();
        } else {
            throw new RuntimeException("Unable to create a media player - failed to detect a supported operating system");
        }
        CanvasVideoSurface canvasVideoSurface = new CanvasVideoSurface(canvas, videoSurfaceAdapter);
        logger.debug("videoSurface={}", (Object)canvasVideoSurface);
        return canvasVideoSurface;
    }

    public ComponentIdVideoSurface newVideoSurface(long l) {
        VideoSurfaceAdapter videoSurfaceAdapter;
        logger.debug("newVideoSurface(componentId={})", (Object)l);
        if (RuntimeUtil.isNix()) {
            videoSurfaceAdapter = new LinuxVideoSurfaceAdapter();
        } else if (RuntimeUtil.isWindows()) {
            videoSurfaceAdapter = new WindowsVideoSurfaceAdapter();
        } else if (RuntimeUtil.isMac()) {
            videoSurfaceAdapter = new MacVideoSurfaceAdapter();
        } else {
            throw new RuntimeException("Unable to create a media player - failed to detect a supported operating system");
        }
        ComponentIdVideoSurface componentIdVideoSurface = new ComponentIdVideoSurface(l, videoSurfaceAdapter);
        logger.debug("videoSurface={}", (Object)componentIdVideoSurface);
        return componentIdVideoSurface;
    }

    public MediaList newMediaList() {
        logger.debug("newMediaList()");
        return new MediaList(this.libvlc, this.instance);
    }

    public MediaMeta getMediaMeta(String string, boolean bl) {
        logger.debug("getMediaMeta(mediaPath={},parse={})", (Object)string, (Object)bl);
        libvlc_media_t libvlc_media_t2 = this.libvlc.libvlc_media_new_path(this.instance, string);
        logger.debug("media={}", (Object)libvlc_media_t2);
        if (libvlc_media_t2 != null) {
            if (bl) {
                logger.debug("Parsing media...");
                this.libvlc.libvlc_media_parse(libvlc_media_t2);
                logger.debug("Media parsed.");
            }
            DefaultMediaMeta defaultMediaMeta = new DefaultMediaMeta(this.libvlc, libvlc_media_t2);
            this.libvlc.libvlc_media_release(libvlc_media_t2);
            return defaultMediaMeta;
        }
        return null;
    }

    public libvlc_media_type_e getMediaType(libvlc_media_t libvlc_media_t2) {
        logger.debug("getMediaType(media={})", (Object)libvlc_media_t2);
        if (libvlc_media_t2 != null) {
            return libvlc_media_type_e.mediaType(this.libvlc.libvlc_media_get_type(libvlc_media_t2));
        }
        return null;
    }

    public String getCodecDescription(libvlc_track_type_t libvlc_track_type_t2, int n) {
        logger.debug("getCodecDescription(type={},codec={})", (Object)libvlc_track_type_t2, (Object)n);
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_300)) {
            return this.libvlc.libvlc_media_get_codec_description(libvlc_track_type_t2.intValue(), n);
        }
        logger.warn("Codec description not available on this platform, needs libvlc 3.0.0 or later");
        return "";
    }

    public NativeLog newLog() {
        logger.debug("newLog()");
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_210)) {
            return new NativeLog(this.libvlc, this.instance);
        }
        logger.warn("Native log not available on this platform, needs libvlc 2.1.0 or later");
        return null;
    }

    public MediaDiscoverer newMediaDiscoverer(String string) {
        logger.debug("newMediaDiscoverer(name={})", (Object)string);
        return new MediaDiscoverer(this.libvlc, this.instance, string);
    }

    public MediaDiscoverer newAudioMediaDiscoverer() {
        logger.debug("newAudioMediaDiscoverer()");
        return this.newMediaDiscoverer("audio");
    }

    public MediaDiscoverer newVideoMediaDiscoverer() {
        logger.debug("newVideoMediaDiscoverer()");
        return this.newMediaDiscoverer("video");
    }

    public long clock() {
        logger.trace("clock()");
        return this.libvlc.libvlc_clock();
    }

    public MediaManager newMediaManager() {
        logger.trace("newMediaManager()");
        return new DefaultMediaManager(this.libvlc, this.instance);
    }

    public String version() {
        logger.debug("version()");
        return this.libvlc.libvlc_get_version();
    }

    public String compiler() {
        logger.debug("compiler()");
        return this.libvlc.libvlc_get_compiler();
    }

    public String changeset() {
        logger.debug("changeset()");
        return this.libvlc.libvlc_get_changeset();
    }

    static {
        Object object;
        logger = LoggerFactory.getLogger(MediaPlayerFactory.class);
        if (RuntimeUtil.isNix() && !GraphicsEnvironment.isHeadless() && ((Version)(object = new Version(System.getProperty("java.version")))).atLeast(new Version("1.7.0"))) {
            logger.debug("Trying workaround for Java7+ on Linux");
            Toolkit.getDefaultToolkit();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        logger.debug("Attempting to load jawt...");
                        System.loadLibrary("jawt");
                        logger.debug("...loaded jawt");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        logger.debug("Failed to load jawt", unsatisfiedLinkError);
                    }
                    return null;
                }
            });
            logger.debug("Java7 on Linux workaround complete.");
        }
        object = System.getProperty("VLCJ_INITX");
        logger.debug("initX={}", object);
        if (!"no".equalsIgnoreCase((String)object)) {
            LibXUtil.initialise();
        }
    }
}

