/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaResourceLocator {
    private static final Logger logger = LoggerFactory.getLogger(MediaResourceLocator.class);
    private static final Pattern MRL_LOCATION_PATTERN = Pattern.compile(".+://.*");

    private MediaResourceLocator() {
    }

    public static boolean isLocation(String string) {
        return MRL_LOCATION_PATTERN.matcher(string).matches();
    }

    public static String encodeMrl(String string) {
        String string2;
        block5: {
            logger.debug("encodeMrl(mrl={})", (Object)string);
            string2 = string;
            if (MediaResourceLocator.containsUnicode(string)) {
                logger.debug("MRL contains Unicode characters");
                try {
                    URI uRI = new URI(string);
                    logger.debug("uri={}", (Object)uRI);
                    String string3 = uRI.getScheme();
                    logger.debug("scheme={}", (Object)uRI.getScheme());
                    if (string3 == null) {
                        logger.debug("MRL has no scheme, assuming a local file name that should be encoded");
                        string2 = new File(string).toURI().toASCIIString().replaceFirst("file:/", "file:///");
                        break block5;
                    }
                    logger.debug("Ignoring MRL with scheme '{}'", (Object)string3);
                }
                catch (URISyntaxException uRISyntaxException) {
                    logger.debug("Can not obtain a valid URI from the MRL");
                }
            } else {
                logger.debug("MRL does not contain any Unicode characters");
            }
        }
        logger.debug("result={}", (Object)string2);
        return string2;
    }

    private static boolean containsUnicode(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) < '\u0080') continue;
            bl = true;
            break;
        }
        return bl;
    }
}

