/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.direct;

import java.util.Arrays;

public class BufferFormat {
    private final String chroma;
    private final int width;
    private final int height;
    private final int[] pitches;
    private final int[] lines;

    public BufferFormat(String string, int n, int n2, int[] nArray, int[] nArray2) {
        this.validate(string, n, n2, nArray, nArray2);
        this.chroma = string;
        this.width = n;
        this.height = n2;
        this.pitches = Arrays.copyOf(nArray, nArray.length);
        this.lines = Arrays.copyOf(nArray2, nArray2.length);
    }

    public final String getChroma() {
        return this.chroma;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int[] getPitches() {
        return this.pitches;
    }

    public final int[] getLines() {
        return this.lines;
    }

    public final int getPlaneCount() {
        return this.pitches.length;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName()).append('[');
        stringBuilder.append("chroma=").append(this.chroma).append(',');
        stringBuilder.append("width=").append(this.width).append(',');
        stringBuilder.append("height=").append(this.height).append(',');
        stringBuilder.append("pitches=").append(Arrays.toString(this.pitches)).append(',');
        stringBuilder.append("lines=").append(Arrays.toString(this.lines)).append(']');
        return stringBuilder.toString();
    }

    private void validate(String string, int n, int n2, int[] nArray, int[] nArray2) {
        if (string == null || string.length() != 4) {
            throw new IllegalArgumentException("chroma must be exactly 4 characters");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("width must be greater than zero");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("height must be greater than zero");
        }
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("pitches length must be greater than zero");
        }
        if (nArray2 == null || nArray2.length == 0) {
            throw new IllegalArgumentException("lines length must be greater than zero");
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("pitches and lines must have equal length");
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) {
                throw new IllegalArgumentException("pitch must be greater than zero");
            }
            if (nArray2[i] > 0) continue;
            throw new IllegalArgumentException("line must be greater than zero");
        }
    }
}

