/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.direct;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.nio.ch.DirectBuffer;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_display_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_lock_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_unlock_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_cleanup_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_format_cb;
import uk.co.caprica.vlcj.player.DefaultMediaPlayer;
import uk.co.caprica.vlcj.player.direct.BufferFormat;
import uk.co.caprica.vlcj.player.direct.BufferFormatCallback;
import uk.co.caprica.vlcj.player.direct.ByteBufferFactory;
import uk.co.caprica.vlcj.player.direct.DirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.RenderCallback;

public class DefaultDirectMediaPlayer
extends DefaultMediaPlayer
implements DirectMediaPlayer {
    private final Logger logger = LoggerFactory.getLogger(DefaultDirectMediaPlayer.class);
    private final Semaphore semaphore = new Semaphore(1);
    private final BufferFormatCallback bufferFormatCallback;
    private final RenderCallback renderCallback;
    private final libvlc_video_format_cb setup;
    private final libvlc_video_cleanup_cb cleanup;
    private final libvlc_lock_callback_t lock;
    private final libvlc_unlock_callback_t unlock;
    private final libvlc_display_callback_t display;
    private BufferFormat bufferFormat;
    private ByteBuffer[] nativeBuffers;
    private Pointer[] pointers;

    public DefaultDirectMediaPlayer(LibVlc libVlc, libvlc_instance_t libvlc_instance_t2, String string, int n, int n2, int n3, RenderCallback renderCallback) {
        this(libVlc, libvlc_instance_t2, new DefaultBufferFormatCallback(string, n, n2, n3), renderCallback);
    }

    public DefaultDirectMediaPlayer(LibVlc libVlc, libvlc_instance_t libvlc_instance_t2, BufferFormatCallback bufferFormatCallback, RenderCallback renderCallback) {
        super(libVlc, libvlc_instance_t2);
        this.bufferFormatCallback = bufferFormatCallback;
        this.renderCallback = renderCallback;
        this.setup = new SetupCallback();
        this.cleanup = new CleanupCallback();
        this.lock = new LockCallback();
        this.unlock = new UnlockCallback();
        this.display = new DisplayCallback();
        libVlc.libvlc_video_set_format_callbacks(this.mediaPlayerInstance(), this.setup, this.cleanup);
        libVlc.libvlc_video_set_callbacks(this.mediaPlayerInstance(), this.lock, this.unlock, this.display, null);
    }

    public final BufferFormat getBufferFormat() {
        return this.bufferFormat;
    }

    @Override
    public final ByteBuffer[] lock() {
        this.semaphore.acquireUninterruptibly();
        return this.nativeBuffers;
    }

    @Override
    public final void unlock() {
        this.semaphore.release();
    }

    static /* synthetic */ ByteBuffer[] access$902(DefaultDirectMediaPlayer defaultDirectMediaPlayer, ByteBuffer[] byteBufferArray) {
        defaultDirectMediaPlayer.nativeBuffers = byteBufferArray;
        return byteBufferArray;
    }

    static /* synthetic */ Pointer[] access$1002(DefaultDirectMediaPlayer defaultDirectMediaPlayer, Pointer[] pointerArray) {
        defaultDirectMediaPlayer.pointers = pointerArray;
        return pointerArray;
    }

    private static final class DefaultBufferFormatCallback
    implements BufferFormatCallback {
        private final BufferFormat bufferFormat;

        private DefaultBufferFormatCallback(String string, int n, int n2, int n3) {
            this.bufferFormat = new BufferFormat(string, n, n2, new int[]{n3}, new int[]{n2});
        }

        @Override
        public BufferFormat getBufferFormat(int n, int n2) {
            return this.bufferFormat;
        }
    }

    private final class DisplayCallback
    implements libvlc_display_callback_t {
        private DisplayCallback() {
        }

        @Override
        public void display(Pointer pointer, Pointer pointer2) {
            DefaultDirectMediaPlayer.this.logger.trace("display");
            DefaultDirectMediaPlayer.this.renderCallback.display(DefaultDirectMediaPlayer.this, DefaultDirectMediaPlayer.this.nativeBuffers, DefaultDirectMediaPlayer.this.bufferFormat);
            DefaultDirectMediaPlayer.this.logger.trace("display finished");
        }
    }

    private final class UnlockCallback
    implements libvlc_unlock_callback_t {
        private UnlockCallback() {
        }

        @Override
        public void unlock(Pointer pointer, Pointer pointer2, Pointer pointer3) {
            DefaultDirectMediaPlayer.this.logger.trace("unlock");
            DefaultDirectMediaPlayer.this.logger.trace("release");
            DefaultDirectMediaPlayer.this.semaphore.release();
            DefaultDirectMediaPlayer.this.logger.trace("released");
            DefaultDirectMediaPlayer.this.logger.trace("unlock finished");
        }
    }

    private final class LockCallback
    implements libvlc_lock_callback_t {
        private LockCallback() {
        }

        @Override
        public Pointer lock(Pointer pointer, PointerByReference pointerByReference) {
            DefaultDirectMediaPlayer.this.logger.trace("lock");
            DefaultDirectMediaPlayer.this.logger.trace("acquire");
            DefaultDirectMediaPlayer.this.semaphore.acquireUninterruptibly();
            DefaultDirectMediaPlayer.this.logger.trace("acquired");
            pointerByReference.getPointer().write(0L, DefaultDirectMediaPlayer.this.pointers, 0, DefaultDirectMediaPlayer.this.pointers.length);
            DefaultDirectMediaPlayer.this.logger.trace("lock finished");
            return null;
        }
    }

    private final class CleanupCallback
    implements libvlc_video_cleanup_cb {
        private CleanupCallback() {
        }

        @Override
        public void cleanup(Pointer pointer) {
            DefaultDirectMediaPlayer.this.logger.trace("cleanup");
            if (DefaultDirectMediaPlayer.this.nativeBuffers != null) {
                DefaultDirectMediaPlayer.access$902(DefaultDirectMediaPlayer.this, null);
            }
            DefaultDirectMediaPlayer.this.logger.trace("cleanup finished");
        }
    }

    private final class SetupCallback
    implements libvlc_video_format_cb {
        private SetupCallback() {
        }

        @Override
        public int format(PointerByReference pointerByReference, PointerByReference pointerByReference2, IntByReference intByReference, IntByReference intByReference2, PointerByReference pointerByReference3, PointerByReference pointerByReference4) {
            DefaultDirectMediaPlayer.this.logger.debug("format(chroma={},width={},height={})", pointerByReference2.getPointer().getString(0L), intByReference.getValue(), intByReference2.getValue());
            DefaultDirectMediaPlayer.this.bufferFormat = DefaultDirectMediaPlayer.this.bufferFormatCallback.getBufferFormat(intByReference.getValue(), intByReference2.getValue());
            DefaultDirectMediaPlayer.this.logger.debug("bufferFormat={}", (Object)DefaultDirectMediaPlayer.this.bufferFormat);
            if (DefaultDirectMediaPlayer.this.bufferFormat == null) {
                throw new IllegalStateException("buffer format can not be null");
            }
            byte[] byArray = DefaultDirectMediaPlayer.this.bufferFormat.getChroma().getBytes();
            pointerByReference2.getPointer().write(0L, byArray, 0, byArray.length > 4 ? 4 : byArray.length);
            intByReference.setValue(DefaultDirectMediaPlayer.this.bufferFormat.getWidth());
            intByReference2.setValue(DefaultDirectMediaPlayer.this.bufferFormat.getHeight());
            int[] nArray = DefaultDirectMediaPlayer.this.bufferFormat.getPitches();
            int[] nArray2 = DefaultDirectMediaPlayer.this.bufferFormat.getLines();
            pointerByReference3.getPointer().write(0L, nArray, 0, nArray.length);
            pointerByReference4.getPointer().write(0L, nArray2, 0, nArray2.length);
            DefaultDirectMediaPlayer.access$902(DefaultDirectMediaPlayer.this, new ByteBuffer[DefaultDirectMediaPlayer.this.bufferFormat.getPlaneCount()]);
            DefaultDirectMediaPlayer.access$1002(DefaultDirectMediaPlayer.this, new Pointer[DefaultDirectMediaPlayer.this.bufferFormat.getPlaneCount()]);
            for (int i = 0; i < DefaultDirectMediaPlayer.this.bufferFormat.getPlaneCount(); ++i) {
                ByteBuffer byteBuffer;
                ((DefaultDirectMediaPlayer)DefaultDirectMediaPlayer.this).nativeBuffers[i] = byteBuffer = ByteBufferFactory.allocateAlignedBuffer(nArray[i] * nArray2[i]);
                ((DefaultDirectMediaPlayer)DefaultDirectMediaPlayer.this).pointers[i] = Pointer.createConstant(((DirectBuffer)((Object)byteBuffer)).address());
            }
            DefaultDirectMediaPlayer.this.logger.trace("format finished");
            return nArray.length;
        }
    }
}

