/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.directaudio;

import com.sun.jna.Pointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_drain_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_flush_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_pause_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_play_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_resume_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.player.directaudio.AudioCallback;
import uk.co.caprica.vlcj.player.directaudio.DirectAudioPlayer;
import uk.co.caprica.vlcj.player.embedded.DefaultEmbeddedMediaPlayer;

public class DefaultDirectAudioPlayer
extends DefaultEmbeddedMediaPlayer
implements DirectAudioPlayer {
    private final Logger logger = LoggerFactory.getLogger(DefaultDirectAudioPlayer.class);
    private final libvlc_audio_play_cb playCallback;
    private final libvlc_audio_pause_cb pauseCallback;
    private final libvlc_audio_resume_cb resumeCallback;
    private final libvlc_audio_flush_cb flushCallback;
    private final libvlc_audio_drain_cb drainCallback;
    private final AudioCallback audioCallback;

    public DefaultDirectAudioPlayer(LibVlc libVlc, libvlc_instance_t libvlc_instance_t2, String string, int n, int n2, AudioCallback audioCallback) {
        super(libVlc, libvlc_instance_t2);
        this.audioCallback = audioCallback;
        this.playCallback = new PlayCallback();
        this.pauseCallback = new PauseCallback();
        this.resumeCallback = new ResumeCallback();
        this.flushCallback = new FlushCallback();
        this.drainCallback = new DrainCallback();
        libVlc.libvlc_audio_set_format(this.mediaPlayerInstance(), string, n, n2);
        libVlc.libvlc_audio_set_callbacks(this.mediaPlayerInstance(), this.playCallback, this.pauseCallback, this.resumeCallback, this.flushCallback, this.drainCallback, null);
    }

    private final class DrainCallback
    implements libvlc_audio_drain_cb {
        private DrainCallback() {
        }

        @Override
        public void drain(Pointer pointer) {
            DefaultDirectAudioPlayer.this.logger.debug("drain()");
            DefaultDirectAudioPlayer.this.audioCallback.drain(DefaultDirectAudioPlayer.this);
        }
    }

    private final class FlushCallback
    implements libvlc_audio_flush_cb {
        private FlushCallback() {
        }

        @Override
        public void flush(Pointer pointer, long l) {
            DefaultDirectAudioPlayer.this.logger.debug("flush(pts={})", (Object)l);
            DefaultDirectAudioPlayer.this.audioCallback.flush(DefaultDirectAudioPlayer.this, l);
        }
    }

    private final class ResumeCallback
    implements libvlc_audio_resume_cb {
        private ResumeCallback() {
        }

        @Override
        public void resume(Pointer pointer, long l) {
            DefaultDirectAudioPlayer.this.logger.debug("resume(pts={})", (Object)l);
            DefaultDirectAudioPlayer.this.audioCallback.resume(DefaultDirectAudioPlayer.this, l);
        }
    }

    private final class PauseCallback
    implements libvlc_audio_pause_cb {
        private PauseCallback() {
        }

        @Override
        public void pause(Pointer pointer, long l) {
            DefaultDirectAudioPlayer.this.logger.debug("pause(pts={})", (Object)l);
            DefaultDirectAudioPlayer.this.audioCallback.pause(DefaultDirectAudioPlayer.this, l);
        }
    }

    private final class PlayCallback
    implements libvlc_audio_play_cb {
        private PlayCallback() {
        }

        @Override
        public void play(Pointer pointer, Pointer pointer2, int n, long l) {
            DefaultDirectAudioPlayer.this.logger.trace("play(count={},pts={})", (Object)n, (Object)l);
            DefaultDirectAudioPlayer.this.audioCallback.play(DefaultDirectAudioPlayer.this, pointer2, n, l);
        }
    }
}

