/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded;

import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.player.DefaultMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.videosurface.CanvasVideoSurface;

public class DefaultEmbeddedMediaPlayer
extends DefaultMediaPlayer
implements EmbeddedMediaPlayer {
    private final Logger logger = LoggerFactory.getLogger(DefaultEmbeddedMediaPlayer.class);
    private FullScreenStrategy fullScreenStrategy;
    private final OverlayComponentAdapter overlayComponentAdapter;
    private final OverlayWindowAdapter overlayWindowAdapter;
    private CanvasVideoSurface videoSurface;
    private Window overlay;
    private boolean requestedOverlay;
    private boolean restoreOverlay;

    public DefaultEmbeddedMediaPlayer(LibVlc libVlc, libvlc_instance_t libvlc_instance_t2) {
        this(libVlc, libvlc_instance_t2, null);
    }

    public DefaultEmbeddedMediaPlayer(LibVlc libVlc, libvlc_instance_t libvlc_instance_t2, FullScreenStrategy fullScreenStrategy) {
        super(libVlc, libvlc_instance_t2);
        this.fullScreenStrategy = fullScreenStrategy;
        this.overlayComponentAdapter = new OverlayComponentAdapter();
        this.overlayWindowAdapter = new OverlayWindowAdapter();
    }

    @Override
    public void setVideoSurface(CanvasVideoSurface canvasVideoSurface) {
        this.logger.debug("setVideoSurface(videoSurface={})", (Object)canvasVideoSurface);
        this.videoSurface = canvasVideoSurface;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void attachVideoSurface() {
        this.logger.debug("attachVideoSurface()");
        if (this.videoSurface != null) {
            if (!this.videoSurface.canvas().isVisible()) throw new IllegalStateException("The video surface is not visible");
            this.videoSurface.attach(this.libvlc, this);
            return;
        } else {
            this.logger.debug("Can't attach video surface since no video surface has been set");
        }
    }

    @Override
    public void setFullScreenStrategy(FullScreenStrategy fullScreenStrategy) {
        this.logger.debug("setFullScreenStrategy(fullScreenStrategy={})", (Object)fullScreenStrategy);
        this.fullScreenStrategy = fullScreenStrategy;
    }

    @Override
    public void toggleFullScreen() {
        this.logger.debug("toggleFullScreen()");
        if (this.fullScreenStrategy != null) {
            this.setFullScreen(!this.fullScreenStrategy.isFullScreenMode());
        }
    }

    @Override
    public void setFullScreen(boolean bl) {
        this.logger.debug("setFullScreen(fullScreen={})", (Object)bl);
        if (this.fullScreenStrategy != null) {
            if (bl) {
                this.fullScreenStrategy.enterFullScreenMode();
            } else {
                this.fullScreenStrategy.exitFullScreenMode();
            }
        }
    }

    @Override
    public boolean isFullScreen() {
        this.logger.debug("isFullScreen()");
        if (this.fullScreenStrategy != null) {
            return this.fullScreenStrategy.isFullScreenMode();
        }
        return false;
    }

    @Override
    public BufferedImage getVideoSurfaceContents() {
        this.logger.debug("getVideoSurfaceContents()");
        try {
            Rectangle rectangle = this.videoSurface.canvas().getBounds();
            rectangle.setLocation(this.videoSurface.canvas().getLocationOnScreen());
            return new Robot().createScreenCapture(rectangle);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to get video surface contents", exception);
        }
    }

    @Override
    public Window getOverlay() {
        this.logger.debug("getOverlay()");
        return this.overlay;
    }

    @Override
    public void setOverlay(Window window) {
        this.logger.debug("setOverlay(overlay={})", (Object)window);
        if (this.videoSurface == null) {
            throw new IllegalStateException("Can't set an overlay when there's no video surface");
        }
        this.enableOverlay(false);
        this.removeOverlay();
        this.addOverlay(window);
    }

    @Override
    public void enableOverlay(boolean bl) {
        this.logger.debug("enableOverlay(enable={})", (Object)bl);
        this.requestedOverlay = bl;
        if (this.overlay != null) {
            if (bl) {
                if (!this.overlay.isVisible()) {
                    this.overlay.setLocation(this.videoSurface.canvas().getLocationOnScreen());
                    this.overlay.setSize(this.videoSurface.canvas().getSize());
                    Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.videoSurface.canvas());
                    window.addComponentListener(this.overlayComponentAdapter);
                    this.overlay.setVisible(true);
                }
            } else if (this.overlay.isVisible()) {
                this.overlay.setVisible(false);
                Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.videoSurface.canvas());
                window.removeComponentListener(this.overlayComponentAdapter);
            }
        }
    }

    @Override
    public boolean overlayEnabled() {
        this.logger.debug("overlayEnabled()");
        return this.overlay != null && this.overlay.isVisible();
    }

    @Override
    public void setEnableMouseInputHandling(boolean bl) {
        this.logger.debug("setEnableMouseInputHandling(enable={})", (Object)bl);
        this.libvlc.libvlc_video_set_mouse_input(this.mediaPlayerInstance(), bl ? 1 : 0);
    }

    @Override
    public void setEnableKeyInputHandling(boolean bl) {
        this.logger.debug("setEnableKeyInputHandling(enable={})", (Object)bl);
        this.libvlc.libvlc_video_set_key_input(this.mediaPlayerInstance(), bl ? 1 : 0);
    }

    private void addOverlay(Window window) {
        this.logger.debug("addOverlay(overlay={})", (Object)window);
        if (window != null) {
            this.overlay = window;
            Window window2 = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.videoSurface.canvas());
            if (window2 != null) {
                window2.addWindowListener(this.overlayWindowAdapter);
            } else {
                this.logger.warn("Failed to find a Window ancestor for the video surface Canvas");
            }
        }
    }

    private void removeOverlay() {
        this.logger.debug("removeOverlay()");
        if (this.overlay != null) {
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.videoSurface.canvas());
            window.removeWindowListener(this.overlayWindowAdapter);
            this.overlay = null;
        }
    }

    @Override
    protected final void onBeforePlay() {
        this.logger.debug("onBeforePlay()");
        this.attachVideoSurface();
    }

    private void showOverlay() {
        this.logger.trace("showOverlay()");
        if (this.restoreOverlay) {
            this.enableOverlay(true);
        }
    }

    private void hideOverlay() {
        this.logger.trace("hideOverlay()");
        if (this.requestedOverlay) {
            this.restoreOverlay = true;
            this.enableOverlay(false);
        } else {
            this.restoreOverlay = false;
        }
    }

    private final class OverlayWindowAdapter
    extends WindowAdapter {
        private OverlayWindowAdapter() {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            DefaultEmbeddedMediaPlayer.this.logger.trace("windowIconified(e={})", (Object)windowEvent);
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
            DefaultEmbeddedMediaPlayer.this.logger.trace("windowDeiconified(e={})", (Object)windowEvent);
            DefaultEmbeddedMediaPlayer.this.showOverlay();
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            DefaultEmbeddedMediaPlayer.this.logger.trace("windowDeactivated(e={})", (Object)windowEvent);
            DefaultEmbeddedMediaPlayer.this.hideOverlay();
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            DefaultEmbeddedMediaPlayer.this.logger.trace("windowActivated(e={})", (Object)windowEvent);
            DefaultEmbeddedMediaPlayer.this.showOverlay();
        }
    }

    private final class OverlayComponentAdapter
    extends ComponentAdapter {
        private OverlayComponentAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            DefaultEmbeddedMediaPlayer.this.logger.trace("componentResized(e={})", (Object)componentEvent);
            DefaultEmbeddedMediaPlayer.this.overlay.setSize(DefaultEmbeddedMediaPlayer.this.videoSurface.canvas().getSize());
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            DefaultEmbeddedMediaPlayer.this.logger.trace("componentMoved(e={})", (Object)componentEvent);
            DefaultEmbeddedMediaPlayer.this.overlay.setLocation(DefaultEmbeddedMediaPlayer.this.videoSurface.canvas().getLocationOnScreen());
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            DefaultEmbeddedMediaPlayer.this.logger.trace("componentShown(e={})", (Object)componentEvent);
            DefaultEmbeddedMediaPlayer.this.showOverlay();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            DefaultEmbeddedMediaPlayer.this.logger.trace("componentHidden(e={})", (Object)componentEvent);
            DefaultEmbeddedMediaPlayer.this.hideOverlay();
        }
    }
}

