/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.videosurface;

import com.sun.jna.Native;
import java.awt.Canvas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurfaceAdapter;

public class CanvasVideoSurface
extends VideoSurface {
    private final Logger logger = LoggerFactory.getLogger(CanvasVideoSurface.class);
    private static final long serialVersionUID = 1L;
    private final Canvas canvas;

    public CanvasVideoSurface(Canvas canvas, VideoSurfaceAdapter videoSurfaceAdapter) {
        super(videoSurfaceAdapter);
        this.canvas = canvas;
    }

    public final Canvas canvas() {
        return this.canvas;
    }

    @Override
    public void attach(LibVlc libVlc, MediaPlayer mediaPlayer) {
        this.logger.debug("attach()");
        if (!this.canvas.isDisplayable()) {
            throw new IllegalStateException("The video surface component must be displayable");
        }
        long l = Native.getComponentID(this.canvas);
        this.logger.debug("componentId={}", (Object)l);
        this.videoSurfaceAdapter.attach(libVlc, mediaPlayer, l);
        this.logger.debug("video surface attached");
    }
}

