/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.windows;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import java.awt.Window;
import uk.co.caprica.vlcj.player.embedded.windows.ExtendedUser32;
import uk.co.caprica.vlcj.player.embedded.windows.WindowState;

final class Win32FullScreenHandler {
    private final Window window;
    private WindowState windowState;

    Win32FullScreenHandler(Window window) {
        this.window = window;
    }

    void setFullScreen(boolean bl) {
        WinDef.HWND hWND = this.getHWND(Native.getComponentID(this.window));
        if (bl) {
            this.windowState = this.getWindowState(hWND);
            ExtendedUser32.INSTANCE.SetWindowLong(hWND, -16, this.windowState.getStyle() & 0xFF3BFFFF);
            ExtendedUser32.INSTANCE.SetWindowLong(hWND, -20, this.windowState.getExStyle() & 0xFFFDFCFE);
            WinUser.MONITORINFO mONITORINFO = this.getMonitorInfo(hWND);
            WinDef.RECT rECT = mONITORINFO.rcMonitor;
            ExtendedUser32.INSTANCE.SetWindowPos(hWND, null, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 52);
        } else {
            ExtendedUser32.INSTANCE.SetWindowLong(hWND, -16, this.windowState.getStyle());
            ExtendedUser32.INSTANCE.SetWindowLong(hWND, -20, this.windowState.getExStyle());
            ExtendedUser32.INSTANCE.SetWindowPos(hWND, null, this.windowState.getLeft(), this.windowState.getTop(), this.windowState.getRight() - this.windowState.getLeft(), this.windowState.getBottom() - this.windowState.getTop(), 52);
            if (this.windowState.getMaximized()) {
                ExtendedUser32.INSTANCE.SendMessage(hWND, 274, new WinDef.WPARAM(61488L), new WinDef.LPARAM(0L));
            }
        }
    }

    private WinDef.HWND getHWND(long l) {
        return new WinDef.HWND(Pointer.createConstant(l));
    }

    private WindowState getWindowState(WinDef.HWND hWND) {
        WindowState windowState = new WindowState();
        windowState.setMaximized(ExtendedUser32.INSTANCE.IsZoomed(hWND));
        if (windowState.getMaximized()) {
            ExtendedUser32.INSTANCE.SendMessage(hWND, 274, new WinDef.WPARAM(61728L), new WinDef.LPARAM(0L));
        }
        windowState.setStyle(ExtendedUser32.INSTANCE.GetWindowLong(hWND, -16));
        windowState.setExStyle(ExtendedUser32.INSTANCE.GetWindowLong(hWND, -20));
        WinDef.RECT rECT = new WinDef.RECT();
        boolean bl = ExtendedUser32.INSTANCE.GetWindowRect(hWND, rECT);
        if (bl) {
            windowState.setLeft(rECT.left);
            windowState.setTop(rECT.top);
            windowState.setRight(rECT.right);
            windowState.setBottom(rECT.bottom);
        }
        return windowState;
    }

    private WinUser.MONITORINFO getMonitorInfo(WinDef.HWND hWND) {
        Pointer pointer = ExtendedUser32.INSTANCE.MonitorFromWindow(hWND, ExtendedUser32.MONITOR_DEFAULTTONEAREST);
        WinUser.MONITORINFO mONITORINFO = new WinUser.MONITORINFO();
        ExtendedUser32.INSTANCE.GetMonitorInfoA(pointer, mONITORINFO);
        return mONITORINFO;
    }
}

