/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.list;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_manager_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_playback_mode_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_state_t;
import uk.co.caprica.vlcj.medialist.MediaList;
import uk.co.caprica.vlcj.player.AbstractMediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.NativeString;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.list.MediaListPlayer;
import uk.co.caprica.vlcj.player.list.MediaListPlayerEventAdapter;
import uk.co.caprica.vlcj.player.list.MediaListPlayerEventListener;
import uk.co.caprica.vlcj.player.list.MediaListPlayerMode;
import uk.co.caprica.vlcj.player.list.events.MediaListPlayerEvent;
import uk.co.caprica.vlcj.player.list.events.MediaListPlayerEventFactory;
import uk.co.caprica.vlcj.player.list.events.MediaListPlayerEventType;

public class DefaultMediaListPlayer
extends AbstractMediaPlayer
implements MediaListPlayer {
    private final Logger logger = LoggerFactory.getLogger(DefaultMediaListPlayer.class);
    private final List<MediaListPlayerEventListener> eventListenerList = new ArrayList<MediaListPlayerEventListener>();
    private final MediaListPlayerEventFactory eventFactory = new MediaListPlayerEventFactory(this);
    private final ExecutorService listenersService = Executors.newSingleThreadExecutor();
    private final NextItemHandler nextItemHandler = new NextItemHandler();
    private libvlc_media_list_player_t mediaListPlayerInstance;
    private libvlc_event_manager_t mediaListPlayerEventManager;
    private libvlc_callback_t callback;
    private MediaPlayer mediaPlayer;
    private long eventMask = MediaListPlayerEventType.ALL.value();
    private MediaList mediaList;
    private Object userData;
    private final AtomicReference<String> currentMrl = new AtomicReference();
    private final AtomicBoolean released = new AtomicBoolean();

    public DefaultMediaListPlayer(LibVlc libVlc, libvlc_instance_t libvlc_instance_t2) {
        super(libVlc, libvlc_instance_t2);
        this.logger.debug("DefaultMediaListPlayer(libvlc={}, instance={})", (Object)libVlc, (Object)libvlc_instance_t2);
        this.createInstance();
    }

    @Override
    public void addMediaListPlayerEventListener(MediaListPlayerEventListener mediaListPlayerEventListener) {
        this.logger.debug("addMediaPlayerEventListener(listener={})", (Object)mediaListPlayerEventListener);
        this.eventListenerList.add(mediaListPlayerEventListener);
    }

    @Override
    public void removeMediaListPlayerEventListener(MediaListPlayerEventListener mediaListPlayerEventListener) {
        this.logger.debug("removeMediaPlayerEventListener(listener={})", (Object)mediaListPlayerEventListener);
        this.eventListenerList.remove(mediaListPlayerEventListener);
    }

    @Override
    public void enableEvents(long l) {
        this.logger.debug("enableEvents(eventMask={})", (Object)l);
        this.eventMask = l;
    }

    @Override
    public void setMediaPlayer(MediaPlayer mediaPlayer) {
        this.logger.debug("setMediaPlayer(mediaPlayer={})", (Object)mediaPlayer);
        this.mediaPlayer = mediaPlayer;
        this.libvlc.libvlc_media_list_player_set_media_player(this.mediaListPlayerInstance, mediaPlayer.mediaPlayerInstance());
    }

    @Override
    public void setMediaList(MediaList mediaList) {
        this.logger.debug("setMediaList(mediaList={})", (Object)mediaList);
        this.libvlc.libvlc_media_list_player_set_media_list(this.mediaListPlayerInstance, mediaList.mediaListInstance());
        this.mediaList = mediaList;
    }

    @Override
    public MediaList getMediaList() {
        this.logger.debug("getMediaList()");
        return this.mediaList;
    }

    @Override
    public void play() {
        this.logger.debug("play()");
        this.attachVideoSurface();
        this.libvlc.libvlc_media_list_player_play(this.mediaListPlayerInstance);
    }

    @Override
    public void pause() {
        this.logger.debug("pause()");
        this.libvlc.libvlc_media_list_player_pause(this.mediaListPlayerInstance);
    }

    @Override
    public void stop() {
        this.logger.debug("stop()");
        this.libvlc.libvlc_media_list_player_stop(this.mediaListPlayerInstance);
    }

    @Override
    public boolean playItem(int n) {
        this.logger.debug("playItem(itemIndex={})", (Object)n);
        if (this.mediaList != null && n >= 0 && n < this.mediaList.size()) {
            this.attachVideoSurface();
            return this.libvlc.libvlc_media_list_player_play_item_at_index(this.mediaListPlayerInstance, n) == 0;
        }
        throw new IllegalArgumentException("Item index is out of bounds");
    }

    @Override
    public void playNext() {
        this.logger.debug("playNext()");
        this.libvlc.libvlc_media_list_player_next(this.mediaListPlayerInstance);
    }

    @Override
    public void playPrevious() {
        this.logger.debug("playPrevious()");
        this.libvlc.libvlc_media_list_player_previous(this.mediaListPlayerInstance);
    }

    @Override
    public boolean isPlaying() {
        this.logger.debug("isPlaying()");
        return this.libvlc.libvlc_media_list_player_is_playing(this.mediaListPlayerInstance) != 0;
    }

    @Override
    public libvlc_state_t getMediaListPlayerState() {
        this.logger.debug("getMediaListPlayerState()");
        return libvlc_state_t.state(this.libvlc.libvlc_media_list_player_get_state(this.mediaListPlayerInstance));
    }

    @Override
    public void setMode(MediaListPlayerMode mediaListPlayerMode) {
        libvlc_playback_mode_e libvlc_playback_mode_e2;
        this.logger.debug("setMode(mode={})", (Object)mediaListPlayerMode);
        switch (mediaListPlayerMode) {
            case DEFAULT: {
                libvlc_playback_mode_e2 = libvlc_playback_mode_e.libvlc_playback_mode_default;
                break;
            }
            case LOOP: {
                libvlc_playback_mode_e2 = libvlc_playback_mode_e.libvlc_playback_mode_loop;
                break;
            }
            case REPEAT: {
                libvlc_playback_mode_e2 = libvlc_playback_mode_e.libvlc_playback_mode_repeat;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mode " + (Object)((Object)mediaListPlayerMode));
            }
        }
        this.libvlc.libvlc_media_list_player_set_playback_mode(this.mediaListPlayerInstance, libvlc_playback_mode_e2.intValue());
    }

    @Override
    public String mrl(libvlc_media_t libvlc_media_t2) {
        this.logger.debug("mrl(mediaInstance={})", (Object)libvlc_media_t2);
        return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_get_mrl(libvlc_media_t2));
    }

    @Override
    public Object userData() {
        this.logger.debug("userData()");
        return this.userData;
    }

    @Override
    public void userData(Object object) {
        this.logger.debug("userData(userData={})", object);
        this.userData = object;
    }

    @Override
    public final String currentMrl() {
        this.logger.debug("currentMrl()");
        return this.currentMrl.get();
    }

    @Override
    public libvlc_media_player_t getMediaPlayerInstance() {
        this.logger.debug("getMediaPlayerInstance()");
        return this.libvlc.libvlc_media_list_player_get_media_player(this.mediaListPlayerInstance);
    }

    @Override
    public final void release() {
        this.logger.debug("release()");
        if (this.released.compareAndSet(false, true)) {
            this.destroyInstance();
        }
    }

    private void createInstance() {
        this.logger.debug("createInstance()");
        this.mediaListPlayerInstance = this.libvlc.libvlc_media_list_player_new(this.instance);
        this.mediaListPlayerEventManager = this.libvlc.libvlc_media_list_player_event_manager(this.mediaListPlayerInstance);
        this.logger.debug("mediaListPlayerEventManager={}", (Object)this.mediaListPlayerEventManager);
        this.registerEventListener();
        this.addMediaListPlayerEventListener(this.nextItemHandler);
    }

    private void destroyInstance() {
        this.logger.debug("destroyInstance()");
        this.logger.debug("Detach events...");
        this.deregisterEventListener();
        this.logger.debug("Events detached.");
        this.eventListenerList.clear();
        this.nextItemHandler.release();
        if (this.mediaListPlayerInstance != null) {
            this.logger.debug("Release media list player...");
            this.libvlc.libvlc_media_list_player_release(this.mediaListPlayerInstance);
            this.logger.debug("Media list player released");
        }
        this.logger.debug("Shut down listeners...");
        this.listenersService.shutdown();
        this.logger.debug("Listeners shut down.");
    }

    private void registerEventListener() {
        this.logger.debug("registerEventListener()");
        this.callback = new VlcVideoPlayerCallback();
        for (libvlc_event_e libvlc_event_e2 : libvlc_event_e.values()) {
            if (libvlc_event_e2.intValue() < libvlc_event_e.libvlc_MediaListPlayerNextItemSet.intValue() || libvlc_event_e2.intValue() > libvlc_event_e.libvlc_MediaListPlayerStopped.intValue()) continue;
            this.logger.debug("event={}", (Object)libvlc_event_e2);
            int n = this.libvlc.libvlc_event_attach(this.mediaListPlayerEventManager, libvlc_event_e2.intValue(), this.callback, null);
            this.logger.debug("result={}", (Object)n);
        }
    }

    private void deregisterEventListener() {
        this.logger.debug("deregisterEventListener()");
        if (this.callback != null) {
            for (libvlc_event_e libvlc_event_e2 : libvlc_event_e.values()) {
                if (libvlc_event_e2.intValue() < libvlc_event_e.libvlc_MediaListPlayerNextItemSet.intValue() || libvlc_event_e2.intValue() > libvlc_event_e.libvlc_MediaListPlayerStopped.intValue()) continue;
                this.logger.debug("event={}", (Object)libvlc_event_e2);
                this.libvlc.libvlc_event_detach(this.mediaListPlayerEventManager, libvlc_event_e2.intValue(), this.callback, null);
            }
            this.callback = null;
        }
    }

    private void attachVideoSurface() {
        if (this.mediaPlayer instanceof EmbeddedMediaPlayer) {
            ((EmbeddedMediaPlayer)this.mediaPlayer).attachVideoSurface();
        }
    }

    @Override
    protected void finalize() throws Throwable {
        this.logger.debug("finalize()");
        this.logger.debug("Media list player has been garbage collected");
        super.finalize();
    }

    private class NextItemHandler
    extends MediaListPlayerEventAdapter {
        private libvlc_media_t mediaInstance;

        private NextItemHandler() {
        }

        @Override
        public void nextItem(MediaListPlayer mediaListPlayer, libvlc_media_t libvlc_media_t2, String string) {
            DefaultMediaListPlayer.this.logger.debug("nextItem(item={},itemMrl={})", (Object)libvlc_media_t2, (Object)string);
            this.deregisterMediaEventListener();
            this.mediaInstance = libvlc_media_t2;
            DefaultMediaListPlayer.this.currentMrl.set(string);
            this.registerMediaEventListener();
        }

        private void registerMediaEventListener() {
            DefaultMediaListPlayer.this.logger.debug("registerMediaEventListener()");
            if (this.mediaInstance != null) {
                DefaultMediaListPlayer.this.libvlc.libvlc_media_retain(this.mediaInstance);
                libvlc_event_manager_t libvlc_event_manager_t2 = DefaultMediaListPlayer.this.libvlc.libvlc_media_event_manager(this.mediaInstance);
                for (libvlc_event_e libvlc_event_e2 : libvlc_event_e.values()) {
                    if (libvlc_event_e2.intValue() < libvlc_event_e.libvlc_MediaMetaChanged.intValue() || libvlc_event_e2.intValue() > libvlc_event_e.libvlc_MediaStateChanged.intValue()) continue;
                    DefaultMediaListPlayer.this.logger.debug("event={}", (Object)libvlc_event_e2);
                    int n = DefaultMediaListPlayer.this.libvlc.libvlc_event_attach(libvlc_event_manager_t2, libvlc_event_e2.intValue(), DefaultMediaListPlayer.this.callback, null);
                    DefaultMediaListPlayer.this.logger.debug("result={}", (Object)n);
                }
            }
        }

        private void deregisterMediaEventListener() {
            DefaultMediaListPlayer.this.logger.debug("deregisterMediaEventListener()");
            if (this.mediaInstance != null) {
                libvlc_event_manager_t libvlc_event_manager_t2 = DefaultMediaListPlayer.this.libvlc.libvlc_media_event_manager(this.mediaInstance);
                for (libvlc_event_e libvlc_event_e2 : libvlc_event_e.values()) {
                    if (libvlc_event_e2.intValue() < libvlc_event_e.libvlc_MediaMetaChanged.intValue() || libvlc_event_e2.intValue() > libvlc_event_e.libvlc_MediaStateChanged.intValue()) continue;
                    DefaultMediaListPlayer.this.logger.debug("event={}", (Object)libvlc_event_e2);
                    DefaultMediaListPlayer.this.libvlc.libvlc_event_detach(libvlc_event_manager_t2, libvlc_event_e2.intValue(), DefaultMediaListPlayer.this.callback, null);
                }
                libvlc_event_manager_t2 = null;
                DefaultMediaListPlayer.this.libvlc.libvlc_media_release(this.mediaInstance);
                this.mediaInstance = null;
            }
        }

        private void release() {
            if (this.mediaInstance != null) {
                DefaultMediaListPlayer.this.libvlc.libvlc_media_release(this.mediaInstance);
            }
        }
    }

    private final class NotifyListenersRunnable
    implements Runnable {
        private final MediaListPlayerEvent mediaListPlayerEvent;

        private NotifyListenersRunnable(MediaListPlayerEvent mediaListPlayerEvent) {
            this.mediaListPlayerEvent = mediaListPlayerEvent;
        }

        @Override
        public void run() {
            DefaultMediaListPlayer.this.logger.trace("run()");
            for (int i = DefaultMediaListPlayer.this.eventListenerList.size() - 1; i >= 0; --i) {
                MediaListPlayerEventListener mediaListPlayerEventListener = (MediaListPlayerEventListener)DefaultMediaListPlayer.this.eventListenerList.get(i);
                try {
                    this.mediaListPlayerEvent.notify(mediaListPlayerEventListener);
                    continue;
                }
                catch (Exception exception) {
                    DefaultMediaListPlayer.this.logger.warn("Event listener {} threw an exception", (Object)exception, (Object)mediaListPlayerEventListener);
                }
            }
            DefaultMediaListPlayer.this.logger.trace("runnable exits");
        }
    }

    private final class VlcVideoPlayerCallback
    implements libvlc_callback_t {
        private VlcVideoPlayerCallback() {
        }

        @Override
        public void callback(libvlc_event_t libvlc_event_t2, Pointer pointer) {
            DefaultMediaListPlayer.this.logger.trace("callback(event={},userData={})", (Object)libvlc_event_t2, (Object)pointer);
            if (!DefaultMediaListPlayer.this.eventListenerList.isEmpty()) {
                MediaListPlayerEvent mediaListPlayerEvent = DefaultMediaListPlayer.this.eventFactory.newMediaListPlayerEvent(libvlc_event_t2, DefaultMediaListPlayer.this.eventMask);
                DefaultMediaListPlayer.this.logger.trace("mediaListPlayerEvent={}", (Object)mediaListPlayerEvent);
                if (mediaListPlayerEvent != null) {
                    DefaultMediaListPlayer.this.listenersService.submit(new NotifyListenersRunnable(mediaListPlayerEvent));
                }
            }
        }
    }
}

