/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.manager;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.player.manager.MediaManager;

public class DefaultMediaManager
implements MediaManager {
    private final Logger logger = LoggerFactory.getLogger(DefaultMediaManager.class);
    protected final LibVlc libvlc;
    protected final libvlc_instance_t instance;

    public DefaultMediaManager(LibVlc libVlc, libvlc_instance_t libvlc_instance_t2) {
        this.libvlc = libVlc;
        this.instance = libvlc_instance_t2;
        this.createInstance();
    }

    @Override
    public boolean addBroadcast(String string, String string2, String string3, boolean bl, boolean bl2, String ... stringArray) {
        this.logger.debug("addBrodcast(name={},inputMrl={},outputMrl={},enable={},loop={},options={})", string, string2, string3, bl, bl2, Arrays.toString(stringArray));
        return this.libvlc.libvlc_vlm_add_broadcast(this.instance, string, string2, string3, stringArray != null ? stringArray.length : 0, stringArray, bl ? 1 : 0, bl2 ? 1 : 0) == 0;
    }

    @Override
    public boolean addVideoOnDemand(String string, String string2, boolean bl, String string3, String ... stringArray) {
        this.logger.debug("addVideoOnDemand(name={},inputMrl={},enable={},mux={},options={})", string, string2, bl, string3, Arrays.toString(stringArray));
        return this.libvlc.libvlc_vlm_add_vod(this.instance, string, string2, stringArray != null ? stringArray.length : 0, stringArray, bl ? 1 : 0, string3) == 0;
    }

    @Override
    public boolean removeMedia(String string) {
        this.logger.debug("removeMedia(name={})", (Object)string);
        return this.libvlc.libvlc_vlm_del_media(this.instance, string) == 0;
    }

    @Override
    public boolean enableMedia(String string, boolean bl) {
        this.logger.debug("enableMedia(name={},enable={})", (Object)string, (Object)bl);
        return this.libvlc.libvlc_vlm_set_enabled(this.instance, string, bl ? 1 : 0) == 0;
    }

    @Override
    public boolean setOutput(String string, String string2) {
        this.logger.debug("setOutput(name={},outputMrl={})", (Object)string, (Object)string2);
        return this.libvlc.libvlc_vlm_set_output(this.instance, string, string2) == 0;
    }

    @Override
    public boolean setInput(String string, String string2) {
        this.logger.debug("setInput(name={},inputMrl={})", (Object)string, (Object)string2);
        return this.libvlc.libvlc_vlm_set_input(this.instance, string, string2) == 0;
    }

    @Override
    public boolean addInput(String string, String string2) {
        this.logger.debug("addInput(name={},inputMrl={})", (Object)string, (Object)string2);
        return this.libvlc.libvlc_vlm_add_input(this.instance, string, string2) == 0;
    }

    @Override
    public boolean setLoop(String string, boolean bl) {
        this.logger.debug("setLoop(name={},loop={})", (Object)string, (Object)bl);
        return this.libvlc.libvlc_vlm_set_loop(this.instance, string, bl ? 1 : 0) == 0;
    }

    @Override
    public boolean setMux(String string, String string2) {
        this.logger.debug("setMux(name={},mux={})", (Object)string, (Object)string2);
        return this.libvlc.libvlc_vlm_set_mux(this.instance, string, string2) == 0;
    }

    @Override
    public boolean changeMedia(String string, String string2, String string3, boolean bl, boolean bl2, String ... stringArray) {
        this.logger.debug("changeMedia(name={},inputMrl={},outputMrl={},enable={},loop={},options={})", string, string2, string3, bl, bl2, Arrays.toString(stringArray));
        return this.libvlc.libvlc_vlm_change_media(this.instance, string, string2, string3, stringArray != null ? stringArray.length : 0, stringArray, bl ? 1 : 0, bl2 ? 1 : 0) == 0;
    }

    @Override
    public boolean play(String string) {
        this.logger.debug("play(name={})", (Object)string);
        return this.libvlc.libvlc_vlm_play_media(this.instance, string) == 0;
    }

    @Override
    public boolean stop(String string) {
        this.logger.debug("stop(name={})", (Object)string);
        return this.libvlc.libvlc_vlm_stop_media(this.instance, string) == 0;
    }

    @Override
    public boolean pause(String string) {
        this.logger.debug("pause(name={})", (Object)string);
        return this.libvlc.libvlc_vlm_pause_media(this.instance, string) == 0;
    }

    @Override
    public boolean seek(String string, float f) {
        this.logger.debug("seek(name={},percentage={})", (Object)string, (Object)Float.valueOf(f));
        return this.libvlc.libvlc_vlm_seek_media(this.instance, string, f) == 0;
    }

    @Override
    public String show(String string) {
        this.logger.debug("show(name={})", (Object)string);
        return this.libvlc.libvlc_vlm_show_media(this.instance, string);
    }

    @Override
    public float getPosition(String string, int n) {
        this.logger.debug("getPosition(name={},instanceId={})", (Object)string, (Object)n);
        return this.libvlc.libvlc_vlm_get_media_instance_position(this.instance, string, n);
    }

    @Override
    public int getTime(String string, int n) {
        this.logger.debug("getTime(name={},instanceId={})", (Object)string, (Object)n);
        return this.libvlc.libvlc_vlm_get_media_instance_time(this.instance, string, n);
    }

    @Override
    public int getLength(String string, int n) {
        this.logger.debug("getLength(name={},instanceId={})", (Object)string, (Object)n);
        return this.libvlc.libvlc_vlm_get_media_instance_length(this.instance, string, n);
    }

    @Override
    public int getRate(String string, int n) {
        this.logger.debug("getRate(name={},instanceId={})", (Object)string, (Object)n);
        return this.libvlc.libvlc_vlm_get_media_instance_rate(this.instance, string, n);
    }

    @Override
    public void release() {
        this.logger.debug("release()");
        this.destroyInstance();
    }

    private void createInstance() {
        this.logger.debug("createInstance()");
    }

    private void destroyInstance() {
        this.logger.debug("destroyInstance()");
        this.libvlc.libvlc_vlm_release(this.instance);
    }
}

