/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.media.callback.seekable;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.player.media.callback.seekable.SeekableCallbackMedia;

public class RandomAccessFileMedia
extends SeekableCallbackMedia {
    private final Logger logger = LoggerFactory.getLogger(RandomAccessFileMedia.class);
    private final File file;
    private RandomAccessFile randomAccessFile;

    public RandomAccessFileMedia(File file, String ... stringArray) {
        super(stringArray);
        this.file = file;
    }

    public RandomAccessFileMedia(File file, int n, String ... stringArray) {
        super(n, stringArray);
        this.file = file;
    }

    @Override
    protected long onGetSize() {
        return this.file.length();
    }

    @Override
    protected boolean onOpen() {
        try {
            this.randomAccessFile = new RandomAccessFile(this.file, "r");
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.error("File not found");
            return false;
        }
    }

    @Override
    protected int onRead(byte[] byArray, int n) throws IOException {
        return this.randomAccessFile.read(byArray, 0, n);
    }

    @Override
    protected boolean onSeek(long l) {
        try {
            this.randomAccessFile.seek(l);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    protected void onClose() {
        try {
            this.randomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

