/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.runtime;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.runtime.RuntimeType;

public final class RuntimeUtil {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeUtil.class);
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();

    private RuntimeUtil() {
    }

    public static boolean isNix() {
        return OS_NAME.indexOf("nux") != -1 || OS_NAME.indexOf("nix") != -1 || OS_NAME.indexOf("freebsd") != -1;
    }

    public static boolean isWindows() {
        return OS_NAME.indexOf("win") != -1;
    }

    public static boolean isMac() {
        return OS_NAME.indexOf("mac") != -1;
    }

    public static RuntimeType runtimeType() {
        if (RuntimeUtil.isNix()) {
            return RuntimeType.NIX;
        }
        if (RuntimeUtil.isMac()) {
            return RuntimeType.MAC;
        }
        if (RuntimeUtil.isWindows()) {
            return RuntimeType.WINDOWS;
        }
        return RuntimeType.UNKNOWN;
    }

    public static int safeLongToInt(long l) {
        logger.debug("nativeComponentId={}", (Object)l);
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            logger.warn("Native component id is too big for int");
            throw new IllegalArgumentException("long value " + l + " cannot be safely converted to an int.");
        }
        return (int)l;
    }

    public static String getLibVlcLibraryName() {
        return RuntimeUtil.isWindows() ? "libvlc" : "vlc";
    }

    public static String getLibVlcName() {
        if (RuntimeUtil.isNix()) {
            return "libvlc.so";
        }
        if (RuntimeUtil.isWindows()) {
            return "libvlc.dll";
        }
        if (RuntimeUtil.isMac()) {
            return "libvlc.dylib";
        }
        throw new RuntimeException("Unknown operating system");
    }

    public static String getLibVlcCoreName() {
        if (RuntimeUtil.isNix()) {
            return "libvlccore.so";
        }
        if (RuntimeUtil.isWindows()) {
            return "libvlccore.dll";
        }
        if (RuntimeUtil.isMac()) {
            return "libvlccore.dylib";
        }
        throw new RuntimeException("Unknown operating system");
    }

    public static String getPluginsDirectoryName() {
        if (!RuntimeUtil.isWindows()) {
            return "vlc/plugins";
        }
        return "plugins";
    }
}

