/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.runtime.streams;

import com.sun.jna.Pointer;
import uk.co.caprica.vlcj.binding.LibC;

public final class NativeStreams {
    private static final int STDOUT_FD = 1;
    private static final int STDERR_FD = 2;
    private static final String STREAM_MODE = "w";
    private Pointer outputStream;
    private Pointer redirectedOutputStream;
    private Pointer errorStream;
    private Pointer redirectedErrorStream;

    public NativeStreams(String string, String string2) {
        if (string != null && !this.redirectOutputTo(string)) {
            throw new IllegalStateException("Failed to redirect stdout");
        }
        if (string2 != null && !this.redirectErrorTo(string2)) {
            throw new IllegalStateException("Failed to redirect stderr");
        }
    }

    private boolean redirectOutputTo(String string) {
        this.outputStream = LibC.INSTANCE.fdopen(1, STREAM_MODE);
        if (this.outputStream != null) {
            this.redirectedOutputStream = LibC.INSTANCE.freopen(string, STREAM_MODE, this.outputStream);
            return this.redirectedOutputStream != null;
        }
        return false;
    }

    private boolean redirectErrorTo(String string) {
        this.errorStream = LibC.INSTANCE.fdopen(2, STREAM_MODE);
        if (this.errorStream != null) {
            this.redirectedErrorStream = LibC.INSTANCE.freopen(string, STREAM_MODE, this.errorStream);
            return this.redirectedErrorStream != null;
        }
        return false;
    }

    public void release() {
        if (this.redirectedOutputStream != null) {
            LibC.INSTANCE.fclose(this.redirectedOutputStream);
        }
        if (this.redirectedErrorStream != null) {
            LibC.INSTANCE.fclose(this.redirectedErrorStream);
        }
    }
}

