/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.runtime.x;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.platform.unix.X11;
import java.awt.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibX11;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;

public final class LibXUtil {
    private static final Logger logger = LoggerFactory.getLogger(LibXUtil.class);
    private static final int _NET_WM_STATE_REMOVE = 0;
    private static final int _NET_WM_STATE_ADD = 1;
    private static final int TRUE = 1;

    private LibXUtil() {
    }

    public static void initialise() {
        block4: {
            try {
                LibX11.INSTANCE.XInitThreads();
            }
            catch (Exception exception) {
                if (!RuntimeUtil.isWindows()) {
                    logger.debug("Did not initialise LibX11: {}", (Object)exception.getMessage());
                }
            }
            catch (Error error) {
                if (RuntimeUtil.isWindows()) break block4;
                logger.debug("Did not initialise LibX11: {}", (Object)error.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setFullScreenWindow(Window window, boolean bl) {
        X11 x11 = X11.INSTANCE;
        X11.Display display = null;
        try {
            display = x11.XOpenDisplay(null);
            int n = LibXUtil.sendClientMessage(display, Native.getWindowID(window), "_NET_WM_STATE", new NativeLong(bl ? 1L : 0L), x11.XInternAtom(display, "_NET_WM_STATE_FULLSCREEN", false));
            boolean bl2 = n != 0;
            return bl2;
        }
        finally {
            if (display != null) {
                x11.XCloseDisplay(display);
            }
        }
    }

    private static int sendClientMessage(X11.Display display, long l, String string, NativeLong nativeLong, NativeLong nativeLong2) {
        X11 x11 = X11.INSTANCE;
        X11.XEvent xEvent = new X11.XEvent();
        xEvent.type = 33;
        xEvent.setType(X11.XClientMessageEvent.class);
        xEvent.xclient.type = 33;
        xEvent.xclient.serial = new NativeLong(0L);
        xEvent.xclient.send_event = 1;
        xEvent.xclient.message_type = x11.XInternAtom(display, string, false);
        xEvent.xclient.window = new X11.Window(l);
        xEvent.xclient.format = 32;
        xEvent.xclient.data.setType(NativeLong[].class);
        xEvent.xclient.data.l[0] = nativeLong;
        xEvent.xclient.data.l[1] = nativeLong2;
        xEvent.xclient.data.l[2] = new NativeLong(0L);
        xEvent.xclient.data.l[3] = new NativeLong(0L);
        xEvent.xclient.data.l[4] = new NativeLong(0L);
        NativeLong nativeLong3 = new NativeLong(0x180000L);
        int n = x11.XSendEvent(display, x11.XDefaultRootWindow(display), 0, nativeLong3, xEvent);
        x11.XFlush(display);
        return n;
    }
}

