/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron;

import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.application.Preloader;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.babelsoft.negatron.controller.MainController;
import net.babelsoft.negatron.io.cache.MachineListCache;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.preloader.NegatronPreloader;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.Strings;
import net.babelsoft.negatron.util.ToolTipDefaultsFixer;

public class NegatronApp
extends Application
implements NegatronPreloader.Notifier {
    private Stage stage;
    private MainController controller;
    private boolean mustClose;

    public static void main(String[] args) {
        ToolTipDefaultsFixer.setTooltipTimers(200L, 15000L, 200L);
        NegatronApp.launch((String[])args);
    }

    public void start(Stage stage) throws Exception {
        try {
            if (stage != null) {
                this.stage = stage;
                if (this.mustClose) {
                    stage.close();
                    return;
                }
            }
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("view/control/fxml/MainView.fxml"), Language.Manager.getBundle());
            Parent root = (Parent)fxmlLoader.load();
            this.controller = (MainController)fxmlLoader.getController();
            if (stage != null) {
                this.controller.ProgressProperty().addListener(o -> this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(this.controller.getProgress())));
                this.controller.OnSucceededProperty().addListener(o -> {
                    if (this.controller.hasSucceeded()) {
                        this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.StateChangeNotification(Preloader.StateChangeNotification.Type.BEFORE_START));
                    }
                });
            }
            this.controller.setApplication(this);
            this.controller.initialiseData();
            if (stage != null) {
                stage.setTitle("Negatron v" + this.getClass().getPackage().getImplementationVersion());
                stage.getIcons().add((Object)new Image(NegatronApp.class.getResourceAsStream("resource/icon/Negatron.png")));
                stage.getIcons().add((Object)new Image(NegatronApp.class.getResourceAsStream("resource/icon/Negatron@1.5x.png")));
                stage.getIcons().add((Object)new Image(NegatronApp.class.getResourceAsStream("resource/icon/Negatron@2x.png")));
                stage.getIcons().add((Object)new Image(NegatronApp.class.getResourceAsStream("resource/icon/Negatron@3x.png")));
                stage.getIcons().add((Object)new Image(NegatronApp.class.getResourceAsStream("resource/icon/Negatron@4x.png")));
                stage.getIcons().add((Object)new Image(NegatronApp.class.getResourceAsStream("resource/icon/Negatron@16x.png")));
                stage.setScene(new Scene(root));
            } else {
                this.controller.restart();
                this.stage.getScene().setRoot(root);
            }
        }
        catch (Throwable ex) {
            Logger.getLogger(NegatronApp.class.getName()).log(Level.SEVERE, "Couldn't start Negatron", ex);
            throw ex;
        }
    }

    @Override
    public void onConfigurationSucceeded() {
        boolean needsConfirmation;
        boolean mustSynchronize;
        MachineListCache cache;
        String locale = Configuration.Manager.getLanguage();
        if (Strings.isValid(locale)) {
            Locale.setDefault(Locale.forLanguageTag(locale));
        }
        ResourceBundle language = Language.Manager.getBundle();
        try {
            Configuration.Manager.initialise();
        }
        catch (Exception ex) {
            Logger.getLogger(NegatronApp.class.getName()).log(Level.SEVERE, "Couldn't read .ini file", ex);
            this.mustClose = true;
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ErrorNotification(language.getString("iniReading.error"), language.getString("iniReading.error.text"), (Throwable)ex));
            return;
        }
        try {
            cache = new MachineListCache();
            mustSynchronize = !cache.checkVersion();
            needsConfirmation = cache.getVersion() != null;
        }
        catch (Exception ex) {
            Logger.getLogger(NegatronApp.class.getName()).log(Level.SEVERE, "Couldn't determine MAME version", ex);
            this.mustClose = true;
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ErrorNotification(language.getString("mameVersion.error"), language.getString("mameVersion.error.text"), (Throwable)ex));
            return;
        }
        if (mustSynchronize) {
            Optional result;
            if (needsConfirmation) {
                Alert alert = new Alert(Alert.AlertType.WARNING, language.getString("mameUpdated.warning"), new ButtonType[]{ButtonType.YES, ButtonType.NO});
                alert.initOwner((Window)this.stage);
                result = alert.showAndWait();
            } else {
                result = Optional.of(ButtonType.YES);
            }
            if (result.isPresent() && result.get() == ButtonType.YES) {
                try {
                    cache.clear();
                }
                catch (IOException ex) {
                    Logger.getLogger(NegatronApp.class.getName()).log(Level.SEVERE, "Couldn't clear cache", ex);
                    this.mustClose = true;
                    this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ErrorNotification(language.getString("cacheClearing.error"), language.getString("cacheClearing.error.text"), (Throwable)ex));
                }
            }
        }
    }

    @Override
    public void onPreloadingSucceeded() {
        Platform.runLater(() -> {
            this.stage.show();
            this.controller.postInitialise(this.stage);
        });
    }

    public void stop() {
        if (this.controller != null) {
            this.controller.dispose();
        }
        System.exit(0);
    }
}

