/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.InvalidationListener;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.SingleSelectionModel;
import net.babelsoft.negatron.controller.MachineComponentController;
import net.babelsoft.negatron.model.Option;
import net.babelsoft.negatron.model.OptionProperty;
import net.babelsoft.negatron.model.component.Choice;
import net.babelsoft.negatron.model.component.MachineComponent;
import net.babelsoft.negatron.view.control.adapter.FocusData;

public class ChoiceController<T extends Option<T>>
extends MachineComponentController<Choice<T>, T, OptionProperty<T>> {
    private InvalidationListener choiceListener;
    private InvalidationListener choiceBoxListener;
    @FXML
    private ChoiceBox<T> choiceBox;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
    }

    @Override
    public void setMachineComponent(Choice<T> choice) {
        super.setMachineComponent(choice);
        this.choiceBox.getItems().addAll(choice.getOptions());
        this.choiceBox.getSelectionModel().select(choice.getValue());
        this.choiceListener = o -> {
            SingleSelectionModel selectionModel = this.choiceBox.getSelectionModel();
            Object option = ((Choice)this.getMachineComponent()).getValue();
            if (selectionModel.getSelectedItem() != option) {
                this.choiceBox.getSelectionModel().select(option);
            }
        };
        choice.valueProperty().addListener(this.choiceListener);
        this.choiceBoxListener = o -> {
            Option option = (Option)this.choiceBox.getSelectionModel().getSelectedItem();
            Choice component = (Choice)this.getMachineComponent();
            if (component.getValue() != option) {
                component.setValue(option);
                this.fireDataUpdated(component.getName());
            }
        };
        this.choiceBox.getSelectionModel().selectedItemProperty().addListener(this.choiceBoxListener);
    }

    @Override
    public void dispose() {
        ((Choice)this.getMachineComponent()).valueProperty().removeListener(this.choiceListener);
        this.choiceBox.getSelectionModel().selectedItemProperty().removeListener(this.choiceBoxListener);
    }

    @Override
    public boolean isFocused() {
        return this.choiceBox.isFocused();
    }

    @Override
    public FocusData getFocusData() {
        return new FocusData((MachineComponent<?, ?>)this.getMachineComponent());
    }

    @Override
    public boolean requestFocus(FocusData focusData) {
        if (super.requestFocus(focusData)) {
            this.choiceBox.requestFocus();
            return true;
        }
        return false;
    }

    @FXML
    private void handleDefaultAction(ActionEvent event) {
        this.choiceBox.getSelectionModel().select(((Choice)this.getMachineComponent()).getDefaultValue());
    }
}

