/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.FileChooser;
import net.babelsoft.negatron.controller.AlertController;
import net.babelsoft.negatron.controller.MachineComponentController;
import net.babelsoft.negatron.controller.SoftwareConfigurationPaneController;
import net.babelsoft.negatron.io.Mame;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.model.component.Device;
import net.babelsoft.negatron.model.component.MachineComponent;
import net.babelsoft.negatron.model.item.Software;
import net.babelsoft.negatron.util.Strings;
import net.babelsoft.negatron.view.control.HddCreationDialog;
import net.babelsoft.negatron.view.control.SoftwareConfigurationPane;
import net.babelsoft.negatron.view.control.adapter.FocusData;

public class DeviceController
extends MachineComponentController<Device, String, StringProperty> {
    private static final Device DEFAULT_DEVICE = new Device("<none>", null, null, false);
    private static final PseudoClass ERROR_CLASS = PseudoClass.getPseudoClass((String)"error");
    private static final KeyEvent SUBMIT_TEXT = new KeyEvent(KeyEvent.KEY_RELEASED, null, null, KeyCode.ENTER, false, false, false, false);
    private static AlertController alertController;
    private static SoftwareConfigurationPane softwareConfigurationPane;
    @FXML
    private HBox root;
    @FXML
    private TextField text;
    @FXML
    private ComboBox<String> combo;
    @FXML
    private Button createButton;
    @FXML
    private ToggleButton listButton;
    private ChangeListener<String> textListener;
    private ChangeListener<String> valueListener;

    public static void setAlertController(AlertController alertController) {
        DeviceController.alertController = alertController;
    }

    public static void setSoftwareConfigurationPane(SoftwareConfigurationPane softwareConfigurationPane) {
        DeviceController.softwareConfigurationPane = softwareConfigurationPane;
    }

    private boolean isText() {
        return this.text.getParent() != null;
    }

    @Override
    public void dispose() {
        Device device = (Device)this.getMachineComponent();
        if (device != DEFAULT_DEVICE) {
            this.text.textProperty().unbindBidirectional((Property)device.valueProperty());
            this.text.textProperty().removeListener(this.textListener);
            this.combo.valueProperty().unbindBidirectional((Property)device.valueProperty());
            this.combo.valueProperty().removeListener(this.valueListener);
        }
    }

    public void reset() {
        if (!this.isText()) {
            this.root.getChildren().add(0, (Object)this.text);
            this.root.getChildren().remove(this.combo);
            String value = (String)this.combo.getValue();
            this.combo.getItems().clear();
            this.text.setText(value);
        }
    }

    @Override
    public void setMachineComponent(Device device) {
        List<String> extensions;
        if (device == null) {
            super.setMachineComponent(DEFAULT_DEVICE);
            return;
        }
        super.setMachineComponent(device);
        this.text.textProperty().bindBidirectional((Property)device.valueProperty());
        this.textListener = (o, oV, newValue) -> {
            if (device.isMandatory()) {
                if (newValue.isEmpty()) {
                    this.text.pseudoClassStateChanged(ERROR_CLASS, true);
                } else {
                    this.text.pseudoClassStateChanged(ERROR_CLASS, false);
                }
            }
            this.fireDataUpdated(((Device)this.getMachineComponent()).getName());
        };
        this.text.textProperty().addListener(this.textListener);
        if (device.isMandatory() && Strings.isEmpty(this.text.getText())) {
            this.text.pseudoClassStateChanged(ERROR_CLASS, true);
        }
        this.combo.valueProperty().bindBidirectional((Property)device.valueProperty());
        this.valueListener = (o, oV, newValue) -> {
            if (device.isMandatory()) {
                if (newValue.isEmpty()) {
                    this.combo.pseudoClassStateChanged(ERROR_CLASS, true);
                } else {
                    this.combo.pseudoClassStateChanged(ERROR_CLASS, false);
                }
            }
            softwareConfigurationPane.getItems().stream().filter(adapter -> adapter.getDevices().contains(this)).forEach(adapter -> {
                if (adapter.getName().equals(newValue)) {
                    adapter.setAssignment(this);
                } else if (adapter.getAssignment() == this) {
                    adapter.setAssignment(SoftwareConfigurationPaneController.DEFAULT_DEVICE);
                }
            });
        };
        this.combo.valueProperty().addListener(this.valueListener);
        if (device.isMandatory() && Strings.isEmpty((String)this.combo.getValue())) {
            this.combo.pseudoClassStateChanged(ERROR_CLASS, true);
        }
        this.combo.focusedProperty().addListener((o, oV, newValue) -> {
            String value = (String)this.combo.getValue();
            String text = this.combo.getEditor().getText();
            if (!newValue.booleanValue() && (value == null && !text.isEmpty() || value != null && !value.equals(text))) {
                this.combo.fireEvent((Event)SUBMIT_TEXT);
            }
        });
        this.root.getChildren().remove(this.combo);
        if (!device.getType().equals("harddisk")) {
            ((Pane)this.createButton.getParent()).getChildren().remove((Object)this.createButton);
            this.createButton = null;
        }
        if (!device.hasCompatibleSoftwareLists()) {
            ((Pane)this.listButton.getParent()).getChildren().remove((Object)this.listButton);
            this.listButton = null;
        }
        if (!(extensions = device.getExtensions()).contains("*.zip")) {
            extensions.add("*.zip");
        }
    }

    @Override
    public boolean isFocused() {
        if (this.isText()) {
            return this.text.isFocused();
        }
        return this.combo.isFocused();
    }

    @Override
    public FocusData getFocusData() {
        int pos = this.isText() ? this.text.getCaretPosition() : this.combo.getEditor().getCaretPosition();
        return new FocusData((MachineComponent<?, ?>)this.getMachineComponent(), pos);
    }

    @Override
    public boolean requestFocus(FocusData focusData) {
        if (super.requestFocus(focusData)) {
            if (this.isText()) {
                this.text.requestFocus();
                this.text.positionCaret(focusData.getCaretPosition());
            } else {
                this.combo.requestFocus();
                this.combo.getEditor().positionCaret(focusData.getCaretPosition());
            }
            return true;
        }
        return false;
    }

    public boolean setSoftware(Software software) {
        if (!software.getName().equals(this.getText())) {
            this.setText(software.getName());
            return true;
        }
        return false;
    }

    public void addSoftwarePart(String softwarePartName) {
        if (this.isText()) {
            this.root.getChildren().remove((Object)this.text);
            this.root.getChildren().add(0, this.combo);
        }
        this.combo.getItems().add((Object)softwarePartName);
    }

    public void setText(String text) {
        if (this.getMachineComponent() == DEFAULT_DEVICE) {
            return;
        }
        if (this.isText()) {
            this.text.setText(text);
        } else {
            this.combo.setValue((Object)text);
        }
    }

    public String getText() {
        if (this.getMachineComponent() == DEFAULT_DEVICE) {
            return "";
        }
        if (this.isText()) {
            return this.text.getText();
        }
        return (String)this.combo.getValue();
    }

    public StringProperty valueProperty() {
        return ((Device)this.getMachineComponent()).valueProperty();
    }

    public void addSoftwareListActionHandler(EventHandler<ActionEvent> value) {
        if (this.listButton != null) {
            this.listButton.setOnAction(value);
        }
    }

    public void setListButtonSelected(boolean state) {
        if (this.listButton != null) {
            this.listButton.setSelected(state);
        }
    }

    public boolean isListButtonSelected() {
        return this.listButton.isSelected();
    }

    public void showList() {
        if (this.listButton != null && !this.listButton.isSelected()) {
            this.listButton.fire();
        }
    }

    public void hideList() {
        if (this.listButton != null && this.listButton.isSelected()) {
            this.listButton.fire();
        }
    }

    private void handleResetAction(ActionEvent event) {
        if (this.isText()) {
            this.text.clear();
        } else {
            this.combo.setValue(null);
        }
    }

    @FXML
    private void handleCreateAction(ActionEvent event) {
        if (Strings.isValid(Configuration.Manager.getChdmanExecutable())) {
            new HddCreationDialog(this.root.getScene().getWindow()).showAndWait().ifPresent(hddGeometry -> {
                try {
                    Mame.createBlankHdd(hddGeometry);
                    this.setText(hddGeometry.getPath());
                }
                catch (IOException | InterruptedException ex) {
                    Logger.getLogger(DeviceController.class.getName()).log(Level.SEVERE, null, ex);
                    alertController.alert(Alert.AlertType.ERROR, "Couldn't create blank HDD image:" + ex.getLocalizedMessage());
                }
            });
        } else {
            alertController.alert(Alert.AlertType.ERROR, "Couldn't initiate the blank HDD creation dialog: Path to the tool CHDMAN is not valid. Please, fix this in the global configuration pane.\n\nIf you installed a packaged MAME on Linux, you may also need to install the optional mame-tools package.");
        }
    }

    @FXML
    private void handleBrowseAction(ActionEvent event) {
        String description;
        Control c = (Control)event.getSource();
        FileChooser fc = new FileChooser();
        Iterator<String> it = ((Device)this.getMachineComponent()).getInterfaceFormats().iterator();
        if (it.hasNext()) {
            description = it.next();
            while (it.hasNext()) {
                description = description + " / " + it.next();
            }
        } else {
            description = ((Device)this.getMachineComponent()).getName();
        }
        fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(description, ((Device)this.getMachineComponent()).getExtensions()), new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"})});
        File f = fc.showOpenDialog(c.getScene().getWindow());
        if (f != null) {
            if (this.isText()) {
                this.text.setText(f.getAbsolutePath());
            } else {
                this.combo.setValue((Object)f.getAbsolutePath());
            }
        }
    }
}

