/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Pane;
import javafx.util.Duration;
import net.babelsoft.negatron.controller.FilterPaneController;
import net.babelsoft.negatron.controller.TreePaneController;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.model.Statistics;
import net.babelsoft.negatron.model.item.EmulatedItem;
import net.babelsoft.negatron.util.Strings;
import net.babelsoft.negatron.view.control.EmulatedItemTreeView;
import net.babelsoft.negatron.view.control.FilterPane;
import net.babelsoft.negatron.view.control.tree.SortableTreeItem;
import net.babelsoft.negatron.view.control.tree.TreeItemPredicate;
import net.babelsoft.negatron.view.control.tree.TreeTableDataFiller;

public class EmulatedItemTreePaneController<T extends EmulatedItem<T>>
extends TreePaneController<EmulatedItemTreeView<T>, T> {
    @FXML
    private ToggleGroup displayToggle;
    @FXML
    private ToggleButton treeViewButton;
    @FXML
    private ToggleButton tableViewButton;
    @FXML
    private ToggleButton viewButton;
    @FXML
    private TextField filterField;
    @FXML
    private ToggleButton filterButton;
    @FXML
    private Button expandAllButton;
    @FXML
    private Button collapseAllButton;
    private boolean mustFlatten;
    private Timeline filterTimeline;
    private Consumer<Boolean> onMoreViews;
    private Consumer<Boolean> onMoreFilters;
    private ChangeListener<? super String> filterChangeListener;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        if (Configuration.Manager.isMess()) {
            Tooltip tooltip = ((EmulatedItemTreeView)this.treeView).getTooltip();
            tooltip.setText(tooltip.getText().replace("MAME", "MESS"));
        }
        super.initialize(url, rb);
        this.filterTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)300.0), event -> {
            ((EmulatedItemTreeView)this.treeView).beginTreeWiseOperation();
            SortableTreeItem root = (SortableTreeItem)((EmulatedItemTreeView)this.treeView).getRoot();
            if (Strings.isValid(this.filterField.getText())) {
                String filter = this.filterField.getText().replace(" ", "").toLowerCase();
                root.setPredicate(TreeItemPredicate.create(emulatedItem -> emulatedItem.getShortcut().contains(filter)));
            } else {
                root.setPredicate(null);
            }
            ((EmulatedItemTreeView)this.treeView).endTreeWiseOperation();
        }, new KeyValue[0])});
        this.filterChangeListener = (o, oV, nV) -> this.filterTimeline.playFromStart();
        this.filterField.textProperty().addListener(this.filterChangeListener);
    }

    public void reset() {
        ((EmulatedItemTreeView)this.treeView).reset();
    }

    public EmulatedItemTreeView<T> getTreeView() {
        return (EmulatedItemTreeView)this.treeView;
    }

    public void setMoreViews(boolean enable) {
        if (!enable) {
            ((Pane)this.viewButton.getParent()).getChildren().remove((Object)this.viewButton);
        }
    }

    public void setOnMoreViews(Consumer<Boolean> onMoreViews) {
        this.onMoreViews = onMoreViews;
    }

    public void setViewButtonSelected(boolean selected) {
        this.viewButton.setSelected(selected);
    }

    public Property<String> filterProperty() {
        return this.filterField.textProperty();
    }

    public void setOnFilter(FilterPane<T, ? extends FilterPaneController<T>> pane) {
        pane.setOnFilter((Boolean isDefaults) -> {
            if (isDefaults.booleanValue()) {
                this.filterButton.setText("+");
            } else {
                this.filterButton.setText("\u00b1");
            }
        });
    }

    public void setOnMoreFilters(Consumer<Boolean> onMoreFilters) {
        this.onMoreFilters = onMoreFilters;
    }

    public boolean isFilterButtonSelected() {
        return this.filterButton.isSelected();
    }

    public void setFilterButtonSelected(boolean selected) {
        this.filterButton.setSelected(selected);
    }

    public void fireFilterButton() {
        this.filterButton.fire();
    }

    public void unbindFilter() {
        this.filterField.textProperty().removeListener(this.filterChangeListener);
        this.filterChangeListener = null;
        this.filterTimeline = null;
    }

    public Statistics setItems(List<T> emulatedItems) {
        ((EmulatedItemTreeView)this.treeView).beginResetOperation();
        this.reset();
        Statistics stats = TreeTableDataFiller.fill((EmulatedItemTreeView)this.treeView, emulatedItems, false);
        if (this.mustFlatten) {
            this.switchView(false);
        }
        ((EmulatedItemTreeView)this.treeView).endResetOperation();
        return stats;
    }

    public void setViewType(Map<SortableTreeItem<T>, List<String>> viewType) {
        ((EmulatedItemTreeView)this.treeView).beginTreeWiseOperation();
        ArrayList sortOrder = new ArrayList(((EmulatedItemTreeView)this.treeView).getSortOrder());
        ((EmulatedItemTreeView)this.treeView).getSortOrder().clear();
        SortableTreeItem root = ((EmulatedItemTreeView)this.treeView).getSortableRoot();
        root.getInternalChildren().clear();
        viewType.entrySet().forEach(entry -> {
            SortableTreeItem folder = (SortableTreeItem)((Object)((Object)entry.getKey()));
            ((List)entry.getValue()).forEach(itemName -> {
                SortableTreeItem item = ((EmulatedItemTreeView)this.treeView).getTreeItem((String)itemName);
                if (item != null) {
                    folder.getInternalChildren().add(item);
                }
            });
            if (folder.getInternalChildren().size() > 0) {
                if (!Strings.isEmpty(((EmulatedItem)folder.getValue()).getName())) {
                    root.getInternalChildren().add((Object)folder);
                } else {
                    root.getInternalChildren().addAll(folder.getInternalChildren());
                }
            }
        });
        ((EmulatedItemTreeView)this.treeView).getSortOrder().addAll(sortOrder);
        ((EmulatedItemTreeView)this.treeView).endTreeWiseOperation();
    }

    private void switchView() {
        this.switchView(true);
    }

    private void switchView(boolean performTreeWiseEncapsulateOps) {
        if (performTreeWiseEncapsulateOps) {
            ((EmulatedItemTreeView)this.treeView).beginTreeWiseOperation();
        }
        ArrayList sortOrder = new ArrayList(((EmulatedItemTreeView)this.treeView).getSortOrder());
        ((EmulatedItemTreeView)this.treeView).getSortOrder().clear();
        SortableTreeItem root = ((EmulatedItemTreeView)this.treeView).getSortableRoot();
        if (this.mustFlatten) {
            root.getInternalChildren().stream().map(item -> (SortableTreeItem)((Object)item)).flatMap(item -> item.getInternalChildren().stream()).collect(Collectors.toList()).forEach(item -> {
                SortableTreeItem parent = (SortableTreeItem)item.getParent();
                if (parent != null) {
                    parent.getInternalChildren().clear();
                }
                root.getInternalChildren().add(item);
            });
        } else {
            root.getInternalChildren().stream().filter(item -> ((EmulatedItem)item.getValue()).hasParent()).collect(Collectors.toList()).forEach(item -> {
                root.getInternalChildren().remove(item);
                ((EmulatedItemTreeView)this.treeView).getTreeItem(((EmulatedItem)((EmulatedItem)item.getValue()).getParent()).getName()).getInternalChildren().add(item);
            });
        }
        ((EmulatedItemTreeView)this.treeView).getSortOrder().addAll(sortOrder);
        if (performTreeWiseEncapsulateOps) {
            ((EmulatedItemTreeView)this.treeView).endTreeWiseOperation();
        }
    }

    @Override
    protected void loadLayout() {
        if (Configuration.Manager.getTreeTableFlattenConfiguration(this.id)) {
            this.displayToggle.selectToggle((Toggle)this.tableViewButton);
            this.setDisable(true);
        } else {
            this.displayToggle.selectToggle((Toggle)this.treeViewButton);
        }
        super.loadLayout();
    }

    private void setDisable(boolean value) {
        this.expandAllButton.setDisable(value);
        this.collapseAllButton.setDisable(value);
        this.mustFlatten = value;
    }

    @FXML
    private void handleTreeViewSwitchAction(ActionEvent event) {
        if (!this.treeViewButton.isSelected()) {
            this.tableViewButton.setSelected(true);
            this.handleTableViewSwitchAction(event);
            return;
        }
        this.setDisable(false);
        try {
            Configuration.Manager.updateTreeTableFlattenConfiguration(this.id, this.mustFlatten);
        }
        catch (IOException ex) {
            Logger.getLogger(EmulatedItemTreePaneController.class.getName()).log(Level.SEVERE, "Tree table flatten configuration failed", ex);
        }
        this.switchView();
    }

    @FXML
    private void handleTableViewSwitchAction(ActionEvent event) {
        if (!this.tableViewButton.isSelected()) {
            this.treeViewButton.setSelected(true);
            this.handleTreeViewSwitchAction(event);
            return;
        }
        this.setDisable(true);
        try {
            Configuration.Manager.updateTreeTableFlattenConfiguration(this.id, this.mustFlatten);
        }
        catch (IOException ex) {
            Logger.getLogger(EmulatedItemTreePaneController.class.getName()).log(Level.SEVERE, "Tree table flatten configuration failed", ex);
        }
        this.switchView();
    }

    @FXML
    private void handleMoreViewsAction(ActionEvent event) {
        this.onMoreViews.accept(this.viewButton.isSelected());
    }

    @FXML
    private void handleMoreFiltersAction(ActionEvent event) {
        this.onMoreFilters.accept(this.filterButton.isSelected());
    }

    @FXML
    private void handleExpandAllAction(ActionEvent event) {
        ((EmulatedItemTreeView)this.treeView).expandAll();
    }

    @FXML
    private void handleCollapseAllAction(ActionEvent event) {
        ((EmulatedItemTreeView)this.treeView).collapseAll();
    }
}

