/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.util.Duration;
import net.babelsoft.negatron.controller.ConfigurationChangeListener;
import net.babelsoft.negatron.controller.EditController;
import net.babelsoft.negatron.controller.TreePaneController;
import net.babelsoft.negatron.io.configuration.FavouriteConfiguration;
import net.babelsoft.negatron.io.configuration.FavouriteTree;
import net.babelsoft.negatron.model.IconDescription;
import net.babelsoft.negatron.model.favourites.Favourite;
import net.babelsoft.negatron.model.favourites.Folder;
import net.babelsoft.negatron.model.favourites.MachineConfiguration;
import net.babelsoft.negatron.model.favourites.Separator;
import net.babelsoft.negatron.model.favourites.SoftwareConfiguration;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.Strings;
import net.babelsoft.negatron.util.function.Delegate;
import net.babelsoft.negatron.view.control.FavouriteTreeView;
import net.babelsoft.negatron.view.control.tree.CopyPastableTreeItem;
import net.babelsoft.negatron.view.control.tree.DateTimeTreeTableCell;
import net.babelsoft.negatron.view.control.tree.FavouriteTreeTableCell;
import net.babelsoft.negatron.view.control.tree.IconNameTreeTableCell;
import net.babelsoft.negatron.view.control.tree.InteractiveTreeTableCell;
import net.babelsoft.negatron.view.control.tree.MachineConfigurationTreeTableCell;
import net.babelsoft.negatron.view.control.tree.MachineTreeTableCell;
import net.babelsoft.negatron.view.control.tree.SoftwareConfigurationTreeTableCell;
import net.babelsoft.negatron.view.control.tree.SortableTreeItem;
import net.babelsoft.negatron.view.control.tree.TreeItemPredicate;

public class FavouriteTreePaneController
extends TreePaneController<FavouriteTreeView, Favourite>
implements ConfigurationChangeListener {
    @FXML
    private SplitPane favouriteSplitPane;
    @FXML
    private AnchorPane bottomPlaceholder;
    @FXML
    private Button newFolderButton;
    @FXML
    private Button newFavouriteButton;
    @FXML
    private Button newSeparatorButton;
    @FXML
    private TextField filterField;
    @FXML
    private Button expandAllButton;
    @FXML
    private Button collapseAllButton;
    @FXML
    private Button cutButton;
    @FXML
    private Button copyButton;
    @FXML
    private Button pasteButton;
    @FXML
    private Button editButton;
    @FXML
    private Button deleteButton;
    @FXML
    private TreeTableColumn<Favourite, IconDescription> iconName;
    @FXML
    private TreeTableColumn<Favourite, Machine> machine;
    @FXML
    private TreeTableColumn<Favourite, SoftwareConfiguration> softwareConfiguration;
    @FXML
    private TreeTableColumn<Favourite, MachineConfiguration> machineConfiguration;
    @FXML
    private TreeTableColumn<Favourite, LocalDateTime> dateCreated;
    @FXML
    private TreeTableColumn<Favourite, LocalDateTime> dateModified;
    private Image rootIcon;
    private Image folderIcon;
    private Image anonymousIcon;
    private List<Folder> folderList;
    private TreeTableView.TreeTableViewSelectionModel<Favourite> selection;
    private boolean isShiftPressed;
    private boolean isDragDone;
    private Consumer<Favourite> onCommitted;
    private FavouriteTreeTableCell hoveredCell;
    private FavouriteTreeTableCell editingCell;
    private EditController editController;
    private boolean isInserting;
    private boolean committing;
    private boolean isHidingMachineList;
    private SplitPane.Divider listDivider;
    private Node listDividerGrabber;
    private Timeline listTimeline;
    private FavouriteConfiguration xmlConf;
    private FavouriteTree initialTree;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        ((FavouriteTreeView)this.treeView).setColumnFactory(this.iconName, () -> new IconNameTreeTableCell(this));
        ((FavouriteTreeView)this.treeView).setColumnFactory(this.machine, () -> new MachineTreeTableCell(this));
        ((FavouriteTreeView)this.treeView).setColumnFactory(this.softwareConfiguration, () -> new SoftwareConfigurationTreeTableCell(this));
        ((FavouriteTreeView)this.treeView).setColumnFactory(this.machineConfiguration, () -> new MachineConfigurationTreeTableCell(this));
        ((FavouriteTreeView)this.treeView).setColumnFactory(this.dateCreated, DateTimeTreeTableCell::new);
        ((FavouriteTreeView)this.treeView).setColumnFactory(this.dateModified, DateTimeTreeTableCell::new);
        ((FavouriteTreeView)this.treeView).setOnDragDone(() -> {
            this.isDragDone = true;
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)500.0), e -> {
                this.isDragDone = false;
            }, new KeyValue[0])});
            timeline.play();
        });
        this.xmlConf = new FavouriteConfiguration();
        ((FavouriteTreeView)this.treeView).setOnInsertFavourite(() -> this.saveConfiguration());
        this.selection = ((FavouriteTreeView)this.treeView).getSelectionModel();
        this.selection.selectedItemProperty().addListener((o, oV, newItem) -> {
            if (this.isInserting) {
                return;
            }
            this.show((TreeItem<Favourite>)newItem);
        });
        this.folderList = new ArrayList<Folder>();
        ((FavouriteTreeView)this.treeView).sceneProperty().addListener((o, oV, newScene) -> {
            if (newScene != null) {
                Platform.runLater(() -> {
                    this.retrieveFolderIcons();
                    this.initialiseTree();
                });
                newScene.getStylesheets().addListener(c -> Platform.runLater(() -> this.retrieveFolderIcons()));
            }
        });
        this.anonymousIcon = new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/icon/Negatron.png"));
        ((FavouriteTreeView)this.treeView).getParent().setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.ESCAPE && ((FavouriteTreeView)this.treeView).isCutCopying()) {
                ((FavouriteTreeView)this.treeView).resetCutCopy();
                event.consume();
            }
        });
        ((FavouriteTreeView)this.treeView).setOnKeyPressed(event -> this.handleKeyPressed((KeyEvent)event));
        ((FavouriteTreeView)this.treeView).setOnKeyReleased(event -> this.handleKeyReleased((KeyEvent)event));
        this.listDivider = (SplitPane.Divider)this.favouriteSplitPane.getDividers().get(0);
        this.listDivider.setPosition(1.0);
        this.listDivider.positionProperty().addListener(o -> {
            if (this.listDivider.getPosition() != 1.0) {
                this.bottomPlaceholder.setMaxHeight(-1.0);
            } else {
                this.bottomPlaceholder.setMaxHeight(0.0);
            }
        });
        Timeline filterTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)300.0), event -> {
            ((FavouriteTreeView)this.treeView).beginTreeWiseOperation();
            SortableTreeItem root = (SortableTreeItem)((FavouriteTreeView)this.treeView).getRoot();
            if (Strings.isValid(this.filterField.getText())) {
                String filter = this.filterField.getText().replace(" ", "").toLowerCase();
                root.setPredicate(TreeItemPredicate.create(favourite -> favourite.getShortcut().contains(filter)));
            } else {
                root.setPredicate(null);
            }
            ((FavouriteTreeView)this.treeView).endTreeWiseOperation();
        }, new KeyValue[0])});
        this.filterField.textProperty().addListener((o, oV, nV) -> filterTimeline.playFromStart());
    }

    private void initialiseTree() {
        if (this.initialTree == null || this.folderIcon == null) {
            return;
        }
        this.folderList = this.initialTree.getFolderList();
        this.folderList.forEach(folder -> folder.setIcon(this.folderIcon));
        this.initialTree.getEmptyFavouriteList().forEach(favourite -> favourite.setIcon(this.anonymousIcon));
        TreeItem<Favourite> root = this.initialTree.getRoot();
        if (root != null) {
            root.setExpanded(true);
            ((Favourite)root.getValue()).setIcon(this.rootIcon);
            ((FavouriteTreeView)this.treeView).setRoot(root);
        }
        this.initialTree = null;
    }

    public void setFavouriteTree(FavouriteTree favourites) {
        this.initialTree = favourites;
        Platform.runLater(() -> this.initialiseTree());
    }

    public void setEditController(EditController controller) {
        this.editController = controller;
    }

    public void setHoveredCell(FavouriteTreeTableCell hoveredCell) {
        this.hoveredCell = hoveredCell;
    }

    public void setEditingCell(FavouriteTreeTableCell editingCell) {
        this.editingCell = editingCell;
    }

    public boolean isEditing() {
        return this.editingCell != null;
    }

    public boolean isEditingMachine() {
        return this.editingCell != null && this.editingCell instanceof MachineTreeTableCell;
    }

    public boolean isEditingSoftware() {
        return this.editingCell != null && this.editingCell instanceof SoftwareConfigurationTreeTableCell;
    }

    public boolean isEditingConfiguration() {
        return this.editingCell != null && this.editingCell instanceof MachineConfigurationTreeTableCell;
    }

    public void setOnCommitted(Consumer<Favourite> onCommitted) {
        this.onCommitted = onCommitted;
    }

    public void fireOnCommitted() {
        this.onCommitted.accept((Favourite)((TreeItem)this.selection.getSelectedItem()).getValue());
    }

    public void setCommitting(boolean comitting) {
        this.committing = comitting;
    }

    public boolean isCommitting() {
        return this.committing;
    }

    public void setOnAction(Delegate delegate) {
        ((FavouriteTreeView)this.treeView).setOnAction(delegate);
    }

    public void saveConfiguration() {
        this.xmlConf.save((TreeItem<Favourite>)((FavouriteTreeView)this.treeView).getRoot());
    }

    private void retrieveFolderIcons() {
        ToggleButton favouriteViewButton;
        Image favouriteViewIcon;
        Label foldersTabLabel = (Label)((FavouriteTreeView)this.treeView).getScene().getRoot().lookup(".titled-pane .tab-pane > .tab-header-area > .headers-region > .tab.folders > .tab-container > .tab-label");
        Image foldersTabIcon = ((ImageView)foldersTabLabel.getGraphic()).getImage();
        if (foldersTabIcon != this.folderIcon) {
            this.folderIcon = foldersTabIcon;
            this.folderList.forEach(folder -> folder.setIcon(this.folderIcon));
        }
        if ((favouriteViewIcon = ((ImageView)(favouriteViewButton = (ToggleButton)((FavouriteTreeView)this.treeView).getScene().getRoot().lookup(".favourite-view-button")).getGraphic()).getImage()) != this.rootIcon) {
            this.rootIcon = favouriteViewIcon;
            if (((FavouriteTreeView)this.treeView).getRoot() != null) {
                Favourite root = (Favourite)((FavouriteTreeView)this.treeView).getRoot().getValue();
                root.setIcon(this.rootIcon);
            }
        }
    }

    private void insert(TreeItem<Favourite> favourite) {
        CopyPastableTreeItem selected = (CopyPastableTreeItem)((Object)this.selection.getSelectedItem());
        if (selected != null) {
            if (selected.getValue() instanceof Folder) {
                if (!selected.isExpanded()) {
                    selected.setExpanded(true);
                }
                ((FavouriteTreeView)this.treeView).insert(selected, favourite, FavouriteTreeView.Position.INSIDE);
            } else {
                this.selection.clearSelection();
                ((FavouriteTreeView)this.treeView).insert(selected, favourite, FavouriteTreeView.Position.BEFORE);
                this.selection.select(favourite);
            }
        } else {
            CopyPastableTreeItem root = (CopyPastableTreeItem)((FavouriteTreeView)this.treeView).getRoot();
            if (root == null) {
                root = new CopyPastableTreeItem(new Folder(Language.Manager.getString("favourites"), this.rootIcon));
                root.setExpanded(true);
                ((FavouriteTreeView)this.treeView).setRoot(root);
            }
            ((FavouriteTreeView)this.treeView).insert(root, favourite, FavouriteTreeView.Position.INSIDE);
            this.selection.select(favourite);
        }
    }

    public void insert(Machine currentMachine, SoftwareConfiguration currentSoftware) {
        this.isInserting = true;
        CopyPastableTreeItem favourite = new CopyPastableTreeItem(new Favourite(currentMachine, currentSoftware));
        this.insert(favourite);
        if (this.selection.getSelectedItem() != favourite) {
            this.selection.select((Object)favourite);
        }
        this.isInserting = false;
        ((FavouriteTreeView)this.treeView).edit(this.selection.getSelectedIndex(), this.iconName);
    }

    public void requestTreeFocus() {
        ((FavouriteTreeView)this.treeView).requestFocus();
    }

    public void show(TreeItem<Favourite> item) {
        if (item != null) {
            Favourite fav = (Favourite)item.getValue();
            this.editController.show(fav.getMachine(), fav.getSoftwareConfiguration(), fav.getMachineConfiguration(), fav.mustMigrate());
        } else {
            this.editController.show(null, null, null, false);
        }
    }

    private void cancelEdit(Delegate beforeCancellingDelegate) {
        if (((FavouriteTreeView)this.treeView).getEditingCell() != null) {
            if (beforeCancellingDelegate != null) {
                beforeCancellingDelegate.fire();
            }
            ((FavouriteTreeView)this.treeView).cancelEdit();
        }
    }

    public void cancelEdit() {
        this.cancelEdit(null);
    }

    private void setRowEdit(Machine machine, SoftwareConfiguration software, MachineConfiguration configuration) {
        this.editingCell.getTreeTableRow().getChildrenUnmodifiable().stream().filter(cell -> cell instanceof InteractiveTreeTableCell).map(cell -> (InteractiveTreeTableCell)((Object)cell)).forEach(cell -> cell.setEdit(machine, software, configuration));
    }

    @Override
    public void changed(Machine newMachine, SoftwareConfiguration newSoftware) {
        this.setRowEdit(newMachine, newSoftware, MachineConfiguration.buildFromParameters(newMachine));
    }

    private void showList(Delegate requestList) {
        if (this.listTimeline != null) {
            this.listTimeline.stop();
        }
        this.listDividerGrabber = this.favouriteSplitPane.lookup(".split-pane-divider");
        this.listDividerGrabber.setMouseTransparent(true);
        requestList.fire();
        this.listTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)200.0), e -> this.listDividerGrabber.getStyleClass().add((Object)"padding"), new KeyValue[]{new KeyValue((WritableValue)this.listDivider.positionProperty(), (Object)0.5)})});
        this.listTimeline.play();
    }

    private void hideList(Delegate dismissList) {
        if (this.listDividerGrabber != null) {
            if (this.listTimeline != null) {
                this.listTimeline.stop();
            }
            this.listDividerGrabber.getStyleClass().remove((Object)"padding");
            this.listDividerGrabber = null;
            this.listTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)this.listDivider.positionProperty(), (Object)1.0)})});
            this.listTimeline.play();
        }
        if (dismissList != null) {
            dismissList.fire();
        }
    }

    public void hideListBackground() {
        this.hideList(null);
    }

    public void showMachineList() {
        this.showList(() -> this.editController.requestMachineList(this, ((Favourite)((TreeItem)this.selection.getSelectedItem()).getValue()).getSoftwareConfiguration()));
    }

    public void hideMachineList() {
        this.isHidingMachineList = true;
        this.hideList(() -> this.editController.dismissMachineList(this));
    }

    public void showSoftwareList() {
        if (!this.isEditingMachine()) {
            this.showList(() -> this.editController.requestSoftwareList(this));
        } else {
            this.editController.requestSoftwareList(this);
        }
    }

    public void hideSoftwareList() {
        if (this.isHidingMachineList || this.isEditingMachine()) {
            this.isHidingMachineList = false;
            this.editController.dismissSoftwareList(this);
        } else {
            this.hideList(() -> this.editController.dismissSoftwareList(this));
        }
    }

    public void showConfigurationPane() {
        this.editController.requestConfigurationPane(this, ((Favourite)((TreeItem)this.selection.getSelectedItem()).getValue()).getSoftwareConfiguration());
    }

    public void hideConfigurationPane() {
        this.editController.dismissConfigurationPane(this);
    }

    @FXML
    private void handleNewFolderAction(ActionEvent event) {
        Folder folder = new Folder(Language.Manager.getString("newFolder"), this.folderIcon);
        this.folderList.add(folder);
        this.insert(new CopyPastableTreeItem(folder));
    }

    @FXML
    private void handleNewFavouriteAction(ActionEvent event) {
        Favourite favourite = new Favourite(Language.Manager.getString("newFavourite"), this.anonymousIcon);
        this.insert(new CopyPastableTreeItem(favourite));
    }

    @FXML
    private void handleNewSeparatorAction(ActionEvent event) {
        Separator separator = new Separator();
        this.insert(new CopyPastableTreeItem(separator));
    }

    @FXML
    private void handleExpandAllAction(ActionEvent event) {
        ((FavouriteTreeView)this.treeView).expandAll();
    }

    @FXML
    private void handleCollapseAllAction(ActionEvent event) {
        ((FavouriteTreeView)this.treeView).collapseAll();
    }

    @FXML
    private void handleCutAction(ActionEvent event) {
        ((FavouriteTreeView)this.treeView).cutCopy(CopyPastableTreeItem.CutCopyState.Cut);
    }

    @FXML
    private void handleCopyAction(ActionEvent event) {
        ((FavouriteTreeView)this.treeView).cutCopy(CopyPastableTreeItem.CutCopyState.Copied);
    }

    @FXML
    private void handlePasteAction(ActionEvent event) {
        ((FavouriteTreeView)this.treeView).paste();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FXML
    private void handleEditAction(ActionEvent event) {
        TreeTableColumn editingColumn;
        TreeItem selected = (TreeItem)this.selection.getSelectedItem();
        if (selected == null || selected.getValue() instanceof Separator) return;
        TreeTablePosition position = ((FavouriteTreeView)this.treeView).getEditingCell();
        if (position != null) {
            if (selected.getValue() instanceof Folder) return;
            int columnIdx = ((FavouriteTreeView)this.treeView).getVisibleLeafIndex(position.getTableColumn());
            do {
                if (!this.isShiftPressed) {
                    if (columnIdx < ((FavouriteTreeView)this.treeView).getVisibleLeafColumns().size() - 1) {
                        ++columnIdx;
                        continue;
                    }
                    columnIdx = 0;
                    continue;
                }
                if (columnIdx > 0) {
                    --columnIdx;
                    continue;
                }
                columnIdx = ((FavouriteTreeView)this.treeView).getVisibleLeafColumns().size() - 1;
            } while ((editingColumn = ((FavouriteTreeView)this.treeView).getVisibleLeafColumn(columnIdx)) == this.dateCreated || editingColumn == this.dateModified || editingColumn == this.softwareConfiguration && ((Favourite)selected.getValue()).getSoftwareConfiguration() == null || editingColumn == this.machineConfiguration && !((Favourite)selected.getValue()).getMachine().isConfigurable());
        } else {
            editingColumn = this.iconName;
        }
        ((FavouriteTreeView)this.treeView).edit(this.selection.getSelectedIndex(), editingColumn);
    }

    @FXML
    private void handleDeleteAction(ActionEvent event) {
        ArrayList list = new ArrayList(this.selection.getSelectedItems());
        if (list.size() > 0) {
            TreeItem selected = (TreeItem)this.selection.getSelectedItem();
            TreeItem ref = selected.nextSibling();
            while (list.contains(ref)) {
                ref = ref.nextSibling();
            }
            if (ref == null) {
                ref = selected.previousSibling();
                while (list.contains(ref)) {
                    ref = ref.previousSibling();
                }
                if (ref == null) {
                    ref = selected.getParent();
                }
            }
            this.selection.clearSelection();
            list.stream().filter(item -> item != null && item.getParent() != null).forEach(item -> ((CopyPastableTreeItem)item.getParent()).getInternalChildren().remove(item));
            this.selection.select((Object)ref);
            this.saveConfiguration();
        }
    }

    private void handleKey(KeyEvent event) {
        if (this.hoveredCell == null) {
            return;
        }
        if (!event.isAltDown() && this.hoveredCell.getTreeTableRow().isSelected() && !this.hoveredCell.isEditing() && this.hoveredCell.canEdit()) {
            this.hoveredCell.pseudoClassStateChanged(FavouriteTreeTableCell.EDITABLE_CLASS, true);
        } else {
            this.hoveredCell.pseudoClassStateChanged(FavouriteTreeTableCell.EDITABLE_CLASS, false);
        }
    }

    private void handleKeyPressed(KeyEvent event) {
        this.handleKey(event);
        switch (event.getCode()) {
            case ESCAPE: 
            case F2: {
                event.consume();
                break;
            }
            case SHIFT: {
                this.isShiftPressed = true;
                break;
            }
        }
    }

    private void handleKeyReleased(KeyEvent event) {
        this.handleKey(event);
        KeyCodeCombination cutKeyCombo = new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCodeCombination altCutKeyCombo = new KeyCodeCombination(KeyCode.DELETE, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN});
        KeyCodeCombination copyKeyCombo = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCodeCombination altCopyKeyCombo = new KeyCodeCombination(KeyCode.INSERT, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCodeCombination pasteKeyCombo = new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCodeCombination altPasteKeyCombo = new KeyCodeCombination(KeyCode.INSERT, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN});
        KeyCodeCombination editKey = new KeyCodeCombination(KeyCode.F2, new KeyCombination.Modifier[0]);
        KeyCodeCombination altEditKey = new KeyCodeCombination(KeyCode.F2, new KeyCombination.Modifier[]{KeyCodeCombination.SHIFT_DOWN});
        KeyCodeCombination newFolderKey = new KeyCodeCombination(KeyCode.INSERT, new KeyCombination.Modifier[0]);
        KeyCodeCombination newFavouriteKeyCombo = new KeyCodeCombination(KeyCode.INSERT, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN});
        KeyCodeCombination newSeparatorKeyCombo = new KeyCodeCombination(KeyCode.INSERT, new KeyCombination.Modifier[]{KeyCodeCombination.ALT_DOWN, KeyCodeCombination.SHIFT_DOWN});
        KeyCodeCombination deleteKey = new KeyCodeCombination(KeyCode.DELETE, new KeyCombination.Modifier[0]);
        if (event.getCode() == KeyCode.SHIFT) {
            this.isShiftPressed = false;
        }
        if (event.getCode() == KeyCode.ESCAPE) {
            if (this.isDragDone) {
                event.consume();
                return;
            }
            this.cancelEdit(() -> {
                if (this.editingCell != null && this.editingCell.isEditing()) {
                    event.consume();
                }
            });
        } else if (cutKeyCombo.match(event) || altCutKeyCombo.match(event)) {
            this.cutButton.fire();
            event.consume();
        } else if (copyKeyCombo.match(event) || altCopyKeyCombo.match(event)) {
            this.copyButton.fire();
            event.consume();
        } else if (pasteKeyCombo.match(event) || altPasteKeyCombo.match(event)) {
            this.pasteButton.fire();
            event.consume();
        } else if (newFolderKey.match(event)) {
            this.newFolderButton.fire();
            event.consume();
        } else if (newFavouriteKeyCombo.match(event)) {
            this.newFavouriteButton.fire();
            event.consume();
        } else if (newSeparatorKeyCombo.match(event)) {
            this.newSeparatorButton.fire();
            event.consume();
        } else if (deleteKey.match(event)) {
            if (((FavouriteTreeView)this.treeView).getEditingCell() == null || !this.editingCell.isEditing()) {
                this.deleteButton.fire();
                event.consume();
            }
        } else if (editKey.match(event) || altEditKey.match(event)) {
            this.editButton.fire();
            event.consume();
        }
    }
}

