/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.Property;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.util.Duration;
import net.babelsoft.negatron.controller.MachineFilterPaneController;
import net.babelsoft.negatron.io.cache.UIConfigurationData;
import net.babelsoft.negatron.model.Status;
import net.babelsoft.negatron.model.item.EmulatedItem;
import net.babelsoft.negatron.model.item.Item;
import net.babelsoft.negatron.util.Strings;
import net.babelsoft.negatron.view.control.EmulatedItemTreeView;
import net.babelsoft.negatron.view.control.TitledWindowPane;
import net.babelsoft.negatron.view.control.YearSpinner;
import net.babelsoft.negatron.view.control.tree.SortableTreeItem;
import net.babelsoft.negatron.view.control.tree.TreeItemPredicate;

public abstract class FilterPaneController<T extends EmulatedItem<T>>
implements Initializable {
    private static final double IN_FOCUS_OPACITY = 1.0;
    private static final double OUT_FOCUS_OPACITY = 0.5;
    private static final Duration ANIM_DURATION = Duration.millis((double)200.0);
    private static final Duration FILTER_DURATION = Duration.seconds((double)1.0);
    private Timeline inTimeline;
    private Timeline outTimeline;
    protected Timeline filterTimeline;
    private boolean canUpdateConfiguration;
    protected T currentItem;
    private Consumer<Boolean> onFilter;
    @FXML
    private TitledWindowPane root;
    @FXML
    private GridPane grid;
    @FXML
    private TextField description;
    @FXML
    private TextField name;
    @FXML
    private TextField company;
    @FXML
    private TextField group;
    @FXML
    private RadioButton yearFixed;
    @FXML
    private ToggleGroup yearGroup;
    @FXML
    private RadioButton yearRange;
    @FXML
    private FlowPane yearPane;
    @FXML
    private HBox yearRangePane;
    @FXML
    private TextField year;
    @FXML
    private YearSpinner yearFrom;
    @FXML
    private YearSpinner yearTo;
    @FXML
    private RadioButton versionAll;
    @FXML
    private ToggleGroup versionGroup;
    @FXML
    private RadioButton versionParents;
    @FXML
    private RadioButton versionClones;
    @FXML
    private CheckBox statusGood;
    @FXML
    private CheckBox statusBad;
    @FXML
    private CheckBox statusMissing;

    public void initialize(URL url, ResourceBundle rb) {
        this.inTimeline = new Timeline();
        this.inTimeline.getKeyFrames().add((Object)new KeyFrame(ANIM_DURATION, new KeyValue[]{new KeyValue((WritableValue)this.root.opacityProperty(), (Object)1.0)}));
        this.outTimeline = new Timeline();
        this.outTimeline.getKeyFrames().add((Object)new KeyFrame(ANIM_DURATION, new KeyValue[]{new KeyValue((WritableValue)this.root.opacityProperty(), (Object)0.5)}));
        this.root.setOpacity(0.5);
        this.root.setOnMouseEntered(evt -> {
            this.outTimeline.stop();
            this.inTimeline.playFromStart();
        });
        this.root.setOnMouseExited(evt -> {
            this.inTimeline.stop();
            this.outTimeline.playFromStart();
        });
        this.setAsSelectionDisable(true);
        this.initialise();
        this.loadData();
        this.wireEvents();
    }

    protected void initialise() {
        this.yearPane.getChildren().removeAll((Object[])new Node[]{this.year, this.yearRangePane});
        this.yearGroup.selectedToggleProperty().addListener((o, oV, newValue) -> {
            if (newValue == this.yearFixed) {
                this.yearPane.getChildren().add((Object)this.year);
                this.yearPane.getChildren().remove((Object)this.yearRangePane);
            } else {
                this.yearPane.getChildren().remove((Object)this.year);
                this.yearPane.getChildren().add((Object)this.yearRangePane);
            }
        });
    }

    protected final void loadData() {
        this.canUpdateConfiguration = false;
        UIConfigurationData data = this.loadConfiguration();
        this.update(field -> field.setText(data.getString(field.getId())), radio -> {
            Boolean val = data.getBoolean(radio.getId());
            if (val != null) {
                radio.setSelected(val.booleanValue());
            } else {
                radio.getToggleGroup().selectToggle((Toggle)radio.getToggleGroup().getToggles().get(0));
            }
        }, spinner -> spinner.getEditor().setText(data.getString(spinner.getId())), check -> {
            Boolean val = data.getBoolean(check.getId());
            if (val != null) {
                check.setSelected(val.booleanValue());
            } else {
                check.setSelected(true);
            }
        });
        this.canUpdateConfiguration = true;
    }

    protected abstract UIConfigurationData loadConfiguration();

    protected void wireEvents() {
        this.description.textProperty().addListener(o -> this.handleOnAction(null));
        this.name.textProperty().addListener(o -> this.handleOnAction(null));
        this.company.textProperty().addListener(o -> this.handleOnAction(null));
        this.group.textProperty().addListener(o -> this.handleOnAction(null));
        this.yearFrom.getEditor().textProperty().addListener(o -> this.handleOnAction(null));
        this.yearTo.getEditor().textProperty().addListener(o -> this.handleOnAction(null));
        this.year.textProperty().addListener((o, oldValue, newValue) -> {
            if (newValue == null || newValue.matches("(\\d|\\?)*")) {
                this.handleOnAction(null);
            } else {
                this.year.setText(oldValue);
            }
        });
    }

    public void setTreeView(EmulatedItemTreeView<T> treeView) {
        this.setTreeView(treeView, new Filter());
    }

    protected final void setTreeView(EmulatedItemTreeView<T> treeView, Filter<T> filter) {
        this.filterTimeline = new Timeline(new KeyFrame[]{new KeyFrame(FILTER_DURATION, event -> {
            if (this.canUpdateConfiguration) {
                try {
                    this.saveConfiguration(this.toUIConfiguration());
                }
                catch (IOException ex) {
                    Logger.getLogger(MachineFilterPaneController.class.getName()).log(Level.SEVERE, "Machine filter layout configuration failed", ex);
                }
            }
            this.onFilter.accept(this.isDefaults());
            treeView.beginTreeWiseOperation();
            SortableTreeItem tree = (SortableTreeItem)treeView.getRoot();
            tree.setPredicate(TreeItemPredicate.create(filter));
            treeView.endTreeWiseOperation();
        }, new KeyValue[0])});
        treeView.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> {
            if (newValue != null) {
                this.currentItem = (EmulatedItem)newValue.getValue();
                if (oldValue == null) {
                    this.setAsSelectionDisable(false);
                }
            } else if (oldValue != null) {
                this.setAsSelectionDisable(true);
            }
        });
    }

    protected abstract void setAsSelectionDisable(boolean var1);

    protected final void setAsSelectionDisable(boolean disable, String ref) {
        Function<Node, Boolean> setDisable = node -> {
            boolean canDisable;
            boolean bl = canDisable = node instanceof Button && ((Button)node).getText().equals(ref);
            if (canDisable) {
                node.setDisable(disable);
            }
            return canDisable;
        };
        this.grid.getChildren().forEach(node -> {
            Integer index = GridPane.getColumnIndex((Node)node);
            if (index != null && index == 2 && !((Boolean)setDisable.apply((Node)node)).booleanValue()) {
                ((Pane)node).getChildren().forEach(child -> {
                    Boolean cfr_ignored_0 = (Boolean)setDisable.apply((Node)child);
                });
            }
        });
    }

    public void setOnFilter(Consumer<Boolean> onFilter) {
        this.onFilter = onFilter;
    }

    protected abstract void saveConfiguration(UIConfigurationData var1) throws IOException;

    public void bind(Property<String> filterProperty) {
        filterProperty.bindBidirectional((Property)this.description.textProperty());
        this.canUpdateConfiguration = false;
        ((KeyFrame)this.filterTimeline.getKeyFrames().get(0)).getOnFinished().handle(null);
        this.canUpdateConfiguration = true;
    }

    public void disableStatusCriteria(boolean disable) {
        this.statusGood.setDisable(disable);
        this.statusBad.setDisable(disable);
        this.statusMissing.setDisable(disable);
    }

    private void restoreDefaults(Parent parent) {
        parent.getChildrenUnmodifiable().forEach(child -> {
            if (child instanceof TextField) {
                ((TextField)child).setText("");
            } else if (child instanceof CheckBox) {
                ((CheckBox)child).setSelected(true);
            } else if (child instanceof Pane) {
                this.restoreDefaults((Parent)((Pane)child));
            }
        });
    }

    private boolean isDefaults() {
        return this.isDefaults(this.description.getParent()) && (this.yearFixed.isSelected() && Strings.isEmpty(this.year.getText()) || this.yearRange.isSelected() && this.yearFrom.getEditor().getText().equals(Integer.toString(((SpinnerValueFactory.IntegerSpinnerValueFactory)this.yearFrom.getValueFactory()).getMin())) && this.yearTo.getEditor().getText().equals(Integer.toString(((SpinnerValueFactory.IntegerSpinnerValueFactory)this.yearFrom.getValueFactory()).getMax()))) && this.versionAll.isSelected();
    }

    private boolean isDefaults(Parent parent) {
        return parent.getChildrenUnmodifiable().stream().allMatch(child -> {
            if (child instanceof TextField) {
                if (((TextField)child).getId().equals("description")) {
                    return true;
                }
                return Strings.isEmpty(((TextField)child).getText());
            }
            if (child instanceof CheckBox) {
                return ((CheckBox)child).isSelected();
            }
            if (child instanceof Pane) {
                return this.isDefaults((Parent)((Pane)child));
            }
            return true;
        });
    }

    private UIConfigurationData toUIConfiguration() {
        UIConfigurationData data = new UIConfigurationData();
        this.update(field -> data.put(field.getId(), field.getText()), radio -> data.put(radio.getId(), radio.isSelected()), spinner -> data.put(spinner.getId(), spinner.getEditor().getText()), check -> data.put(check.getId(), check.isSelected()));
        return data;
    }

    protected void update(Consumer<TextField> updateText, Consumer<RadioButton> updateRadio, Consumer<Spinner> updateSpinner, Consumer<CheckBox> updateCheck) {
        updateText.accept(this.description);
        updateText.accept(this.name);
        updateText.accept(this.company);
        updateText.accept(this.group);
        updateRadio.accept(this.yearFixed);
        updateRadio.accept(this.yearRange);
        updateText.accept(this.year);
        updateSpinner.accept(this.yearFrom);
        updateSpinner.accept(this.yearTo);
        updateRadio.accept(this.versionAll);
        updateRadio.accept(this.versionParents);
        updateRadio.accept(this.versionClones);
        updateCheck.accept(this.statusGood);
        updateCheck.accept(this.statusBad);
        updateCheck.accept(this.statusMissing);
    }

    @FXML
    protected void handleOnAction(ActionEvent event) {
        this.filterTimeline.playFromStart();
    }

    @FXML
    protected void handleOnSetCompanyAsSelection(ActionEvent event) {
        this.company.setText(((EmulatedItem)this.currentItem).getCompany());
        this.company.requestFocus();
    }

    @FXML
    protected void handleOnSetGroupAsSelection(ActionEvent event) {
        this.group.setText(((EmulatedItem)this.currentItem).getGroup());
        this.group.requestFocus();
    }

    @FXML
    protected void handleOnSetYearAsSelection(ActionEvent event) {
        this.yearFixed.setSelected(true);
        this.year.setText(((EmulatedItem)this.currentItem).getYear());
        this.year.requestFocus();
    }

    @FXML
    protected void handleOnSetVersionAsSelection(ActionEvent event) {
        if (((EmulatedItem)this.currentItem).hasParent()) {
            this.versionClones.setSelected(true);
        } else {
            this.versionParents.setSelected(true);
        }
        this.filterTimeline.playFromStart();
        this.versionAll.requestFocus();
    }

    @FXML
    protected void handleOnSetStatusAsSelection(ActionEvent event) {
        switch (((EmulatedItem)this.currentItem).getStatus()) {
            case GOOD: {
                this.statusGood.setSelected(true);
                this.statusBad.setSelected(false);
                this.statusMissing.setSelected(false);
                break;
            }
            case BAD: {
                this.statusGood.setSelected(false);
                this.statusBad.setSelected(true);
                this.statusMissing.setSelected(false);
            }
            default: {
                this.statusGood.setSelected(false);
                this.statusBad.setSelected(false);
                this.statusMissing.setSelected(true);
            }
        }
        this.filterTimeline.playFromStart();
        this.statusGood.requestFocus();
    }

    @FXML
    protected void handleOnRestoreDefaults(ActionEvent event) {
        this.restoreDefaults(this.description.getParent());
        this.year.setText("");
        this.yearFrom.getEditor().setText(Integer.toString(((SpinnerValueFactory.IntegerSpinnerValueFactory)this.yearFrom.getValueFactory()).getMin()));
        this.yearTo.getEditor().setText(Integer.toString(((SpinnerValueFactory.IntegerSpinnerValueFactory)this.yearFrom.getValueFactory()).getMax()));
        this.versionAll.setSelected(true);
    }

    protected class Filter<T extends EmulatedItem<T>>
    implements Predicate<T> {
        protected Filter() {
        }

        @Override
        public boolean test(T item) {
            BiFunction<TextField, String, Boolean> validateText = (field, val) -> {
                String filter = field.getText();
                if (Strings.isValid(filter)) {
                    filter = filter.replace(" ", "").toLowerCase();
                    return val.contains(filter);
                }
                return true;
            };
            boolean yearValidated = false;
            if (FilterPaneController.this.yearFixed.isSelected()) {
                String mask = FilterPaneController.this.year.getText();
                if (Strings.isValid(mask) && mask.length() == 4) {
                    String val2 = ((EmulatedItem)item).getYear();
                    if (val2.length() > 4) {
                        val2 = val2.substring(0, 4);
                    }
                    mask = mask.replace("?", ".");
                    yearValidated = val2.matches(mask);
                } else if (Strings.isEmpty(mask)) {
                    yearValidated = true;
                }
            } else if (Strings.isValid(FilterPaneController.this.yearFrom.getEditor().getText()) && Strings.isValid(FilterPaneController.this.yearTo.getEditor().getText())) {
                int valFrom = Integer.valueOf(((EmulatedItem)item).getYear().replace("?", "9"));
                int valTo = Integer.valueOf(((EmulatedItem)item).getYear().replace("?", "0"));
                int refFrom = Integer.valueOf(FilterPaneController.this.yearFrom.getEditor().getText());
                int refTo = Integer.valueOf(FilterPaneController.this.yearTo.getEditor().getText());
                yearValidated = refFrom <= valFrom && valTo <= refTo;
            } else {
                yearValidated = true;
            }
            return validateText.apply(FilterPaneController.this.description, ((EmulatedItem)item).getShortcut()) != false && validateText.apply(FilterPaneController.this.name, ((Item)item).getName()) != false && validateText.apply(FilterPaneController.this.company, ((EmulatedItem)item).getCompany().replace(" ", "").toLowerCase()) != false && validateText.apply(FilterPaneController.this.group, ((EmulatedItem)item).getGroup()) != false && yearValidated && (FilterPaneController.this.versionAll.isSelected() || !((EmulatedItem)item).hasParent() && FilterPaneController.this.versionParents.isSelected() || ((EmulatedItem)item).hasParent() && FilterPaneController.this.versionClones.isSelected()) && (((EmulatedItem)item).getStatus() == Status.UNKNOWN && FilterPaneController.this.statusMissing.isSelected() || ((EmulatedItem)item).getStatus() == Status.GOOD && FilterPaneController.this.statusGood.isSelected() || ((EmulatedItem)item).getStatus() == Status.BAD && FilterPaneController.this.statusBad.isSelected());
        }
    }
}

