/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.GridPane;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.Domain;
import net.babelsoft.negatron.io.configuration.Property;
import net.babelsoft.negatron.util.function.Delegate;
import net.babelsoft.negatron.view.control.form.ChdmanPathField;
import net.babelsoft.negatron.view.control.form.CheatCheckField;
import net.babelsoft.negatron.view.control.form.ExtrasRootPathField;
import net.babelsoft.negatron.view.control.form.GridAdornment;
import net.babelsoft.negatron.view.control.form.LanguageChoiceField;
import net.babelsoft.negatron.view.control.form.MameIniField;
import net.babelsoft.negatron.view.control.form.MamePathField;
import net.babelsoft.negatron.view.control.form.MultiPathField;
import net.babelsoft.negatron.view.control.form.MultimediaRootPathField;
import net.babelsoft.negatron.view.control.form.SkinChoiceField;
import net.babelsoft.negatron.view.control.form.VlcPathField;
import net.babelsoft.negatron.view.control.form.VsyncChoiceField;

public class GlobalConfigurationPaneController
implements Initializable {
    private static final double SPACING = 16.0;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab foldersTab;
    @FXML
    private Tab optionsTab;
    @FXML
    private Label foldersLabel;
    @FXML
    private Label foldersLabel2;
    @FXML
    private GridPane foldersGrid;
    @FXML
    private GridPane foldersGrid2;
    @FXML
    private Label optionsLabel;
    @FXML
    private Label optionsLabel2;
    @FXML
    private GridPane optionsGrid;
    @FXML
    private GridPane optionsGrid2;
    private MamePathField mameExec;
    private MameIniField mameIni;
    private ChdmanPathField chdmanExec;
    private MultiPathField artwork;
    private MultiPathField cheat;
    private MultiPathField controller;
    private MultiPathField rom;
    private MultiPathField sample;
    private MultiPathField information;
    private MultiPathField folderView;
    private VlcPathField vlcPath;
    private ExtrasRootPathField mameExtras;
    private MultimediaRootPathField mameMultimedia;
    private MultiPathField icon;
    private MultiPathField manual;
    private MultiPathField snapshot;
    private MultiPathField title;
    private MultiPathField videoPreview;
    private MultiPathField artworkPreview;
    private MultiPathField boss;
    private MultiPathField cabinet;
    private MultiPathField controlPanel;
    private MultiPathField device;
    private MultiPathField end;
    private MultiPathField flyer;
    private MultiPathField gameOver;
    private MultiPathField howTo;
    private MultiPathField logo;
    private MultiPathField marquee;
    private MultiPathField pcb;
    private MultiPathField score;
    private MultiPathField select;
    private MultiPathField soundtrack;
    private MultiPathField versus;
    private MultiPathField boxArt;
    private MultiPathField cover;
    private MultiPathField media;
    private CheatCheckField cheatCheck;
    private VsyncChoiceField vsync;
    private SkinChoiceField skin;
    private LanguageChoiceField language;

    public void initialize(URL url, ResourceBundle rb) {
        this.tabPane.getSelectionModel().select(Configuration.Manager.getSoftwareInformationTabIndex());
        this.tabPane.getSelectionModel().selectedIndexProperty().addListener((o, oV, newValue) -> {
            try {
                Configuration.Manager.updateSoftwareInformationTabIndex(newValue.intValue());
            }
            catch (IOException ex) {
                Logger.getLogger(GlobalConfigurationPaneController.class.getName()).log(Level.SEVERE, "Couldn't save global conf tab index", ex);
            }
        });
        boolean isMess = Configuration.Manager.isMess();
        String compressedArchives = rb.getString("compressedArchives");
        if (isMess) {
            this.foldersLabel.setText(this.foldersLabel.getText().replace("MAME", "MESS"));
            this.foldersLabel2.setText(this.foldersLabel2.getText().replace("MAME", "MESS"));
            this.optionsLabel.setText(this.optionsLabel.getText().replace("MAME", "MESS"));
        }
        this.mameExec = new MamePathField(this.foldersGrid, 0, isMess);
        this.mameIni = new MameIniField(this.foldersGrid, 1, isMess);
        this.chdmanExec = new ChdmanPathField(this.foldersGrid, 2);
        GridAdornment.insertSpacing(this.foldersGrid, 3, 16.0);
        this.artwork = new MultiPathField(this.foldersGrid, 4, Property.ARTWORK, rb.getString("artwork"), rb.getString("artwork.tooltip"), new String[0]);
        this.cheat = new MultiPathField(this.foldersGrid, 5, Property.CHEAT, rb.getString("cheat"), rb.getString("cheat.tooltip"), compressedArchives, "*.7z; *.zip");
        this.controller = new MultiPathField(this.foldersGrid, 6, Property.CONTROLLER, rb.getString("controllerDefinition"), rb.getString("controllerDefinition.tooltip"), new String[0]);
        this.rom = new MultiPathField(this.foldersGrid, 7, Property.ROM, rb.getString("rom"), rb.getString("rom.tooltip"), new String[0]);
        this.sample = new MultiPathField(this.foldersGrid, 8, Property.SAMPLE, rb.getString("sample"), rb.getString("sample.tooltip"), new String[0]);
        GridAdornment.insertSpacing(this.foldersGrid, 9, 16.0);
        GridAdornment.insertTitle(this.foldersGrid, 10, 16.0, isMess ? rb.getString("mameExtrasHistoryVersioning").replaceFirst("MAME", "MESS") : rb.getString("mameExtrasHistoryVersioning"));
        this.information = new MultiPathField(this.foldersGrid, 11, Property.INFORMATION, rb.getString("information"), rb.getString("information.tooltip"), rb.getString("dataFiles"), "*.dat");
        this.folderView = new MultiPathField(this.foldersGrid, 12, Property.FOLDER_VIEW, rb.getString("folderView"), rb.getString("folderView.tooltip"), new String[0]);
        GridAdornment.insertSpacing(this.foldersGrid, 13, 16.0);
        GridAdornment.insertTitle(this.foldersGrid, 14, 16.0, rb.getString("miscellaneous"));
        this.vlcPath = new VlcPathField(this.foldersGrid, 15);
        this.mameExtras = new ExtrasRootPathField(this.foldersGrid2, 0, isMess);
        this.mameMultimedia = new MultimediaRootPathField(this.foldersGrid2, 1);
        GridAdornment.insertHeader(this.foldersGrid2, 2, 16.0, Domain.EXTRAS_MACHINE_SOFTWARE);
        this.icon = new MultiPathField(this.foldersGrid2, 3, Property.ICON, rb.getString("icon"), rb.getString("icon.tooltip"), compressedArchives, "*.zip");
        this.manual = new MultiPathField(this.foldersGrid2, 4, Property.MANUAL, rb.getString("manual"), rb.getString("manual.tooltip"), compressedArchives, "*.zip");
        this.snapshot = new MultiPathField(this.foldersGrid2, 5, Property.SNAPSHOT, rb.getString("snapshot"), rb.getString("snapshot.tooltip"), compressedArchives, "*.zip");
        this.title = new MultiPathField(this.foldersGrid2, 6, Property.TITLE, rb.getString("title"), rb.getString("title.tooltip"), compressedArchives, "*.zip");
        this.videoPreview = new MultiPathField(this.foldersGrid2, 7, Property.VIDEO_PREVIEW, rb.getString("videoPreview"), rb.getString("videoPreview.tooltip"), new String[0]);
        GridAdornment.insertHeader(this.foldersGrid2, 8, 16.0, Domain.EXTRAS_MACHINE_ONLY);
        this.artworkPreview = new MultiPathField(this.foldersGrid2, 9, Property.ARTWORK_PREVIEW, rb.getString("artworkPreview"), rb.getString("artworkPreview.tooltip"), compressedArchives, "*.zip");
        this.boss = new MultiPathField(this.foldersGrid2, 10, Property.BOSS, rb.getString("boss"), rb.getString("boss.tooltip"), compressedArchives, "*.zip");
        this.cabinet = new MultiPathField(this.foldersGrid2, 11, Property.CABINET, rb.getString("cabinet"), rb.getString("cabinet.tooltip"), compressedArchives, "*.zip");
        this.controlPanel = new MultiPathField(this.foldersGrid2, 12, Property.CONTROL_PANEL, rb.getString("controlPanel"), rb.getString("controlPanel.tooltip"), compressedArchives, "*.zip");
        this.device = new MultiPathField(this.foldersGrid2, 13, Property.DEVICE, rb.getString("device"), rb.getString("device.tooltip"), compressedArchives, "*.zip");
        this.end = new MultiPathField(this.foldersGrid2, 14, Property.END, rb.getString("end"), rb.getString("end.tooltip"), compressedArchives, "*.zip");
        this.flyer = new MultiPathField(this.foldersGrid2, 15, Property.FLYER, rb.getString("flyer"), rb.getString("flyer.tooltip"), compressedArchives, "*.zip");
        this.gameOver = new MultiPathField(this.foldersGrid2, 16, Property.GAME_OVER, rb.getString("gameOver"), rb.getString("gameOver.tooltip"), compressedArchives, "*.zip");
        this.howTo = new MultiPathField(this.foldersGrid2, 17, Property.HOW_TO, rb.getString("howTo"), rb.getString("howTo.tooltip"), compressedArchives, "*.zip");
        this.logo = new MultiPathField(this.foldersGrid2, 18, Property.LOGO, rb.getString("logo"), rb.getString("logo.tooltip"), compressedArchives, "*.zip");
        this.marquee = new MultiPathField(this.foldersGrid2, 19, Property.MARQUEE, rb.getString("marquee"), rb.getString("marquee.tooltip"), compressedArchives, "*.zip");
        this.pcb = new MultiPathField(this.foldersGrid2, 20, Property.PCB, rb.getString("pcb"), rb.getString("pcb.tooltip"), compressedArchives, "*.zip");
        this.score = new MultiPathField(this.foldersGrid2, 21, Property.SCORE, rb.getString("score"), rb.getString("score.tooltip"), compressedArchives, "*.zip");
        this.select = new MultiPathField(this.foldersGrid2, 22, Property.SELECT, rb.getString("select"), rb.getString("select.tooltip"), compressedArchives, "*.zip");
        this.soundtrack = new MultiPathField(this.foldersGrid2, 23, Property.SOUNDTRACK, rb.getString("soundtrack"), rb.getString("soundtrack.tooltip"), new String[0]);
        this.versus = new MultiPathField(this.foldersGrid2, 24, Property.VERSUS, rb.getString("versus"), rb.getString("versus.tooltip"), compressedArchives, "*.zip");
        GridAdornment.insertHeader(this.foldersGrid2, 25, 16.0, Domain.EXTRAS_SOFTWARE_ONLY);
        this.boxArt = new MultiPathField(this.foldersGrid2, 26, Property.BOX_ART, rb.getString("boxArt"), rb.getString("boxArt.tooltip"), new String[0]);
        this.cover = new MultiPathField(this.foldersGrid2, 27, Property.COVER, rb.getString("cover"), rb.getString("cover.tooltip"), compressedArchives, "*.zip");
        this.media = new MultiPathField(this.foldersGrid2, 28, Property.MEDIA, rb.getString("media"), rb.getString("media.tooltip"), new String[0]);
        this.cheatCheck = new CheatCheckField(this.optionsGrid, 0, isMess);
        this.vsync = new VsyncChoiceField(this.optionsGrid, 1, isMess);
        this.skin = new SkinChoiceField(this.optionsGrid2, 0);
        this.language = new LanguageChoiceField(this.optionsGrid2, 1);
    }

    public void setOnRestart(Delegate delegate) {
        this.language.setOnRestart(delegate);
    }

    public void selectOptionsTab() {
        this.tabPane.getSelectionModel().select((Object)this.optionsTab);
    }

    public void disableLanguageOption(boolean disable) {
        this.language.setDisable(disable);
    }

    public void resetVlcPath() {
        this.vlcPath.reset();
    }
}

