/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javafx.scene.transform.Shear;
import javafx.util.Duration;
import net.babelsoft.negatron.controller.MachineInformationPaneController;
import net.babelsoft.negatron.io.cache.InformationCache;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.Property;
import net.babelsoft.negatron.io.extras.Extras;
import net.babelsoft.negatron.io.extras.Icons;
import net.babelsoft.negatron.io.extras.Images;
import net.babelsoft.negatron.model.item.EmulatedItem;
import net.babelsoft.negatron.model.item.Item;
import net.babelsoft.negatron.util.Disposable;
import net.babelsoft.negatron.util.function.Delegate;
import net.babelsoft.negatron.view.control.ImageViewPane;
import net.babelsoft.negatron.view.control.MediaViewPane;
import net.babelsoft.negatron.view.control.Text;
import org.jpedal.examples.viewer.PdfViewer;

public abstract class InformationPaneController<T extends EmulatedItem<T>>
implements Initializable,
Disposable {
    @FXML
    private TabPane tabPane;
    @FXML
    private Button favouritesButton;
    @FXML
    private Tab externalTab;
    @FXML
    private Tab ingameTab;
    @FXML
    private Tab informationTab;
    @FXML
    private Tab manualTab;
    @FXML
    private ImageViewPane externalsZoomImagePane;
    @FXML
    private ImageViewPane ingameZoomImagePane;
    @FXML
    protected GridPane ingameGrid;
    @FXML
    protected ImageViewPane titleImagePane;
    @FXML
    protected ImageViewPane snapshotImagePane;
    @FXML
    protected MediaViewPane mediaViewPane;
    @FXML
    private AnchorPane pdfPane;
    private PdfViewer pdfViewer;
    private InformationCache cache;
    protected T currentEmulatedItem;
    protected String systemName;
    private Application application;
    protected Image noiseImage;
    protected Image colourTestImage;
    private final Timeline timeline = new Timeline();
    private final List<KeyValue> keyValues1 = new ArrayList<KeyValue>();
    private final List<KeyValue> keyValues2 = new ArrayList<KeyValue>();
    private final Delegate onDropCompleted = () -> this.updateTabContent(true);
    private MouseEvent favouritesEvent;
    private boolean soundEnabled;
    private boolean videoEnabled;
    private boolean zoomEnabled = true;

    protected InformationPaneController() {
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.noiseImage = new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/VideoNoise.png"));
        this.colourTestImage = new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/TvColourTestCard.png"));
        this.favouritesEvent = new MouseEvent((Object)this.favouritesButton, (EventTarget)this.favouritesButton, MouseEvent.MOUSE_CLICKED, 0.0, 0.0, 0.0, 0.0, MouseButton.MIDDLE, 1, false, false, false, false, false, false, false, false, false, false, null);
        this.keyValues1.add(new KeyValue((WritableValue)this.tabPane.scaleXProperty(), (Object)1.0));
        this.keyValues1.add(new KeyValue((WritableValue)this.tabPane.opacityProperty(), (Object)1.0));
        this.keyValues2.add(new KeyValue((WritableValue)this.tabPane.scaleXProperty(), (Object)0.0));
        this.keyValues2.add(new KeyValue((WritableValue)this.tabPane.opacityProperty(), (Object)0.0));
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((o, oV, newValue) -> this.updateTabContent((Tab)newValue));
        this.pdfViewer = new PdfViewer((Parent)this.pdfPane, null);
        this.pdfViewer.setupViewer();
        AnchorPane.setBottomAnchor((Node)this.pdfViewer.getRoot(), (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.pdfViewer.getRoot(), (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.pdfViewer.getRoot(), (Double)0.0);
        AnchorPane.setTopAnchor((Node)this.pdfViewer.getRoot(), (Double)0.0);
        this.mediaViewPane.addAllDropTargets(this.titleImagePane, this.snapshotImagePane);
        this.mediaViewPane.playingProperty().addListener((o, oV, newValue) -> {
            this.zoomEnabled = newValue == false;
        });
        this.soundEnabled = Configuration.Manager.isSoundEnabled();
        Consumer<ImageViewPane> unzoom = zoomingPane -> {
            zoomingPane.setMouseTransparent(true);
            FadeTransition fade = new FadeTransition(Duration.millis((double)200.0), (Node)zoomingPane);
            fade.setToValue(0.0);
            fade.setInterpolator(Interpolator.EASE_OUT);
            fade.play();
        };
        this.externalsZoomImagePane.setOnMouseClicked(event -> unzoom.accept(this.externalsZoomImagePane));
        this.ingameZoomImagePane.setOnMouseClicked(event -> unzoom.accept(this.ingameZoomImagePane));
        this.favouritesButton.setDisable(true);
        try {
            this.cache = new InformationCache();
        }
        catch (IOException | ClassNotFoundException ex) {
            Logger.getLogger(InformationPaneController.class.getName()).log(Level.SEVERE, "Couldn't init cache", ex);
        }
    }

    protected void initialise(ImageViewPane pane) {
        pane.setOnDropCompleted(this.onDropCompleted);
    }

    protected void initialiseExternalsZooming(ImageViewPane ... panes) {
        this.initialiseZooming(this.externalsZoomImagePane, panes);
    }

    protected void initialiseIngameZooming(ImageViewPane ... panes) {
        this.initialiseZooming(this.ingameZoomImagePane, this.titleImagePane, this.snapshotImagePane);
        this.initialiseZooming(this.ingameZoomImagePane, panes);
    }

    private void initialiseZooming(ImageViewPane zoomingPane, ImageViewPane ... panes) {
        Arrays.stream(panes).forEach(pane -> pane.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.PRIMARY && (this.tabPane.getSelectionModel().getSelectedItem() != this.ingameTab || this.zoomEnabled)) {
                zoomingPane.setImage(pane.getImageView().getImage());
                zoomingPane.setMouseTransparent(false);
                FadeTransition fade = new FadeTransition(Duration.millis((double)200.0), (Node)zoomingPane);
                fade.setToValue(1.0);
                fade.setInterpolator(Interpolator.EASE_OUT);
                fade.play();
            }
        }));
    }

    protected void postInitialise(ImageViewPane[] panes) {
        this.postInitialise(null, panes);
    }

    protected void postInitialise(Tab[] tabs, ImageViewPane[] panes) {
        Object dummyMachine = new Object();
        this.externalTab.setUserData(dummyMachine);
        this.ingameTab.setUserData(dummyMachine);
        this.informationTab.setUserData(dummyMachine);
        this.manualTab.setUserData(dummyMachine);
        if (tabs != null) {
            Arrays.stream(tabs).forEach(tab -> tab.setUserData(dummyMachine));
        }
        this.setEmulatedItem(null);
        this.initialise(this.titleImagePane);
        this.initialise(this.snapshotImagePane);
        this.mediaViewPane.setOnDropCompleted(this.onDropCompleted);
        if (panes != null) {
            Arrays.stream(panes).forEach(pane -> this.initialise((ImageViewPane)((Object)pane)));
        }
    }

    @Override
    public void dispose() {
        this.mediaViewPane.dispose();
        this.pdfViewer.close();
    }

    public void setFavouriteEnabled(boolean favouriteEnabled) {
        if (favouriteEnabled && this.currentEmulatedItem != null) {
            this.favouritesButton.setDisable(false);
        } else {
            this.favouritesButton.setDisable(true);
        }
    }

    public void setSoundEnabled(boolean soundEnabled) {
        if (soundEnabled) {
            this.mediaViewPane.setVolume(100);
        } else {
            this.mediaViewPane.setVolume(0);
        }
        this.soundEnabled = soundEnabled;
    }

    public void setVideoEnabled(boolean videoEnabled) {
        this.videoEnabled = videoEnabled;
        if (videoEnabled) {
            this.playVideo(this.getCurrentName());
        } else {
            this.mediaViewPane.stop();
        }
    }

    public void setOnVideoShortcut(Delegate delegate) {
        this.mediaViewPane.setOnMouseRightClick(delegate);
    }

    public TabPane getTabPane() {
        return this.tabPane;
    }

    protected abstract void setText(String var1);

    protected abstract void setGraphic(ImageView var1);

    public void setApplication(Application application) {
        this.application = application;
    }

    public void setEmulatedItem(T emulatedItem) {
        this.currentEmulatedItem = emulatedItem;
        try {
            if (this.currentEmulatedItem != null) {
                this.setText(((Item)emulatedItem).getDescription());
                Image image = Icons.newImage(((Item)emulatedItem).getName());
                if (image == null) {
                    image = new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/icon/Negatron@2x.png"));
                }
                this.setGraphic(new ImageView(image));
                this.favouritesButton.setDisable(false);
            } else {
                this.setText("Negatron");
                this.setGraphic(new ImageView(new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/icon/Negatron@2x.png"))));
                this.favouritesButton.setDisable(true);
            }
            this.updateTabContent();
        }
        catch (IOException ex) {
            Logger.getLogger(InformationPaneController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String getCurrentName() {
        return this.currentEmulatedItem != null ? ((Item)this.currentEmulatedItem).getName() : null;
    }

    private void playVideo(String currentName) {
        if (currentName != null && this.videoEnabled) {
            Path videoSource = Extras.toPath(this.systemName, currentName, Property.VIDEO_PREVIEW, ".mp4", ".flv");
            this.mediaViewPane.setMedia(videoSource);
            if (!this.soundEnabled) {
                this.mediaViewPane.setVolume(0);
            }
            this.mediaViewPane.setDragCopyPath(Extras.toPrimaryPath(this.systemName, currentName, Property.VIDEO_PREVIEW));
            if (videoSource != null && this.tabPane.getSelectionModel().getSelectedItem() == this.ingameTab) {
                this.mediaViewPane.play();
            }
        } else {
            this.mediaViewPane.setMedia(null);
        }
    }

    public void pauseVideo() {
        this.mediaViewPane.pause();
    }

    public void showTab() {
        if (this.tabPane.getOpacity() < 1.0) {
            ArrayList<KeyValue> keyValuesA = new ArrayList<KeyValue>();
            ArrayList<KeyValue> keyValuesB = new ArrayList<KeyValue>();
            Shear shear = new Shear();
            this.tabPane.getTransforms().add((Object)shear);
            keyValuesA.add(new KeyValue((WritableValue)this.tabPane.scaleXProperty(), (Object)0.0));
            keyValuesA.add(new KeyValue((WritableValue)this.tabPane.opacityProperty(), (Object)0.0));
            keyValuesA.add(new KeyValue((WritableValue)shear.xProperty(), (Object)0.7));
            keyValuesB.add(new KeyValue((WritableValue)this.tabPane.scaleXProperty(), (Object)1.0));
            keyValuesB.add(new KeyValue((WritableValue)this.tabPane.opacityProperty(), (Object)1.0));
            keyValuesB.add(new KeyValue((WritableValue)shear.xProperty(), (Object)0.0));
            Timeline _timeline = new Timeline();
            _timeline.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, null, null, keyValuesA));
            _timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)300.0), null, evt -> this.tabPane.getTransforms().remove((Object)shear), keyValuesB));
            _timeline.play();
        }
    }

    public void hideTab(Delegate delegate, boolean onStarted) {
        if (Configuration.Manager.isSyncExecutionMode()) {
            this.keyValues2.forEach(keyValue -> ((DoubleProperty)keyValue.getTarget()).setValue((Number)((Double)keyValue.getEndValue())));
            delegate.fire();
        } else if (this.timeline.getStatus() == Animation.Status.STOPPED && this.tabPane.getOpacity() > 0.0) {
            this.timeline.getKeyFrames().clear();
            this.timeline.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, null, null, this.keyValues1));
            this.timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)300.0), null, onStarted ? null : event -> delegate.fire(), this.keyValues2));
            this.timeline.play();
            if (onStarted) {
                delegate.fire();
            }
        }
    }

    public void hideTab(EventHandler<ActionEvent> onFinished) {
        this.timeline.getKeyFrames().clear();
        this.timeline.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.tabPane.opacityProperty(), (Object)1.0)}));
        this.timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)300.0), onFinished, new KeyValue[]{new KeyValue((WritableValue)this.tabPane.opacityProperty(), (Object)0.0)}));
        this.timeline.play();
    }

    public void selectInformationTab() {
        this.tabPane.getSelectionModel().select((Object)this.informationTab);
    }

    private void updateTabContent() {
        this.updateTabContent(false);
    }

    protected void updateTabContent(boolean forceUpdate) {
        this.updateTabContent((Tab)this.tabPane.getSelectionModel().getSelectedItem(), forceUpdate);
    }

    private boolean updateTabContent(Tab selectedTab) {
        return this.updateTabContent(selectedTab, false);
    }

    protected boolean updateTabContent(Tab selectedTab, boolean forceUpdate) {
        String currentName = this.getCurrentName();
        try {
            if (selectedTab != this.ingameTab) {
                this.pauseVideo();
            }
            if (selectedTab == this.externalTab) {
                if (forceUpdate || this.currentEmulatedItem != this.externalTab.getUserData()) {
                    this.updateExternalTabContent(currentName);
                    this.externalTab.setUserData(this.currentEmulatedItem);
                }
                return true;
            }
            if (selectedTab == this.ingameTab) {
                if (forceUpdate || this.currentEmulatedItem != this.ingameTab.getUserData()) {
                    this.updateIngameTabContent(currentName);
                    this.ingameTab.setUserData(this.currentEmulatedItem);
                }
                return true;
            }
            if (selectedTab == this.informationTab) {
                if (forceUpdate || this.currentEmulatedItem != this.informationTab.getUserData()) {
                    String parentName = null;
                    if (this.currentEmulatedItem != null && ((EmulatedItem)this.currentEmulatedItem).getParent() != null) {
                        parentName = ((EmulatedItem)((EmulatedItem)this.currentEmulatedItem).getParent()).getName();
                    }
                    this.updateInformationTabContent(currentName, parentName);
                    this.informationTab.setUserData(this.currentEmulatedItem);
                }
                return true;
            }
            if (selectedTab == this.manualTab) {
                if (forceUpdate || this.currentEmulatedItem != this.manualTab.getUserData()) {
                    Path path = Extras.toPdfPath(this.systemName, currentName, Property.MANUAL);
                    if (path != null) {
                        this.pdfViewer.openDefaultFile(path.toString());
                    } else {
                        this.pdfViewer.openDefaultFile(Extras.getDefaultPdfPath());
                    }
                    this.manualTab.setUserData(this.currentEmulatedItem);
                }
                return true;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(InformationPaneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    protected abstract void updateExternalTabContent(String var1) throws IOException;

    protected void updateIngameTabContent(String currentName) throws IOException {
        Image image = Images.newImage(this.systemName, currentName, Property.TITLE);
        if (image == null) {
            image = this.colourTestImage;
        }
        this.titleImagePane.setImage(image);
        this.titleImagePane.setDragCopyPath(Extras.toPrimaryPath(this.systemName, currentName, Property.TITLE));
        image = Images.newImage(this.systemName, currentName, Property.SNAPSHOT);
        if (image == null) {
            image = this.noiseImage;
        }
        this.snapshotImagePane.setImage(image);
        this.snapshotImagePane.setDragCopyPath(Extras.toPrimaryPath(this.systemName, currentName, Property.SNAPSHOT));
        this.playVideo(currentName);
    }

    private void updateInformationTabContent(String currentName, String parentName) {
        this.informationTab.setContent(null);
        TabPane informationPane = new TabPane();
        informationPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.informationTab.setContent((Node)informationPane);
        BiConsumer<String, String> addTab = (tabName, content) -> {
            if (content != null) {
                TextFlow textFlow = new TextFlow();
                textFlow.getStyleClass().add((Object)"textFlow");
                textFlow.setPadding(new Insets(10.0));
                textFlow.setTextAlignment(TextAlignment.JUSTIFY);
                ScrollPane scrollPane = new ScrollPane((Node)textFlow);
                scrollPane.setFitToWidth(true);
                informationPane.getTabs().add((Object)new Tab(tabName, (Node)scrollPane));
                content = content.replaceAll("\\n\\s{2}\\*\\s", System.lineSeparator() + "\u2022 ");
                content = content.replaceAll("\\n\\s{4}\\*\\s", System.lineSeparator() + "\t\u2022 ");
                content = content.replaceAll("\\n\\*\\s", System.lineSeparator() + "\u2022 ");
                ObservableList nodes = textFlow.getChildren();
                int from = 0;
                if (content.startsWith("\n")) {
                    from = content.indexOf("\n", 1);
                    Text text = new Text(content.substring(1, from));
                    text.getStyleClass().add((Object)"h1");
                    nodes.add((Object)text);
                }
                Pattern pattern = Pattern.compile("http:\\/\\/\\S+[\\w/]|- ([A-Z\\d]+ )+-|={6} (\\S+ )+={6}|={5} (\\S+ )+={5}|={2} (\\S+ )+={2}");
                Matcher matcher = pattern.matcher((CharSequence)content);
                while (matcher.find()) {
                    Text text;
                    int to = matcher.start();
                    nodes.add((Object)new Text(content.substring(from, to)));
                    String match = matcher.group();
                    if (match.startsWith("h")) {
                        String label = match;
                        if (label.startsWith("http://www.arcade-history.com")) {
                            label = currentName + " at http://www.arcade-history.com";
                        }
                        Hyperlink hyperlink = new Hyperlink(label);
                        hyperlink.setOnAction(event -> this.application.getHostServices().showDocument(match));
                        nodes.add((Object)hyperlink);
                    } else if (match.startsWith("-")) {
                        text = new Text(match.substring(2, 3) + match.substring(3, match.length() - 2).toLowerCase());
                        text.getStyleClass().add((Object)"h2");
                        nodes.add((Object)text);
                    } else if (match.startsWith("======")) {
                        text = new Text(match.substring(7, match.length() - 7));
                        text.getStyleClass().add((Object)"h1");
                        nodes.add((Object)text);
                    } else if (match.startsWith("=====")) {
                        text = new Text(match.substring(6, match.length() - 6));
                        text.getStyleClass().add((Object)"h2");
                        nodes.add((Object)text);
                    } else {
                        text = new Text(match.substring(3, match.length() - 3));
                        text.getStyleClass().add((Object)"h3");
                        nodes.add((Object)text);
                    }
                    from = matcher.end();
                }
                if (from != content.length() - 1) {
                    nodes.add((Object)new Text(content.substring(from)));
                }
            }
        };
        if (currentName == null) {
            String content2 = "An unexpected error occurred while retrieving content.";
            try {
                content2 = Extras.getDefaultInformationContent();
            }
            catch (IOException ex) {
                Logger.getLogger(MachineInformationPaneController.class.getName()).log(Level.SEVERE, null, ex);
            }
            addTab.accept("readme.txt", content2);
        } else {
            String _systemName = this.systemName != null ? this.systemName : "info";
            Map<String, String> data = this.cache.get(_systemName, currentName, parentName);
            data.keySet().stream().forEachOrdered(tabName -> {
                String content = (String)data.get(tabName);
                addTab.accept((String)tabName, content);
            });
        }
    }

    @FXML
    private void handleOnAddToFavourites(ActionEvent event) {
        this.favouritesButton.fireEvent((Event)this.favouritesEvent);
    }
}

