/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.beans.property.Property;
import javafx.fxml.Initializable;
import net.babelsoft.negatron.model.component.MachineComponent;
import net.babelsoft.negatron.util.Disposable;
import net.babelsoft.negatron.view.control.adapter.FocusData;

public abstract class MachineComponentController<T extends MachineComponent<S, P>, S, P extends Property<S>>
implements Initializable,
Disposable {
    private T machineComponent;
    private Consumer<String> onDataUpdated;

    public void initialize(URL url, ResourceBundle rb) {
    }

    public void setMachineComponent(T machineComponent) {
        this.machineComponent = machineComponent;
    }

    public T getMachineComponent() {
        return this.machineComponent;
    }

    public void setOnDataUpdated(Consumer<String> consumer) {
        this.onDataUpdated = consumer;
    }

    protected void fireDataUpdated(String origin) {
        if (this.onDataUpdated != null) {
            this.onDataUpdated.accept(origin);
        }
    }

    public abstract boolean isFocused();

    public abstract FocusData getFocusData();

    public boolean requestFocus(FocusData focusData) {
        if (focusData == null) {
            return false;
        }
        MachineComponent<?, ?> component = focusData.getComponent();
        return component != null && component.canReplace(this.machineComponent);
    }
}

