/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.FlowPane;
import net.babelsoft.negatron.controller.FilterPaneController;
import net.babelsoft.negatron.io.cache.UIConfigurationData;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.model.ControllerType;
import net.babelsoft.negatron.model.DisplayType;
import net.babelsoft.negatron.model.ScreenOrientation;
import net.babelsoft.negatron.model.SoundType;
import net.babelsoft.negatron.model.Support;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.view.control.EmulatedItemTreeView;

public class MachineFilterPaneController
extends FilterPaneController<Machine> {
    @FXML
    private CheckBox supportGood;
    @FXML
    private CheckBox supportImperfect;
    @FXML
    private CheckBox supportPreliminary;
    @FXML
    private CheckBox machineTypeElectronic;
    @FXML
    private CheckBox machineTypeMechanical;
    @FXML
    private CheckBox businessModelCoinOperated;
    @FXML
    private CheckBox businessModelFreeAccess;
    @FXML
    private CheckBox softwareHousingEmbedded;
    @FXML
    private CheckBox softwareHousingMedium;
    @FXML
    private CheckBox numberPlayersNone;
    @FXML
    private CheckBox numberPlayersSingle;
    @FXML
    private CheckBox numberPlayersDuo;
    @FXML
    private CheckBox numberPlayersMore;
    @FXML
    private FlowPane controllerPane;
    @FXML
    private CheckBox controllerNone;
    @FXML
    private CheckBox serviceModeAvailable;
    @FXML
    private CheckBox serviceModeUnavailable;
    @FXML
    private CheckBox tiltDetectionAvailable;
    @FXML
    private CheckBox tiltDetectionUnavailable;
    @FXML
    private CheckBox displayNone;
    @FXML
    private CheckBox displayRaster;
    @FXML
    private CheckBox displayVector;
    @FXML
    private CheckBox displayLcd;
    @FXML
    private CheckBox displaySvg;
    @FXML
    private CheckBox displayUnknown;
    @FXML
    private CheckBox screenOrientationHorizontal;
    @FXML
    private CheckBox screenOrientationVertical;
    @FXML
    private CheckBox soundNone;
    @FXML
    private CheckBox soundMono;
    @FXML
    private CheckBox soundStereo;
    @FXML
    private CheckBox soundSurround;

    @Override
    protected void initialise() {
        super.initialise();
        Arrays.stream(ControllerType.values()).forEachOrdered(controller -> {
            CheckBox checkBox = new CheckBox(controller.toString());
            checkBox.setId("controller" + controller.name());
            checkBox.setTooltip(new Tooltip(controller.getTooltipText()));
            checkBox.setUserData((Object)controller);
            this.controllerPane.getChildren().add((Object)checkBox);
        });
    }

    @Override
    protected UIConfigurationData loadConfiguration() {
        return Configuration.Manager.getFilterConfiguration();
    }

    @Override
    protected void wireEvents() {
        super.wireEvents();
        this.controllerPane.getChildren().stream().map(node -> (CheckBox)node).forEach(check -> check.setOnAction(evt -> this.handleOnAction((ActionEvent)evt)));
    }

    @Override
    public void setTreeView(EmulatedItemTreeView<Machine> treeView) {
        this.setTreeView(treeView, new MachineFilter());
    }

    @Override
    protected void setAsSelectionDisable(boolean disable) {
        this.setAsSelectionDisable(disable, Language.Manager.getString("setAsSelection.machine"));
    }

    @Override
    protected void saveConfiguration(UIConfigurationData data) throws IOException {
        Configuration.Manager.updateFilterConfiguration(data);
    }

    @Override
    protected void update(Consumer<TextField> updateText, Consumer<RadioButton> updateRadio, Consumer<Spinner> updateSpinner, Consumer<CheckBox> updateCheck) {
        super.update(updateText, updateRadio, updateSpinner, updateCheck);
        updateCheck.accept(this.supportGood);
        updateCheck.accept(this.supportImperfect);
        updateCheck.accept(this.supportPreliminary);
        updateCheck.accept(this.machineTypeElectronic);
        updateCheck.accept(this.machineTypeMechanical);
        updateCheck.accept(this.businessModelCoinOperated);
        updateCheck.accept(this.businessModelFreeAccess);
        updateCheck.accept(this.softwareHousingEmbedded);
        updateCheck.accept(this.softwareHousingMedium);
        updateCheck.accept(this.numberPlayersNone);
        updateCheck.accept(this.numberPlayersSingle);
        updateCheck.accept(this.numberPlayersDuo);
        updateCheck.accept(this.numberPlayersMore);
        updateCheck.accept(this.controllerNone);
        this.controllerPane.getChildren().forEach(check -> updateCheck.accept((CheckBox)check));
        updateCheck.accept(this.serviceModeAvailable);
        updateCheck.accept(this.serviceModeUnavailable);
        updateCheck.accept(this.tiltDetectionAvailable);
        updateCheck.accept(this.tiltDetectionUnavailable);
        updateCheck.accept(this.displayNone);
        updateCheck.accept(this.displayRaster);
        updateCheck.accept(this.displayVector);
        updateCheck.accept(this.displayLcd);
        updateCheck.accept(this.displaySvg);
        updateCheck.accept(this.displayUnknown);
        updateCheck.accept(this.screenOrientationHorizontal);
        updateCheck.accept(this.screenOrientationVertical);
        updateCheck.accept(this.soundNone);
        updateCheck.accept(this.soundMono);
        updateCheck.accept(this.soundStereo);
        updateCheck.accept(this.soundSurround);
    }

    @FXML
    protected void handleOnSetSupportAsSelection(ActionEvent event) {
        this.supportGood.setSelected(false);
        this.supportImperfect.setSelected(false);
        this.supportPreliminary.setSelected(false);
        switch (((Machine)this.currentItem).getSupport()) {
            case GOOD: {
                this.supportGood.setSelected(true);
                break;
            }
            case IMPERFECT: {
                this.supportImperfect.setSelected(true);
                break;
            }
            default: {
                this.supportPreliminary.setSelected(true);
            }
        }
        this.filterTimeline.playFromStart();
        this.supportGood.requestFocus();
    }

    @FXML
    private void handleOnSetMachineTypeAsSelection(ActionEvent event) {
        if (((Machine)this.currentItem).isMechanical()) {
            this.machineTypeElectronic.setSelected(false);
            this.machineTypeMechanical.setSelected(true);
        } else {
            this.machineTypeElectronic.setSelected(true);
            this.machineTypeMechanical.setSelected(false);
        }
        this.filterTimeline.playFromStart();
        this.machineTypeElectronic.requestFocus();
    }

    @FXML
    private void handleOnSetBusinessModelAsSelection(ActionEvent event) {
        if (((Machine)this.currentItem).hasCoinSlot()) {
            this.businessModelCoinOperated.setSelected(true);
            this.businessModelFreeAccess.setSelected(false);
        } else {
            this.businessModelCoinOperated.setSelected(false);
            this.businessModelFreeAccess.setSelected(true);
        }
        this.filterTimeline.playFromStart();
        this.businessModelCoinOperated.requestFocus();
    }

    @FXML
    private void handleOnSetSoftwareHousingTypeAsSelection(ActionEvent event) {
        if (((Machine)this.currentItem).isSoftwareEmbedded()) {
            this.softwareHousingEmbedded.setSelected(true);
            this.softwareHousingMedium.setSelected(false);
        } else {
            this.softwareHousingEmbedded.setSelected(false);
            this.softwareHousingMedium.setSelected(true);
        }
        this.filterTimeline.playFromStart();
        this.softwareHousingEmbedded.requestFocus();
    }

    @FXML
    private void handleOnSetMaxNumberPlayersAsSelection(ActionEvent event) {
        this.numberPlayersNone.setSelected(false);
        this.numberPlayersSingle.setSelected(false);
        this.numberPlayersDuo.setSelected(false);
        this.numberPlayersMore.setSelected(false);
        switch (((Machine)this.currentItem).getMaxNumberPlayers()) {
            case 0: {
                this.numberPlayersNone.setSelected(true);
                break;
            }
            case 1: {
                this.numberPlayersSingle.setSelected(true);
                break;
            }
            case 2: {
                this.numberPlayersDuo.setSelected(true);
                break;
            }
            default: {
                this.numberPlayersMore.setSelected(true);
            }
        }
        this.filterTimeline.playFromStart();
        this.numberPlayersNone.requestFocus();
    }

    @FXML
    private void handleOnSelectAllControllers(ActionEvent event) {
        this.controllerPane.getChildren().forEach(checkBox -> ((CheckBox)checkBox).setSelected(true));
        this.filterTimeline.playFromStart();
    }

    @FXML
    private void handleOnSelectNoneControllers(ActionEvent event) {
        this.controllerPane.getChildren().forEach(checkBox -> ((CheckBox)checkBox).setSelected(false));
        this.filterTimeline.playFromStart();
    }

    @FXML
    private void handleOnSetControllerAsSelection(ActionEvent event) {
        this.controllerPane.getChildren().stream().map(checkBox -> (CheckBox)checkBox).forEach(checkBox -> {
            ControllerType type = (ControllerType)((Object)((Object)checkBox.getUserData()));
            if (((Machine)this.currentItem).hasControllerType(type)) {
                checkBox.setSelected(true);
            } else {
                checkBox.setSelected(false);
            }
        });
        if (!((Machine)this.currentItem).hasControllerTypes()) {
            this.controllerNone.setSelected(true);
        }
        this.filterTimeline.playFromStart();
    }

    @FXML
    private void handleOnSetServiceModeAsSelection(ActionEvent event) {
        if (((Machine)this.currentItem).hasServiceMode()) {
            this.serviceModeAvailable.setSelected(true);
            this.serviceModeUnavailable.setSelected(false);
        } else {
            this.serviceModeAvailable.setSelected(false);
            this.serviceModeUnavailable.setSelected(true);
        }
        this.filterTimeline.playFromStart();
        this.serviceModeAvailable.requestFocus();
    }

    @FXML
    private void handleOnSetTiltSlamDetectionAsSelection(ActionEvent event) {
        if (((Machine)this.currentItem).hasTilt()) {
            this.tiltDetectionAvailable.setSelected(true);
            this.tiltDetectionUnavailable.setSelected(false);
        } else {
            this.tiltDetectionAvailable.setSelected(false);
            this.tiltDetectionUnavailable.setSelected(true);
        }
        this.filterTimeline.playFromStart();
        this.tiltDetectionAvailable.requestFocus();
    }

    @FXML
    private void handleOnSetDisplayAsSelection(ActionEvent event) {
        this.displayNone.setSelected(false);
        this.displayRaster.setSelected(false);
        this.displayVector.setSelected(false);
        this.displayLcd.setSelected(false);
        this.displaySvg.setSelected(false);
        this.displayUnknown.setSelected(false);
        switch (((Machine)this.currentItem).getDisplayType()) {
            case none: {
                this.displayNone.setSelected(true);
                break;
            }
            case raster: {
                this.displayRaster.setSelected(true);
                break;
            }
            case vector: {
                this.displayVector.setSelected(true);
                break;
            }
            case lcd: {
                this.displayLcd.setSelected(true);
                break;
            }
            case svg: {
                this.displaySvg.setSelected(true);
                break;
            }
            default: {
                this.displayUnknown.setSelected(true);
            }
        }
        this.filterTimeline.playFromStart();
        this.displayNone.requestFocus();
    }

    @FXML
    private void handleOnSetScreenOrientationAsSelection(ActionEvent event) {
        this.screenOrientationHorizontal.setSelected(false);
        this.screenOrientationVertical.setSelected(false);
        switch (((Machine)this.currentItem).getScreenOrientation()) {
            case VERTICAL: {
                this.screenOrientationVertical.setSelected(true);
                break;
            }
            default: {
                this.screenOrientationHorizontal.setSelected(true);
            }
        }
        this.filterTimeline.playFromStart();
        this.screenOrientationHorizontal.requestFocus();
    }

    @FXML
    private void handleOnSetSoundAsSelection(ActionEvent event) {
        this.soundNone.setSelected(false);
        this.soundMono.setSelected(false);
        this.soundStereo.setSelected(false);
        this.soundSurround.setSelected(false);
        switch (((Machine)this.currentItem).getSoundType()) {
            case NONE: {
                this.soundNone.setSelected(true);
                break;
            }
            case MONO: {
                this.soundMono.setSelected(true);
                break;
            }
            case STEREO: {
                this.soundStereo.setSelected(true);
                break;
            }
            default: {
                this.soundSurround.setSelected(true);
            }
        }
        this.filterTimeline.playFromStart();
        this.soundNone.requestFocus();
    }

    protected class MachineFilter
    extends FilterPaneController.Filter<Machine> {
        protected MachineFilter() {
        }

        @Override
        public boolean test(Machine machine) {
            if (!machine.isRunnable()) {
                return false;
            }
            int nbPlayers = machine.getMaxNumberPlayers();
            boolean controllerValidated = MachineFilterPaneController.this.controllerPane.getChildren().stream().map(node -> (CheckBox)node).filter(check -> machine.hasControllerType((ControllerType)((Object)((Object)check.getUserData()))) && check.isSelected()).findAny().isPresent();
            DisplayType display = machine.getDisplayType();
            SoundType sound = machine.getSoundType();
            Support support = machine.getSupport();
            return super.test(machine) && (support == Support.GOOD && MachineFilterPaneController.this.supportGood.isSelected() || support == Support.IMPERFECT && MachineFilterPaneController.this.supportImperfect.isSelected() || support == Support.PRELIMINARY && MachineFilterPaneController.this.supportPreliminary.isSelected()) && (!machine.isMechanical() && MachineFilterPaneController.this.machineTypeElectronic.isSelected() || machine.isMechanical() && MachineFilterPaneController.this.machineTypeMechanical.isSelected()) && (machine.hasCoinSlot() && MachineFilterPaneController.this.businessModelCoinOperated.isSelected() || !machine.hasCoinSlot() && MachineFilterPaneController.this.businessModelFreeAccess.isSelected()) && (machine.isSoftwareEmbedded() && MachineFilterPaneController.this.softwareHousingEmbedded.isSelected() || !machine.isSoftwareEmbedded() && MachineFilterPaneController.this.softwareHousingMedium.isSelected()) && (nbPlayers == 0 && MachineFilterPaneController.this.numberPlayersNone.isSelected() || nbPlayers == 1 && MachineFilterPaneController.this.numberPlayersSingle.isSelected() || nbPlayers == 2 && MachineFilterPaneController.this.numberPlayersDuo.isSelected() || nbPlayers > 2 && MachineFilterPaneController.this.numberPlayersMore.isSelected()) && (!machine.hasControllerTypes() && MachineFilterPaneController.this.controllerNone.isSelected() || controllerValidated) && (machine.hasServiceMode() && MachineFilterPaneController.this.serviceModeAvailable.isSelected() || !machine.hasServiceMode() && MachineFilterPaneController.this.serviceModeUnavailable.isSelected()) && (machine.hasTilt() && MachineFilterPaneController.this.tiltDetectionAvailable.isSelected() || !machine.hasTilt() && MachineFilterPaneController.this.tiltDetectionUnavailable.isSelected()) && (display == DisplayType.none && MachineFilterPaneController.this.displayNone.isSelected() || display == DisplayType.raster && MachineFilterPaneController.this.displayRaster.isSelected() || display == DisplayType.vector && MachineFilterPaneController.this.displayVector.isSelected() || display == DisplayType.lcd && MachineFilterPaneController.this.displayLcd.isSelected() || display == DisplayType.svg && MachineFilterPaneController.this.displaySvg.isSelected() || display == DisplayType.unknown && MachineFilterPaneController.this.displayUnknown.isSelected()) && (display == DisplayType.none || display == DisplayType.unknown || machine.getScreenOrientation() == ScreenOrientation.HORIZONTAL && MachineFilterPaneController.this.screenOrientationHorizontal.isSelected() || machine.getScreenOrientation() == ScreenOrientation.VERTICAL && MachineFilterPaneController.this.screenOrientationVertical.isSelected()) && (sound == SoundType.NONE && MachineFilterPaneController.this.soundNone.isSelected() || sound == SoundType.MONO && MachineFilterPaneController.this.soundMono.isSelected() || sound == SoundType.STEREO && MachineFilterPaneController.this.soundStereo.isSelected() || sound == SoundType.SURROUND && MachineFilterPaneController.this.soundSurround.isSelected());
        }
    }
}

