/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.layout.FlowPane;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.Property;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.model.item.MachineFolder;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.view.control.tree.SortableTreeItem;

public class MachineFolderViewPaneController
implements Initializable {
    @FXML
    private ChoiceBox<IniPath> choice;
    @FXML
    private Button selectAllButton;
    @FXML
    private Button selectNoneButton;
    @FXML
    private FlowPane flow;
    private IniPath defaultPath;
    private Consumer<Map<SortableTreeItem<Machine>, List<String>>> onViewTypeChanged;

    public void initialize(URL url, ResourceBundle rb) {
        this.defaultPath = new IniPath(Language.Manager.getString("parentClone"));
        this.choice.getItems().add((Object)this.defaultPath);
        this.choice.getSelectionModel().select(0);
        Configuration.Manager.getFolderPaths(Property.FOLDER_VIEW).stream().map(path -> Paths.get(path, new String[0])).filter(path -> Files.exists(path, new LinkOption[0])).forEachOrdered(path -> {
            try (Stream<Path> paths = Files.walk(path, new FileVisitOption[0]);){
                paths.filter(iniPath -> iniPath.getFileName().toString().endsWith(".ini")).forEachOrdered(iniPath -> this.choice.getItems().add((Object)new IniPath((Path)iniPath)));
            }
            catch (IOException ex) {
                Logger.getLogger(MachineFolderViewPaneController.class.getName()).log(Level.SEVERE, "Error while initialising view pane", ex);
            }
        });
    }

    public void setOnViewTypeChanged(Consumer<Map<SortableTreeItem<Machine>, List<String>>> onViewTypeChanged) {
        this.onViewTypeChanged = onViewTypeChanged;
    }

    private List<String> addFolder(Map<String, SortableTreeItem<Machine>> index, Map<SortableTreeItem<Machine>, List<String>> view, String name) {
        return this.addFolder(index, view, name, true);
    }

    private List<String> addFolder(Map<String, SortableTreeItem<Machine>> index, Map<SortableTreeItem<Machine>, List<String>> view, String name, boolean addGraphics) {
        SortableTreeItem<MachineFolder> folder = new SortableTreeItem<MachineFolder>(new MachineFolder(name));
        index.put(name, folder);
        ArrayList<String> items = new ArrayList<String>();
        view.put(folder, items);
        if (addGraphics) {
            CheckBox check = new CheckBox(name);
            check.setSelected(true);
            this.flow.getChildren().add((Object)check);
        }
        return items;
    }

    private void setSelected(boolean selected) {
        this.flow.getChildren().stream().map(node -> (CheckBox)node).forEach(check -> check.setSelected(selected));
    }

    @FXML
    private void handleChoiceAction(ActionEvent event) {
        this.flow.getChildren().clear();
        IniPath iniPath = (IniPath)this.choice.getSelectionModel().getSelectedItem();
        if (iniPath != this.defaultPath) {
            try {
                HashMap<String, SortableTreeItem<Machine>> index = new HashMap<String, SortableTreeItem<Machine>>();
                HashMap<SortableTreeItem<Machine>, List<String>> view = new HashMap<SortableTreeItem<Machine>, List<String>>();
                List<String> lines = Files.readAllLines(iniPath.getPath());
                boolean skip = false;
                boolean isMame32Format = false;
                List<String> items = null;
                for (String line : lines) {
                    if ((line = line.trim()).startsWith("[")) {
                        switch (line) {
                            case "[FOLDER_SETTINGS]": {
                                skip = true;
                                isMame32Format = true;
                                break;
                            }
                            case "[ROOT_FOLDER]": {
                                skip = false;
                                break;
                            }
                            default: {
                                if (skip) {
                                    skip = false;
                                }
                                if (!isMame32Format) break;
                                items = this.addFolder(index, view, line.substring(1, line.length() - 1));
                            }
                        }
                    }
                    if (skip || line.isEmpty() || line.startsWith("[") || line.startsWith(";")) continue;
                    if (!isMame32Format) {
                        String[] itemFolder = line.split("=");
                        items = (List<String>)view.get(index.get(itemFolder[1]));
                        if (items == null) {
                            items = this.addFolder(index, view, itemFolder[1]);
                        }
                        items.add(itemFolder[0]);
                        continue;
                    }
                    if (items == null) {
                        items = this.addFolder(index, view, "", false);
                    }
                    items.add(line);
                }
                this.onViewTypeChanged.accept(view);
            }
            catch (IOException ex) {
                Logger.getLogger(MachineFolderViewPaneController.class.getName()).log(Level.SEVERE, "Error while processing .ini file", ex);
            }
        }
        this.selectAllButton.setDisable(this.flow.getChildren().size() <= 0);
        this.selectNoneButton.setDisable(this.flow.getChildren().size() <= 0);
    }

    @FXML
    private void handleSelectAllAction(ActionEvent event) {
        this.setSelected(true);
    }

    @FXML
    private void handleSelectNoneAction(ActionEvent event) {
        this.setSelected(false);
    }

    private class IniPath {
        private final Path path;
        private final String label;

        public IniPath(Path path) {
            this.path = path;
            this.label = path.getFileName().toString();
        }

        public IniPath(String label) {
            this.path = null;
            this.label = label;
        }

        public Path getPath() {
            return this.path;
        }

        public String toString() {
            return this.label;
        }
    }
}

