/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tab;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import net.babelsoft.negatron.controller.InformationPaneController;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.Property;
import net.babelsoft.negatron.io.extras.Extras;
import net.babelsoft.negatron.io.extras.Images;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.util.function.Delegate;
import net.babelsoft.negatron.view.control.ImageViewPane;
import net.babelsoft.negatron.view.control.adapter.ImageGridAdapter;

public class MachineInformationPaneController
extends InformationPaneController<Machine> {
    @FXML
    private Label headerLabel;
    @FXML
    private ProgressIndicator progressIndicator;
    @FXML
    private ImageViewPane marqueeImagePane;
    @FXML
    private ImageViewPane cabinetImagePane;
    @FXML
    private ImageViewPane controlPanelImagePane;
    @FXML
    private ImageViewPane flyerImagePane;
    @FXML
    private GridPane ingameTitleGrid;
    @FXML
    private ImageViewPane logoImagePane;
    @FXML
    private ImageViewPane howtoImagePane;
    @FXML
    private ImageViewPane scoreImagePane;
    @FXML
    private ImageViewPane bossImagePane;
    @FXML
    private ImageViewPane gameoverImagePane;
    @FXML
    private ImageViewPane endImagePane;
    @FXML
    private ImageViewPane selectImagePane;
    @FXML
    private ImageViewPane artpreviewImagePane;
    @FXML
    private ImageViewPane versusImagePane;
    @FXML
    private Tab internalsTab;
    @FXML
    private GridPane internalsPane;
    private Image marqueeImage;
    private Image cabinetImage;
    private Image cpanelImage;
    private Image flyerImage;
    private Image colourTestAltImage;
    private Image deviceImage;
    private int internalDeviceCount;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.getTabPane().getSelectionModel().select(Configuration.Manager.getMachineInformationTabIndex());
        super.initialize(url, rb);
        this.getTabPane().getSelectionModel().selectedIndexProperty().addListener((o, oV, newValue) -> {
            try {
                Configuration.Manager.updateMachineInformationTabIndex(newValue.intValue());
            }
            catch (IOException ex) {
                Logger.getLogger(MachineInformationPaneController.class.getName()).log(Level.SEVERE, "Couldn't save machine tab index", ex);
            }
        });
        this.marqueeImage = new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/marquee.png"));
        this.cabinetImage = new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/cabinet.png"));
        this.cpanelImage = new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/cpanel.png"));
        this.flyerImage = new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/flyer.png"));
        this.colourTestAltImage = new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/TvColourTestCardAlt.png"));
        this.deviceImage = new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/device.png"));
        this.mediaViewPane.addAllDropTargets(this.logoImagePane, this.howtoImagePane, this.scoreImagePane, this.bossImagePane, this.gameoverImagePane, this.endImagePane, this.selectImagePane, this.artpreviewImagePane, this.versusImagePane);
        this.initialiseExternalsZooming(this.marqueeImagePane, this.cabinetImagePane, this.controlPanelImagePane, this.flyerImagePane);
        this.initialiseIngameZooming(this.logoImagePane, this.howtoImagePane, this.scoreImagePane, this.bossImagePane, this.gameoverImagePane, this.endImagePane, this.selectImagePane, this.artpreviewImagePane, this.versusImagePane);
        this.postInitialise(new Tab[]{this.internalsTab}, new ImageViewPane[]{this.marqueeImagePane, this.cabinetImagePane, this.controlPanelImagePane, this.flyerImagePane, this.logoImagePane, this.howtoImagePane, this.scoreImagePane, this.bossImagePane, this.gameoverImagePane, this.endImagePane, this.selectImagePane, this.artpreviewImagePane, this.versusImagePane});
    }

    @Override
    protected void setText(String text) {
        this.headerLabel.setText(text);
    }

    @Override
    protected void setGraphic(ImageView graphic) {
        this.headerLabel.setGraphic((Node)graphic);
    }

    @Override
    public void showTab() {
        super.showTab();
        this.progressIndicator.setVisible(false);
    }

    @Override
    public void hideTab(Delegate delegate, boolean onStarted) {
        super.hideTab(delegate, onStarted);
        this.progressIndicator.setVisible(true);
    }

    @Override
    protected boolean updateTabContent(Tab selectedTab, boolean forceUpdate) {
        if (super.updateTabContent(selectedTab, forceUpdate)) {
            return true;
        }
        String currentName = this.currentEmulatedItem != null ? ((Machine)this.currentEmulatedItem).getName() : null;
        try {
            if (selectedTab == this.internalsTab) {
                if (forceUpdate || this.currentEmulatedItem != this.internalsTab.getUserData() || this.currentEmulatedItem != null && this.currentEmulatedItem == this.internalsTab.getUserData() && ((Machine)this.currentEmulatedItem).hasNewInternalDevices()) {
                    this.updateInternalsTabContent(currentName);
                    this.internalsTab.setUserData((Object)this.currentEmulatedItem);
                }
                return true;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MachineInformationPaneController.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    @Override
    protected void updateExternalTabContent(String currentName) throws IOException {
        Image image = Images.newImage(currentName, Property.MARQUEE);
        if (image == null) {
            image = this.marqueeImage;
        }
        this.marqueeImagePane.setImage(image);
        this.marqueeImagePane.setDragCopyPath(Extras.toPrimaryPath(currentName, Property.MARQUEE));
        image = Images.newImage(currentName, Property.CABINET);
        if (image == null) {
            image = this.cabinetImage;
        }
        this.cabinetImagePane.setImage(image);
        this.cabinetImagePane.setDragCopyPath(Extras.toPrimaryPath(currentName, Property.CABINET));
        image = Images.newImage(currentName, Property.CONTROL_PANEL);
        if (image == null) {
            image = this.cpanelImage;
        }
        this.controlPanelImagePane.setImage(image);
        this.controlPanelImagePane.setDragCopyPath(Extras.toPrimaryPath(currentName, Property.CONTROL_PANEL));
        image = Images.newImage(currentName, Property.FLYER);
        if (image == null) {
            image = this.flyerImage;
        }
        this.flyerImagePane.setImage(image);
        this.flyerImagePane.setDragCopyPath(Extras.toPrimaryPath(currentName, Property.FLYER));
    }

    @Override
    protected void updateIngameTabContent(String currentName) throws IOException {
        super.updateIngameTabContent(currentName);
        Image image = Images.newImage(this.systemName, currentName, Property.LOGO);
        if (image == null) {
            image = this.colourTestImage;
        }
        this.logoImagePane.setImage(image);
        this.logoImagePane.setDragCopyPath(Extras.toPrimaryPath(this.systemName, currentName, Property.LOGO));
        image = Images.newImage(this.systemName, currentName, Property.HOW_TO);
        if (image == null) {
            image = this.colourTestAltImage;
        }
        this.howtoImagePane.setImage(image);
        this.howtoImagePane.setDragCopyPath(Extras.toPrimaryPath(this.systemName, currentName, Property.HOW_TO));
        image = Images.newImage(this.systemName, currentName, Property.SCORE);
        if (image == null) {
            image = this.noiseImage;
        }
        this.scoreImagePane.setImage(image);
        this.scoreImagePane.setDragCopyPath(Extras.toPrimaryPath(this.systemName, currentName, Property.SCORE));
        image = Images.newImage(this.systemName, currentName, Property.BOSS);
        if (image == null) {
            image = this.colourTestImage;
        }
        this.bossImagePane.setImage(image);
        this.bossImagePane.setDragCopyPath(Extras.toPrimaryPath(this.systemName, currentName, Property.BOSS));
        image = Images.newImage(this.systemName, currentName, Property.GAME_OVER);
        if (image == null) {
            image = this.colourTestAltImage;
        }
        this.gameoverImagePane.setImage(image);
        this.gameoverImagePane.setDragCopyPath(Extras.toPrimaryPath(this.systemName, currentName, Property.GAME_OVER));
        image = Images.newImage(this.systemName, currentName, Property.END);
        if (image == null) {
            image = this.noiseImage;
        }
        this.endImagePane.setImage(image);
        this.endImagePane.setDragCopyPath(Extras.toPrimaryPath(this.systemName, currentName, Property.END));
        image = Images.newImage(this.systemName, currentName, Property.SELECT);
        if (image == null) {
            image = this.colourTestImage;
        }
        this.selectImagePane.setImage(image);
        this.selectImagePane.setDragCopyPath(Extras.toPrimaryPath(this.systemName, currentName, Property.SELECT));
        image = Images.newImage(this.systemName, currentName, Property.ARTWORK_PREVIEW);
        if (image == null) {
            image = this.colourTestAltImage;
        }
        this.artpreviewImagePane.setImage(image);
        this.artpreviewImagePane.setDragCopyPath(Extras.toPrimaryPath(this.systemName, currentName, Property.ARTWORK_PREVIEW));
        image = Images.newImage(this.systemName, currentName, Property.VERSUS);
        if (image == null) {
            image = this.noiseImage;
        }
        this.versusImagePane.setImage(image);
        this.versusImagePane.setDragCopyPath(Extras.toPrimaryPath(this.systemName, currentName, Property.VERSUS));
        image = this.snapshotImagePane.getImageView().getImage();
        if (image.getWidth() >= image.getHeight()) {
            GridPane.setConstraints((Node)this.ingameTitleGrid, (int)0, (int)0, (int)3, (int)1);
            GridPane.setConstraints((Node)this.titleImagePane, (int)0, (int)0);
            GridPane.setConstraints((Node)this.snapshotImagePane, (int)1, (int)0);
            GridPane.setConstraints((Node)this.logoImagePane, (int)0, (int)1);
            GridPane.setConstraints((Node)this.howtoImagePane, (int)1, (int)1);
            GridPane.setConstraints((Node)this.scoreImagePane, (int)2, (int)1);
            GridPane.setConstraints((Node)this.bossImagePane, (int)0, (int)2);
            GridPane.setConstraints((Node)this.gameoverImagePane, (int)1, (int)2);
            GridPane.setConstraints((Node)this.endImagePane, (int)2, (int)2);
            GridPane.setConstraints((Node)this.selectImagePane, (int)0, (int)3);
            GridPane.setConstraints((Node)this.artpreviewImagePane, (int)1, (int)3);
            GridPane.setConstraints((Node)this.versusImagePane, (int)2, (int)3);
            ColumnConstraints fiftyPctWidth = new ColumnConstraints();
            fiftyPctWidth.setPercentWidth(50.0);
            RowConstraints hundredPctHeight = new RowConstraints();
            hundredPctHeight.setPercentHeight(100.0);
            this.ingameTitleGrid.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{fiftyPctWidth, fiftyPctWidth});
            this.ingameTitleGrid.getRowConstraints().setAll((Object[])new RowConstraints[]{hundredPctHeight});
            ColumnConstraints thirdWidth = new ColumnConstraints();
            thirdWidth.setPercentWidth(33.333333333333336);
            RowConstraints fortyPctHeight = new RowConstraints();
            fortyPctHeight.setPercentHeight(40.0);
            RowConstraints twentyPctHeight = new RowConstraints();
            twentyPctHeight.setPercentHeight(20.0);
            this.ingameGrid.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{thirdWidth, thirdWidth, thirdWidth});
            this.ingameGrid.getRowConstraints().setAll((Object[])new RowConstraints[]{fortyPctHeight, twentyPctHeight, twentyPctHeight, twentyPctHeight});
        } else {
            GridPane.setConstraints((Node)this.ingameTitleGrid, (int)0, (int)0, (int)1, (int)3);
            GridPane.setConstraints((Node)this.titleImagePane, (int)0, (int)0);
            GridPane.setConstraints((Node)this.snapshotImagePane, (int)0, (int)1);
            GridPane.setConstraints((Node)this.logoImagePane, (int)1, (int)0);
            GridPane.setConstraints((Node)this.howtoImagePane, (int)1, (int)1);
            GridPane.setConstraints((Node)this.scoreImagePane, (int)1, (int)2);
            GridPane.setConstraints((Node)this.bossImagePane, (int)2, (int)0);
            GridPane.setConstraints((Node)this.gameoverImagePane, (int)2, (int)1);
            GridPane.setConstraints((Node)this.endImagePane, (int)2, (int)2);
            GridPane.setConstraints((Node)this.selectImagePane, (int)3, (int)0);
            GridPane.setConstraints((Node)this.artpreviewImagePane, (int)3, (int)1);
            GridPane.setConstraints((Node)this.versusImagePane, (int)3, (int)2);
            ColumnConstraints hundredPctWidth = new ColumnConstraints();
            hundredPctWidth.setPercentWidth(100.0);
            RowConstraints fiftyPctHeight = new RowConstraints();
            fiftyPctHeight.setPercentHeight(50.0);
            this.ingameTitleGrid.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{hundredPctWidth});
            this.ingameTitleGrid.getRowConstraints().setAll((Object[])new RowConstraints[]{fiftyPctHeight, fiftyPctHeight});
            ColumnConstraints fortyPctWidth = new ColumnConstraints();
            fortyPctWidth.setPercentWidth(40.0);
            ColumnConstraints twentyPctWidth = new ColumnConstraints();
            twentyPctWidth.setPercentWidth(20.0);
            RowConstraints thirdHeight = new RowConstraints();
            thirdHeight.setPercentHeight(33.333333333333336);
            this.ingameGrid.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{fortyPctWidth, twentyPctWidth, twentyPctWidth, twentyPctWidth});
            this.ingameGrid.getRowConstraints().setAll((Object[])new RowConstraints[]{thirdHeight, thirdHeight, thirdHeight});
        }
    }

    private void addInternalsItem(String name, Image image) {
        this.addInternalsItem(null, name, image, null);
    }

    private void addInternalsItem(String code, String name, Image image, Property property) {
        ReadOnlyDoubleProperty widthProperty = this.internalsTab.getTabPane().widthProperty();
        ImageGridAdapter adapter = new ImageGridAdapter(image, widthProperty, 0.8, code, property);
        Label label = new Label(name);
        label.setWrapText(true);
        ImageViewPane pane = adapter.getImageViewPane();
        this.initialise(pane);
        this.internalsPane.addRow(this.internalDeviceCount++, new Node[]{label, pane});
        this.internalsPane.getRowConstraints().add((Object)adapter.getRowConstraints());
    }

    private void updateInternalsTabContent(String currentName) throws IOException {
        this.internalsPane.getChildren().clear();
        this.internalsPane.getRowConstraints().clear();
        this.internalDeviceCount = 0;
        if (this.currentEmulatedItem != null) {
            Image image = Images.newImage(currentName, Property.PCB);
            if (image == null) {
                image = this.deviceImage;
            }
            this.addInternalsItem(currentName, "Printed Circuit Board", image, Property.PCB);
            for (Map.Entry<String, String> entry : ((Machine)this.currentEmulatedItem).getInternalDevices().entrySet()) {
                image = Images.newImage(entry.getKey(), Property.DEVICE);
                if (image == null) {
                    image = this.deviceImage;
                }
                this.addInternalsItem(entry.getKey(), entry.getValue(), image, Property.DEVICE);
            }
        } else {
            this.addInternalsItem("Developer at BabelSoft", new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/BabelSoft.png")));
            this.addInternalsItem("JavaFx GUI Library", new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/JavaFx.png")));
            this.addInternalsItem("NetBeans IDE", new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/NetBeans.png")));
            this.addInternalsItem("Oxygen Icon Library", new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/OxygenProject.png")));
            this.addInternalsItem("PDF viewer from IDR Solutions", new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/IDR.png")));
        }
    }
}

