/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.PauseTransition;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.util.Duration;
import net.babelsoft.negatron.controller.AlertController;
import net.babelsoft.negatron.controller.ConfigurationChangeListener;
import net.babelsoft.negatron.controller.DeviceController;
import net.babelsoft.negatron.controller.EditController;
import net.babelsoft.negatron.io.Audio;
import net.babelsoft.negatron.io.Mame;
import net.babelsoft.negatron.io.Video;
import net.babelsoft.negatron.io.cache.CacheManager;
import net.babelsoft.negatron.io.cache.MachineListCache;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.FavouriteTree;
import net.babelsoft.negatron.io.loader.MachineLoader;
import net.babelsoft.negatron.model.SoftwareListFilter;
import net.babelsoft.negatron.model.Statistics;
import net.babelsoft.negatron.model.comparing.Difference;
import net.babelsoft.negatron.model.component.Device;
import net.babelsoft.negatron.model.favourites.MachineConfiguration;
import net.babelsoft.negatron.model.favourites.SoftwareConfiguration;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.model.item.Software;
import net.babelsoft.negatron.model.item.SoftwareList;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.DirectoryWatchService;
import net.babelsoft.negatron.util.Disposable;
import net.babelsoft.negatron.util.SimpleDirectoryWatchService;
import net.babelsoft.negatron.util.Strings;
import net.babelsoft.negatron.util.function.Delegate;
import net.babelsoft.negatron.view.control.AdvancedParametrisationDialog;
import net.babelsoft.negatron.view.control.EmulatedItemTreePane;
import net.babelsoft.negatron.view.control.FavouriteTreePane;
import net.babelsoft.negatron.view.control.GlobalConfigurationPane;
import net.babelsoft.negatron.view.control.MachineConfigurationPane;
import net.babelsoft.negatron.view.control.MachineFilterPane;
import net.babelsoft.negatron.view.control.MachineFolderViewPane;
import net.babelsoft.negatron.view.control.MachineInformationPane;
import net.babelsoft.negatron.view.control.SoftwareConfigurationPane;
import net.babelsoft.negatron.view.control.SoftwareFilterPane;
import net.babelsoft.negatron.view.control.SoftwareInformationPane;
import net.babelsoft.negatron.view.control.TitledWindowPane;
import net.babelsoft.negatron.view.control.form.Control;
import net.babelsoft.negatron.view.control.form.DeviceControl;
import net.babelsoft.negatron.view.control.tree.SortableTreeItem;

public class MainController
implements Initializable,
AlertController,
EditController,
Disposable {
    @FXML
    private SplitPane mainSplitPane;
    @FXML
    private TitledPane machineTreeWindow;
    @FXML
    private EmulatedItemTreePane<Machine> machineTreePane;
    @FXML
    private MachineFilterPane machineFilterWindow;
    @FXML
    private MachineInformationPane machineInformationPane;
    @FXML
    private TitledWindowPane machineConfigurationWindow;
    @FXML
    private MachineConfigurationPane machineConfigurationPane;
    @FXML
    private TitledWindowPane softwareTreeWindow;
    @FXML
    private EmulatedItemTreePane<Software> softwareTreePane;
    @FXML
    private SoftwareFilterPane softwareFilterWindow;
    @FXML
    private SoftwareInformationPane softwareInformationWindow;
    @FXML
    private TitledWindowPane softwareConfigurationWindow;
    @FXML
    private SoftwareConfigurationPane softwareConfigurationTable;
    @FXML
    private TitledWindowPane favouriteMachineTreeWindow;
    @FXML
    private TitledWindowPane favouriteSoftwareTreeWindow;
    @FXML
    private TitledWindowPane favouriteSoftwareConfigurationWindow;
    @FXML
    private TitledWindowPane favouriteTreeWindow;
    @FXML
    private FavouriteTreePane favouriteTreePane;
    @FXML
    private MachineFolderViewPane machineFolderViewWindow;
    @FXML
    private GlobalConfigurationPane globalConfigurationWindow;
    @FXML
    private ToolBar buttonBar;
    @FXML
    private Label statusLabel;
    @FXML
    private Button launchButton;
    @FXML
    private ToggleButton machineConfigurationButton;
    @FXML
    private ToggleButton softwareConfigurationButton;
    @FXML
    private Button advancedParametrisationButton;
    @FXML
    private ToggleButton favouriteViewButton;
    @FXML
    private HBox notificationArea;
    @FXML
    private ToggleButton soundButton;
    @FXML
    private ToggleButton videoButton;
    @FXML
    private ToggleButton view3dButton;
    @FXML
    private ToggleButton globalConfigurationButton;
    @FXML
    private ProgressIndicator notifier;
    private Application application;
    private CacheManager cache;
    private final SimpleBooleanProperty onSucceededProperty = new SimpleBooleanProperty(false);
    private final SimpleDoubleProperty progressProperty = new SimpleDoubleProperty(0.0);
    private final MachineLoader machineLoader = new MachineLoader();
    private final AtomicInteger machineLoadingCount = new AtomicInteger(1);
    private final AtomicBoolean machineLoadingSucceeded = new AtomicBoolean();
    private boolean isLoading;
    private boolean isDoingMachineTreeWiseOperation;
    private boolean isDoingSoftwareTreeWiseOperation;
    private String softwareTreeWiseOperationDeviceValue;
    private boolean isMameFatalErrorMode;
    private boolean mustTriggerLaunchAction;
    private boolean isDataReloadFromSoftwareListEnabled = true;
    private final Timeline launchActionTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)5000.0), new KeyValue[0])});
    private DeviceController currentDeviceController;
    private Machine previousMachine;
    private Machine currentMachine;
    private List<Machine> machines;
    private Map<String, SoftwareList> softwareLists;
    private boolean isFocusOnMame;
    private final Timeline emulationErrorWatcherTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), new KeyValue[0])});
    private final Timeline layoutTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), evt -> {
        try {
            Configuration.Manager.updateMainDividerPosition(((SplitPane.Divider)this.mainSplitPane.getDividers().get(0)).getPosition());
        }
        catch (IOException ex) {
            Logger.getLogger(MainController.class.getName()).log(Level.SEVERE, "Main divider layout configuration failed", ex);
        }
    }, new KeyValue[0])});
    private boolean isHidingConfigurationPane;
    private SoftwareConfiguration displayingSoftwareConfiguration;
    private SoftwareConfiguration editingSoftwareConfiguration;
    private ConfigurationChangeListener onMachineLoaded;
    private int _highlightCount;

    public void initialize(URL url, ResourceBundle rb) {
        DeviceController.setAlertController(this);
        DeviceController.setSoftwareConfigurationPane(this.softwareConfigurationTable);
        double dividerPosition = Configuration.Manager.getMainDividerPosition();
        if (dividerPosition >= 0.0) {
            this.mainSplitPane.setDividerPosition(0, dividerPosition);
        }
        ((SplitPane.Divider)this.mainSplitPane.getDividers().get(0)).positionProperty().addListener((o, oV, nV) -> {
            this.layoutTimeline.playFromStart();
            if (this.mainSplitPane.getWidth() / 2.0 - 10.0 < nV.doubleValue() * this.mainSplitPane.getWidth() && nV.doubleValue() * this.mainSplitPane.getWidth() < this.mainSplitPane.getWidth() / 2.0 + 10.0) {
                this.mainSplitPane.setDividerPosition(0, 0.5);
            }
        });
        Delegate onWindowClose = () -> {
            this.reset();
            if (!this.isDataReloadFromSoftwareListEnabled) {
                this.disableAction(false);
            }
            this.machineConfigurationButton.setSelected(false);
            this.notificationArea.getChildren().remove((Object)this.view3dButton);
        };
        this.buttonBar.getItems().removeAll((Object[])new Node[]{this.machineConfigurationButton, this.softwareConfigurationButton});
        this.notificationArea.getChildren().remove((Object)this.view3dButton);
        this.machineFilterWindow.setOnClose(() -> this.machineTreePane.setFilterButtonSelected(false));
        this.machineFolderViewWindow.setOnClose(() -> this.machineTreePane.setViewButtonSelected(false));
        this.softwareFilterWindow.setOnClose(() -> this.softwareTreePane.setFilterButtonSelected(false));
        this.favouriteTreeWindow.setOnClose(() -> this.favouriteViewButton.setSelected(false));
        this.globalConfigurationWindow.setOnClose(() -> this.globalConfigurationButton.setSelected(false));
        this.globalConfigurationWindow.setOnRestart(() -> {
            try {
                this.dispose();
                this.application.start(null);
            }
            catch (Exception ex) {
                Logger.getLogger(MainController.class.getName()).log(Level.SEVERE, "Couldn't restart Negatron to change UI language", ex);
            }
        });
        if (Configuration.Manager.isMess()) {
            Tooltip tooltip = this.launchButton.getTooltip();
            tooltip.setText(tooltip.getText().replace("MAME", "MESS"));
            this.launchButton.getStyleClass().removeIf(styleClass -> styleClass.equals("launch-mame-button"));
            this.launchButton.getStyleClass().add((Object)"launch-mess-button");
            tooltip = this.advancedParametrisationButton.getTooltip();
            tooltip.setText(tooltip.getText().replace("MAME", "MESS"));
        }
        this.machineTreePane.setOnAction(() -> this.handleLaunchAction(new ActionEvent()));
        this.machineTreePane.setOnSpaceKeyPressed(() -> this.handleMachineConfigurationAction(null));
        this.machineTreePane.setOnTreeMouseClicked((EventHandler<MouseEvent>)((EventHandler)event -> {
            if (event.getButton() == MouseButton.SECONDARY) {
                this.handleMachineConfigurationAction(null);
            }
        }));
        this.machineTreePane.setOnMoreViews(selected -> {
            if (selected.booleanValue()) {
                this.machineFolderViewWindow.showMaximised();
            } else {
                this.machineFolderViewWindow.close();
            }
            if (this.machineFilterWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
                this.machineFilterWindow.close();
            }
        });
        this.machineTreePane.setFilterPane(this.machineFilterWindow);
        this.machineTreePane.setOnMoreFilters(selected -> {
            if (selected.booleanValue()) {
                this.machineFilterWindow.showMaximised();
            } else {
                this.machineFilterWindow.close();
            }
            if (this.machineFolderViewWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
                this.machineFolderViewWindow.close();
            }
        });
        this.machineTreePane.setOnTreeWiseOperation(beginOp -> {
            this.isDoingMachineTreeWiseOperation = beginOp;
        });
        this.machineTreePane.currentItemProperty().addListener((o, oV, newValue) -> {
            if (this.isDoingMachineTreeWiseOperation) {
                return;
            }
            if (newValue != null) {
                Machine machine = (Machine)newValue.getValue();
                if (machine.isFolder()) {
                    return;
                }
                this.machineInformationPane.hideTab(() -> this.machineConfigurationPane.clearControls());
                this.currentMachine = machine;
                if (this.currentMachine != this.previousMachine) {
                    this.previousMachine = this.currentMachine;
                    this.load();
                }
            } else {
                if (this.machineLoader.isRunning()) {
                    this.machineLoader.cancel();
                }
                this.currentMachine = null;
                this.previousMachine = null;
                this.reset();
                this.machineConfigurationWindow.close();
                this.machineInformationPane.hideTab((EventHandler<ActionEvent>)((EventHandler)event -> this.loadMachineInformation()));
            }
        });
        this.machineConfigurationPane.setOnDataUpdated(origin -> {
            if (this.displayingSoftwareConfiguration == null && !this.isDoingMachineTreeWiseOperation && !this.isDoingSoftwareTreeWiseOperation) {
                this.reload((String)origin);
            }
        });
        this.machineConfigurationWindow.setWindowSlaves(this.softwareTreeWindow, this.softwareInformationWindow, this.softwareConfigurationWindow);
        this.machineConfigurationWindow.setOnClose(onWindowClose);
        this.machineInformationPane.setOnVideoShortcut(() -> this.videoButton.fire());
        this.machineFolderViewWindow.setOnViewTypeChanged(viewType -> this.machineTreePane.setViewType((Map<SortableTreeItem<Machine>, List<String>>)viewType));
        this.machineLoader.setOnReady(e -> {
            int count = this.machineLoadingCount.incrementAndGet();
            if (count == 1) {
                this.machineInformationPane.setFavouriteEnabled(false);
                this.softwareInformationWindow.setFavouriteEnabled(false);
            }
        });
        Delegate decrementMachineLoadingCount = () -> {
            int count = this.machineLoadingCount.decrementAndGet();
            if (count == 0) {
                this.machineInformationPane.setFavouriteEnabled(true);
                this.softwareInformationWindow.setFavouriteEnabled(true);
            }
        };
        this.machineLoader.setOnSucceeded(e -> {
            this.machineLoadingSucceeded.set(true);
            this.handleMachineLoaded();
            decrementMachineLoadingCount.fire();
        });
        this.machineLoader.setOnCancelled(e -> {
            if (!this.machineLoadingSucceeded.compareAndSet(true, false)) {
                decrementMachineLoadingCount.fire();
            }
        });
        this.machineLoader.setOnFailed(event -> {
            Logger.getLogger(MachineLoader.class.getName()).log(Level.SEVERE, "System panic", event.getSource().getException());
            this.isLoading = false;
            this.mustTriggerLaunchAction = false;
            this.alert(Alert.AlertType.ERROR, Language.Manager.getString("machineConfLoading.error.text"));
        });
        this.softwareTreePane.setOnAction(() -> this.handleLaunchAction(new ActionEvent()));
        this.softwareTreePane.setOnSpaceKeyPressed(() -> this.handleSoftwareConfigurationAction(null));
        this.softwareTreePane.setOnTreeMouseClicked((EventHandler<MouseEvent>)((EventHandler)event -> {
            if (event.getButton() == MouseButton.SECONDARY) {
                this.handleSoftwareConfigurationAction(null);
            }
        }));
        this.softwareTreePane.setFilterPane(this.softwareFilterWindow);
        this.softwareTreePane.setOnMoreFilters(selected -> {
            if (selected.booleanValue()) {
                this.softwareFilterWindow.showMaximised();
            } else {
                this.softwareFilterWindow.close();
            }
        });
        this.softwareTreePane.setOnAllowAction(() -> this.disableAction(false));
        this.softwareTreePane.setOnForbidAction(() -> this.disableAction(true));
        this.softwareTreePane.setOnEscapeNode((Node)this.softwareTreeWindow);
        this.softwareTreePane.setOnTreeWiseOperation(beginOp -> {
            if (!beginOp.booleanValue() && this.currentDeviceController != null) {
                this.currentDeviceController.setText(this.softwareTreeWiseOperationDeviceValue);
                this.softwareTreeWiseOperationDeviceValue = null;
            }
            this.isDoingSoftwareTreeWiseOperation = beginOp;
            if (beginOp.booleanValue() && this.currentDeviceController != null) {
                this.softwareTreeWiseOperationDeviceValue = this.currentDeviceController.getText();
            }
        });
        this.softwareTreePane.currentItemProperty().addListener((o, oV, newValue) -> {
            Software software;
            Software software2 = software = newValue != null ? (Software)newValue.getValue() : null;
            if (this.mustSetSoftware(software)) {
                if (!this.currentDeviceController.setSoftware(software)) {
                    this.fireOnMachineLoaded();
                }
                this.machineConfigurationPane.satisfyRequirement(software.getRequirement(), this.softwareLists);
                this.softwareConfigurationTable.setSoftware(software);
                this.softwareInformationWindow.setEmulatedItem(software);
                if (this.softwareInformationWindow.getDisplayMode() == TitledWindowPane.DisplayMode.HIDDEN) {
                    this.softwareInformationWindow.setSyncWindow(this.machineConfigurationWindow);
                    if (this.machineConfigurationWindow.getDisplayMode() != TitledWindowPane.DisplayMode.MAXIMISED) {
                        this.softwareInformationWindow.show();
                    }
                }
                if (software.getSoftwareParts().size() > 1) {
                    if (this.softwareConfigurationButton.getParent() == null) {
                        this.buttonBar.getItems().add(2, (Object)this.softwareConfigurationButton);
                        this.highlight(this.softwareConfigurationButton);
                    }
                    if (this.displayingSoftwareConfiguration != null) {
                        if (this.displayingSoftwareConfiguration.getSoftwarePart() != null) {
                            this.softwareConfigurationTable.setCurrentItem(this.displayingSoftwareConfiguration.getSoftwarePart(), this.displayingSoftwareConfiguration.getDevice());
                            if (this.softwareConfigurationWindow.getDisplayMode() == TitledWindowPane.DisplayMode.HIDDEN) {
                                this.handleSoftwareConfigurationAction(null);
                            }
                        }
                        this.displayingSoftwareConfiguration = null;
                    }
                } else if (this.softwareConfigurationButton.getParent() != null) {
                    this.buttonBar.getItems().remove((Object)this.softwareConfigurationButton);
                }
            } else {
                this.softwareConfigurationTable.setSoftware(null);
                this.softwareInformationWindow.setEmulatedItem(null);
                if (this.softwareConfigurationButton.getParent() != null) {
                    this.buttonBar.getItems().remove((Object)this.softwareConfigurationButton);
                }
            }
            if (this.view3dButton.getParent() == null) {
                this.notificationArea.getChildren().add(2, (Object)this.view3dButton);
                this.highlight(this.view3dButton);
            }
        });
        this.softwareTreeWindow.setWindowSlaves(this.machineConfigurationWindow, this.softwareInformationWindow, this.softwareConfigurationWindow);
        this.softwareInformationWindow.setWindowSlaves(this.machineConfigurationWindow, this.softwareTreeWindow, this.softwareConfigurationWindow);
        this.softwareInformationWindow.setOnVideoShortcut(() -> this.videoButton.fire());
        this.softwareInformationWindow.setOnView3dShortcut(() -> this.view3dButton.fire());
        this.softwareTreeWindow.setOnClose(() -> {
            this.softwareFilterWindow.close();
            onWindowClose.fire();
        });
        this.softwareInformationWindow.setOnClose(onWindowClose);
        this.softwareConfigurationWindow.setOnClose(() -> this.softwareConfigurationButton.setSelected(false));
        this.softwareConfigurationTable.setMachineConfigurationPane(this.machineConfigurationPane);
        this.favouriteTreeWindow.setOnClose(() -> {
            if (this.favouriteMachineTreeWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
                this.favouriteMachineTreeWindow.setContent(null);
                this.machineTreeWindow.setContent(this.machineTreePane);
            }
            if (this.favouriteSoftwareTreeWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
                this.favouriteSoftwareTreeWindow.setContent(null);
                this.softwareTreeWindow.setContent((Node)this.softwareTreePane);
            }
            if (this.favouriteSoftwareConfigurationWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
                this.favouriteSoftwareConfigurationWindow.setContent(null);
                this.softwareConfigurationWindow.setContent((Node)this.softwareConfigurationTable);
            }
            this.favouriteTreePane.cancelEdit();
            if (this.favouriteViewButton.isSelected()) {
                this.favouriteViewButton.setSelected(false);
            }
            this.displayingSoftwareConfiguration = null;
            if (this.softwareConfigurationWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
                this.softwareConfigurationTable.requestTableFocus();
            } else if (this.softwareTreeWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
                this.softwareTreePane.requestTreeFocus();
            } else {
                this.machineTreePane.requestTreeFocus();
            }
        });
        this.favouriteTreePane.setEditController(this);
        this.favouriteTreePane.setOnCommitted(favourite -> {
            SoftwareConfiguration softwareConfiguration = favourite.getSoftwareConfiguration();
            if (softwareConfiguration != null) {
                if (!this.machineConfigurationButton.isSelected()) {
                    this.machineConfigurationButton.fire();
                }
                if (this.softwareTreeWindow.getDisplayMode() == TitledWindowPane.DisplayMode.HIDDEN) {
                    this.displayingSoftwareConfiguration = softwareConfiguration;
                    this.machineConfigurationPane.showList(softwareConfiguration.getDevice());
                } else if (this.softwareTreePane.getCurrentItem() != softwareConfiguration.getSoftware()) {
                    this.softwareTreePane.setCurrentItem(softwareConfiguration.getSoftware());
                } else if (this.softwareInformationWindow.getDisplayMode() == TitledWindowPane.DisplayMode.HIDDEN) {
                    this.softwareInformationWindow.show();
                }
            }
        });
        this.favouriteTreePane.setOnAction(() -> this.handleLaunchAction(new ActionEvent()));
        this.favouriteMachineTreeWindow.setOnClose(() -> {
            this.favouriteMachineTreeWindow.setOnceOnAnimationEnded(() -> {
                this.favouriteMachineTreeWindow.setContent(null);
                this.machineTreeWindow.setContent(this.machineTreePane);
            });
            if (!this.favouriteTreePane.isCommitting()) {
                this.favouriteTreePane.cancelEdit();
            }
        });
        this.favouriteSoftwareTreeWindow.setOnClose(() -> {
            this.favouriteSoftwareTreeWindow.setOnceOnAnimationEnded(() -> {
                this.favouriteSoftwareTreeWindow.setContent(null);
                this.softwareTreeWindow.setContent((Node)this.softwareTreePane);
            });
            if (this.softwareInformationWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN && this.favouriteTreePane.isEditingMachine()) {
                this.favouriteSoftwareConfigurationWindow.close();
            }
            if (this.favouriteSoftwareConfigurationWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
                this.favouriteSoftwareConfigurationWindow.close();
            }
            if (this.favouriteTreePane.isEditingSoftware() && !this.favouriteTreePane.isCommitting()) {
                this.favouriteTreePane.cancelEdit();
            } else if (this.favouriteTreePane.isEditingConfiguration()) {
                this.favouriteTreePane.hideListBackground();
            }
            if (!this.favouriteTreePane.isCommitting() && this.currentDeviceController != null) {
                this.currentDeviceController.hideList();
            }
        });
        this.favouriteSoftwareConfigurationWindow.setOnClose(() -> {
            this.favouriteSoftwareConfigurationWindow.setOnceOnAnimationEnded(() -> {
                this.favouriteSoftwareConfigurationWindow.setContent(null);
                this.softwareConfigurationWindow.setContent((Node)this.softwareConfigurationTable);
            });
            if (this.softwareConfigurationWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
                this.handleSoftwareConfigurationAction(null);
            }
        });
        Consumer<Boolean> addToFavourites = isShiftDown -> {
            if (this.currentMachine != null && this.machineLoadingCount.get() == 0) {
                Software software = this.softwareTreePane.getCurrentItem();
                if (software != null) {
                    this.favouriteTreePane.insert(this.currentMachine, new SoftwareConfiguration(this.currentMachine, (Device)this.currentDeviceController.getMachineComponent(), software));
                } else {
                    this.favouriteTreePane.insert(this.currentMachine, null);
                }
                this.favouriteTreeWindow.setOnceOnAnimationEnded(() -> {
                    if (isShiftDown.booleanValue()) {
                        this.favouriteTreeWindow.close();
                    } else {
                        this.favouriteTreePane.requestTreeFocus();
                    }
                });
                this.favouriteViewButton.fire();
            }
        };
        this.mainSplitPane.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getButton() == MouseButton.MIDDLE && this.favouriteTreeWindow.getDisplayMode() == TitledWindowPane.DisplayMode.HIDDEN) {
                addToFavourites.accept(event.isShiftDown());
                event.consume();
            }
        });
        this.mainSplitPane.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.INSERT) {
                addToFavourites.accept(event.isShiftDown());
                event.consume();
            }
        });
        this.soundButton.selectedProperty().addListener((o, oV, newValue) -> {
            this.machineInformationPane.setSoundEnabled((boolean)newValue);
            this.softwareInformationWindow.setSoundEnabled((boolean)newValue);
        });
        this.soundButton.setSelected(Configuration.Manager.isSoundEnabled());
        this.videoButton.selectedProperty().addListener((o, oV, newValue) -> {
            this.machineInformationPane.setVideoEnabled((boolean)newValue);
            this.softwareInformationWindow.setVideoEnabled((boolean)newValue);
            this.soundButton.setDisable(newValue == false);
        });
        this.videoButton.setSelected(Configuration.Manager.isVideoEnabled());
        if (!Configuration.Manager.isVideoEnabled()) {
            this.soundButton.setDisable(true);
        }
        this.view3dButton.selectedProperty().addListener((o, oV, newValue) -> this.softwareInformationWindow.setView3dEnabled((boolean)newValue));
        this.view3dButton.setSelected(Configuration.Manager.isView3dEnabled());
        try {
            EmulationErrorWatcher watcher = new EmulationErrorWatcher((Node)this.launchButton);
            this.emulationErrorWatcherTimeline.setOnFinished(evt -> watcher.displayAlert());
            SimpleDirectoryWatchService.getInstance().register(watcher, Paths.get("", new String[0]).toAbsolutePath(), "tmp-*.log");
        }
        catch (IOException ex) {
            Logger.getLogger(MainController.class.getName()).log(Level.SEVERE, "Unable to register file change listener for *.log", ex);
        }
        SimpleDirectoryWatchService.getInstance().start();
    }

    public void initialiseData() {
        this.cache = new CacheManager(this, machines -> Platform.runLater(() -> {
            this.machines = machines;
            Statistics statistics = this.machineTreePane.setItems((List<Machine>)machines);
            this.machineFilterWindow.bind(this.machineTreePane);
            this.softwareFilterWindow.bind(this.softwareTreePane);
            try {
                MachineListCache machineListCache = new MachineListCache();
                this.statusLabel.setText(String.format(Language.Manager.getString("statistics"), ((String)machineListCache.getVersion()).split("-")[0].trim(), statistics.getTotalCount(), statistics.getParentCount(), statistics.getCloneCount()));
            }
            catch (IOException | ClassNotFoundException ex) {
                Logger.getLogger(MainController.class.getName()).log(Level.SEVERE, "Couldn't display statistics", ex);
            }
        }));
        this.cache.execute();
    }

    public void postInitialise(Stage stage) {
        if (!Video.isEnabled()) {
            this.soundButton.setSelected(false);
            this.soundButton.setDisable(true);
            this.videoButton.setSelected(false);
            this.videoButton.setDisable(true);
        }
        this.globalConfigurationWindow.resetVlcPath();
        this.buttonBar.getScene().getWindow().focusedProperty().addListener((o, oV, newValue) -> {
            if (this.soundButton.isSelected() && newValue.booleanValue() && this.isFocusOnMame) {
                Audio.play(Audio.Sound.BACK_FROM_MAME);
                this.isFocusOnMame = false;
            }
        });
        stage.setHeight((double)Configuration.Manager.getWindowHeight());
        stage.setWidth((double)Configuration.Manager.getWindowWidth());
        stage.setMaximized(Configuration.Manager.isWindowMaximised());
        stage.setFullScreen(Configuration.Manager.isWindowFullscreen());
        stage.centerOnScreen();
        stage.heightProperty().addListener((o, oV, newValue) -> {
            if (newValue.intValue() != Configuration.Manager.getWindowHeight()) {
                try {
                    Configuration.Manager.updateWindowHeight(newValue.intValue());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        stage.widthProperty().addListener((o, oV, newValue) -> {
            if (newValue.intValue() != Configuration.Manager.getWindowWidth()) {
                try {
                    Configuration.Manager.updateWindowWidth(newValue.intValue());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        stage.maximizedProperty().addListener((o, oV, newValue) -> {
            if (newValue.booleanValue() != Configuration.Manager.isWindowMaximised()) {
                try {
                    Configuration.Manager.updateWindowMaximised((boolean)newValue);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        stage.fullScreenProperty().addListener((o, oV, newValue) -> {
            if (newValue.booleanValue() != Configuration.Manager.isWindowFullscreen()) {
                try {
                    Configuration.Manager.updateWindowFullscreen((boolean)newValue);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.machineTreePane.requestTreeFocus();
    }

    public void restart() {
        Platform.runLater(() -> {
            this.globalConfigurationButton.fire();
            this.globalConfigurationWindow.selectOptionsTab();
        });
    }

    @Override
    public void dispose() {
        this.machineInformationPane.dispose();
        if (this.cache != null) {
            this.cache.cancel();
            this.cache = null;
        }
    }

    public void setApplication(Application application) {
        this.application = application;
        this.machineInformationPane.setApplication(application);
        this.softwareInformationWindow.setApplication(application);
    }

    public void setSoftwareLists(Map<String, SoftwareList> softwareLists) {
        this.softwareLists = softwareLists;
        this.machineLoader.setSoftwareLists(softwareLists);
    }

    public void setFavouriteTree(FavouriteTree favourites) {
        this.favouriteTreePane.setFavouriteTree(favourites);
    }

    public ReadOnlyBooleanProperty OnSucceededProperty() {
        return this.onSucceededProperty;
    }

    public boolean hasSucceeded() {
        return this.onSucceededProperty.get();
    }

    public void setSucceeded(boolean succeeded) {
        this.onSucceededProperty.set(succeeded);
    }

    public SimpleDoubleProperty ProgressProperty() {
        return this.progressProperty;
    }

    public double getProgress() {
        return this.progressProperty.get();
    }

    @Override
    public void alert(Alert.AlertType alertType, String message) {
        Alert alert = new Alert(alertType, message, new ButtonType[0]);
        alert.initOwner(this.launchButton.getScene().getWindow());
        alert.setResizable(true);
        alert.show();
        if (this.soundButton.isSelected()) {
            Audio.play(Audio.Sound.ERROR);
        }
    }

    private void highlight(ToggleButton button) {
        PseudoClass CSS_FOCUSED = PseudoClass.getPseudoClass((String)"focused");
        PseudoClass CSS_HOVER = PseudoClass.getPseudoClass((String)"hover");
        Duration FREQUENCY = Duration.millis((double)200.0);
        int MAX_ROUND = 25;
        this._highlightCount = 0;
        PauseTransition highlighted = new PauseTransition(FREQUENCY);
        PauseTransition dimmed = new PauseTransition(FREQUENCY);
        highlighted.setOnFinished(e -> {
            if (this._highlightCount < 25) {
                button.pseudoClassStateChanged(CSS_FOCUSED, true);
                button.pseudoClassStateChanged(CSS_HOVER, true);
                dimmed.playFromStart();
                ++this._highlightCount;
            }
        });
        dimmed.setOnFinished(e -> {
            button.pseudoClassStateChanged(CSS_FOCUSED, false);
            button.pseudoClassStateChanged(CSS_HOVER, false);
            if (this._highlightCount < 25) {
                highlighted.playFromStart();
                ++this._highlightCount;
            }
        });
        highlighted.play();
    }

    private boolean mustSetSoftware(Software software) {
        return this.isDataReloadFromSoftwareListEnabled && this.currentDeviceController != null && software != null;
    }

    private List<String> commandLineToParameters(String commandLine) {
        ArrayList<String> parameters = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s\"]+|\"[^\"]*\"");
        Matcher regexMatcher = regex.matcher(commandLine.trim());
        while (regexMatcher.find()) {
            parameters.add(regexMatcher.group());
        }
        Logger.getLogger(MainController.class.getName()).log(Level.INFO, ((Object)parameters).toString());
        return parameters;
    }

    private void load() {
        this.reload(null);
    }

    private void reload(String origin) {
        if (this.currentMachine != null) {
            this.machineLoader.setInitialisationData(this.currentMachine, origin, origin != null ? MachineLoader.Mode.UPDATE : MachineLoader.Mode.CREATE);
            this.machineLoader.restart();
            this.isLoading = true;
        }
    }

    private void reset() {
        if (this.currentDeviceController != null) {
            this.currentDeviceController.setListButtonSelected(false);
            this.currentDeviceController = null;
        }
        this.softwareTreePane.reset();
    }

    private void reset(List<Control<?>> controls) {
        Optional<Control> candidateControl;
        if (this.machineLoader.getMode() == MachineLoader.Mode.UPDATE && controls != null && this.currentDeviceController != null && (candidateControl = controls.stream().filter(control -> {
            if (control.getStatus() != Difference.DELETED && control instanceof DeviceControl) {
                Device candidateDevice = (Device)((DeviceControl)control).getController().getMachineComponent();
                Device currentDevice = (Device)this.currentDeviceController.getMachineComponent();
                return candidateDevice.canReplace(currentDevice);
            }
            return false;
        }).findAny()).isPresent()) {
            this.currentDeviceController = (DeviceController)candidateControl.get().getController();
            if (this.softwareTreeWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
                this.currentDeviceController.setListButtonSelected(true);
            }
            return;
        }
        if (controls != null && controls.size() > 0) {
            if (this.machineConfigurationButton.getParent() == null) {
                this.buttonBar.getItems().add(1, (Object)this.machineConfigurationButton);
                this.highlight(this.machineConfigurationButton);
            }
        } else if (this.machineConfigurationButton.getParent() != null) {
            this.buttonBar.getItems().remove((Object)this.machineConfigurationButton);
        }
        this.reset();
    }

    private void loadMachineInformation() {
        this.machineInformationPane.setEmulatedItem(this.currentMachine);
        this.machineInformationPane.showTab();
    }

    private void disableAction(boolean value) {
        this.machineTreePane.setDisable(value);
        this.launchButton.setDisable(value);
        this.advancedParametrisationButton.setDisable(value);
        this.isDataReloadFromSoftwareListEnabled = !value;
    }

    private void closeSoftwareFilterWindow() {
        if (this.softwareFilterWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
            this.softwareFilterWindow.close();
        }
    }

    private void closeGlobalConfigurationWindow() {
        if (this.globalConfigurationButton.isSelected()) {
            this.globalConfigurationButton.fire();
        }
    }

    private void launchMame(List<String> parameters) throws IOException {
        if (this.soundButton.isSelected()) {
            Audio.play(Audio.Sound.LAUNCH);
            this.isFocusOnMame = true;
        }
        this.machineInformationPane.pauseVideo();
        this.softwareInformationWindow.pauseVideo();
        Mame.launch(parameters);
    }

    @Override
    public void requestMachineList(ConfigurationChangeListener listener, SoftwareConfiguration softwareConfiguration) {
        this.onMachineLoaded = listener;
        this.editingSoftwareConfiguration = softwareConfiguration;
        this.machineTreeWindow.setContent(null);
        this.favouriteMachineTreeWindow.setContent((Node)this.machineTreePane);
        this.favouriteMachineTreeWindow.show();
        if (this.machineConfigurationWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
            this.machineConfigurationWindow.close();
        }
    }

    @Override
    public void dismissMachineList(ConfigurationChangeListener listener) {
        this.dismissConfigurationPane(listener);
        if (this.favouriteMachineTreeWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
            this.favouriteMachineTreeWindow.close();
        }
    }

    @Override
    public void requestSoftwareList(ConfigurationChangeListener listener) {
        this.onMachineLoaded = listener;
        this.softwareTreeWindow.setContent(null);
        this.favouriteSoftwareTreeWindow.setContent((Node)this.softwareTreePane);
        this.favouriteSoftwareTreeWindow.show();
    }

    @Override
    public void dismissSoftwareList(ConfigurationChangeListener listener) {
        if (this.favouriteSoftwareTreeWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
            this.favouriteSoftwareTreeWindow.close();
        }
        if (!this.favouriteTreePane.isEditingMachine()) {
            this.onMachineLoaded = null;
        }
    }

    @Override
    public void requestConfigurationPane(ConfigurationChangeListener listener, SoftwareConfiguration softwareConfiguration) {
        this.onMachineLoaded = listener;
        this.editingSoftwareConfiguration = softwareConfiguration;
        if (this.machineConfigurationWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
            this.machineConfigurationWindow.setOnceOnAnimationEnded(() -> this.handleMachineConfigurationAction(null));
        }
        this.handleMachineConfigurationAction(null);
    }

    @Override
    public void dismissConfigurationPane(ConfigurationChangeListener listener) {
        this.isHidingConfigurationPane = true;
        this.favouriteTreePane.hideSoftwareList();
        this.onMachineLoaded = null;
        this.editingSoftwareConfiguration = null;
        if (this.machineConfigurationWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
            this.handleMachineConfigurationAction(null);
        }
    }

    @Override
    public void show(Machine machine, SoftwareConfiguration software, MachineConfiguration configuration, boolean mustMigrate) {
        this.displayingSoftwareConfiguration = software;
        if (this.softwareConfigurationWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
            this.handleSoftwareConfigurationAction(null);
        }
        if (software == null && this.softwareInformationWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
            this.softwareInformationWindow.close();
        }
        if (machine != null) {
            if (!mustMigrate) {
                machine.forceParameters(configuration.getParameters());
            }
            if (this.machineTreePane.getCurrentItem() == machine) {
                this.load();
            } else {
                this.machineTreePane.setCurrentItem(machine);
            }
        } else {
            this.machineTreePane.setCurrentItem(null);
        }
    }

    private void fireOnMachineLoaded() {
        if (this.onMachineLoaded != null) {
            Software software = this.softwareTreePane.getCurrentItem();
            if (software != null) {
                if (((Device)this.currentDeviceController.getMachineComponent()).getValue() != null) {
                    this.onMachineLoaded.changed(this.currentMachine, new SoftwareConfiguration(this.currentMachine, (Device)this.currentDeviceController.getMachineComponent(), software));
                } else {
                    this.onMachineLoaded.changed(this.currentMachine, null);
                }
            } else if (this.editingSoftwareConfiguration != null && this.currentMachine.getName().equals(this.editingSoftwareConfiguration.getMachine())) {
                this.onMachineLoaded.changed(this.currentMachine, this.editingSoftwareConfiguration);
            } else {
                this.onMachineLoaded.changed(this.currentMachine, null);
            }
        }
    }

    public void handleCacheNotification(boolean isRunning) {
        if (isRunning) {
            if (this.notifier.getParent() == null) {
                this.notificationArea.getChildren().add((Object)this.notifier);
            }
        } else {
            this.cache = null;
            this.notificationArea.getChildren().remove((Object)this.notifier);
        }
        this.machineFilterWindow.disableStatusCriteria(isRunning);
        this.softwareFilterWindow.disableStatusCriteria(isRunning);
        this.globalConfigurationWindow.disableLanguageOption(isRunning);
    }

    private void handleMachineLoaded() {
        List controls = (List)this.machineLoader.getValue();
        if (controls == MachineLoader.MAME_FATAL_ERROR) {
            this.isMameFatalErrorMode = true;
            if (this.mustTriggerLaunchAction) {
                this.mustTriggerLaunchAction = false;
            }
            this.disableAction(true);
            this.alert(Alert.AlertType.WARNING, Language.Manager.getString("machineConfValidated.error.text"));
        } else {
            if (this.isMameFatalErrorMode) {
                this.disableAction(false);
                this.isMameFatalErrorMode = false;
            }
            if (controls != null) {
                this.reset(controls);
                this.machineConfigurationPane.setControls(this.currentMachine, controls);
                Software software = this.softwareTreePane.getCurrentItem();
                if (this.mustSetSoftware(software)) {
                    this.softwareConfigurationTable.setSoftware(software);
                }
                controls.stream().filter(control -> control instanceof DeviceControl).map(control -> (DeviceController)control.getController()).forEach(controller -> controller.addSoftwareListActionHandler(new SoftwareTreeTableDataFiller((DeviceController)controller)));
                this.loadMachineInformation();
                if (this.displayingSoftwareConfiguration != null) {
                    if (!this.favouriteTreePane.isEditing() || this.favouriteTreePane.isEditingSoftware()) {
                        if (!this.machineConfigurationButton.isSelected()) {
                            this.machineConfigurationButton.fire();
                        }
                        this.machineConfigurationPane.showList(this.displayingSoftwareConfiguration.getDevice());
                    } else {
                        this.displayingSoftwareConfiguration = null;
                    }
                }
            } else {
                this.machineConfigurationPane.clearBadges();
            }
            this.fireOnMachineLoaded();
        }
        this.isLoading = false;
        if (this.mustTriggerLaunchAction) {
            this.mustTriggerLaunchAction = false;
            this.handleLaunchAction(null);
        } else if (this.soundButton.isSelected() && this.machineLoader.getMode() == MachineLoader.Mode.CREATE && controls.size() > 0) {
            Audio.play(Audio.Sound.MACHINE_SETTINGS);
        }
    }

    @FXML
    private void handleLaunchAction(ActionEvent event) {
        if (event != null) {
            if (this.launchActionTimeline.getStatus() == Animation.Status.RUNNING) {
                return;
            }
            this.launchActionTimeline.play();
        }
        if (!this.isLoading) {
            try {
                if (this.currentMachine == null) {
                    this.launchMame(new ArrayList<String>());
                } else if (this.currentMachine.isReady()) {
                    this.launchMame(this.currentMachine.parameters());
                } else {
                    this.alert(Alert.AlertType.WARNING, Language.Manager.getString("machineConfMandatory.error.text"));
                    if (this.machineConfigurationWindow.getDisplayMode() == TitledWindowPane.DisplayMode.HIDDEN) {
                        this.handleMachineConfigurationAction(null);
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(MainController.class.getName()).log(Level.SEVERE, "Couldn't launch MAME", ex);
                this.alert(Alert.AlertType.ERROR, String.format(Language.Manager.getString("mameLaunching.error.text"), ex));
            }
        } else {
            this.mustTriggerLaunchAction = true;
        }
    }

    @FXML
    private void handleMachineConfigurationAction(ActionEvent event) {
        this.closeGlobalConfigurationWindow();
        this.closeSoftwareFilterWindow();
        switch (this.machineConfigurationWindow.getDisplayMode()) {
            case INTERMEDIATE: 
            case MAXIMISED: {
                this.machineConfigurationWindow.close();
                this.machineConfigurationButton.setSelected(false);
                break;
            }
            default: {
                this.machineTreePane.closeFilterPane();
                this.machineConfigurationWindow.show();
                this.machineConfigurationButton.setSelected(true);
            }
        }
    }

    @FXML
    private void handleSoftwareConfigurationAction(ActionEvent event) {
        this.closeGlobalConfigurationWindow();
        switch (this.softwareConfigurationWindow.getDisplayMode()) {
            case INTERMEDIATE: 
            case MAXIMISED: {
                this.softwareConfigurationWindow.close();
                this.softwareConfigurationButton.setSelected(false);
                if (this.favouriteSoftwareConfigurationWindow.getDisplayMode() == TitledWindowPane.DisplayMode.HIDDEN) break;
                this.favouriteSoftwareConfigurationWindow.close();
                break;
            }
            default: {
                this.softwareConfigurationWindow.show();
                this.softwareConfigurationButton.setSelected(true);
                if (!this.favouriteTreePane.isEditing()) break;
                this.softwareConfigurationWindow.setContent(null);
                this.favouriteSoftwareConfigurationWindow.setContent((Node)this.softwareConfigurationTable);
                this.favouriteSoftwareConfigurationWindow.show();
            }
        }
    }

    @FXML
    private void handleAdvancedParametrisationAction(ActionEvent event) {
        if (!this.isLoading) {
            String commandLine = null;
            if (this.currentMachine != null) {
                commandLine = this.currentMachine.toCommandLine();
            }
            AdvancedParametrisationDialog dialog = new AdvancedParametrisationDialog(this.advancedParametrisationButton.getScene().getWindow(), commandLine, new ButtonType(Language.Manager.getString("launch"), ButtonBar.ButtonData.OK_DONE));
            dialog.showAndWait().ifPresent(command -> {
                try {
                    List<String> parameters = this.commandLineToParameters((String)command);
                    this.launchMame(parameters);
                }
                catch (IOException ex) {
                    Logger.getLogger(MainController.class.getName()).log(Level.SEVERE, "Couldn't launch MAME", ex);
                    this.alert(Alert.AlertType.ERROR, String.format(Language.Manager.getString("mameLaunching.error.text"), ex));
                }
            });
        }
    }

    @FXML
    private void handleFavouriteViewAction(ActionEvent event) {
        if (this.favouriteViewButton.isSelected()) {
            this.favouriteTreeWindow.showMaximised();
        } else {
            this.favouriteTreeWindow.close();
        }
    }

    @FXML
    private void handleSoundAction(ActionEvent event) throws IOException {
        if (this.soundButton.isSelected()) {
            Audio.play(Audio.Sound.SOUND_ON);
        }
        try {
            Configuration.Manager.updateSoundEnabled(this.soundButton.isSelected());
        }
        catch (IOException ex) {
            Logger.getLogger(MainController.class.getName()).log(Level.SEVERE, "Couldn't update Negatron.ini", ex);
            this.alert(Alert.AlertType.ERROR, String.format(Language.Manager.getString("confUpdating.error.text"), ex));
        }
    }

    @FXML
    private void handleVideoAction(ActionEvent event) throws IOException {
        try {
            Configuration.Manager.updateVideoEnabled(this.videoButton.isSelected());
        }
        catch (IOException ex) {
            Logger.getLogger(MainController.class.getName()).log(Level.SEVERE, "Couldn't update Negatron.ini", ex);
            this.alert(Alert.AlertType.ERROR, String.format(Language.Manager.getString("confUpdating.error.text"), ex));
        }
    }

    @FXML
    private void handleView3dAction(ActionEvent event) throws IOException {
        try {
            Configuration.Manager.updateView3dEnabled(this.view3dButton.isSelected());
        }
        catch (IOException ex) {
            Logger.getLogger(MainController.class.getName()).log(Level.SEVERE, "Couldn't update Negatron.ini", ex);
            this.alert(Alert.AlertType.ERROR, String.format(Language.Manager.getString("confUpdating.error.text"), ex));
        }
    }

    @FXML
    private void handleGlobalConfigurationAction(ActionEvent event) {
        switch (this.globalConfigurationWindow.getDisplayMode()) {
            case HIDDEN: {
                this.globalConfigurationWindow.showMaximised();
                break;
            }
            default: {
                this.globalConfigurationWindow.close();
            }
        }
    }

    @FXML
    private void handleHelpAction(ActionEvent event) {
        this.closeGlobalConfigurationWindow();
        this.machineTreePane.closeFilterPane();
        this.machineTreePane.clearSelection();
        this.machineInformationPane.selectInformationTab();
    }

    private class EmulationErrorWatcher
    implements DirectoryWatchService.OnFileChangeListener {
        private final Node node;
        private Path filePath;

        public EmulationErrorWatcher(Node node) {
            this.node = node;
        }

        @Override
        public void onFileModify(Path filePath) {
            this.filePath = filePath;
            MainController.this.emulationErrorWatcherTimeline.playFromStart();
        }

        public void displayAlert() {
            try {
                StringBuilder sb = new StringBuilder();
                Files.newBufferedReader(this.filePath).lines().forEach(line -> sb.append((String)line).append(System.lineSeparator()));
                String msg = sb.toString();
                if (Strings.isValid(msg) && !msg.contains("NO GOOD DUMP KNOWN") && !msg.contains("WARNING: the machine might not run correctly")) {
                    Platform.runLater(() -> MainController.this.alert(Alert.AlertType.WARNING, msg));
                }
            }
            catch (IOException ex) {
                Logger.getLogger(MainController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private class SoftwareTreeTableDataFiller
    implements EventHandler<ActionEvent> {
        private final DeviceController controller;

        public SoftwareTreeTableDataFiller(DeviceController controller) {
            this.controller = controller;
        }

        public void handle(ActionEvent evt) {
            MainController.this.reset();
            if (this.controller.isListButtonSelected()) {
                if (MainController.this.softwareConfigurationWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
                    MainController.this.handleSoftwareConfigurationAction(null);
                }
                List<String> interfaceFormats = ((Device)this.controller.getMachineComponent()).getInterfaceFormats();
                Machine machine = (Machine)MainController.this.machineTreePane.getCurrentItem();
                String configurationId = "";
                for (String interfaceFormat : interfaceFormats) {
                    if (!configurationId.equals("")) {
                        configurationId = configurationId + ".";
                    }
                    configurationId = configurationId + interfaceFormat;
                }
                configurationId = configurationId + "-";
                for (SoftwareListFilter softwareListFilter2 : machine.getSoftwareLists()) {
                    if (!configurationId.endsWith("-")) {
                        configurationId = configurationId + ".";
                    }
                    configurationId = configurationId + softwareListFilter2.getSoftwareList();
                }
                MainController.this.softwareFilterWindow.setConfigurationId(configurationId);
                List softwares = machine.getSoftwareLists().stream().flatMap(softwareListFilter -> {
                    SoftwareList softwareList = (SoftwareList)MainController.this.softwareLists.get(softwareListFilter.getSoftwareList());
                    return softwareList.getSoftwares(interfaceFormats, softwareListFilter.getFilter()).stream();
                }).collect(Collectors.toList());
                MainController.this.softwareTreePane.setItems(softwares);
                MainController.this.softwareTreeWindow.showMaximised();
                if (MainController.this.favouriteTreePane.isEditing() && !MainController.this.favouriteTreePane.isEditingSoftware() && MainController.this.favouriteSoftwareTreeWindow.getDisplayMode() == TitledWindowPane.DisplayMode.HIDDEN) {
                    MainController.this.favouriteTreePane.showSoftwareList();
                }
                MainController.this.currentDeviceController = this.controller;
                if (MainController.this.displayingSoftwareConfiguration != null) {
                    MainController.this.softwareTreePane.setCurrentItem(MainController.this.displayingSoftwareConfiguration.getSoftware());
                    if (MainController.this.softwareInformationWindow.getDisplayMode() == TitledWindowPane.DisplayMode.HIDDEN) {
                        MainController.this.softwareInformationWindow.show();
                    }
                    if (MainController.this.displayingSoftwareConfiguration != null && MainController.this.displayingSoftwareConfiguration.getSoftwarePart() == null) {
                        MainController.this.displayingSoftwareConfiguration = null;
                    }
                }
            } else {
                MainController.this.softwareTreeWindow.hide();
                if (MainController.this.softwareConfigurationWindow.getDisplayMode() != TitledWindowPane.DisplayMode.HIDDEN) {
                    MainController.this.handleSoftwareConfigurationAction(null);
                }
                if (!MainController.this.isHidingConfigurationPane) {
                    MainController.this.softwareInformationWindow.hide();
                } else {
                    MainController.this.isHidingConfigurationPane = false;
                }
                if (MainController.this.favouriteTreePane.isEditing()) {
                    MainController.this.favouriteTreePane.hideSoftwareList();
                }
            }
        }
    }
}

