/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import javafx.util.Duration;
import net.babelsoft.negatron.controller.DeviceController;
import net.babelsoft.negatron.controller.EmulatedItemTreePaneController;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.TableColumnConfiguration;
import net.babelsoft.negatron.model.component.Device;
import net.babelsoft.negatron.model.item.Software;
import net.babelsoft.negatron.model.item.SoftwarePart;
import net.babelsoft.negatron.view.control.MachineConfigurationPane;
import net.babelsoft.negatron.view.control.SoftwarePartChoiceCell;
import net.babelsoft.negatron.view.control.adapter.SoftwarePartAdapter;
import net.babelsoft.negatron.view.control.adapter.TableColumnsAdapter;

public class SoftwareConfigurationPaneController
implements Initializable {
    public static final DeviceController DEFAULT_DEVICE = new DeviceController();
    @FXML
    private TableView<SoftwarePartAdapter> root;
    @FXML
    private TableColumn<SoftwarePartAdapter, String> descriptionColumn;
    @FXML
    private TableColumn<SoftwarePartAdapter, String> nameColumn;
    @FXML
    private TableColumn<SoftwarePartAdapter, DeviceController> assignmentColumn;
    private MachineConfigurationPane machineConfigurationPane;
    private TableColumnsAdapter<TableColumn<SoftwarePartAdapter, ?>, TableColumnConfiguration> columnsAdapter;

    public void initialize(URL url, ResourceBundle rb) {
        this.columnsAdapter = new TableColumnsAdapter<TableColumn, TableColumnConfiguration>(this.root.getColumns(), this.root.getSortOrder(), (col, conf) -> col.setSortType((TableColumn.SortType)conf.getSortType()), (conf, col) -> conf.setSortType(col.getSortType()), TableColumnConfiguration.class, conf -> {
            try {
                Configuration.Manager.updateTableColumnsConfiguration(null, (Map<String, TableColumnConfiguration>)conf);
            }
            catch (IOException ex) {
                Logger.getLogger(EmulatedItemTreePaneController.class.getName()).log(Level.SEVERE, "Table column layout configuration couldn't be saved", ex);
            }
        });
        this.loadLayout();
        this.descriptionColumn.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.assignmentColumn.setCellValueFactory((Callback)new PropertyValueFactory("assignment"));
        this.assignmentColumn.setCellFactory(column -> new SoftwarePartChoiceCell());
        this.root.getSelectionModel().selectedIndexProperty().addListener((o, oV, newValue) -> {
            int row = newValue.intValue();
            if (row >= 0) {
                Platform.runLater(() -> {
                    this.root.getFocusModel().focus(row, this.assignmentColumn);
                    this.root.edit(row, this.assignmentColumn);
                });
            }
        });
    }

    public void setMachineConfigurationPane(MachineConfigurationPane machineConfigurationPane) {
        this.machineConfigurationPane = machineConfigurationPane;
    }

    public void setSoftware(Software software) {
        this.machineConfigurationPane.resetControllers();
        ArrayList adapters = new ArrayList();
        if (software != null) {
            software.getSoftwareParts().forEach(softwarePart -> {
                ArrayList<DeviceController> devices = new ArrayList<DeviceController>();
                devices.add(DEFAULT_DEVICE);
                DeviceController[] assignedController = new DeviceController[1];
                this.machineConfigurationPane.getControllers().stream().filter(controller -> controller instanceof DeviceController).map(controller -> (DeviceController)controller).filter(controller -> ((Device)controller.getMachineComponent()).getInterfaceFormats().contains(softwarePart.getInterfaceFormat())).forEach(controller -> {
                    devices.add((DeviceController)controller);
                    String name = SoftwarePartAdapter.getName(software, softwarePart);
                    controller.addSoftwarePart(name);
                    if (name.equals(controller.getText())) {
                        assignedController[0] = controller;
                    }
                });
                SoftwarePartAdapter adapter = new SoftwarePartAdapter(software, (SoftwarePart)softwarePart, (List<DeviceController>)devices);
                if (assignedController[0] != null) {
                    adapter.setAssignment(assignedController[0]);
                }
                adapters.add(adapter);
            });
        }
        this.root.getItems().setAll(adapters);
    }

    public void setCurrentItem(SoftwarePart softwarePart, String device) {
        this.root.getItems().stream().filter(adapter -> adapter.getPartName().equals(softwarePart.getName())).findAny().ifPresent(adapter -> adapter.getDevices().stream().filter(deviceController -> ((Device)deviceController.getMachineComponent()).getName().equals(device)).findAny().ifPresent(deviceController -> deviceController.setText(adapter.getName())));
    }

    private void loadLayout() {
        this.columnsAdapter.loadLayout(Configuration.Manager.getTableColumnsConfiguration(null));
        Timeline resizeTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), event -> this.saveColumnsLayout(), new KeyValue[0])});
        this.root.setOnSort(evt -> this.saveColumnsLayout());
        this.root.getColumns().addListener(c -> this.saveColumnsLayout());
        this.root.getColumns().forEach(col -> {
            col.widthProperty().addListener((o, oV, nV) -> resizeTimeline.playFromStart());
            col.visibleProperty().addListener((o, oV, nV) -> this.saveColumnsLayout());
        });
    }

    private void saveColumnsLayout() {
        this.columnsAdapter.saveColumnsLayout(null);
    }

    public void requestTableFocus() {
        this.root.requestFocus();
    }

    static {
        DEFAULT_DEVICE.setMachineComponent((Device)null);
    }
}

