/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.io.IOException;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import net.babelsoft.negatron.controller.FilterPaneController;
import net.babelsoft.negatron.io.cache.UIConfigurationData;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.model.Support;
import net.babelsoft.negatron.model.item.Software;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.Strings;
import net.babelsoft.negatron.view.control.EmulatedItemTreeView;

public class SoftwareFilterPaneController
extends FilterPaneController<Software> {
    private String configurationId;
    @FXML
    private CheckBox supportSupported;
    @FXML
    private CheckBox supportPartial;
    @FXML
    private CheckBox supportUnsupported;

    @Override
    protected UIConfigurationData loadConfiguration() {
        return Configuration.Manager.getFilterConfiguration(this.configurationId);
    }

    @Override
    protected void saveConfiguration(UIConfigurationData data) throws IOException {
        if (Strings.isValid(this.configurationId)) {
            Configuration.Manager.updateFilterConfiguration(this.configurationId, data);
        }
    }

    @Override
    public void setTreeView(EmulatedItemTreeView<Software> treeView) {
        this.setTreeView(treeView, new SoftwareFilter());
    }

    @Override
    protected void setAsSelectionDisable(boolean disable) {
        this.setAsSelectionDisable(disable, Language.Manager.getString("setAsSelection.software"));
    }

    public void setConfigurationId(String configurationId) {
        this.configurationId = configurationId;
        this.loadData();
    }

    @Override
    protected void update(Consumer<TextField> updateText, Consumer<RadioButton> updateRadio, Consumer<Spinner> updateSpinner, Consumer<CheckBox> updateCheck) {
        super.update(updateText, updateRadio, updateSpinner, updateCheck);
        updateCheck.accept(this.supportSupported);
        updateCheck.accept(this.supportPartial);
        updateCheck.accept(this.supportUnsupported);
    }

    @FXML
    protected void handleOnSetSupportAsSelection(ActionEvent event) {
        this.supportSupported.setSelected(false);
        this.supportPartial.setSelected(false);
        this.supportUnsupported.setSelected(false);
        switch (((Software)this.currentItem).getSupport()) {
            case YES: {
                this.supportSupported.setSelected(true);
                break;
            }
            case PARTIAL: {
                this.supportPartial.setSelected(true);
                break;
            }
            default: {
                this.supportUnsupported.setSelected(true);
            }
        }
        this.filterTimeline.playFromStart();
        this.supportSupported.requestFocus();
    }

    protected class SoftwareFilter
    extends FilterPaneController.Filter<Software> {
        protected SoftwareFilter() {
        }

        @Override
        public boolean test(Software software) {
            Support support = software.getSupport();
            return super.test(software) && (support == Support.YES && SoftwareFilterPaneController.this.supportSupported.isSelected() || support == Support.PARTIAL && SoftwareFilterPaneController.this.supportPartial.isSelected() || support == Support.NO && SoftwareFilterPaneController.this.supportUnsupported.isSelected());
        }
    }
}

