/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.fxml.FXML;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.util.Duration;
import net.babelsoft.negatron.controller.InformationPaneController;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.Property;
import net.babelsoft.negatron.io.extras.Extras;
import net.babelsoft.negatron.io.extras.Images;
import net.babelsoft.negatron.model.item.Software;
import net.babelsoft.negatron.util.function.Delegate;
import net.babelsoft.negatron.view.control.ImageViewPane;
import net.babelsoft.negatron.view.control.TitledWindowPane;
import net.babelsoft.negatron.view.control.model3d.KeepCase;
import net.babelsoft.negatron.view.control.model3d.StraightTuckEndBox;
import net.babelsoft.negatron.view.control.model3d.TuckTopSnapLockBottomBox;

public class SoftwareInformationPaneController
extends InformationPaneController<Software> {
    @FXML
    private TitledWindowPane titlePane;
    @FXML
    private StackPane externalStackPane;
    @FXML
    private GridPane externalGrid;
    @FXML
    private ImageViewPane boxartImagePane;
    @FXML
    private ImageViewPane coverImagePane;
    @FXML
    private ImageViewPane mediaImagePane;
    @FXML
    private SubScene scene;
    private Image boxArtImage;
    private Image coverImage;
    private Image mediaImage;
    private Group packageShape3DGroup;
    private double mousePosX;
    private double mousePosY;
    private Rotate rotateX;
    private Rotate rotateY;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.getTabPane().getSelectionModel().select(Configuration.Manager.getSoftwareInformationTabIndex());
        super.initialize(url, rb);
        this.getTabPane().getSelectionModel().selectedIndexProperty().addListener((o, oV, newValue) -> {
            try {
                Configuration.Manager.updateSoftwareInformationTabIndex(newValue.intValue());
            }
            catch (IOException ex) {
                Logger.getLogger(SoftwareInformationPaneController.class.getName()).log(Level.SEVERE, "Couldn't save software tab index", ex);
            }
        });
        this.boxArtImage = new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/boxArt.png"));
        this.coverImage = new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/cover.png"));
        this.mediaImage = new Image(this.getClass().getResourceAsStream("/net/babelsoft/negatron/resource/media.png"));
        if (Platform.isSupported((ConditionalFeature)ConditionalFeature.SCENE3D)) {
            double translateZ = -400.0;
            this.rotateX = new Rotate(50.0, Rotate.X_AXIS);
            this.rotateY = new Rotate(40.0, Rotate.Y_AXIS);
            PerspectiveCamera camera = new PerspectiveCamera(true);
            camera.setFarClip(Double.MAX_VALUE);
            camera.getTransforms().addAll((Object[])new Transform[]{this.rotateX, this.rotateY, new Translate(0.0, 0.0, -400.0)});
            this.packageShape3DGroup = new Group();
            this.scene = new SubScene((Parent)this.packageShape3DGroup, this.externalGrid.getWidth(), this.externalGrid.getHeight(), true, SceneAntialiasing.BALANCED);
            this.scene.widthProperty().bind((ObservableValue)this.externalGrid.widthProperty());
            this.scene.heightProperty().bind((ObservableValue)this.externalGrid.heightProperty());
            this.scene.setPickOnBounds(true);
            this.scene.setCamera((Camera)camera);
            this.scene.setOpacity(1.0);
            this.scene.getStyleClass().add((Object)"view3d-pane");
            this.scene.addEventHandler(MouseEvent.ANY, event -> {
                if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
                    this.mousePosX = event.getSceneX();
                    this.mousePosY = event.getSceneY();
                } else if (event.getEventType() == MouseEvent.MOUSE_DRAGGED && event.isPrimaryButtonDown()) {
                    double modifier = 1.0;
                    if (event.isControlDown()) {
                        modifier = 0.1;
                    }
                    if (event.isShiftDown()) {
                        modifier = 10.0;
                    }
                    modifier *= 0.6;
                    double mouseOldX = this.mousePosX;
                    double mouseOldY = this.mousePosY;
                    this.mousePosX = event.getSceneX();
                    this.mousePosY = event.getSceneY();
                    double mouseDeltaX = this.mousePosX - mouseOldX;
                    double mouseDeltaY = this.mousePosY - mouseOldY;
                    this.rotateY.setAngle(this.rotateY.getAngle() + mouseDeltaX * modifier);
                    this.rotateX.setAngle(this.rotateX.getAngle() + mouseDeltaY * modifier);
                }
            });
            this.scene.addEventHandler(ScrollEvent.ANY, event -> {
                if (event.getTouchCount() > 0) {
                    this.rotateX.setAngle(this.rotateX.getAngle() - 0.01 * event.getDeltaX());
                    this.rotateY.setAngle(this.rotateY.getAngle() - 0.01 * event.getDeltaY());
                }
            });
            this.scene.setMouseTransparent(true);
            this.externalStackPane.getChildren().add((Object)this.scene);
            this.externalGrid.setOpacity(0.0);
            this.setView3dEnabled(false);
        }
        this.initialiseExternalsZooming(this.boxartImagePane, this.coverImagePane, this.mediaImagePane);
        this.initialiseIngameZooming(new ImageViewPane[0]);
        this.postInitialise(new ImageViewPane[]{this.boxartImagePane, this.coverImagePane, this.mediaImagePane});
    }

    public void setView3dEnabled(boolean view3dEnabled) {
        if (view3dEnabled) {
            Timeline timeline = new Timeline();
            timeline.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.externalGrid.opacityProperty(), (Object)1.0), new KeyValue((WritableValue)this.scene.opacityProperty(), (Object)0.0)}));
            timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)300.0), event -> this.scene.setMouseTransparent(false), new KeyValue[]{new KeyValue((WritableValue)this.externalGrid.opacityProperty(), (Object)0.0), new KeyValue((WritableValue)this.scene.opacityProperty(), (Object)1.0)}));
            timeline.play();
        } else {
            Timeline timeline = new Timeline();
            timeline.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.externalGrid.opacityProperty(), (Object)0.0), new KeyValue((WritableValue)this.scene.opacityProperty(), (Object)1.0)}));
            timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)300.0), event -> this.scene.setMouseTransparent(true), new KeyValue[]{new KeyValue((WritableValue)this.externalGrid.opacityProperty(), (Object)1.0), new KeyValue((WritableValue)this.scene.opacityProperty(), (Object)0.0)}));
            timeline.play();
        }
    }

    public void setOnView3dShortcut(Delegate delegate) {
        this.externalStackPane.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.SECONDARY) {
                delegate.fire();
            }
        });
    }

    @Override
    protected void setText(String text) {
        this.titlePane.setText(text);
    }

    @Override
    protected void setGraphic(ImageView graphic) {
        this.titlePane.setGraphic(graphic);
    }

    @Override
    public void setEmulatedItem(Software emulatedItem) {
        if (emulatedItem != null) {
            this.systemName = emulatedItem.getGroup();
        }
        super.setEmulatedItem(emulatedItem);
    }

    @Override
    protected void updateExternalTabContent(String currentName) throws IOException {
        Object packageShape3D;
        Image image = Images.newImage(this.systemName, currentName, Property.MEDIA);
        if (image == null) {
            image = this.mediaImage;
        }
        this.mediaImagePane.setImage(image, true);
        this.mediaImagePane.setDragCopyPath(Extras.toPrimaryPath(this.systemName, currentName, Property.MEDIA));
        image = Images.newImage(this.systemName, currentName, Property.COVER);
        if (image == null) {
            image = this.coverImage;
        }
        this.coverImagePane.setImage(image, true);
        this.coverImagePane.setDragCopyPath(Extras.toPrimaryPath(this.systemName, currentName, Property.COVER));
        image = Images.newImage(this.systemName, currentName, Property.BOX_ART);
        if (image == null) {
            image = this.boxArtImage;
        }
        this.boxartImagePane.setImage(image, true);
        this.boxartImagePane.setDragCopyPath(Extras.toPrimaryPath(this.systemName, currentName, Property.BOX_ART));
        if (!Platform.isSupported((ConditionalFeature)ConditionalFeature.SCENE3D)) {
            return;
        }
        if (image != this.boxArtImage) {
            switch (this.systemName) {
                default: {
                    packageShape3D = new KeepCase(178.0f, 126.5f, 23.0f, Color.BLACK, 173.0f, 123.5f, 24.0f, image);
                    break;
                }
                case "snes": {
                    packageShape3D = new StraightTuckEndBox(180.0f, 126.0f, 31.0f, 10.0f, 15.5f, true, image);
                    break;
                }
                case "nes": {
                    packageShape3D = new TuckTopSnapLockBottomBox(179.0f, 126.0f, 22.0f, 10.5f, 16.0f, 30.5f, 86.0f, image);
                    break;
                }
            }
        } else {
            packageShape3D = new KeepCase(178.0f, 126.5f, 23.0f, Color.BLACK, 173.0f, 123.5f, 24.0f, image);
        }
        this.packageShape3DGroup.getChildren().setAll((Object[])new Node[]{packageShape3D});
    }

    @Override
    protected void updateIngameTabContent(String currentName) throws IOException {
        super.updateIngameTabContent(currentName);
        Image image = this.snapshotImagePane.getImageView().getImage();
        if (image.getWidth() >= image.getHeight()) {
            GridPane.setConstraints((Node)this.titleImagePane, (int)0, (int)0);
            GridPane.setConstraints((Node)this.snapshotImagePane, (int)0, (int)1);
            ColumnConstraints hundredPctWidth = new ColumnConstraints();
            hundredPctWidth.setPercentWidth(100.0);
            RowConstraints fiftyPctHeight = new RowConstraints();
            fiftyPctHeight.setPercentHeight(50.0);
            this.ingameGrid.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{hundredPctWidth});
            this.ingameGrid.getRowConstraints().setAll((Object[])new RowConstraints[]{fiftyPctHeight, fiftyPctHeight});
        } else {
            GridPane.setConstraints((Node)this.titleImagePane, (int)0, (int)0);
            GridPane.setConstraints((Node)this.snapshotImagePane, (int)1, (int)0);
            ColumnConstraints fiftyPctWidth = new ColumnConstraints();
            fiftyPctWidth.setPercentWidth(50.0);
            RowConstraints hundredPctHeight = new RowConstraints();
            hundredPctHeight.setPercentHeight(100.0);
            this.ingameGrid.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{fiftyPctWidth, fiftyPctWidth});
            this.ingameGrid.getRowConstraints().setAll((Object[])new RowConstraints[]{hundredPctHeight});
        }
    }
}

