/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.net.URL;
import java.util.Arrays;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import net.babelsoft.negatron.util.function.Delegate;
import net.babelsoft.negatron.view.control.TitledWindowPane;

public class TitledWindowPaneController
implements Initializable {
    @FXML
    private VBox root;
    @FXML
    private Label titleLabel;
    @FXML
    private HBox buttonBox;
    @FXML
    private Button minimiseButton;
    @FXML
    private Button restoreButton;
    @FXML
    private Button maximiseButton;
    @FXML
    private Button closeButton;
    @FXML
    private HBox headerPane;
    @FXML
    private StackPane contentPane;
    private TitledWindowPane control;
    private TitledWindowPane[] windowSlaves;
    private TitledWindowPane syncWindow;
    private Delegate onClose;
    private boolean isEscPressed = false;

    public void initialize(URL url, ResourceBundle rb) {
        this.minimiseButton.setOnAction(evt -> {
            this.control.hide();
            if (this.syncWindow != null) {
                this.syncWindow.showMaximised();
            }
        });
        this.restoreButton.setOnAction(evt -> {
            this.control.show();
            if (this.syncWindow != null) {
                this.syncWindow.show();
            }
        });
        this.maximiseButton.setOnAction(evt -> {
            this.control.showMaximised();
            if (this.syncWindow != null) {
                this.syncWindow.hide();
            }
        });
        this.closeButton.setOnAction(evt -> {
            if (this.onClose != null) {
                this.onClose.fire();
            }
            this.control.hide();
            if (this.windowSlaves != null) {
                Arrays.stream(this.windowSlaves).forEach(window -> window.hide());
            }
            if (this.syncWindow != null) {
                this.syncWindow.setSyncWindow(null);
                this.syncWindow = null;
            }
        });
    }

    private void layoutButtonBox() {
        ObservableList children = this.buttonBox.getChildren();
        children.clear();
        if (this.syncWindow != null) {
            children.add((Object)this.minimiseButton);
        }
        if (this.control.isIntermediateSize()) {
            switch (this.control.getDisplayMode()) {
                case INTERMEDIATE: {
                    children.addAll((Object[])new Node[]{this.maximiseButton, this.closeButton});
                    break;
                }
                case MAXIMISED: {
                    children.addAll((Object[])new Node[]{this.restoreButton, this.closeButton});
                }
            }
        } else {
            children.addAll((Object[])new Node[]{this.closeButton});
        }
    }

    public void setControl(TitledWindowPane control) {
        this.control = control;
        control.displayModeProperty().addListener((o, oV, newValue) -> {
            if (newValue != TitledWindowPane.DisplayMode.HIDDEN) {
                this.layoutButtonBox();
            }
        });
        control.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ESCAPE) {
                this.isEscPressed = true;
            }
        });
        control.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            if (event.getCode() == KeyCode.ESCAPE && this.isEscPressed) {
                this.isEscPressed = false;
                this.closeButton.fire();
            }
        });
    }

    public void setText(String text) {
        this.titleLabel.setText(text);
    }

    public void setGraphic(ImageView graphic) {
        this.titleLabel.setGraphic((Node)graphic);
    }

    public void setHeader(Node header) {
        this.headerPane.getChildren().add((Object)header);
    }

    public void setContent(Node content) {
        if (content != null) {
            this.contentPane.getChildren().setAll((Object[])new Node[]{content});
        } else {
            this.contentPane.getChildren().clear();
        }
    }

    public void setWindowSlaves(TitledWindowPane[] windows) {
        this.windowSlaves = windows;
    }

    public void setSyncWindow(TitledWindowPane reference, TitledWindowPane window) {
        if (this.syncWindow != window) {
            this.syncWindow = window;
            this.layoutButtonBox();
            if (window != null) {
                window.setSyncWindow(reference);
            }
        }
    }

    public void setOnClose(Delegate delegate) {
        this.onClose = delegate;
    }

    public void close() {
        this.closeButton.fire();
    }
}

