/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.controller;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TreeTableColumn;
import javafx.util.Duration;
import net.babelsoft.negatron.controller.EmulatedItemTreePaneController;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.TreeTableColumnConfiguration;
import net.babelsoft.negatron.view.control.NegatronTreeView;
import net.babelsoft.negatron.view.control.adapter.TableColumnsAdapter;

public abstract class TreePaneController<T extends NegatronTreeView<I>, I>
implements Initializable {
    @FXML
    protected T treeView;
    protected String id;
    private TableColumnsAdapter<TreeTableColumn<I, ?>, TreeTableColumnConfiguration> columnsAdapter;

    public void initialize(URL url, ResourceBundle rb) {
        this.columnsAdapter = new TableColumnsAdapter<TreeTableColumn, TreeTableColumnConfiguration>(this.treeView.getColumns(), this.treeView.getSortOrder(), (col, conf) -> col.setSortType((TreeTableColumn.SortType)conf.getSortType()), (conf, col) -> conf.setSortType(col.getSortType()), TreeTableColumnConfiguration.class, conf -> {
            try {
                Configuration.Manager.updateTreeTableColumnsConfiguration(this.id, (Map<String, TreeTableColumnConfiguration>)conf);
            }
            catch (IOException ex) {
                Logger.getLogger(EmulatedItemTreePaneController.class.getName()).log(Level.SEVERE, "Tree table column layout configuration couldn't be saved", ex);
            }
        });
        this.treeView.initialize(url, rb);
    }

    public void setId(String id) {
        this.id = id;
        this.loadLayout();
    }

    protected void loadLayout() {
        this.columnsAdapter.loadLayout(Configuration.Manager.getTreeTableColumnsConfiguration(this.id));
        Timeline resizeTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), event -> this.saveColumnsLayout(), new KeyValue[0])});
        this.treeView.setOnSort(evt -> this.saveColumnsLayout());
        this.treeView.getColumns().addListener(c -> {
            while (c.next()) {
                if (!c.wasReplaced() && !c.wasPermutated() && !c.wasUpdated()) continue;
                this.saveColumnsLayout();
                break;
            }
        });
        this.treeView.getColumns().forEach(col -> {
            col.widthProperty().addListener((o, oV, nV) -> resizeTimeline.playFromStart());
            col.visibleProperty().addListener((o, oV, nV) -> this.saveColumnsLayout());
        });
    }

    private void saveColumnsLayout() {
        this.columnsAdapter.saveColumnsLayout(this.id);
    }
}

