/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.model.HddGeometry;

public class Mame {
    private Mame() {
    }

    public static InputStream newInputStream(String ... arguments) throws IOException {
        return Mame.newProcess(arguments).getInputStream();
    }

    public static InputStream newInputStream(List<String> arguments) throws IOException {
        return Mame.newProcess(arguments).getInputStream();
    }

    public static Process newProcess(String ... arguments) throws IOException {
        ArrayList<String> command = new ArrayList<String>(arguments.length + 1);
        command.addAll(Arrays.asList(arguments));
        return Mame.newProcess(command);
    }

    public static Process newProcess(List<String> arguments) throws IOException {
        arguments.add(0, Configuration.Manager.getMameExecutable());
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        processBuilder.directory(new File(Configuration.Manager.getMamePath()));
        return processBuilder.redirectErrorStream(true).start();
    }

    public static void launch(List<String> arguments) throws IOException {
        try {
            Mame.launch(arguments, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void launch(List<String> arguments, boolean synchronise) throws IOException, InterruptedException {
        Mame.launch(arguments, Configuration.Manager.getMamePath(), synchronise);
    }

    public static void launch(List<String> arguments, String workingFolder, boolean synchronise) throws IOException, InterruptedException {
        if (arguments == null) {
            arguments = new ArrayList<String>();
        }
        arguments.add(0, Configuration.Manager.getMameExecutable());
        Path workingPath = Paths.get(workingFolder, new String[0]);
        if (!Files.exists(workingPath, new LinkOption[0])) {
            Files.createDirectories(workingPath, new FileAttribute[0]);
        }
        ProcessBuilder pb = new ProcessBuilder(arguments);
        pb.directory(new File(workingFolder));
        File err = Files.createTempFile(Paths.get("", new String[0]), "tmp-", ".log", new FileAttribute[0]).toFile();
        err.deleteOnExit();
        pb.redirectError(err);
        Process process = pb.start();
        if (synchronise) {
            process.waitFor();
        }
    }

    public static void createBlankHdd(HddGeometry hddGeometry) throws IOException, InterruptedException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(Configuration.Manager.getChdmanExecutable());
        arguments.add("createhd");
        arguments.add("--compression");
        arguments.add("none");
        arguments.add("--sectorsize");
        arguments.add(Long.toString(hddGeometry.getSectorSize()));
        arguments.add("--chs");
        arguments.add(String.format("%d,%d,%d", hddGeometry.getCylinder(), hddGeometry.getHead(), hddGeometry.getSector()));
        arguments.add("--output");
        arguments.add(hddGeometry.getPath());
        new ProcessBuilder(arguments).start().waitFor();
    }
}

