/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.util.Strings;
import uk.co.caprica.vlcj.discovery.NativeDiscovery;
import uk.co.caprica.vlcj.discovery.NativeDiscoveryStrategy;
import uk.co.caprica.vlcj.discovery.linux.DefaultLinuxNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.discovery.mac.DefaultMacNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.discovery.windows.DefaultWindowsNativeDiscoveryStrategy;

public class Video {
    private Video() {
    }

    public static boolean isEnabled() {
        System.setProperty("VLCJ_INITX", "no");
        return new CustomNativeDiscovery().discover();
    }

    private static class CustomMacNativeDiscoveryStrategy
    extends DefaultMacNativeDiscoveryStrategy
    implements UserHintedDiscoveryStrategy {
        private CustomMacNativeDiscoveryStrategy() {
        }

        protected void onGetDirectoryNames(List<String> directoryNames) {
            String vlcPath = Configuration.Manager.getVlcPath();
            if (Strings.isEmpty(vlcPath)) {
                try {
                    String libVlc = "VLC.app/Contents/MacOS/lib/libvlc.dylib";
                    if (Files.exists(Paths.get("VLC.app/Contents/MacOS/lib/libvlc.dylib", new String[0]), new LinkOption[0])) {
                        Configuration.Manager.updateVlcPath("VLC.app/Contents/MacOS/lib/libvlc.dylib");
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(Video.class.getName()).log(Level.WARNING, "Failed to detect any versions of VLC included in Negatron's installation folder", ex);
                }
            }
            this.onGetUserDirectoryNames(directoryNames);
            super.onGetDirectoryNames(directoryNames);
        }
    }

    private static class CustomWindowsNativeDiscoveryStrategy
    extends DefaultWindowsNativeDiscoveryStrategy
    implements UserHintedDiscoveryStrategy {
        private CustomWindowsNativeDiscoveryStrategy() {
        }

        protected void onGetDirectoryNames(List<String> directoryNames) {
            String vlcPath = Configuration.Manager.getVlcPath();
            if (Strings.isEmpty(vlcPath) || Files.notExists(Paths.get(vlcPath, new String[0]), new LinkOption[0])) {
                try {
                    Path libVlc = Files.find(Paths.get(".", new String[0]), 2, (p, bfa) -> p.toString().startsWith(".\\vlc-") && p.endsWith("libvlc.dll") && bfa.isRegularFile(), new FileVisitOption[0]).findAny().orElse(null);
                    if (libVlc != null) {
                        Configuration.Manager.updateVlcPath(libVlc.toString());
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(Video.class.getName()).log(Level.WARNING, "Failed to detect any portable versions of VLC included in Negatron's installation folder", ex);
                }
            }
            this.onGetUserDirectoryNames(directoryNames);
            super.onGetDirectoryNames(directoryNames);
        }
    }

    private static class CustomLinuxNativeDiscoveryStrategy
    extends DefaultLinuxNativeDiscoveryStrategy
    implements UserHintedDiscoveryStrategy {
        private CustomLinuxNativeDiscoveryStrategy() {
        }

        protected void onGetDirectoryNames(List<String> directoryNames) {
            this.onGetUserDirectoryNames(directoryNames);
            super.onGetDirectoryNames(directoryNames);
            directoryNames.add("/usr/lib64");
            directoryNames.add("/usr/local/lib64");
        }
    }

    private static interface UserHintedDiscoveryStrategy {
        default public void onGetUserDirectoryNames(List<String> directoryNames) {
            String vlcPath = Configuration.Manager.getVlcPath();
            if (Strings.isValid(vlcPath)) {
                try {
                    directoryNames.add(Paths.get(vlcPath, new String[0]).getParent().toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static class CustomNativeDiscovery
    extends NativeDiscovery {
        public CustomNativeDiscovery() {
            super(new NativeDiscoveryStrategy[]{new CustomLinuxNativeDiscoveryStrategy(), new CustomWindowsNativeDiscoveryStrategy(), new CustomMacNativeDiscoveryStrategy()});
        }
    }
}

