/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.cache;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cache<T, S> {
    private static final String VERSION_EXTENSION = ".version";
    protected static final String CACHE_EXTENSION = ".cache";
    public static final Path ROOT_FOLDER = Paths.get("Cache", new String[0]);
    protected final Path cachePath;
    protected final Path versionPath;
    protected S version;

    public static void initialise() {
        if (Files.notExists(ROOT_FOLDER, new LinkOption[0])) {
            try {
                Files.createDirectory(ROOT_FOLDER, new FileAttribute[0]);
            }
            catch (IOException ex) {
                Logger.getLogger(Cache.class.getName()).log(Level.SEVERE, "Couldn't create cache root folder", ex);
            }
        }
    }

    public static void clearAll() throws IOException {
        Cache cache = new Cache();
        cache.clear(ROOT_FOLDER);
    }

    private Cache() {
        this.cachePath = null;
        this.versionPath = null;
    }

    protected Cache(String path) throws ClassNotFoundException, IOException {
        this.cachePath = Paths.get(ROOT_FOLDER.toString(), path + CACHE_EXTENSION);
        this.versionPath = Paths.get(ROOT_FOLDER.toString(), path + VERSION_EXTENSION);
        this.version = this.loadVersion();
    }

    public boolean exists() {
        return Files.exists(this.cachePath, new LinkOption[0]);
    }

    public final S getVersion() {
        return this.version;
    }

    protected void clearVersion() throws IOException {
        Files.deleteIfExists(this.versionPath);
    }

    protected void clear(final Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.endsWith("ui.cache")) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e == null) {
                        if (!dir.equals(path)) {
                            Files.delete(dir);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
        }
    }

    protected S loadVersion() throws ClassNotFoundException, IOException {
        return (S)this.load(this.versionPath);
    }

    public T load() throws ClassNotFoundException, IOException {
        return (T)this.load(this.cachePath);
    }

    /*
     * Exception decompiling
     */
    protected <O> O load(Path path) throws ClassNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void saveVersion() throws IOException {
        this.save(this.version, this.versionPath);
    }

    public void save(T content) throws IOException {
        this.save(content, this.cachePath);
    }

    protected void save(Object content, Path path) throws IOException {
        try (OutputStream file = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream buffer = new BufferedOutputStream(file);
             ObjectOutputStream output = new ObjectOutputStream(buffer);){
            output.writeObject(content);
        }
    }
}

