/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.control.Alert;
import net.babelsoft.negatron.controller.MainController;
import net.babelsoft.negatron.io.cache.Cache;
import net.babelsoft.negatron.io.cache.IconCacheSingleton;
import net.babelsoft.negatron.io.cache.InformationCache;
import net.babelsoft.negatron.io.cache.SoftwareListCache;
import net.babelsoft.negatron.io.cache.StatusCache;
import net.babelsoft.negatron.io.configuration.FavouriteTree;
import net.babelsoft.negatron.io.loader.FavouriteLoader;
import net.babelsoft.negatron.io.loader.MachineListLoader;
import net.babelsoft.negatron.model.item.Machine;

public class CacheManager
extends Task<Void> {
    private final MainController controller;
    private final ExecutorService service;
    private final ExecutorCompletionService<Void> execService;
    private final Consumer<List<Machine>> onMachineListLoaded;

    public CacheManager(MainController controller, Consumer<List<Machine>> onMachineListLoaded) {
        this.controller = controller;
        this.onMachineListLoaded = onMachineListLoaded;
        int nbProcessors = Runtime.getRuntime().availableProcessors();
        if (nbProcessors < 3) {
            nbProcessors = 3;
        }
        CacheThreadFactory threadFactory = new CacheThreadFactory();
        this.service = Executors.newFixedThreadPool(nbProcessors, runnable -> threadFactory.newThread(runnable));
        this.execService = new ExecutorCompletionService(this.service);
        Cache.initialise();
    }

    public void execute() {
        this.service.execute((Runnable)((Object)this));
    }

    private void notify(boolean isRunning) {
        Platform.runLater(() -> this.controller.handleCacheNotification(isRunning));
    }

    protected Void call() throws Exception {
        ArrayList tasks = new ArrayList();
        try {
            FavouriteTree favourites;
            this.notify(true);
            SoftwareListCache softwareListCache = new SoftwareListCache();
            softwareListCache.threadedLoad().forEach(loader -> tasks.add(this.execService.submit((Callable<Void>)loader)));
            int max = tasks.size();
            for (int i = 0; i < max; ++i) {
                tasks.remove(this.execService.take());
            }
            this.controller.setSoftwareLists(softwareListCache.get());
            MachineListLoader machineListLoader = new MachineListLoader(softwareListCache.get(), this.controller.ProgressProperty());
            Future<MachineListLoader.MachineListData> machineListFuture = this.service.submit(machineListLoader);
            MachineListLoader.MachineListData machines = machineListFuture.get();
            this.onMachineListLoaded.accept(machines.getList());
            this.controller.setSucceeded(true);
            if (!this.isCancelled() && (favourites = new FavouriteLoader(machines.getMap(), softwareListCache.get()).call()) != null) {
                this.controller.setFavouriteTree(favourites);
            }
            if (!this.isCancelled()) {
                Consumer<List> load = loaders -> loaders.forEach(loader -> {
                    loader.initialise(machines.getMap(), softwareListCache.get());
                    tasks.add(this.execService.submit((Callable<Void>)loader));
                });
                IconCacheSingleton iconCache = IconCacheSingleton.Instance;
                load.accept(iconCache.threadedLoad());
                InformationCache informationCache = new InformationCache();
                load.accept(informationCache.threadedLoad());
                StatusCache statusCache = new StatusCache(machines.getMap(), softwareListCache.get());
                load.accept(statusCache.threadedLoad());
                int nbTasks = tasks.size();
                do {
                    Future<Void> future;
                    if ((future = this.execService.poll(5L, TimeUnit.SECONDS)) != null) {
                        tasks.remove(future);
                        --nbTasks;
                    }
                    if (!this.isCancelled()) continue;
                    tasks.forEach(task -> task.cancel(true));
                    nbTasks = 0;
                } while (nbTasks > 0);
            }
            Void void_ = null;
            return void_;
        }
        catch (InterruptedException ex) {
            tasks.forEach(task -> task.cancel(true));
            Void void_ = null;
            return void_;
        }
        catch (Exception ex) {
            Logger.getLogger(CacheManager.class.getName()).log(Level.SEVERE, null, ex);
            Platform.runLater(() -> this.controller.alert(Alert.AlertType.ERROR, "Unexpected error while building cache: " + ex.getLocalizedMessage()));
            throw ex;
        }
        finally {
            this.notify(false);
            this.service.shutdown();
        }
    }

    private static class CacheThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        CacheThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "cache-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

